/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.Outlet;
import com.floreantpos.model.dao.BaseOutletDAO;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Hibernate;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class OutletDAO
extends BaseOutletDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Outlet initialize(Outlet outlet) {
        if (outlet == null || outlet.getId() == null) {
            return outlet;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)outlet);
            Hibernate.initialize(outlet.getDepartments());
            Outlet outlet2 = outlet;
            return outlet2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateOutlets(List<Outlet> list) throws Exception {
        if (list == null) {
            return;
        }
        Transaction transaction = null;
        Session session = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (Outlet outlet : list) {
                Outlet outlet2 = this.get(outlet.getId());
                if (outlet2 != null) {
                    String string = outlet2.getId();
                    long l = outlet2.getVersion();
                    PropertyUtils.copyProperties((Object)outlet2, (Object)outlet);
                    outlet2.setId(string);
                    outlet2.setVersion(l);
                    this.update(outlet2, session);
                    continue;
                }
                outlet.setVersion(0L);
                this.save(outlet, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

