/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.MenuItem;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.RecipeTable;
import com.floreantpos.model.dao.BaseRecipeTableDAO;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Criteria;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;

public class RecipeTableDAO
extends BaseRecipeTableDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecipeTable findBy(String string) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.createAlias(RecipeTable.PROP_MENU_ITEM, "item");
            criteria.add((Criterion)Restrictions.eq((String)"item.id", (Object)string));
            RecipeTable recipeTable = (RecipeTable)criteria.uniqueResult();
            return recipeTable;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<MenuItem> findMenuItems(Recepie recepie) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.distinct((Projection)Projections.property((String)RecipeTable.PROP_MENU_ITEM)));
            criteria.createAlias("recipeList", "r");
            criteria.add((Criterion)Restrictions.eq((String)"r.id", (Object)recepie.getId()));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RecipeTable> findRecipeTables(Recepie recepie) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.createAlias("recipeList", "r");
            criteria.add((Criterion)Restrictions.eq((String)"r.id", (Object)recepie.getId()));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<RecipeTable> findRecipeTables(String string) {
        Session session = null;
        Criteria criteria = null;
        try {
            Object object;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            if (StringUtils.isNotEmpty((String)string)) {
                object = Restrictions.disjunction();
                criteria.createAlias("recipeList", "r");
                object.add(Restrictions.ilike((String)"r.name", (String)string, (MatchMode)MatchMode.ANYWHERE));
                criteria.createAlias(RecipeTable.PROP_MENU_ITEM, "item");
                object.add(Restrictions.ilike((String)"item", (String)string, (MatchMode)MatchMode.ANYWHERE));
                criteria.add((Criterion)object);
            }
            object = criteria.list();
            return object;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveRecipeTables(List<MenuItem> list, Object ... objectArray) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            if (objectArray != null) {
                for (Object object : objectArray) {
                    if (object == null) continue;
                    session.saveOrUpdate(object);
                }
            }
            if (list != null) {
                for (MenuItem menuItem : list) {
                    RecipeTable recipeTable = this.findBy(menuItem.getId());
                    if (recipeTable == null) continue;
                    session.delete((Object)recipeTable);
                }
            }
            transaction.commit();
        }
        catch (Exception exception) {
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }
}

