/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.model.ShopFloor;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.dao.BaseShopFloorDAO;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projections;

public class ShopFloorDAO
extends BaseShopFloorDAO {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<ShopFloor> findAll() {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(Order.asc((String)ShopFloor.PROP_SORT_ORDER));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public boolean hasFloor() {
        Number number = (Number)this.getSession().createCriteria(this.getReferenceClass()).setProjection(Projections.rowCount()).uniqueResult();
        return number.intValue() != 0;
    }

    public void initializeTables(ShopFloor shopFloor) {
        if (shopFloor == null || shopFloor.getId() == null) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)shopFloor);
            Hibernate.initialize(shopFloor.getTables());
        }
        finally {
            this.closeSession(session);
        }
    }

    @Override
    public void delete(ShopFloor shopFloor) throws HibernateException {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            Set<ShopTable> set = shopFloor.getTables();
            if (set != null && !set.isEmpty()) {
                shopFloor.getTables().removeAll(set);
                this.saveOrUpdate(shopFloor);
            }
            super.delete(shopFloor, session);
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            LogFactory.getLog(ShopFloorDAO.class).error((Object)exception);
            throw new HibernateException((Throwable)exception);
        }
        finally {
            this.closeSession(session);
        }
    }
}

