/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao;

import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.config.CardConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.ActionHistory;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.DataUpdateInfo;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryTransaction;
import com.floreantpos.model.InventoryTransactionType;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.KitchenTicket;
import com.floreantpos.model.KitchenTicketItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemInventoryStatus;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentStatusFilter;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.StoreSessionControl;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketType;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.VoidItem;
import com.floreantpos.model.dao.ActionHistoryDAO;
import com.floreantpos.model.dao.BaseTicketDAO;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.DataUpdateInfoDAO;
import com.floreantpos.model.dao.InventoryTransactionDAO;
import com.floreantpos.model.dao.KitchenTicketDAO;
import com.floreantpos.model.dao.KitchenTicketItemDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuItemInventoryStatusDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.RecepieDAO;
import com.floreantpos.model.dao.SequenceNumberDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.ShopTableStatusDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TicketItemDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.VoidItemDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.payment.PaymentPlugin;
import com.floreantpos.swing.PaginatedTableModel;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.payment.CardProcessor;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.NumericGlobalIdGenerator;
import com.floreantpos.util.StoreUtil;
import com.orocube.rest.service.mqtt.NotificationServiceUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Criteria;
import org.hibernate.Hibernate;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.Transaction;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.transform.Transformers;

public class TicketDAO
extends BaseTicketDAO {
    private static final TicketDAO instance = new TicketDAO();

    @Override
    public Order getDefaultOrder() {
        return Order.desc((String)Ticket.PROP_CREATE_DATE);
    }

    @Override
    protected Serializable save(Object object, Session session) {
        Ticket ticket = (Ticket)object;
        if (StringUtils.isEmpty((String)ticket.getStoreSessionId())) {
            ticket.setStoreSessionId(DataProvider.get().getStoreSession().getId());
        }
        Serializable serializable = super.save(object, session);
        this.performPostSaveOperations(session, ticket);
        return serializable;
    }

    @Override
    protected void update(Object object, Session session) {
        Ticket ticket = (Ticket)object;
        if (StringUtils.isEmpty((String)ticket.getStoreSessionId())) {
            ticket.setStoreSessionId(DataProvider.get().getStoreSession().getId());
        }
        super.update(object, session);
        this.performPostSaveOperations(session, ticket);
    }

    @Override
    public synchronized void saveOrUpdate(Ticket ticket) {
        if (StringUtils.isEmpty((String)ticket.getStoreSessionId())) {
            ticket.setStoreSessionId(DataProvider.get().getStoreSession().getId());
        }
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.saveOrUpdate(ticket, session);
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
        NotificationServiceUtils.pulishTicket(ticket.getId());
    }

    @Override
    public void saveOrUpdate(Ticket ticket, Session session) {
        this.saveOrUpdate(ticket, session, true);
    }

    private void performPostSaveOperations(Session session, Ticket ticket) {
        this.updateStock(ticket, session);
        ticket.clearDeletedItems();
        this.clearVoidedItems(ticket);
        DataUpdateInfo dataUpdateInfo = DataUpdateInfoDAO.getLastUpdateInfo(session);
        if (dataUpdateInfo != null) {
            dataUpdateInfo.setLastUpdateTime(new Date());
            DataUpdateInfoDAO.getInstance().update(dataUpdateInfo, session);
        }
    }

    public synchronized void saveOrUpdateSplitTickets(List<Ticket> list, List<Integer> list2) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            Ticket ticket = list.get(0);
            for (Ticket ticket2 : list) {
                ticket2.addProperty("split_ticket_id", ticket.getId());
                ticket2.addProperty("split", "true");
                this.saveOrUpdate(ticket2, session, false);
            }
            ShopTableStatusDAO.getInstance().addTicketsToShopTableStatus(list2, list, session);
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdate(Ticket ticket, Session session, boolean bl) {
        boolean bl2;
        boolean bl3 = bl2 = StringUtils.isEmpty((String)ticket.getId()) ? true : this.isNewTicket(ticket.getId(), session);
        if (bl2) {
            if (StringUtils.isEmpty((String)ticket.getId())) {
                ticket.setId(NumericGlobalIdGenerator.generateGlobalId());
            }
            if (StringUtils.isEmpty((String)ticket.getShortId())) {
                ticket.setShortId(RandomStringUtils.randomNumeric((int)7));
            }
            ticket.setTokenNo(SequenceNumberDAO.getInstance().getNextSequenceNumber("TICKET_TOKEN_NUMBER", session));
        }
        ticket.setActiveDate(StoreDAO.getServerTimestamp());
        ticket.updateGratuityInfo();
        if (ticket.isPaid().booleanValue() && ticket.getDueAmount() > 0.0) {
            ticket.setPaid(false);
        }
        if (bl2) {
            this.save(ticket, session);
        } else {
            this.update(ticket, session);
        }
        if (bl) {
            this.updateShopTableStatus(ticket, session, bl2);
        }
    }

    private boolean isNewTicket(String string, Session session) {
        Criteria criteria = session.createCriteria(this.getReferenceClass());
        criteria.setProjection(Projections.rowCount());
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ID, (Object)string));
        Number number = (Number)criteria.uniqueResult();
        return number == null || number.intValue() == 0;
    }

    private void clearVoidedItems(Ticket ticket) {
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            ticketItem.setVoidItem(null);
        }
    }

    public synchronized void saveKitchenPrintStatus(Ticket ticket, KitchenTicket kitchenTicket) throws Exception {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            List<KitchenTicketItem> list = kitchenTicket.getTicketItems();
            Iterator<KitchenTicketItem> iterator = list.iterator();
            while (iterator.hasNext()) {
                KitchenTicketItem kitchenTicketItem = iterator.next();
                if (!kitchenTicketItem.isVoided().booleanValue()) continue;
                String string = kitchenTicketItem.getVoidedItemId();
                KitchenTicketItemDAO.getInstance().markVoided(string, kitchenTicketItem.isModifierItem(), session);
                iterator.remove();
            }
            if (list.size() > 0) {
                KitchenTicketDAO.getInstance().saveOrUpdate(kitchenTicket, session);
            }
            ticket.clearDeletedItems();
            if (ticket.getId() == null) {
                ticket.setTokenNo(SequenceNumberDAO.getInstance().getNextSequenceNumber("TICKET_TOKEN_NUMBER", session));
            }
            this.saveOrUpdate(ticket, session);
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    private void updateShopTableStatus(Ticket ticket, Session session, boolean bl) {
        List<Integer> list = ticket.getTableNumbers();
        if (list == null || list.isEmpty()) {
            return;
        }
        if (ticket.isClosed().booleanValue()) {
            ShopTableStatusDAO.getInstance().removeTicketFromShopTableStatus(ticket, session);
        } else if (bl || ticket.isShouldUpdateTableStatus()) {
            ShopTableDAO.getInstance().occupyTables(ticket, session);
            ticket.setShouldUpdateTableStatus(false);
        }
    }

    public void voidTicket(Ticket ticket) throws Exception {
        Session session = null;
        Transaction transaction = null;
        try {
            ticket.setDiscounts(null);
            ticket.calculatePrice();
            this.populateVoidItems(ticket);
            ticket.calculatePrice();
            session = this.createNewSession();
            transaction = session.beginTransaction();
            List<KitchenTicket> list = KitchenTicketDAO.getInstance().findByParentId(ticket.getId());
            Date date = StoreDAO.getServerTimestamp();
            if (list != null) {
                for (KitchenTicket kitchenTicket : list) {
                    kitchenTicket.setCreateDate(date);
                    kitchenTicket.setVoided(true);
                    session.saveOrUpdate((Object)kitchenTicket);
                }
            }
            ticket.setVoided(true);
            ticket.setClosed(true);
            ticket.setClosingDate(StoreDAO.getServerTimestamp());
            TicketDAO.getInstance().saveOrUpdate(ticket, session);
            String string = POSConstants.RECEIPT_REPORT_TICKET_NO_LABEL + ":" + ticket.getId() + "; Total: " + NumberUtil.formatNumber(ticket.getTotalAmountWithTips());
            ActionHistoryDAO.getInstance().saveHistory(Application.getCurrentUser(), ActionHistory.VOID_CHECK, string, session);
            transaction.commit();
        }
        catch (Exception exception) {
            try {
                try {
                    transaction.rollback();
                }
                catch (Exception exception2) {
                    // empty catch block
                }
                throw exception;
            }
            catch (Throwable throwable) {
                this.closeSession(session);
                throw throwable;
            }
        }
        this.closeSession(session);
    }

    /*
     * WARNING - void declaration
     */
    private void populateVoidItems(Ticket ticket) {
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        for (TicketItem object22 : ticket.getTicketItems()) {
            void var5_7;
            if (!object22.isVoided().booleanValue()) continue;
            Double d = (Double)hashMap.get(object22.getMenuItemId());
            if (d == null) {
                Double d2 = 0.0;
            }
            double d3 = 0.0;
            d3 = Math.abs(object22.getQuantity());
            if ((d3 += var5_7.doubleValue()) == 0.0) continue;
            hashMap.put(object22.getMenuItemId(), d3);
        }
        HashMap hashMap2 = new HashMap();
        for (TicketItem ticketItem : ticket.getTicketItems()) {
            if (ticketItem.getId() == null || ticketItem.isVoided().booleanValue() || ticketItem.getVoidItem() != null) continue;
            Double d = (Double)hashMap.get(ticketItem.getMenuItemId());
            double d4 = ticketItem.getQuantity();
            if (d != null && d > 0.0) {
                if (d >= d4) {
                    hashMap.put(ticketItem.getMenuItemId(), d - d4);
                    continue;
                }
                d4 -= d.doubleValue();
            }
            hashMap2.put(ticketItem, new VoidItem(ticket.getVoidReason(), ticket.isWasted(), d4));
        }
        Set set = hashMap2.keySet();
        for (TicketItem ticketItem : set) {
            VoidItem voidItem = (VoidItem)hashMap2.get(ticketItem);
            ticket.voidItem(ticketItem, voidItem.getVoidReason(), voidItem.isItemWasted(), voidItem.getQuantity());
        }
    }

    public void loadFullTicket(Ticket ticket) {
        if (ticket.getId() == null) {
            return;
        }
        if (Hibernate.isInitialized(ticket.getTicketItems()) && Hibernate.isInitialized(ticket.getTransactions())) {
            return;
        }
        Session session = null;
        try {
            session = this.createNewSession();
            session.refresh((Object)ticket);
            Hibernate.initialize(ticket.getTicketItems());
            Hibernate.initialize(ticket.getTransactions());
        }
        finally {
            this.closeSession(session);
        }
    }

    public Ticket loadFullTicket(String string) {
        Session session = this.createNewSession();
        Ticket ticket = (Ticket)session.get(this.getReferenceClass(), (Serializable)((Object)string));
        if (ticket == null) {
            return null;
        }
        Hibernate.initialize(ticket.getTicketItems());
        Hibernate.initialize(ticket.getTransactions());
        session.close();
        return ticket;
    }

    public Ticket loadCouponsAndTransactions(String string) {
        Session session = this.createNewSession();
        Ticket ticket = (Ticket)session.get(this.getReferenceClass(), (Serializable)((Object)string));
        Hibernate.initialize(ticket.getTransactions());
        session.close();
        return ticket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findOpenTickets() {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            criteria.addOrder(this.getDefaultOrder());
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findOpenTickets(Integer n) {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_PAID, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)n));
            criteria.addOrder(this.getDefaultOrder());
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findOpenTickets(Terminal terminal, UserType userType) {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            if (userType != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_TYPE_ID, (Object)userType.getId()));
            }
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            criteria.addOrder(this.getDefaultOrder());
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumTickets() {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            this.updateCriteriaFilters(criteria);
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                int n = number.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTickets(PaginatedTableModel paginatedTableModel) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            this.updateCriteriaFilters(criteria);
            criteria.addOrder(this.getDefaultOrder());
            criteria.setFirstResult(paginatedTableModel.getCurrentRowIndex());
            criteria.setMaxResults(paginatedTableModel.getPageSize());
            paginatedTableModel.setRows(criteria.list());
            return;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findCustomerTickets(String string, PaginatedTableModel paginatedTableModel) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)string));
            criteria.setFirstResult(0);
            criteria.setMaxResults(paginatedTableModel.getPageSize());
            List list = criteria.list();
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                paginatedTableModel.setNumRows(number.intValue());
            }
            paginatedTableModel.setCurrentRowIndex(0);
            List list2 = list;
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findNextCustomerTickets(Integer n, PaginatedTableModel paginatedTableModel, String string) {
        List list;
        Session session = null;
        Criteria criteria = null;
        PaymentStatusFilter paymentStatusFilter = PaymentStatusFilter.fromString(string);
        try {
            int n2 = paginatedTableModel.getNextRowIndex();
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)n));
            if (paymentStatusFilter == PaymentStatusFilter.OPEN) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_PAID, (Object)Boolean.FALSE));
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            }
            criteria.setFirstResult(n2);
            criteria.setMaxResults(paginatedTableModel.getPageSize());
            List list2 = criteria.list();
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                paginatedTableModel.setNumRows(number.intValue());
            }
            paginatedTableModel.setCurrentRowIndex(n2);
            list = list2;
        }
        catch (Throwable throwable) {
            this.closeSession(session);
            throw throwable;
        }
        this.closeSession(session);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findPreviousCustomerTickets(Integer n, PaginatedTableModel paginatedTableModel, String string) {
        List list;
        Session session = null;
        Criteria criteria = null;
        PaymentStatusFilter paymentStatusFilter = PaymentStatusFilter.fromString(string);
        try {
            int n2 = paginatedTableModel.getPreviousRowIndex();
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)n));
            if (paymentStatusFilter == PaymentStatusFilter.OPEN) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_PAID, (Object)Boolean.FALSE));
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            }
            criteria.setFirstResult(n2);
            criteria.setMaxResults(paginatedTableModel.getPageSize());
            List list2 = criteria.list();
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                paginatedTableModel.setNumRows(number.intValue());
            }
            paginatedTableModel.setCurrentRowIndex(n2);
            list = list2;
        }
        catch (Throwable throwable) {
            this.closeSession(session);
            throw throwable;
        }
        this.closeSession(session);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findTicketByCustomer(Integer n) {
        Session session = null;
        Criteria criteria = null;
        try {
            List list;
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)n));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Ticket> findTickets(PaymentStatusFilter paymentStatusFilter, OrderType orderType) {
        return this.findTicketsForUser(paymentStatusFilter, orderType, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findTicketsForUser(PaymentStatusFilter paymentStatusFilter, OrderType orderType, User user) {
        Session session = null;
        try {
            Object object;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            if (paymentStatusFilter == PaymentStatusFilter.OPEN) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_PAID, (Object)Boolean.FALSE));
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            } else if (paymentStatusFilter == PaymentStatusFilter.PAID) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_PAID, (Object)Boolean.TRUE));
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            } else if (paymentStatusFilter == PaymentStatusFilter.CLOSED) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.TRUE));
                object = Calendar.getInstance();
                ((Calendar)object).add(11, -24);
                criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CLOSING_DATE, (Object)((Calendar)object).getTime()));
            }
            if (orderType != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ORDER_TYPE_ID, (Object)orderType.getId()));
            }
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)user.getId()));
            }
            Object object2 = object = criteria.list();
            return object2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasOpenTickets(User user) {
        Session session = null;
        try {
            Number number;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)user.getId()));
            }
            if ((number = (Number)criteria.uniqueResult()) != null) {
                boolean bl = number.intValue() > 0;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findOpenTicketsForUser(User user) {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)(user == null ? null : user.getId())));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findOpenTickets(Date date, Date date2) {
        Session session = null;
        try {
            List list;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)date2));
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findClosedTickets(Date date, Date date2) {
        Session session = null;
        try {
            List list;
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.TRUE));
            if (date != null && date2 != null) {
                criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
                criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)date2));
            }
            List list2 = list = criteria.list();
            return list2;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void closeOrder(Ticket ticket) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.saveOrUpdate(ticket);
            User user = ticket.getAssignedDriver();
            if (user != null) {
                user.setAvailableForDelivery(true);
                UserDAO.getInstance().saveOrUpdate(user);
            }
            ShopTableDAO.getInstance().releaseTables(ticket);
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            LogFactory.getLog(TicketDAO.class).error((Object)exception);
            throw new RuntimeException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findTickets(Date date, Date date2, boolean bl, Terminal terminal) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)date2));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_REFUNDED, (Object)Boolean.FALSE));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findTicketsForLaborHour(Date date, Date date2, int n, Terminal terminal) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_ACTIVE_DATE, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_ACTIVE_DATE, (Object)date2));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CREATION_HOUR, (Object)n));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findTicketsForShift(Date date, Date date2, Shift shift, Terminal terminal) {
        Session session = null;
        try {
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)date2));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_SHIFT_ID, (Object)(shift == null ? null : shift.getId())));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.TRUE));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)Boolean.FALSE));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_REFUNDED, (Object)Boolean.FALSE));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public static TicketDAO getInstance() {
        return instance;
    }

    private void updateCriteriaFilters(Criteria criteria) {
        User user = Application.getCurrentUser();
        PaymentStatusFilter paymentStatusFilter = TerminalConfig.getPaymentStatusFilter();
        String string = TerminalConfig.getOrderTypeFilter();
        boolean bl = TerminalConfig.isFilterByOwner();
        OrderType orderType = null;
        if (!"ALL".equals(string)) {
            orderType = OrderTypeDAO.getInstance().findByName(string);
        }
        if (paymentStatusFilter == PaymentStatusFilter.OPEN) {
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            if (!user.canViewAllOpenTickets() || bl) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)user.getId()));
            }
        } else if (paymentStatusFilter == PaymentStatusFilter.CLOSED) {
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.TRUE));
            StoreSessionControl storeSessionControl = StoreUtil.getCurrentStoreOperation();
            if (storeSessionControl != null && storeSessionControl.getCurrentData() != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_STORE_SESSION_ID, (Object)storeSessionControl.getCurrentData().getId()));
            }
            if (!user.canViewAllCloseTickets() || bl) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)user.getId()));
            }
        }
        if (!string.equals(POSConstants.ALL)) {
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ORDER_TYPE_ID, (Object)orderType.getId()));
        }
    }

    public void deleteTickets(List<Ticket> list) {
        this.deleteTickets(list, false);
    }

    public void deleteTickets(List<Ticket> list, boolean bl) {
        this.deleteTickets(list, bl, false);
    }

    public void deleteTickets(List<Ticket> list, boolean bl, boolean bl2) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            this.deleteTickets(session, list, bl, bl2);
            transaction.commit();
        }
        catch (Exception exception) {
            transaction.rollback();
            LogFactory.getLog(TicketDAO.class).error((Object)exception);
            throw new RuntimeException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    public void deleteTickets(Session session, List<Ticket> list, boolean bl) throws Exception {
        this.deleteTickets(session, list, bl, false);
    }

    public void deleteTickets(Session session, List<Ticket> list, boolean bl, boolean bl2) throws Exception {
        for (Ticket ticket : list) {
            List<Object> list2;
            if (!ticket.isClosed().booleanValue()) {
                list2 = new ArrayList<TicketItem>();
                list2.addAll(ticket.getTicketItems());
                for (TicketItem ticketItem : list2) {
                    ticket.addDeletedItems(ticketItem);
                }
                if (bl2 && ticket.getPaidAmount() > 0.0) {
                    TicketDAO.getInstance().updateStock(ticket, session);
                }
            }
            super.delete(ticket, session);
            if (!bl || (list2 = ticket.getTableNumbers()) == null || list2.isEmpty()) continue;
            ShopTableDAO.getInstance().freeTables(list2, session);
        }
    }

    protected void updateStock(Ticket ticket, Session session) {
        try {
            if (!this.shouldUpdateStock(ticket)) {
                return;
            }
            InventoryLocation inventoryLocation = null;
            InventoryLocation inventoryLocation2 = null;
            inventoryLocation = DataProvider.get().getDefaultOutLocation();
            if (inventoryLocation == null) {
                return;
            }
            HashMap<String, Double> hashMap = this.buildItemMapForInventoryAdjustment(ticket);
            HashMap<String, Double> hashMap2 = this.buildItemMapForVoidItems(ticket, session);
            this.adjustInventory(ticket, hashMap, InventoryTransactionType.OUT, "TICKET SALES", inventoryLocation, session);
            if (hashMap2 != null && hashMap2.size() > 0) {
                inventoryLocation2 = DataProvider.get().getDefaultInLocation();
                this.adjustInventory(ticket, hashMap2, InventoryTransactionType.IN, "VOID", inventoryLocation2, session);
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), "Failed to update stock balance for ticket: " + ticket.getId());
        }
    }

    private void adjustInventory(Ticket ticket, HashMap<String, Double> hashMap, InventoryTransactionType inventoryTransactionType, String string, InventoryLocation inventoryLocation, Session session) throws Exception {
        Store store = Application.getInstance().getStore();
        boolean bl = store.isUpdateOnHandBlncForSale();
        boolean bl2 = store.isUpdateAvlBlncForSale();
        for (String string2 : hashMap.keySet()) {
            Double d = hashMap.get(string2);
            MenuItem menuItem = MenuItemDAO.getInstance().getMenuItemWithFields(session, string2, MenuItem.PROP_NAME, MenuItem.PROP_PRICE, MenuItem.PROP_SKU, MenuItem.PROP_BARCODE, MenuItem.PROP_UNIT_ID, MenuItem.PROP_COST, MenuItem.PROP_AVERAGE_UNIT_PURCHASE_PRICE, MenuItem.PROP_AVG_COST, MenuItem.PROP_DEFAULT_RECIPE_ID);
            if (menuItem == null || !menuItem.isInventoryItem().booleanValue()) continue;
            InventoryTransaction inventoryTransaction = new InventoryTransaction();
            inventoryTransaction.setReason(string);
            inventoryTransaction.setTransactionDate(new Date());
            inventoryTransaction.setMenuItem(menuItem);
            inventoryTransaction.setType(inventoryTransactionType.getType());
            inventoryTransaction.setTicketId(ticket.getId());
            inventoryTransaction.setUser(ticket.getOwner());
            InventoryUnit inventoryUnit = menuItem.getUnit();
            inventoryTransaction.setUnitPrice(menuItem.getPrice());
            inventoryTransaction.setQuantity(d);
            if (inventoryUnit != null) {
                inventoryTransaction.setUnit(inventoryUnit.getCode());
            }
            inventoryTransaction.setUnitCost(menuItem.getAverageUnitPurchasePrice());
            if (inventoryTransactionType == InventoryTransactionType.IN) {
                inventoryTransaction.setToInventoryLocation(inventoryLocation);
            } else {
                inventoryTransaction.setFromInventoryLocation(inventoryLocation);
            }
            inventoryTransaction.setTotal(inventoryTransaction.getUnitCost() * inventoryTransaction.getQuantity());
            InventoryTransactionDAO.getInstance().adjustInventoryStock(inventoryTransaction, session, bl2, bl);
            MenuItemInventoryStatus menuItemInventoryStatus = MenuItemInventoryStatusDAO.getInstance().get(string2, session);
            if (menuItemInventoryStatus == null || !(menuItemInventoryStatus.getAvailableUnit() <= 0.0) || !StringUtils.isNotEmpty((String)menuItem.getDefaultRecipeId())) continue;
            Recepie recepie = RecepieDAO.getInstance().get(menuItem.getDefaultRecipeId(), session);
            RecepieDAO.getInstance().adjustRecipeItemsFromInventory(Arrays.asList(recepie), session);
        }
    }

    private HashMap<String, Double> buildItemMapForInventoryAdjustment(Ticket ticket) {
        List<TicketItem> list = ticket.getTicketItems();
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        this.populateItemToMap(list, hashMap);
        return hashMap;
    }

    private void populateItemToMap(List<TicketItem> list, HashMap<String, Double> hashMap) {
        for (TicketItem ticketItem : list) {
            if (!ticketItem.isInventoryItem().booleanValue() || ticketItem.getMenuItemId() == null || ticketItem.isVoided().booleanValue() || ticketItem.isInventoryAdjusted()) continue;
            Double d = hashMap.get(ticketItem.getMenuItemId());
            if (d == null) {
                d = 0.0;
            }
            Double d2 = ticketItem.getQuantity();
            d2 = d2 - ticketItem.getInventoryAdjustQty();
            if ((d2 = Double.valueOf(d2 + d)) <= 0.0) continue;
            hashMap.put(ticketItem.getMenuItemId(), d2);
            ticketItem.setInventoryAdjustQty(ticketItem.getQuantity());
            if (!ticketItem.isComboItem().booleanValue()) continue;
            this.populateItemToMap(ticketItem.getComboItems(), hashMap);
        }
    }

    private HashMap<String, Double> buildItemMapForVoidItems(Ticket ticket, Session session) {
        List<TicketItem> list = ticket.getTicketItems();
        HashMap<String, Double> hashMap = new HashMap<String, Double>();
        this.populateVoidItemToMap(ticket, session, list, hashMap);
        return hashMap;
    }

    private void populateVoidItemToMap(Ticket ticket, Session session, List<TicketItem> list, HashMap<String, Double> hashMap) {
        for (TicketItem ticketItem : list) {
            VoidItem voidItem = ticketItem.getVoidItem();
            String string = ticketItem.getMenuItemId();
            String string2 = string;
            if (StringUtils.isEmpty((String)string2)) {
                string2 = ticketItem.getName() + "_" + ticketItem.getUnitPrice();
                ticketItem.setInventoryItem(false);
            }
            if (voidItem == null || !ticketItem.isVoided().booleanValue()) continue;
            Double d = hashMap.get(string2);
            if (d == null) {
                d = 0.0;
            }
            double d2 = 0.0;
            d2 = voidItem.getQuantity();
            if ((d2 += d.doubleValue()) == 0.0) continue;
            if (!voidItem.isItemWasted().booleanValue() && !ticketItem.isInventoryAdjusted()) {
                hashMap.put(string2, d2);
                ticketItem.setInventoryAdjustQty(ticketItem.getQuantity());
            }
            Boolean bl = ticketItem.isPrintedToKitchen();
            VoidItemDAO.getInstance().saveAndSentToKitchenIfNeeded(voidItem, bl, ticket, session);
            List<VoidItem> list2 = voidItem.getVoidedModifiers();
            if (list2 != null && list2.size() > 0) {
                for (VoidItem voidItem2 : list2) {
                    VoidItemDAO.getInstance().saveAndSentToKitchenIfNeeded(voidItem2, bl, ticket, session);
                }
            }
            if (!ticketItem.isComboItem().booleanValue()) continue;
            this.populateVoidItemToMap(ticket, session, ticketItem.getComboItems(), hashMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumTickets(Date date, Date date2) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            if (date != null) {
                criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_DELIVERY_DATE, (Object)date));
            }
            if (date2 != null) {
                criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_DELIVERY_DATE, (Object)date2));
            }
            criteria.add(Restrictions.isNotNull((String)Ticket.PROP_DELIVERY_DATE));
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                int n = number.intValue();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTickets(PaginatedTableModel paginatedTableModel, Date date, Date date2) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(this.getDefaultOrder());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            if (date != null) {
                criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_DELIVERY_DATE, (Object)date));
            }
            if (date2 != null) {
                criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_DELIVERY_DATE, (Object)date2));
            }
            criteria.setFirstResult(paginatedTableModel.getCurrentRowIndex());
            criteria.setMaxResults(paginatedTableModel.getPageSize());
            paginatedTableModel.setRows(criteria.list());
            return;
        }
        finally {
            this.closeSession(session);
        }
    }

    public List<Ticket> getTicketsWithSpecificFields(String ... stringArray) {
        return this.getTicketsWithSpecificFields(true, stringArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> getTicketsWithSpecificFields(boolean bl, String ... stringArray) {
        Session session = null;
        Criteria criteria = null;
        User user = Application.getCurrentUser();
        boolean bl2 = !user.isAdministrator() || !user.isManager();
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(Ticket.class);
            if (bl) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            }
            if (bl2) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)user.getId()));
            }
            ProjectionList projectionList = Projections.projectionList();
            for (String string : stringArray) {
                projectionList.add((Projection)Projections.property((String)string), string);
            }
            criteria.setProjection((Projection)projectionList);
            criteria.setResultTransformer(Transformers.aliasToBean(Ticket.class));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTicketByOnlineOrderId(String string) {
        Session session = null;
        try {
            session = this.createNewSession();
            String string2 = "select * from TICKET_PROPERTIES where PROPERTY_VALUE='%s' and PROPERTY_NAME='%s'";
            string2 = String.format(string2, string, "onlineOrderId");
            SQLQuery sQLQuery = session.createSQLQuery(string2);
            List list = sQLQuery.list();
            boolean bl = list.size() > 0;
            return bl;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTicketByReservationId(String string) {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ID, (Object)string));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_TYPE, (Object)TicketType.RESERVATION.getTypeNo()));
            criteria.setProjection(Projections.rowCount());
            Number number = (Number)criteria.uniqueResult();
            if (number != null) {
                boolean bl = number.intValue() > 0;
                return bl;
            }
        }
        catch (Exception exception) {
            PosLog.error(this.getReferenceClass(), exception);
        }
        finally {
            this.closeSession(session);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findOnlineTickets(PaginatedTableModel paginatedTableModel) {
        Session session = null;
        try {
            session = this.createNewSession();
            String string = "select TICKET_ID from TICKET_PROPERTIES where PROPERTY_VALUE='online' and PROPERTY_NAME='source'";
            SQLQuery sQLQuery = session.createSQLQuery(string);
            List list = sQLQuery.list();
            ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
            for (String string2 : list) {
                if (string2 == null) continue;
                Ticket ticket = this.get(string2);
                arrayList.add(ticket);
            }
            ArrayList<Ticket> arrayList2 = arrayList;
            return arrayList2;
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doDriverOut(List<Ticket> list, List<User> list2) {
        Session session = null;
        Transaction transaction = null;
        try {
            session = TicketDAO.getInstance().createNewSession();
            transaction = session.beginTransaction();
            for (Ticket ticket : list) {
                ticket.addProperty("OUT_AT", DateUtil.getReportDate());
                User user = ticket.getAssignedDriver();
                if (user != null && !list2.contains(user)) {
                    list2.add(user);
                }
                this.saveOrUpdate(ticket, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage());
            if (transaction != null) {
                transaction.rollback();
            }
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void findTicketForDeliveryDispath(PaginatedTableModel paginatedTableModel, OrderType orderType, String string, Date date, Date date2, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        User user = Application.getCurrentUser();
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.addOrder(this.getDefaultOrder());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ORDER_TYPE_ID, (Object)orderType.getId()));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
            if (StringUtils.isNotEmpty((String)string)) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)string));
            }
            if (!user.canViewAllOpenTickets()) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)user.getId()));
            }
            if (date != null && date2 != null) {
                criteria.add((Criterion)Restrictions.and((Criterion)Restrictions.ge((String)Ticket.PROP_DELIVERY_DATE, (Object)date), (Criterion)Restrictions.le((String)Ticket.PROP_DELIVERY_DATE, (Object)date2)));
            }
            if (bl2) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_WILL_PICKUP, (Object)Boolean.TRUE));
            }
            if (bl3) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_WILL_PICKUP, (Object)Boolean.FALSE));
            }
            if (bl4) {
                criteria.add(Restrictions.isNull((String)Ticket.PROP_ASSIGNED_DRIVER_ID));
            }
            int n = paginatedTableModel.getCurrentRowIndex();
            criteria.setFirstResult(n);
            criteria.setMaxResults(paginatedTableModel.getPageSize());
            List list = criteria.list();
            if (bl) {
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    Ticket ticket = (Ticket)iterator.next();
                    if (ticket.isSourceOnline()) continue;
                    iterator.remove();
                }
            }
            paginatedTableModel.setRows(list);
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void closeOrders(Ticket ... ticketArray) {
        Session session = TicketDAO.getInstance().createNewSession();
        Transaction transaction = null;
        if (ticketArray == null) {
            return;
        }
        try {
            transaction = session.beginTransaction();
            Date date = StoreDAO.getServerTimestamp();
            for (Ticket ticket : ticketArray) {
                ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
                ticket.setClosed(true);
                ticket.setClosingDate(date);
                TicketDAO.getInstance().saveOrUpdate(ticket, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            PosLog.error(OrderController.class, exception);
            POSMessageDialog.showError(exception.getMessage());
            if (transaction != null) {
                transaction.rollback();
            }
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findBarTabOpenTickets(OrderType orderType) {
        List list;
        Criteria criteria;
        ArrayList<String> arrayList;
        Session session;
        block6: {
            session = null;
            try {
                arrayList = new ArrayList<String>();
                List<OrderType> list2 = DataProvider.get().getOrderTypes();
                if (list2 != null) {
                    for (OrderType comparable2 : list2) {
                        if (!comparable2.isBarTab().booleanValue()) continue;
                        arrayList.add(comparable2.getId());
                    }
                }
                if (arrayList != null && !arrayList.isEmpty()) break block6;
                criteria = null;
            }
            catch (Throwable throwable) {
                this.closeSession(session);
                throw throwable;
            }
            this.closeSession(session);
            return criteria;
        }
        session = this.getSession();
        criteria = session.createCriteria(this.getReferenceClass());
        User user = Application.getCurrentUser();
        if (user != null && !user.canViewAllOpenTickets()) {
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)user.getId()));
        }
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ORDER_TYPE_ID, (Object)(orderType == null ? null : orderType.getId())));
        criteria.add(Restrictions.in((String)Ticket.PROP_ORDER_TYPE_ID, arrayList));
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)Boolean.FALSE));
        criteria.addOrder(this.getDefaultOrder());
        List list2 = list = criteria.list();
        this.closeSession(session);
        return list2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findVoidTicketByDate(Date date, Date date2, Terminal terminal) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_VOIDED, (Object)true));
            criteria.add((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date));
            criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CLOSING_DATE, (Object)date2));
            if (terminal != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_TERMINAL_ID, (Object)terminal.getId()));
            }
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    public User findOwner(String string) {
        if (string == null) {
            return null;
        }
        Session session = this.getSession();
        Criteria criteria = session.createCriteria(Ticket.class);
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_ID, (Object)string));
        ProjectionList projectionList = Projections.projectionList();
        projectionList.add((Projection)Projections.property((String)Ticket.PROP_OWNER_ID));
        criteria.setProjection((Projection)projectionList);
        if (criteria.list().isEmpty()) {
            return null;
        }
        User user = UserDAO.getInstance().get((String)criteria.list().get(0));
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ticket findByCustomerAndDeliveryDate(String string, Date date) {
        Session session = null;
        try {
            session = this.createNewSession();
            Criteria criteria = session.createCriteria(Ticket.class);
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CUSTOMER_ID, (Object)string));
            criteria.add(Restrictions.between((String)Ticket.PROP_DELIVERY_DATE, (Object)DateUtil.startOfDay(date), (Object)DateUtil.endOfDay(date)));
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)false));
            List list = criteria.list();
            if (!list.isEmpty()) {
                Ticket ticket = (Ticket)list.get(0);
                return ticket;
            }
            Ticket ticket = null;
            return ticket;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveMergedTickets(List<Ticket> list, Ticket ticket) throws Exception {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            for (Ticket ticket2 : list) {
                this.update(ticket2, session);
            }
            this.deleteTickets(session, list, true);
            this.saveOrUpdate(ticket, session, true);
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void saveOrUpdateTransferedTicketsList(List<Ticket> list, List<Ticket> list2) throws Exception {
        Session session = null;
        Transaction transaction = null;
        try {
            session = this.createNewSession();
            transaction = session.beginTransaction();
            if (list != null || list.size() > 0) {
                this.deleteTickets(session, list, true);
            }
            for (Ticket ticket : list2) {
                this.saveOrUpdate(ticket, session);
            }
            transaction.commit();
        }
        catch (Exception exception) {
            if (transaction != null) {
                transaction.rollback();
            }
            throw exception;
        }
        finally {
            this.closeSession(session);
        }
    }

    public void reversePayment(Ticket ticket, PosTransaction posTransaction, boolean bl) {
        String string = "Failed to reverse payment.";
        if (!bl && posTransaction instanceof CreditCardTransaction) {
            CardProcessor cardProcessor = CardConfig.getPaymentGateway().getProcessor();
            try {
                cardProcessor.voidTransaction(posTransaction);
                if (!posTransaction.isVoided().booleanValue()) {
                    cardProcessor.refundTransaction(posTransaction, posTransaction.getAmount());
                    if (!posTransaction.isRefunded()) {
                        throw new PosException(string);
                    }
                }
            }
            catch (Exception exception) {
                try {
                    cardProcessor.refundTransaction(posTransaction, posTransaction.getAmount());
                    if (!posTransaction.isRefunded()) {
                        throw new PosException(string);
                    }
                }
                catch (Exception exception2) {
                    throw new PosException(string);
                }
            }
            posTransaction.setVoided(true);
            ticket.setPaidAmount(ticket.getPaidAmount() - posTransaction.getAmount());
            ticket.setDueAmount(ticket.getDueAmount() + posTransaction.getAmount());
            ticket.setClosed(false);
            ticket.setPaid(false);
            this.update(ticket);
        } else {
            Session session = null;
            Transaction transaction = null;
            try {
                session = this.createNewSession();
                transaction = session.beginTransaction();
                PaymentType paymentType = posTransaction.getPaymentType();
                PaymentPlugin paymentPlugin = paymentType.getPaymentPlugin();
                if (paymentPlugin != null) {
                    paymentPlugin.voidPayment(posTransaction, session);
                }
                posTransaction.setVoided(true);
                ticket.setPaidAmount(ticket.getPaidAmount() - posTransaction.getAmount());
                ticket.setDueAmount(ticket.getDueAmount() + posTransaction.getAmount());
                ticket.setClosed(false);
                ticket.setPaid(false);
                this.update(ticket, session);
                transaction.commit();
            }
            catch (Exception exception) {
                if (transaction != null) {
                    transaction.rollback();
                }
                throw exception;
            }
            finally {
                this.closeSession(session);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadTicketsForUser(User user, Date date, Date date2, PaginatedTableModel paginatedTableModel) {
        Session session = null;
        try {
            Number number;
            session = this.getSession();
            Criteria criteria = session.createCriteria(this.getReferenceClass());
            criteria.setProjection(Projections.rowCount());
            if (user != null) {
                criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_OWNER_ID, (Object)user.getId()));
            }
            if (date != null) {
                criteria.add((Criterion)Restrictions.or((Criterion)Restrictions.ge((String)Ticket.PROP_CREATE_DATE, (Object)date), (Criterion)Restrictions.eq((String)Ticket.PROP_CLOSED, (Object)false)));
            }
            if (date2 != null) {
                criteria.add((Criterion)Restrictions.le((String)Ticket.PROP_CREATE_DATE, (Object)date2));
            }
            if ((number = (Number)criteria.uniqueResult()) != null) {
                paginatedTableModel.setNumRows(number.intValue());
            } else {
                paginatedTableModel.setNumRows(0);
            }
            criteria.setProjection(null);
            criteria.setFirstResult(paginatedTableModel.getCurrentRowIndex());
            criteria.setMaxResults(paginatedTableModel.getPageSize());
            criteria.addOrder(Order.desc((String)Ticket.PROP_CREATE_DATE));
            paginatedTableModel.setRows(criteria.list());
        }
        finally {
            this.closeSession(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> findUnsyncedTickets() {
        Session session = null;
        Criteria criteria = null;
        try {
            session = this.createNewSession();
            criteria = session.createCriteria(this.getReferenceClass());
            criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE));
            criteria.addOrder(Order.asc((String)Ticket.PROP_CREATE_DATE));
            List list = criteria.list();
            return list;
        }
        finally {
            this.closeSession(session);
        }
    }

    private boolean shouldUpdateStock(Ticket ticket) {
        if (ticket.isReservation()) {
            return true;
        }
        return (ticket.getPaidAmount() > 0.0 || ticket.hasRefundableItem() != false) && !ticket.isSourceOnline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Ticket> getTicketsOfCurrentSession(StoreSession storeSession) {
        List<String> list;
        Criteria criteria;
        Session session;
        block3: {
            List<Ticket> list2;
            session = null;
            criteria = null;
            try {
                list = CashDrawerDAO.getInstance().getCashDrawerIds(storeSession);
                if (list != null && !list.isEmpty()) break block3;
                list2 = null;
            }
            catch (Throwable throwable) {
                this.closeSession(session);
                throw throwable;
            }
            this.closeSession(session);
            return list2;
        }
        session = this.createNewSession();
        criteria = session.createCriteria(this.getReferenceClass());
        criteria.add((Criterion)Restrictions.eq((String)Ticket.PROP_CLOUD_SYNCED, (Object)Boolean.FALSE));
        criteria.createAlias("transactions", "tx");
        criteria.add(Restrictions.in((String)("tx." + PosTransaction.PROP_CASH_DRAWER_ID), list));
        criteria.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        List list3 = criteria.list();
        this.closeSession(session);
        return list3;
    }

    public void updateTicketAndTicketItemSync(List<Ticket> list, boolean bl) {
        if (list != null) {
            for (Ticket ticket : list) {
                List<TicketItem> list2;
                this.loadFullTicket(ticket);
                if (!ticket.isCloudSynced().booleanValue() && ticket.isClosed().booleanValue()) {
                    ticket.setCloudSynced(bl);
                    TicketDAO.getInstance().update(ticket);
                }
                if ((list2 = ticket.getTicketItems()) == null) continue;
                for (TicketItem ticketItem : list2) {
                    if (ticketItem.isCloudSynced().booleanValue()) continue;
                    ticketItem.setCloudSynced(bl);
                    TicketItemDAO.getInstance().update(ticketItem);
                }
            }
        }
    }

    public void saveOrUpdateTicket(Ticket ticket, Session session) throws Exception {
        if (ticket == null) {
            return;
        }
        String string = ticket.getId();
        Ticket ticket2 = this.get(string);
        if (ticket2 != null) {
            String string2 = ticket2.getId();
            long l = ticket2.getVersion();
            PropertyUtils.copyProperties((Object)ticket2, (Object)ticket);
            if (ticket.getOutletId() != null) {
                String string3 = String.valueOf(ticket.getOutletId());
                ticket2.setOutletId(string3);
            }
            ticket2.setId(string2);
            ticket2.setVersion(l);
            this.update(ticket2, session);
        } else {
            this.save(ticket, session);
        }
    }
}

