/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.model.dao.util;

import com.floreantpos.config.AppConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.model.Address;
import com.floreantpos.model.Course;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerGroup;
import com.floreantpos.model.DayPart;
import com.floreantpos.model.Department;
import com.floreantpos.model.InventoryLocation;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemInventoryStatus;
import com.floreantpos.model.MenuShift;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PosPrinters;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.Recepie;
import com.floreantpos.model.ReportGroup;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.base.BaseAddress;
import com.floreantpos.model.base.BaseStoreSessionControl;
import com.floreantpos.model.dao.AddressDAO;
import com.floreantpos.model.dao.CourseDAO;
import com.floreantpos.model.dao.CurrencyDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.DayPartDAO;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.InventoryLocationDAO;
import com.floreantpos.model.dao.InventoryUnitDAO;
import com.floreantpos.model.dao.MenuItemInventoryStatusDAO;
import com.floreantpos.model.dao.MenuShiftDAO;
import com.floreantpos.model.dao.MultiplierDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.PriceRuleDAO;
import com.floreantpos.model.dao.PriceShiftDAO;
import com.floreantpos.model.dao.PrinterGroupDAO;
import com.floreantpos.model.dao.RecepieDAO;
import com.floreantpos.model.dao.ReportGroupDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.dao.ShiftDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TerminalTypeDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.DatabaseConnectionException;
import com.floreantpos.util.StoreUtil;
import com.orocube.common.util.TerminalUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.math.RandomUtils;
import org.hibernate.Session;

public class PosCacheManager
extends DataProvider {
    private Store store;
    private Outlet outlet;
    private Terminal terminal;
    private InventoryLocation defaultInLocation;
    private InventoryLocation defaultOutLocation;
    private Map<String, OrderType> orderTypes = null;
    private Map<String, UserType> userTypeMap = new LinkedHashMap<String, UserType>();
    private Map<String, Shift> shiftMap = new LinkedHashMap<String, Shift>();
    private Map<String, Currency> currencyMap = new LinkedHashMap<String, Currency>();
    private Map<String, TerminalType> terminalTypeMap = new LinkedHashMap<String, TerminalType>();
    private Map<String, Multiplier> multiplierMap = new LinkedHashMap<String, Multiplier>();
    private Map<String, Department> departmentMap = new LinkedHashMap<String, Department>();
    private Map<String, InventoryLocation> inventoryLocationMap = new LinkedHashMap<String, InventoryLocation>();
    private Map<String, InventoryUnit> inventoryUnitMap = new HashMap<String, InventoryUnit>();
    private Map<String, TaxGroup> taxGroupMap = new HashMap<String, TaxGroup>();
    private Map<String, PrinterGroup> printerGroupMap = new HashMap<String, PrinterGroup>();
    private Map<String, ReportGroup> reportGroupMap = new HashMap<String, ReportGroup>();
    private Map<String, Course> courseMap = new HashMap<String, Course>();
    private static List<DayPart> daypartShifts;
    private static List<PriceShift> priceShifts;
    private static List<MenuShift> menuShifts;
    private Map<Integer, Terminal> terminalMap = new LinkedHashMap<Integer, Terminal>();
    private Map<String, User> userMap = new LinkedHashMap<String, User>();
    private List<OrderType> orderTypeList = new ArrayList<OrderType>();
    private List<Multiplier> multiplierList = new ArrayList<Multiplier>();
    private String defaultCourseId;
    private PosPrinters printers;
    private StoreSession currentSession;

    @Override
    public void initialize() {
        this.terminalMap.clear();
        this.userMap.clear();
        this.multiplierList.clear();
        this.orderTypeList.clear();
        this.loadStore();
        this.initializeShifts();
        this.loadTerminalTypes();
        this.loadUserTypes();
        this.loadTerminal();
        this.loadOrderTypes();
        this.loadCurrencies();
        this.loadCourses();
        this.loadMultipliers();
        this.loadInventoryLocations();
        this.loadPrinterGroups();
        this.loadInventoryUnits();
        this.loadReportGroups();
        this.loadTaxGroups();
        this.loadDepartments();
        this.loadPrinters();
    }

    private void initializeShifts() {
        List<Shift> list = ShiftDAO.getInstance().findAll();
        this.clear(this.shiftMap);
        if (list != null && list.size() > 0) {
            for (Shift shift : list) {
                this.shiftMap.put(shift.getId(), shift);
            }
        }
        daypartShifts = DayPartDAO.getInstance().findAll();
        Iterator<Shift> iterator = daypartShifts.iterator();
        while (iterator.hasNext()) {
            Shift shift;
            shift = iterator.next();
            if (!"DEFAULT SHIFT".equalsIgnoreCase(shift.getName())) continue;
            iterator.remove();
            break;
        }
        priceShifts = PriceShiftDAO.getInstance().findAllActive();
        menuShifts = MenuShiftDAO.getInstance().findAllActive();
    }

    private void loadMultipliers() {
        List<Multiplier> list = MultiplierDAO.getInstance().findAll();
        this.clear(this.multiplierMap);
        if (list != null && list.size() > 0) {
            for (Multiplier multiplier : list) {
                this.multiplierMap.put(multiplier.getId(), multiplier);
                this.multiplierList.add(multiplier);
            }
        }
    }

    private void loadTerminalTypes() {
        List<TerminalType> list = TerminalTypeDAO.getInstance().findAll();
        this.clear(this.terminalTypeMap);
        if (list != null && list.size() > 0) {
            for (TerminalType terminalType : list) {
                this.terminalTypeMap.put(terminalType.getId(), terminalType);
            }
        }
    }

    private void loadCurrencies() {
        List<Currency> list = CurrencyDAO.getInstance().findAll();
        this.clear(this.currencyMap);
        if (list != null && list.size() > 0) {
            for (Currency currency : list) {
                this.currencyMap.put(currency.getId(), currency);
            }
        }
        CurrencyUtil.populateCurrency();
    }

    private void loadCourses() {
        List<Course> list = CourseDAO.getInstance().findAll();
        this.clear(this.courseMap);
        if (list != null && list.size() > 0) {
            this.defaultCourseId = list.get(0).getId();
            for (Course course : list) {
                this.courseMap.put(course.getId(), course);
            }
        }
    }

    private void loadUserTypes() {
        List<UserType> list = UserTypeDAO.getInstance().findAll();
        this.clear(this.userTypeMap);
        if (list != null && list.size() > 0) {
            for (UserType userType : list) {
                this.userTypeMap.put(userType.getId(), userType);
            }
        }
    }

    private void loadDepartments() {
        List<Department> list = DepartmentDAO.getInstance().findAll();
        this.clear(this.departmentMap);
        if (list != null && list.size() > 0) {
            for (Department department : list) {
                this.departmentMap.put(department.getId(), department);
            }
        }
    }

    public void loadCloudCacheData() {
        this.loadStore();
        this.loadTerminal();
        this.loadPrinterGroups();
    }

    @Override
    public void refreshStore() {
        this.loadStore();
    }

    @Override
    public void refreshCurrentTerminal() {
        TerminalDAO.getInstance().refresh(this.terminal);
    }

    private void loadStore() {
        Comparable comparable;
        this.store = StoreDAO.getRestaurant();
        if (this.store.getUniqueId() == null || this.store.getUniqueId() == 0) {
            this.store.setUniqueId(RandomUtils.nextInt());
            StoreDAO.getInstance().saveOrUpdate(this.store);
        }
        this.outlet = OutletDAO.getInstance().get(String.valueOf(this.store.getUniqueId()));
        if (this.outlet == null) {
            this.outlet = new Outlet();
            this.outlet.setId(String.valueOf(this.store.getUniqueId()));
            this.outlet.setName(this.store.getOutletName());
            comparable = new Address();
            ((BaseAddress)comparable).setAddressLine(this.store.getAddressLine1());
            this.outlet.setAddress((Address)comparable);
            AddressDAO.getInstance().saveOrUpdate((Address)comparable);
            OutletDAO.getInstance().save(this.outlet);
        }
        if ((comparable = StoreUtil.getCurrentStoreOperation()) != null) {
            this.currentSession = ((BaseStoreSessionControl)comparable).getCurrentData();
        }
        AppConfig.put("store_uuid", this.store.getUuid());
    }

    @Override
    public void setStoreSession(StoreSession storeSession) {
        this.currentSession = storeSession;
    }

    @Override
    public StoreSession getStoreSession() {
        return this.currentSession;
    }

    private void loadOrderTypes() {
        this.orderTypes = new LinkedHashMap<String, OrderType>();
        List<OrderType> list = OrderTypeDAO.getInstance().findEnabledOrderTypesForTerminal(this.terminal);
        this.orderTypeList.clear();
        if (list != null && list.size() > 0) {
            for (OrderType orderType : list) {
                this.orderTypes.put(orderType.getId(), orderType);
                this.orderTypeList.add(orderType);
            }
        }
    }

    private void loadTerminal() {
        try {
            int n = 0;
            String string = TerminalUtil.getSystemUID();
            TerminalDAO terminalDAO = TerminalDAO.getInstance();
            this.terminal = terminalDAO.getByTerminalKey(string);
            if (this.terminal != null) {
                TerminalConfig.setTerminalId(this.terminal.getId());
                return;
            }
            n = TerminalConfig.getTerminalId();
            this.terminal = terminalDAO.get(n);
            Outlet outlet = DataProvider.get().getOutlet();
            if (this.terminal == null) {
                this.terminal = terminalDAO.createNewTerminal(string, n, outlet);
            } else if (!string.equals(this.terminal.getTerminalKey())) {
                this.terminal = terminalDAO.createNewTerminal(string, null, outlet);
            }
            if (this.terminal.getOutlet() == null) {
                this.terminal.setOutlet(outlet);
                terminalDAO.saveOrUpdate(this.terminal);
            }
            TerminalConfig.setTerminalId(n);
        }
        catch (Exception exception) {
            throw new DatabaseConnectionException(exception);
        }
    }

    private void loadTaxGroups() {
        List<TaxGroup> list = TaxGroupDAO.getInstance().findAll();
        this.clear(this.taxGroupMap);
        if (list != null && list.size() > 0) {
            for (TaxGroup taxGroup : list) {
                this.taxGroupMap.put(taxGroup.getId(), taxGroup);
            }
        }
    }

    private void loadReportGroups() {
        List<ReportGroup> list = ReportGroupDAO.getInstance().findAll();
        this.clear(this.reportGroupMap);
        if (list != null && list.size() > 0) {
            for (ReportGroup reportGroup : list) {
                this.reportGroupMap.put(reportGroup.getId(), reportGroup);
            }
        }
    }

    private void loadInventoryUnits() {
        List<InventoryUnit> list = InventoryUnitDAO.getInstance().findAll();
        this.clear(this.inventoryUnitMap);
        if (list != null && list.size() > 0) {
            for (InventoryUnit inventoryUnit : list) {
                this.inventoryUnitMap.put(inventoryUnit.getId(), inventoryUnit);
            }
        }
    }

    private void loadPrinterGroups() {
        List<PrinterGroup> list = PrinterGroupDAO.getInstance().findAll();
        this.clear(this.printerGroupMap);
        if (list != null && list.size() > 0) {
            for (PrinterGroup printerGroup : list) {
                this.printerGroupMap.put(printerGroup.getId(), printerGroup);
            }
        }
    }

    private void loadInventoryLocations() {
        this.defaultInLocation = null;
        this.defaultOutLocation = null;
        Terminal terminal = this.getCurrentTerminal();
        String string = terminal.getInventoryInLocationId();
        String string2 = terminal.getInventoryOutLocationId();
        if (StringUtils.isNotEmpty((String)string)) {
            this.defaultInLocation = InventoryLocationDAO.getInstance().get(string);
        }
        if (StringUtils.isNotEmpty((String)string2)) {
            this.defaultOutLocation = InventoryLocationDAO.getInstance().get(string2);
        }
        List<InventoryLocation> list = InventoryLocationDAO.getInstance().findAll();
        this.clear(this.inventoryLocationMap);
        if (list != null && list.size() > 0) {
            for (InventoryLocation inventoryLocation : list) {
                this.inventoryLocationMap.put(inventoryLocation.getId(), inventoryLocation);
                if (this.defaultInLocation == null && inventoryLocation.isDefaultInLocation().booleanValue()) {
                    this.defaultInLocation = inventoryLocation;
                }
                if (this.defaultOutLocation != null || !inventoryLocation.isDefaultOutLocation().booleanValue()) continue;
                this.defaultOutLocation = inventoryLocation;
            }
        }
    }

    private void clear(Map map) {
        if (map.size() > 0) {
            map.clear();
        }
    }

    @Override
    public Terminal getCurrentTerminal() {
        return this.terminal;
    }

    @Override
    public void setCloudTerminal(Terminal terminal) {
        this.terminalMap.put(terminal.getId(), terminal);
        this.terminal = terminal;
    }

    @Override
    public OrderType getOrderType(String string) {
        return this.orderTypes.get(string);
    }

    @Override
    public List<OrderType> getOrderTypes() {
        return this.orderTypeList;
    }

    @Override
    public UserType getUserType(String string) {
        UserType userType = this.userTypeMap.get(string);
        if (userType == null) {
            return UserTypeDAO.getInstance().get(string);
        }
        return userType;
    }

    @Override
    public Currency getCurrency(String string) {
        return this.currencyMap.get(string);
    }

    @Override
    public Course getCourse(String string) {
        return this.courseMap.get(string);
    }

    @Override
    public TerminalType getTerminalType(String string) {
        return this.terminalTypeMap.get(string);
    }

    @Override
    public Multiplier getMultiplierById(String string) {
        return this.multiplierMap.get(string);
    }

    @Override
    public List<Multiplier> getMultiplierList() {
        return this.multiplierList;
    }

    @Override
    public InventoryLocation getDefaultInLocation() {
        return this.defaultInLocation;
    }

    @Override
    public InventoryLocation getDefaultOutLocation() {
        return this.defaultOutLocation;
    }

    @Override
    public List<Course> getCourses() {
        if (this.courseMap.size() > 0) {
            return new ArrayList<Course>(this.courseMap.values());
        }
        return new ArrayList<Course>();
    }

    @Override
    public String getDefaultCourseId() {
        return this.defaultCourseId;
    }

    @Override
    public String getRecipeMenuItemName(Recepie recepie) {
        return RecepieDAO.getInstance().getMenuItemName(recepie);
    }

    @Override
    public MenuItemInventoryStatus getMenuItemStockStatus(MenuItem menuItem) {
        MenuItemInventoryStatusDAO menuItemInventoryStatusDAO = MenuItemInventoryStatusDAO.getInstance();
        try (Session session = menuItemInventoryStatusDAO.createNewSession();){
            MenuItemInventoryStatus menuItemInventoryStatus = menuItemInventoryStatusDAO.get(menuItem.getId(), session);
            if (menuItemInventoryStatus == null) {
                menuItemInventoryStatus = new MenuItemInventoryStatus(menuItem.getId());
                menuItemInventoryStatusDAO.save(menuItemInventoryStatus, session);
            }
            MenuItemInventoryStatus menuItemInventoryStatus2 = menuItemInventoryStatus;
            return menuItemInventoryStatus2;
        }
    }

    @Override
    public SalesArea getSalesArea(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        return SalesAreaDAO.getInstance().get(string);
    }

    @Override
    public Customer getCustomer(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        return CustomerDAO.getInstance().get(string);
    }

    @Override
    public double getPriceFromPriceRule(MenuItem menuItem, OrderType orderType, Department department, SalesArea salesArea, CustomerGroup customerGroup) {
        Double d = PriceRuleDAO.getInstance().getPrice(menuItem, orderType, department, salesArea, customerGroup);
        if (d == null) {
            return menuItem.getPrice();
        }
        return d;
    }

    @Override
    public PosPrinters getPrinters() {
        return this.printers;
    }

    private void loadPrinters() {
        this.printers = PosPrinters.load();
    }

    @Override
    public Store getStore() {
        return this.store;
    }

    @Override
    public Outlet getOutlet() {
        return this.outlet;
    }

    @Override
    public InventoryUnit getInventoryUnitById(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        return this.inventoryUnitMap.get(string);
    }

    @Override
    public TaxGroup getTaxGroupById(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        return this.taxGroupMap.get(string);
    }

    @Override
    public ReportGroup getReportGroupById(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        return this.reportGroupMap.get(string);
    }

    @Override
    public PrinterGroup getPrinterGroupById(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        return this.printerGroupMap.get(string);
    }

    @Override
    public Department getDepartmentById(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        return this.departmentMap.get(string);
    }

    @Override
    public OrderType getOrderTypeById(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        if (this.orderTypes != null) {
            return this.orderTypes.get(string);
        }
        return OrderTypeDAO.getInstance().get(string);
    }

    @Override
    public InventoryLocation getInventoryLocationById(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        return this.inventoryLocationMap.get(string);
    }

    @Override
    public User getUserById(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        User user = this.userMap.get(string);
        if (user == null) {
            user = UserDAO.getInstance().get(string);
            this.userMap.put(string, user);
        }
        return user;
    }

    @Override
    public Terminal getTerminalById(Integer n) {
        if (n == null) {
            return null;
        }
        Terminal terminal = this.terminalMap.get(n);
        if (terminal == null) {
            terminal = TerminalDAO.getInstance().get(n);
            this.terminalMap.put(n, terminal);
        }
        return terminal;
    }

    @Override
    public Shift getShiftById(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return null;
        }
        return this.shiftMap.get(string);
    }

    @Override
    public List<DayPart> getDaryPartShifts() {
        return daypartShifts;
    }

    @Override
    public List<PriceShift> getPriceShifts() {
        return priceShifts;
    }

    @Override
    public List<MenuShift> getMenuShifts() {
        return menuShifts;
    }

    @Override
    public File getAppConfigFileLocation() {
        return new File(".");
    }
}

