/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.payment;

import com.floreantpos.PosException;
import com.floreantpos.customer.CustomerSelectorDialog;
import com.floreantpos.customer.CustomerSelectorFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.Customer;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.payment.AbstractPaymentPlugin;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.services.PostPaymentProcessor;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.payment.SettleTicketProcessor;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.util.List;
import net.xeoh.plugins.base.annotations.PluginImplementation;
import org.apache.commons.lang.StringUtils;
import org.hibernate.Session;
import org.hibernate.Transaction;

@PluginImplementation
public class MemberPaymentPlugin
extends AbstractPaymentPlugin
implements PostPaymentProcessor {
    private static final String a = "Member payment";
    private Customer b;

    @Override
    public String getName() {
        return a;
    }

    @Override
    public void pay(Ticket ticket, double d, SettleTicketProcessor settleTicketProcessor) throws Exception {
        this.b = this.a(ticket);
        if (this.b.getBalance() < ticket.getTotalAmount()) {
            throw new PosException("Member does not have enough balance!");
        }
        CustomerAccountTransaction customerAccountTransaction = (CustomerAccountTransaction)PaymentType.MEMBER_ACCOUNT.createTransaction(ticket, d);
        settleTicketProcessor.settleTicket(customerAccountTransaction, this);
    }

    @Override
    public String getId() {
        return a;
    }

    @Override
    public void paymentDone(PosTransaction posTransaction, Session session) {
        this.b.setBalance(this.b.getBalance() - posTransaction.getAmount());
        CustomerDAO.getInstance().saveOrUpdate(this.b, session);
    }

    public void doRefund(Ticket ticket, List<PosTransaction> list) throws Exception {
        Transaction transaction = null;
        try (Session session = null;){
            Customer customer = this.a(ticket);
            double d = this.getRefundableAmount(ticket);
            double d2 = NumberSelectionDialog2.takeDoubleInput("Enter refund amount", d);
            if (d2 <= 0.0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Refund amount must be greater than zero.");
                return;
            }
            if (d2 > d) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Refund amount cannot be greater than " + NumberUtil.round(d));
                return;
            }
            double d3 = this.calculateTaxAmount(ticket);
            Double d4 = NumberUtil.roundToTwoDigit(d3 * d2 / ticket.getPaidAmount());
            session = CustomerDAO.getInstance().createNewSession();
            transaction = session.beginTransaction();
            PosTransactionService posTransactionService = PosTransactionService.getInstance();
            RefundTransaction refundTransaction = posTransactionService.createRefundTransaction(ticket, null, d2);
            refundTransaction.setPaymentType(PaymentType.MEMBER_ACCOUNT);
            refundTransaction.setCustomPaymentFieldName("MEMBER ID");
            refundTransaction.setCustomPaymentRef(customer.getId());
            User user = Application.getCurrentUser();
            double d5 = posTransactionService.refundTicket(ticket, refundTransaction, d2, d4, user, session);
            customer.setBalance(customer.getBalance() + d5);
            CustomerDAO.getInstance().saveOrUpdate(customer, session);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Refunded " + CurrencyUtil.getCurrencySymbol() + d5);
            transaction.commit();
        }
    }

    private Customer a(Ticket ticket) {
        Customer customer = ticket.getCustomer();
        if (customer == null) {
            CustomerSelectorDialog customerSelectorDialog = CustomerSelectorFactory.createCustomerSelectorDialog(ticket.getOrderType());
            customerSelectorDialog.setCreateNewTicket(false);
            if (ticket != null) {
                customerSelectorDialog.setTicket(ticket);
            }
            customerSelectorDialog.openUndecoratedFullScreen();
            if (customerSelectorDialog.isCanceled()) {
                throw new PosException("Member not selected!");
            }
            customer = customerSelectorDialog.getSelectedCustomer();
            if (customer == null) {
                throw new PosException("Member not selected!");
            }
            ticket.setCustomer(customer);
            OrderController.saveOrder(ticket);
        }
        return customer;
    }

    @Override
    public void voidPayment(PosTransaction posTransaction, Session session) {
        String string = posTransaction.getCustomerId();
        if (StringUtils.isEmpty((String)string)) {
            throw new PosException("Member ID not found in transaction.");
        }
        Customer customer = CustomerDAO.getInstance().get(string);
        customer.setBalance(customer.getBalance() + posTransaction.getAmount());
        CustomerDAO.getInstance().saveOrUpdate(customer, session);
    }
}

