/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.model.CashDropTransaction;
import com.floreantpos.model.Customer;
import com.floreantpos.model.PayOutTransaction;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.CustomerDAO;
import java.text.SimpleDateFormat;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class CashDrawerTransactionReportModel
extends AbstractTableModel {
    private static final SimpleDateFormat a = new SimpleDateFormat("dd MMM yy, hh:mm a");
    private String[] b = new String[]{"transTime", "ticketId", "member", "totalAmount", "transType"};
    private List<PosTransaction> c;

    @Override
    public int getRowCount() {
        if (this.c == null) {
            return 0;
        }
        return this.c.size();
    }

    @Override
    public int getColumnCount() {
        return this.b.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.b[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        PosTransaction posTransaction = this.c.get(n);
        Ticket ticket = posTransaction.getTicket();
        switch (n2) {
            case 0: {
                return a.format(posTransaction.getTransactionTime());
            }
            case 1: {
                if (ticket != null) {
                    return ticket.getId();
                }
                return null;
            }
            case 2: {
                String string = posTransaction.getCustomerId();
                if (string == null) {
                    return "Guest";
                }
                Customer customer = CustomerDAO.getInstance().findById(string);
                return customer == null ? "Guest" : customer.getName();
            }
            case 3: {
                if (posTransaction instanceof RefundTransaction || posTransaction instanceof CashDropTransaction || posTransaction instanceof PayOutTransaction) {
                    return posTransaction.getAmount() * -1.0;
                }
                return posTransaction.getAmount();
            }
            case 4: {
                return posTransaction.getPaymentTypeString().replaceAll("_", " ");
            }
        }
        return null;
    }

    public List<PosTransaction> getItems() {
        return this.c;
    }

    public void setItems(List<PosTransaction> list) {
        this.c = list;
    }
}

