/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.report;

import com.floreantpos.report.ReportItem;
import java.text.DecimalFormat;
import java.util.List;
import javax.swing.table.AbstractTableModel;

public class SalesReportModel
extends AbstractTableModel {
    private static DecimalFormat a = new DecimalFormat("#,##0.00");
    private String[] b = new String[]{"barcode", "name", "qty", "price", "cost", "costPercentage", "grossTotal", "tax", "netTotal", "group", "discount", "serviceCharge"};
    private List<ReportItem> c;
    private double d;
    private double e;
    private double f;
    private double g;
    private double h;

    @Override
    public int getRowCount() {
        if (this.c == null) {
            return 0;
        }
        return this.c.size();
    }

    @Override
    public int getColumnCount() {
        return this.b.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.b[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ReportItem reportItem = this.c.get(n);
        switch (n2) {
            case 0: {
                return reportItem.getBarcode() != null ? reportItem.getBarcode() : reportItem.getId();
            }
            case 1: {
                return reportItem.getName();
            }
            case 2: {
                return reportItem.getQuantity();
            }
            case 3: {
                return reportItem.getPrice();
            }
            case 4: {
                return reportItem.getCost();
            }
            case 5: {
                if (reportItem.getAdjustedPrice() > 0.0) {
                    return reportItem.getCost() / reportItem.getAdjustedPrice() * 100.0;
                }
                return 0.0;
            }
            case 6: {
                return reportItem.getGrossTotal();
            }
            case 7: {
                return reportItem.getTaxTotal();
            }
            case 8: {
                return reportItem.getNetTotal();
            }
            case 9: {
                if (reportItem.getGroupName() != null) {
                    return "Group: " + reportItem.getGroupName();
                }
                return "Group: NONE";
            }
            case 10: {
                return reportItem.getDiscount();
            }
            case 11: {
                return reportItem.getServiceCharge();
            }
        }
        return null;
    }

    public List<ReportItem> getItems() {
        return this.c;
    }

    public void setItems(List<ReportItem> list) {
        this.c = list;
    }

    public double getGrandTotal() {
        return this.d;
    }

    public String getGrandTotalAsString() {
        return a.format(this.d);
    }

    public void setGrandTotal(double d) {
        this.d = d;
    }

    public void calculateGrandTotal() {
        this.d = 0.0;
        if (this.c == null) {
            return;
        }
        for (ReportItem reportItem : this.c) {
            this.d += reportItem.getNetTotal();
        }
    }

    public String getTaxTotalAsString() {
        return a.format(this.f);
    }

    public void setTaxTotal(double d) {
        this.f = d;
    }

    public void calculateTaxTotal() {
        this.f = 0.0;
        if (this.c == null) {
            return;
        }
        for (ReportItem reportItem : this.c) {
            this.f += reportItem.getTaxTotal();
        }
    }

    public String getNetTotalAsString() {
        return a.format(this.g);
    }

    public void setNetTotal(double d) {
        this.g = d;
    }

    public void calculateNetTotal() {
        this.g = 0.0;
        if (this.c == null) {
            return;
        }
        for (ReportItem reportItem : this.c) {
            this.g += reportItem.getGrossTotal();
        }
    }

    public String getTotalQuantityAsString() {
        return String.valueOf(this.e);
    }

    public void setTotalQuantity(int n) {
        this.e = n;
    }

    public void calculateTotalQuantity() {
        this.e = 0.0;
        if (this.c == null) {
            return;
        }
        for (ReportItem reportItem : this.c) {
            this.e += reportItem.getQuantity();
        }
    }

    public String getDiscountTotalAsString() {
        return String.valueOf(this.h);
    }

    public void setDiscountTotal(int n) {
        this.h = n;
    }

    public void calculateDiscountTotal() {
        this.h = 0.0;
        if (this.c == null) {
            return;
        }
        for (ReportItem reportItem : this.c) {
            this.h += reportItem.getDiscount();
        }
    }
}

