/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.services;

import com.floreantpos.model.Customer;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemSeat;
import com.floreantpos.model.base.BaseTicketItemSeat;
import com.floreantpos.util.AESencrp;
import com.floreantpos.util.NumberUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;

public class SplitTicketService {
    public static final String SPLIT_TYPE = "SPLIT_TYPE";
    public static final int SPLIT_EQUALLY = 0;
    public static final int SPLIT_BY_SEAT = 1;
    public static final int SPLIT_MANUALLY = 2;

    static List<Double> a(double d, int n) {
        ArrayList<Double> arrayList = new ArrayList<Double>(n);
        double d2 = 0.0;
        for (int i = 0; i < n; ++i) {
            double d3 = d - d2;
            double d4 = n - i;
            double d5 = d3 > 0.0 ? Math.max(NumberUtil.roundToTwoDigit(d3 / d4), 0.01) : 0.0;
            arrayList.add(d5);
            d2 += d5;
        }
        Double d6 = (Double)arrayList.get(n - 1);
        if (d2 < d) {
            d6 = d6 + (d - d2);
            arrayList.set(n - 1, d6);
        }
        return arrayList;
    }

    public static List<Ticket> doEquallySplit(Ticket ticket, int n) throws Exception {
        HashMap<Integer, Ticket> hashMap = new HashMap<Integer, Ticket>();
        hashMap.put(1, ticket);
        for (int i = 1; i < n; ++i) {
            Ticket ticket2 = SplitTicketService.a(ticket, n);
            ticket2.setSplitOrder(i + 1);
            for (TicketItem ticketItem : ticket.getTicketItems()) {
                SplitTicketService.transferTicketItem(ticketItem, ticket2, n);
            }
            ticket2.calculatePrice();
            hashMap.put(i + 1, ticket2);
        }
        SplitTicketService.a(ticket, null, 0, n);
        return new ArrayList<Ticket>(hashMap.values());
    }

    public static List<Ticket> doSplitBySeatNumber(Ticket ticket) throws Exception {
        int n;
        Object object;
        Comparable comparable;
        ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
        List<TicketItem> list = ticket.getTicketItems();
        ArrayList<TicketItem> arrayList2 = new ArrayList<TicketItem>();
        HashMap<Integer, Customer> hashMap = new HashMap<Integer, Customer>();
        HashMap<Integer, ArrayList<TicketItem>> hashMap2 = new HashMap<Integer, ArrayList<TicketItem>>();
        for (TicketItem object22 : list) {
            comparable = object22.getSeat();
            object = comparable == null ? object22.getSeatNumber() : ((BaseTicketItemSeat)comparable).getSeatNumber();
            Serializable serializable = (ArrayList<TicketItem>)hashMap2.get(object);
            if ((Integer)object == 0) {
                arrayList2.add(object22);
                continue;
            }
            if (serializable == null) {
                serializable = new ArrayList<TicketItem>();
                serializable.add(object22);
                if (comparable != null) {
                    hashMap.put(object22.getSeatNumber(), ((TicketItemSeat)comparable).getMember());
                }
                hashMap2.put(object22.getSeatNumber(), (ArrayList<TicketItem>)serializable);
                continue;
            }
            serializable.add(object22);
        }
        if (hashMap2.size() <= 1) {
            return null;
        }
        int n2 = 1;
        Iterator n22 = hashMap2.keySet().iterator();
        while (n22.hasNext()) {
            comparable = (Integer)n22.next();
            object = (List)hashMap2.get(comparable);
            if (object == null || object.size() != 1 || !((TicketItem)object.get(0)).isTreatAsSeat().booleanValue()) continue;
            n22.remove();
        }
        boolean bl = false;
        if (hashMap2.keySet().size() > 1) {
            n = hashMap2.keySet().size();
        }
        comparable = (Integer)hashMap2.keySet().iterator().next();
        ticket.setTicketItems((List)hashMap2.get(comparable));
        arrayList.add(ticket);
        for (Serializable serializable : hashMap2.keySet()) {
            if (((Integer)serializable).intValue() == ((Integer)comparable).intValue()) continue;
            List list2 = (List)hashMap2.get(serializable);
            Ticket ticket2 = SplitTicketService.a(ticket, list2, arrayList2, n2, n, 1);
            Customer customer = (Customer)hashMap.get(serializable);
            if (customer != null) {
                ticket2.setCustomer(customer);
            }
            arrayList.add(ticket2);
            ++n2;
        }
        SplitTicketService.a(ticket, arrayList2, n2, n, 1);
        object = (Customer)hashMap.get(comparable);
        if (object != null) {
            ticket.setCustomer((Customer)object);
        }
        return arrayList;
    }

    private static Ticket a(Ticket ticket, List<TicketItem> list, List<TicketItem> list2, int n, int n2, int n3) throws Exception {
        TicketItem ticketItem;
        Ticket ticket2 = SplitTicketService.a(ticket, n3);
        ticket2.setSplitOrder(n + 1);
        for (TicketItem ticketItem2 : list) {
            ticketItem = SplitTicketService.a(ticketItem2, 1);
            ticketItem.setTicket(ticket2);
            ticketItem.setPrintedToKitchen(ticketItem2.isPrintedToKitchen());
            ticket2.addToticketItems(ticketItem);
        }
        if (list2 != null && n2 > 1) {
            for (TicketItem ticketItem2 : list2) {
                ticketItem = SplitTicketService.a(ticketItem2, n2);
                ticketItem.setFractionalUnit(true);
                ticketItem.setPrintedToKitchen(ticketItem2.isPrintedToKitchen());
                ticket2.addToticketItems(ticketItem);
                ticketItem.setTicket(ticket2);
            }
        }
        ticket2.calculatePrice();
        return ticket2;
    }

    private static List<TicketDiscount> a(List<TicketDiscount> list, int n) throws Exception {
        ArrayList<TicketDiscount> arrayList = new ArrayList<TicketDiscount>();
        if (list != null && !list.isEmpty()) {
            for (TicketDiscount ticketDiscount : list) {
                TicketDiscount ticketDiscount2 = new TicketDiscount();
                PropertyUtils.copyProperties((Object)ticketDiscount2, (Object)ticketDiscount);
                ticketDiscount2.setId(null);
                if (ticketDiscount.getType() != 1) {
                    ticketDiscount2.setCouponQuantity(ticketDiscount.getCouponQuantity() / (double)n);
                }
                arrayList.add(ticketDiscount2);
            }
        }
        return arrayList;
    }

    public static void transferTicketItem(TicketItem ticketItem, Ticket ticket, int n) {
        TicketItem ticketItem2 = SplitTicketService.a(ticketItem, n);
        if (Double.isInfinite(n)) {
            return;
        }
        if (n % 1 != 0) {
            ticketItem2.setFractionalUnit(true);
        }
        ticketItem2.setMenuItemId(ticketItem.getMenuItemId());
        ticketItem2.setTicket(ticket);
        ticketItem2.setPrintedToKitchen(ticketItem.isPrintedToKitchen());
        ticket.addToticketItems(ticketItem2);
    }

    private static TicketItem a(TicketItem ticketItem, int n) {
        try {
            TicketItem ticketItem2 = ticketItem.cloneAsNew();
            ticketItem2.setQuantity(ticketItem.getQuantity() / (double)n);
            List<TicketItemDiscount> list = ticketItem2.getDiscounts();
            ticketItem2.calculatePrice();
            SplitTicketService.d(list, n);
            return ticketItem2;
        }
        catch (Exception exception) {
            return ticketItem;
        }
    }

    private static Ticket a(Ticket ticket, int n) throws Exception {
        Ticket ticket2 = new Ticket(true);
        PropertyUtils.copyProperties((Object)ticket2, (Object)ticket);
        ticket2.setProperties(null);
        ticket2.setTransactions(null);
        ticket2.setId(null);
        ticket2.setTokenNo(null);
        ticket2.setShortId(null);
        ticket2.setTicketItems(null);
        ticket2.setDiscounts(SplitTicketService.a(ticket.getDiscounts(), n));
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        List<Integer> list = ticket.getTableNumbers();
        if (list != null) {
            arrayList.addAll(list);
        }
        ticket2.setTableNumbers(arrayList);
        return ticket2;
    }

    private static void a(Ticket ticket, List<TicketItem> list, int n, int n2) throws Exception {
        SplitTicketService.a(ticket, list, n, n2, n2);
    }

    private static void a(Ticket ticket, List<TicketItem> list, int n, int n2, int n3) throws Exception {
        ticket.setSplitOrder(n + 1);
        SplitTicketService.b(ticket.getTicketItems(), n3);
        if (list != null && n2 > 1) {
            ArrayList<TicketItem> arrayList = new ArrayList<TicketItem>();
            for (TicketItem ticketItem : list) {
                TicketItem ticketItem2 = SplitTicketService.a(ticketItem, n2);
                ticketItem2.setFractionalUnit(true);
                arrayList.add(ticketItem2);
                ticketItem2.setTicket(ticket);
            }
            for (TicketItem ticketItem : arrayList) {
                ticket.addToticketItems(ticketItem);
            }
        }
        SplitTicketService.c(ticket.getDiscounts(), n2);
        ticket.calculatePrice();
    }

    private static void b(List<TicketItem> list, int n) throws Exception {
        for (TicketItem ticketItem : list) {
            ticketItem.setQuantity(ticketItem.getQuantity() / (double)n);
            ticketItem.setFractionalUnit(true);
            ticketItem.calculatePrice();
            SplitTicketService.d(ticketItem.getDiscounts(), n);
        }
    }

    private static void c(List<TicketDiscount> list, int n) throws Exception {
        if (list != null && !list.isEmpty()) {
            for (TicketDiscount ticketDiscount : list) {
                if (ticketDiscount.getType() == 1) continue;
                ticketDiscount.setCouponQuantity(ticketDiscount.getCouponQuantity() / (double)n);
            }
        }
    }

    private static void d(List<TicketItemDiscount> list, int n) throws Exception {
        if (list != null && !list.isEmpty()) {
            for (TicketItemDiscount ticketItemDiscount : list) {
                if (ticketItemDiscount.getType() != 1) {
                    ticketItemDiscount.setCouponQuantity(ticketItemDiscount.getCouponQuantity() / (double)n);
                }
                ticketItemDiscount.calculateDiscount(ticketItemDiscount.getTicketItem().getSubtotalAmount());
            }
        }
    }

    public static void main(String[] stringArray) throws Exception {
        String string = AESencrp.decrypt("ICniG0w+rKbFnd+T2TUDUA==");
        System.out.println(string);
    }
}

