/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.swing;

import com.floreantpos.swing.ListModel;
import java.util.List;

public class PaginatedListModel<E>
extends ListModel<E> {
    private int numRows;
    private int currentRowIndex;
    private int pageSize = 10;

    public PaginatedListModel() {
    }

    public PaginatedListModel(int n) {
        this.pageSize = n;
    }

    public PaginatedListModel(List<E> list) {
        super(list);
    }

    public int getNumRows() {
        return this.numRows;
    }

    public void setNumRows(int n) {
        this.numRows = n;
    }

    public int getCurrentRowIndex() {
        return this.currentRowIndex;
    }

    public void setCurrentRowIndex(int n) {
        this.currentRowIndex = n;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int n) {
        this.pageSize = n;
    }

    public boolean hasNext() {
        return this.currentRowIndex + this.pageSize < this.numRows;
    }

    public boolean hasPrevious() {
        return this.currentRowIndex > 0;
    }

    public int getNextRowIndex() {
        if (this.numRows == 0) {
            return 0;
        }
        return this.getCurrentRowIndex() + this.getPageSize();
    }

    public int getPreviousRowIndex() {
        int n = this.getCurrentRowIndex() - this.getPageSize();
        if (n < 0) {
            n = 0;
        }
        return n;
    }
}

