/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.table;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.model.BookingInfo;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableType;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.dao.BookingInfoDAO;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.table.ShopTableForm;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang3.StringUtils;

public class ShopTableBrowser
extends TransparentPanel {
    private JTable a;
    private BeanTableModel<ShopTable> b;
    private JTextField c;

    public ShopTableBrowser() {
        this.a();
        this.initData();
    }

    private void a() {
        this.setBorder(new TitledBorder(null, "TABLES", 2, 2, null, null));
        this.b = new BeanTableModel(ShopTable.class);
        this.b.addColumn(Messages.getString("ShopTableBrowser.0"), ShopTable.PROP_ID);
        this.b.addColumn("Name", ShopTable.PROP_NAME);
        this.b.addColumn(Messages.getString("ShopTableBrowser.1"), ShopTable.PROP_CAPACITY);
        this.b.addColumn("Type", "typesAsString");
        this.b.addColumn("Min Guest", ShopTable.PROP_MIN_CAPACITY);
        this.b.addColumn("Reservable", ShopTable.PROP_RESERVABLE);
        this.b.addColumn(Messages.getString("ShopTableBrowser.2"), ShopTable.PROP_DESCRIPTION);
        this.a = new JTable(this.b);
        this.a.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.a.setSelectionMode(0);
        this.a.setRowHeight(PosUIManager.getSize(20));
        this.a.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    ShopTableBrowser.this.d();
                }
            }
        });
        this.a.setRowHeight(PosUIManager.getSize(30));
        this.setLayout(new BorderLayout(5, 5));
        this.add((Component)new PosScrollPane(this.a), "Center");
        this.add((Component)this.b(), "South");
        this.add((Component)this.h(), "North");
    }

    private JPanel b() {
        ExplorerButtonPanel explorerButtonPanel = new ExplorerButtonPanel();
        JButton jButton = explorerButtonPanel.getEditButton();
        JButton jButton2 = explorerButtonPanel.getAddButton();
        JButton jButton3 = explorerButtonPanel.getDeleteButton();
        jButton2.setText("NEW");
        jButton.setText("EDIT");
        jButton3.setText("DELETE");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShopTableBrowser.this.d();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShopTableBrowser.this.c();
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShopTableBrowser.this.e();
            }
        });
        JButton jButton4 = new JButton("DUPLICATE");
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShopTableBrowser.this.g();
            }
        });
        JButton jButton5 = new JButton("DELETE ALL");
        jButton5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShopTableBrowser.this.f();
            }
        });
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("center", ""));
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton);
        transparentPanel.add(jButton3);
        transparentPanel.add(jButton4);
        transparentPanel.add(jButton5);
        jPanel.add((Component)transparentPanel, "");
        return jPanel;
    }

    public void initData() {
        List<ShopTable> list = ShopTableDAO.getInstance().findAllWithTypes();
        BeanTableModel beanTableModel = (BeanTableModel)this.a.getModel();
        beanTableModel.removeAll();
        beanTableModel.addRows(list);
    }

    public void doRefreshTable() {
        List<ShopTable> list = ShopTableDAO.getInstance().findAllWithTypes();
        BeanTableModel beanTableModel = (BeanTableModel)this.a.getModel();
        beanTableModel.removeAll();
        beanTableModel.addRows(list);
    }

    private void c() {
        ShopTableForm shopTableForm = new ShopTableForm(new ShopTable(), false);
        BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)shopTableForm);
        beanEditorDialog.openFullScreen();
        if (beanEditorDialog.isCanceled()) {
            return;
        }
        ShopTable shopTable = (ShopTable)shopTableForm.getBean();
        this.b.addRow(shopTable);
    }

    private void d() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select a table.");
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            ShopTable shopTable = this.b.getRow(n);
            this.b.setRow(n, shopTable);
            ShopTableForm shopTableForm = new ShopTableForm(shopTable, false);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)shopTableForm);
            beanEditorDialog.openWithScale(800, 600);
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.a.repaint();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void e() {
        int n = this.a.getSelectedRow();
        if (n < 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select a table.");
            return;
        }
        n = this.a.convertRowIndexToModel(n);
        ShopTable shopTable = this.b.getRow(n);
        this.b.setRow(n, shopTable);
        ShopTableForm shopTableForm = new ShopTableForm(shopTable, false);
        shopTableForm.delete();
        this.a.repaint();
        this.doRefreshTable();
    }

    private void f() {
        boolean bl = this.deleteAllTables();
        if (bl) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "All table successfully deleted!");
        }
        this.a.repaint();
        this.doRefreshTable();
    }

    public boolean deleteAllTables() {
        List<ShopTable> list = ShopTableDAO.getInstance().findAll();
        if (list.isEmpty()) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), Messages.getString("ShopTableForm.51"));
            return false;
        }
        int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), Messages.getString("ShopTableForm.20"), Messages.getString("ShopTableForm.21"));
        if (n != 0) {
            return false;
        }
        List<BookingInfo> list2 = BookingInfoDAO.getInstance().findAll();
        for (BookingInfo comparable : list2) {
            comparable.setTables(null);
            BookingInfoDAO.getInstance().saveOrUpdate(comparable);
        }
        for (ShopTable shopTable : list) {
            shopTable.setFloor(null);
            shopTable.setTypes(null);
            ShopTableDAO.getInstance().delete(shopTable);
        }
        return true;
    }

    private void g() {
        int n = this.a.getSelectedRow();
        if (n < 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select a table.");
            return;
        }
        n = this.a.convertRowIndexToModel(n);
        ShopTable shopTable = this.b.getRow(n);
        NumberSelectionDialog2 numberSelectionDialog2 = new NumberSelectionDialog2();
        numberSelectionDialog2.setTitle("How many duplicates?");
        numberSelectionDialog2.setFloatingPoint(false);
        numberSelectionDialog2.pack();
        numberSelectionDialog2.open();
        if (numberSelectionDialog2.isCanceled()) {
            return;
        }
        int n2 = (int)numberSelectionDialog2.getValue();
        for (int i = 0; i < n2; ++i) {
            this.a(shopTable);
        }
        this.a.repaint();
        this.doRefreshTable();
    }

    private void a(ShopTable shopTable) {
        ShopTable shopTable2 = new ShopTable();
        int n = ShopTableDAO.getInstance().getNextTableNumber();
        if (shopTable2.getId() == null) {
            shopTable2.setId(n + 1);
        }
        List<ShopTableType> list = shopTable.getTypes();
        ArrayList<ShopTableType> arrayList = new ArrayList<ShopTableType>();
        for (ShopTableType shopTableType : list) {
            arrayList.add(shopTableType);
        }
        shopTable2.setTypes(arrayList);
        shopTable2.setCapacity(shopTable.getCapacity());
        shopTable2.setDescription(shopTable.getDescription());
        shopTable2.setName(shopTable.getName());
        shopTable2.setTableStatus(TableStatus.Available);
        shopTable2.setMinCapacity(shopTable.getMinCapacity());
        shopTable2.setReservable(shopTable.isReservable());
        ShopTableDAO.getInstance().saveOrUpdate(shopTable2);
    }

    private JPanel h() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("", "[][][][]", ""));
        JLabel jLabel = new JLabel("Search by capacity: ");
        this.c = new JTextField(15);
        JButton jButton = new JButton("Search");
        JButton jButton2 = new JButton("Reset");
        JButton jButton3 = new JButton("Refresh");
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShopTableBrowser.this.i();
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShopTableBrowser.this.i();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShopTableBrowser.this.c.setText("");
                ShopTableBrowser.this.doRefreshTable();
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ShopTableBrowser.this.c.setText("");
                ShopTableBrowser.this.doRefreshTable();
            }
        });
        jPanel.add((Component)jLabel, "grow");
        jPanel.add((Component)this.c, "grow");
        jPanel.add((Component)jButton, "grow");
        jPanel.add((Component)jButton3, "grow");
        return jPanel;
    }

    private void i() {
        String string = this.c.getText();
        if (StringUtils.isEmpty((CharSequence)string)) {
            return;
        }
        List<ShopTable> list = ShopTableDAO.getInstance().findBy(string);
        if (list == null || list.size() == 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "No result found!");
            return;
        }
        BeanTableModel beanTableModel = (BeanTableModel)this.a.getModel();
        beanTableModel.removeAll();
        beanTableModel.addRows(list);
    }
}

