/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui;

import com.floreantpos.IconFactory;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.base.BaseTerminal;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.util.NumberUtil;
import java.awt.Color;
import java.awt.Component;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableModel;

public class PosTableRenderer
extends DefaultTableCellRenderer {
    private static final SimpleDateFormat a = new SimpleDateFormat("MMM dd, h:m a");
    private JCheckBox b = new JCheckBox();
    private JLabel c = new JLabel();

    public PosTableRenderer() {
        this.b.setHorizontalAlignment(0);
        this.c.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
        if (object instanceof String) {
            jLabel.setText(object.toString());
        }
        jLabel.setIcon(null);
        jLabel.setHorizontalAlignment(10);
        if (object instanceof Boolean) {
            this.b.setSelected((Boolean)object);
            if (bl) {
                this.b.setBackground(jTable.getSelectionBackground());
            } else {
                this.b.setBackground(jTable.getBackground());
            }
            return this.b;
        }
        if (object instanceof Color) {
            Color color = (Color)object;
            String string = Integer.toHexString(color.getRGB()).toUpperCase();
            string = string.substring(2, string.length());
            this.c.setText(string);
            this.c.setBackground(color);
            return this.c;
        }
        if (object instanceof ImageIcon) {
            ImageIcon imageIcon = (ImageIcon)object;
            if ((imageIcon = new ImageIcon(imageIcon.getImage().getScaledInstance(48, 48, 4))) != null) {
                jTable.setRowHeight(PosUIManager.getSize(60));
            }
            JLabel jLabel2 = new JLabel(imageIcon);
            MatteBorder matteBorder = BorderFactory.createMatteBorder(5, 5, 5, 5, jTable.getBackground());
            jLabel2.setBorder(matteBorder);
            return jLabel2;
        }
        if (n2 == 0) {
            Serializable serializable;
            Object e;
            Ticket ticket = null;
            TableModel tableModel = jTable.getModel();
            if (tableModel instanceof ListTableModel && (e = ((ListTableModel)(serializable = (ListTableModel)tableModel)).getRowData(n)) instanceof Ticket) {
                ticket = (Ticket)e;
            }
            if (ticket == null) {
                return jLabel;
            }
            if (ticket.isSourceOnline()) {
                jLabel.setIcon(IconFactory.getIcon("/ui_icons/", "cloud.png"));
            }
            if ((serializable = ticket.getTerminal()) != null && ((BaseTerminal)serializable).getDeviceType() == 1) {
                jLabel.setIcon(IconFactory.getIcon("/ui_icons/", "mobile_32px.png"));
            }
        }
        if (object instanceof Double) {
            jLabel.setHorizontalAlignment(4);
        }
        return jLabel;
    }

    @Override
    protected void setValue(Object object) {
        if (object == null) {
            this.setText("");
            return;
        }
        String string = object.toString();
        if (object instanceof Double || object instanceof Float) {
            string = NumberUtil.formatNumber(((Number)object).doubleValue(), true);
            this.setHorizontalAlignment(4);
        } else if (object instanceof Integer) {
            this.setHorizontalAlignment(4);
        } else if (object instanceof Date) {
            string = a.format(object);
            this.setHorizontalAlignment(2);
        } else {
            this.setHorizontalAlignment(2);
        }
        this.setText(" " + string + " ");
    }
}

