/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuCategoryForm;
import com.floreantpos.ui.views.MenuCategorySelectionView;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class MenuCategorySelectionDialog
extends POSDialog
implements ActionListener {
    private MenuCategorySelectionView a;
    private List<MenuCategory> b;
    private int c;
    private TitlePanel d;
    private static MenuCategorySelectionDialog e;

    public MenuCategorySelectionDialog(List<MenuCategory> list) {
        super(POSUtil.getFocusedWindow(), "");
        this.b = list;
        this.a();
    }

    public MenuCategorySelectionDialog() {
        super(POSUtil.getFocusedWindow(), "");
        this.setTitle("Select menu category");
        this.a();
    }

    private void a() {
        this.setLayout(new BorderLayout(5, 5));
        this.setTitle("Select Menu Category");
        this.d = new TitlePanel();
        this.d.setTitle("Select one or more menu category");
        this.add((Component)this.d, "North");
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,inset 0 10 0 10"));
        this.a = new MenuCategorySelectionView(this.b);
        jPanel.add((Component)this.a, "grow,span,wrap");
        PosButton posButton = new PosButton("SELECT");
        posButton.setActionCommand(POSConstants.OK);
        posButton.setBackground(Color.GREEN);
        posButton.setFocusable(false);
        posButton.addActionListener(this);
        PosButton posButton2 = new PosButton(POSConstants.CANCEL);
        posButton2.setFocusable(false);
        posButton2.addActionListener(this);
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("center,ins 0 5 5 5", "", ""));
        PosButton posButton3 = new PosButton();
        PosButton posButton4 = new PosButton();
        posButton4.setText(POSConstants.ADD.toUpperCase());
        posButton3.setText(POSConstants.EDIT.toUpperCase());
        posButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuCategorySelectionDialog.this.d();
            }
        });
        posButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    MenuCategory menuCategory = new MenuCategory();
                    MenuCategoryForm menuCategoryForm = new MenuCategoryForm(menuCategory);
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuCategoryForm);
                    beanEditorDialog.setPreferredSize(PosUIManager.getSize(900, 650));
                    beanEditorDialog.open();
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    MenuCategory menuCategory2 = (MenuCategory)menuCategoryForm.getBean();
                    MenuCategorySelectionDialog.this.a.getModel().addRow(menuCategory2);
                }
                catch (Throwable throwable) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        jPanel2.add(posButton4);
        jPanel2.add(posButton3);
        jPanel2.add(posButton);
        jPanel2.add(posButton2);
        this.add((Component)jPanel2, "South");
        this.add(jPanel);
    }

    public void setSelectionMode(int n) {
        this.c = n;
        if (n == 0) {
            this.d.setTitle("SELECT A MENU CATEGORY");
        } else {
            this.d.setTitle("Select one or more menu category");
        }
        this.a.setSelectionMode(n);
    }

    public void setSelectedOrderType(OrderType orderType) {
        this.a.setSelectedOrdertype(orderType);
    }

    private void b() {
        if (this.c == 0) {
            MenuCategory menuCategory = this.getSelectedRowData();
            if (menuCategory == null) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select menu category");
                return;
            }
        } else {
            List<MenuCategory> list = this.a.getSelectedMenuCategoryList();
            if (list == null || list.isEmpty()) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select menu category");
                return;
            }
        }
        this.setCanceled(false);
        this.dispose();
    }

    private void c() {
        this.setCanceled(true);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (POSConstants.CANCEL.equalsIgnoreCase(string)) {
            this.c();
        } else if (POSConstants.OK.equalsIgnoreCase(string)) {
            this.b();
        }
    }

    private void d() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                return;
            }
            MenuCategory menuCategory = this.a.getModel().getRow(n);
            MenuCategoryDAO.getInstance().initialize(menuCategory);
            this.a.getModel().setRow(n, menuCategory);
            MenuCategoryForm menuCategoryForm = new MenuCategoryForm(menuCategory);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuCategoryForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            this.a.repaintTable();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    public List<MenuCategory> getSelectedCategories() {
        return this.a.getSelectedMenuCategoryList();
    }

    public MenuCategory getSelectedRowData() {
        int n = this.a.getSelectedRow();
        if (n < 0) {
            return null;
        }
        return this.a.getModel().getRow(n);
    }

    public static MenuCategorySelectionDialog getInstance() {
        if (e == null) {
            e = new MenuCategorySelectionDialog();
        }
        return e;
    }
}

