/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.POSConstants;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.RefundTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.VoidTransaction;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.dialog.GlobalInputDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.payment.SettleTicketProcessor;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.Window;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class RefundDialog
extends OkCancelOptionDialog {
    private Ticket a;
    private Map<String, PosButton> b = new HashMap<String, PosButton>();
    private PosButton c;
    private PosButton d;
    private JPanel e;
    private double f = 0.0;
    private SettleTicketProcessor g;

    public RefundDialog(Window window, Ticket ticket, SettleTicketProcessor settleTicketProcessor) {
        super(window, "");
        this.a = ticket;
        this.g = settleTicketProcessor;
        this.a();
        this.b();
        this.c();
    }

    private void a() {
        this.setCaption("Refund " + CurrencyUtil.getCurrencySymbol() + this.d());
        this.setOkButtonText(POSConstants.SAVE_BUTTON_TEXT);
        this.setDefaultCloseOperation(0);
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("inset 0,fill,hidemode 3", "[grow]", ""));
        Font font = new Font("Tahoma", 1, PosUIManager.getFontSize(16));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("fill,ins 0 5 2 5,hidemode 3", "[grow]", "[grow]"));
        this.e = new JPanel((LayoutManager)new MigLayout("wrap 3,center", "sg,fill", ""));
        this.c = new PosButton("<html><center><h2> CASH </h2></center></html>");
        this.c.setAction(new CashRefundAction());
        this.c.setMinimumSize(PosUIManager.getSize(120, 110));
        this.d = new PosButton("<html><center><h2> GIFT CARD </h2></center></html>");
        this.d.setAction(new GiftCardRefundAction());
        this.d.setMinimumSize(PosUIManager.getSize(120, 110));
        JLabel jLabel = new JLabel("Select transaction to refund");
        jLabel.setFont(font);
        PosScrollPane posScrollPane = new PosScrollPane(this.e);
        posScrollPane.setBorder(BorderFactory.createTitledBorder(null, "REFUND USING", 2, 2));
        jPanel2.add((Component)posScrollPane, "grow,aligny bottom,span");
        jPanel.add((Component)jPanel2, "grow");
        this.getContentPanel().add(jPanel);
    }

    private void b() {
        this.e.removeAll();
        this.e.add((Component)this.c, "aligny top");
        this.e.add((Component)this.d, "aligny top");
        if (this.a != null && this.a.getTransactions() != null) {
            for (PosTransaction posTransaction : this.a.getTransactions()) {
                if (posTransaction.isVoided().booleanValue() || posTransaction instanceof RefundTransaction || posTransaction instanceof VoidTransaction || posTransaction instanceof CashTransaction) continue;
                PosButton posButton = new PosButton();
                posButton.putClientProperty("transaction", posTransaction);
                posButton.setAction(new RefundAction());
                posButton.setMinimumSize(PosUIManager.getSize(120, 110));
                this.a(posTransaction, posButton);
                this.e.add((Component)posButton, "aligny top");
                this.b.put(posTransaction.getId(), posButton);
            }
        }
        boolean bl = this.a.getPaidAmount() != this.a.getRefundAmount();
        this.c.setEnabled(bl);
        this.c.setText("<html><center><b>CASH </b></center></html>");
        this.d.setEnabled(bl);
        this.d.setText("<html><center><b>GIFT CARD </b></center></html>");
        this.e.revalidate();
        this.e.repaint();
    }

    private void a(PosTransaction posTransaction, PosButton posButton) {
        double d = this.a(posTransaction);
        if (d > 0.0) {
            posButton.setText("<html><center>" + (Object)((Object)posTransaction.getPaymentType()) + "<br><h2>" + CurrencyUtil.getCurrencySymbol() + posTransaction.getAmount() + "</h2><h5>Refunded -" + CurrencyUtil.getCurrencySymbol() + d + "</h5></html>");
            posButton.setEnabled(posTransaction.getAmount() != d);
            if (posTransaction.getAmount() != d) {
                posButton.setSelected(true);
            }
        } else {
            posButton.setSelected(true);
            posButton.setText("<html><center>" + (Object)((Object)posTransaction.getPaymentType()) + "<br><h2>" + CurrencyUtil.getCurrencySymbol() + posTransaction.getAmount() + "<h2></center></html>");
        }
    }

    private double a(List<PosTransaction> list) {
        double d = 0.0;
        for (PosTransaction posTransaction : list) {
            if (posTransaction.isVoided().booleanValue()) continue;
            d += posTransaction.getAmount().doubleValue();
        }
        return d;
    }

    private void c() {
        this.f = 0.0;
        for (PosTransaction posTransaction : this.a.getTransactions()) {
            if (posTransaction instanceof RefundTransaction || posTransaction.isVoided().booleanValue()) continue;
            this.f += posTransaction.getTaxAmount().doubleValue();
        }
    }

    @Override
    public void doOk() {
        this.setCanceled(false);
        this.dispose();
    }

    private void a(List<PosTransaction> list, boolean bl) {
        this.a(list, bl, false);
    }

    private void a(List<PosTransaction> list, boolean bl, boolean bl2) {
        try {
            double d;
            DrawerUtil.kickDrawer();
            double d2 = this.d();
            String string = null;
            if (bl2) {
                GlobalInputDialog globalInputDialog = new GlobalInputDialog();
                globalInputDialog.setCaption("Enter gift card number ");
                globalInputDialog.open();
                if (globalInputDialog.isCanceled()) {
                    return;
                }
                string = globalInputDialog.getInput();
                if (string == null) {
                    return;
                }
            }
            if ((d = NumberSelectionDialog2.takeDoubleInput("Enter refund amount", d2)) < 0.0) {
                return;
            }
            if (d == 0.0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Refund amount must be greater than zero.");
                return;
            }
            if (d > d2) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Refund amount cannot be greater than " + d2);
                return;
            }
            Double d3 = NumberUtil.roundToTwoDigit(this.f * d / this.a.getPaidAmount());
            double d4 = PosTransactionService.getInstance().refundTicket(this.a, d, d3, Application.getCurrentUser(), list, bl, string);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Refunded " + CurrencyUtil.getCurrencySymbol() + d4);
            this.a.calculatePrice();
            if (NumberUtil.isZero(this.a.getDueAmount())) {
                this.doOk();
            }
            this.g.doInformListenerPaymentUpdate();
            this.setCaption("Refund " + CurrencyUtil.getCurrencySymbol() + this.d());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private double d() {
        double d = 0.0;
        if (this.a.getDueAmount() >= 0.0) {
            return 0.0;
        }
        d = Math.abs(this.a.getDueAmount());
        return NumberUtil.roundToTwoDigit(d);
    }

    private double b(List<PosTransaction> list) {
        double d = 0.0;
        for (PosTransaction posTransaction : list) {
            String string;
            if (posTransaction.isVoided().booleanValue() || !StringUtils.isNotEmpty((String)(string = posTransaction.getProperty("REFUNDED_AMOUNT")))) continue;
            try {
                d += Double.parseDouble(string);
            }
            catch (Exception exception) {}
        }
        return NumberUtil.roundToTwoDigit(d);
    }

    private double a(PosTransaction posTransaction) {
        double d = 0.0;
        String string = posTransaction.getProperty("REFUNDED_AMOUNT");
        if (StringUtils.isNotEmpty((String)string)) {
            try {
                d = Double.parseDouble(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return NumberUtil.roundToTwoDigit(d);
    }

    private class GiftCardRefundAction
    extends PosAction {
        @Override
        public void execute() {
            ArrayList<PosTransaction> arrayList = new ArrayList<PosTransaction>();
            for (PosTransaction posTransaction : RefundDialog.this.a.getTransactions()) {
                if (posTransaction instanceof RefundTransaction || posTransaction instanceof VoidTransaction) continue;
                arrayList.add(posTransaction);
            }
            RefundDialog.this.a(arrayList, false, true);
        }
    }

    private class CashRefundAction
    extends PosAction {
        @Override
        public void execute() {
            ArrayList<PosTransaction> arrayList = new ArrayList<PosTransaction>();
            for (PosTransaction posTransaction : RefundDialog.this.a.getTransactions()) {
                if (posTransaction instanceof RefundTransaction || posTransaction instanceof VoidTransaction) continue;
                arrayList.add(posTransaction);
            }
            RefundDialog.this.a(arrayList, true);
        }
    }

    private class RefundAction
    extends PosAction {
        public RefundAction() {
            this.setRequiredPermission(UserPermission.PERFORM_MANAGER_TASK);
            this.setMandatoryPermission(true);
        }

        @Override
        public void execute() {
            PosButton posButton = (PosButton)this.event.getSource();
            PosTransaction posTransaction = (PosTransaction)posButton.getClientProperty("transaction");
            String string = posTransaction.getProperty("REFUNDED_AMOUNT");
            double d = 0.0;
            if (StringUtils.isNotEmpty((String)string)) {
                try {
                    d = Double.parseDouble(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (d >= posTransaction.getAmount()) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Transaction already refunded.");
                    posButton.setSelected(false);
                    return;
                }
            }
            ArrayList<PosTransaction> arrayList = new ArrayList<PosTransaction>();
            arrayList.add(posTransaction);
            RefundDialog.this.a(arrayList, false);
        }
    }
}

