/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.dialog;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.actions.GroupSettleTicketAction;
import com.floreantpos.actions.SettleTicketAction;
import com.floreantpos.actions.TicketTransferAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.ButtonColumn;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.UserListDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.table.TableColumnModelExt;

public class ServerOpenTicketListDialog
extends POSDialog {
    private TitlePanel a;
    private JXTable b;
    private TicketTableModel c;
    private List<Ticket> d;
    private DefaultListSelectionModel e;
    private User f;
    private User g;
    private PosButton h;
    private boolean i;

    public ServerOpenTicketListDialog(User user, User user2, boolean bl) {
        super((Frame)Application.getPosWindow(), true);
        this.f = user;
        this.g = user2;
        this.i = bl;
        this.a();
        this.initData();
        this.e();
    }

    @Override
    public void setTitle(String string) {
        super.setTitle(POSConstants.OPEN_TICKETS);
        this.a.setTitle(string);
    }

    private void a() {
        TransparentPanel transparentPanel = new TransparentPanel();
        this.a = new TitlePanel();
        TransparentPanel transparentPanel2 = new TransparentPanel();
        TransparentPanel transparentPanel3 = new TransparentPanel((LayoutManager)new MigLayout("al center", "sg, fill", ""));
        JSeparator jSeparator = new JSeparator();
        this.h = new PosButton();
        JScrollPane jScrollPane = new JScrollPane();
        this.b = new JXTable();
        this.b.setRowHeight(PosUIManager.getSize(30));
        this.b.getTableHeader().setPreferredSize(PosUIManager.getSize(0, 30));
        this.getContentPane().setLayout(new BorderLayout(5, 5));
        transparentPanel.setLayout(new BorderLayout(5, 5));
        transparentPanel.add((Component)jSeparator, "North");
        PosButton posButton = new PosButton(POSConstants.TRANSFER_ALL);
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServerOpenTicketListDialog.this.b();
            }
        });
        transparentPanel3.add(posButton);
        PosButton posButton2 = new PosButton(POSConstants.SETTLE_ALL);
        posButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServerOpenTicketListDialog.this.d();
            }
        });
        transparentPanel3.add(posButton2);
        PosButton posButton3 = new PosButton(POSConstants.CLOSE_ALL);
        posButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServerOpenTicketListDialog.this.c();
            }
        });
        transparentPanel3.add(posButton3);
        this.h.setText("DONE");
        this.h.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ServerOpenTicketListDialog.this.a(actionEvent);
            }
        });
        transparentPanel3.add(this.h);
        transparentPanel.add((Component)transparentPanel3, "Center");
        this.getContentPane().add((Component)transparentPanel, "South");
        transparentPanel2.setLayout(new BorderLayout());
        transparentPanel2.add((Component)this.a, "North");
        jScrollPane.setBorder(BorderFactory.createCompoundBorder(new EmptyBorder(10, 10, 5, 10), jScrollPane.getBorder()));
        jScrollPane.setViewportView((Component)this.b);
        transparentPanel2.add((Component)jScrollPane, "Center");
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("center,ins 0"));
        transparentPanel2.add((Component)jPanel, "South");
        this.getContentPane().add((Component)transparentPanel2, "Center");
    }

    public void initData() {
        this.e = new DefaultListSelectionModel();
        this.e.setSelectionMode(0);
        this.b.getSelectionModel().setSelectionMode(0);
        this.b.setDefaultRenderer(Object.class, (TableCellRenderer)new TableRenderer());
        this.c = new TicketTableModel();
        this.b.setModel((TableModel)this.c);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Integer.parseInt(actionEvent.getActionCommand());
                Ticket ticket = (Ticket)ServerOpenTicketListDialog.this.c.getRowData(n);
                ServerOpenTicketListDialog.this.a(ticket);
                ServerOpenTicketListDialog.this.e();
            }
        };
        AbstractAction abstractAction2 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Integer.parseInt(actionEvent.getActionCommand());
                Ticket ticket = (Ticket)ServerOpenTicketListDialog.this.c.getRowData(n);
                new SettleTicketAction(ticket, ServerOpenTicketListDialog.this.f).actionPerformed(actionEvent);
                ServerOpenTicketListDialog.this.e();
            }
        };
        AbstractAction abstractAction3 = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Integer.parseInt(actionEvent.getActionCommand());
                Ticket ticket = (Ticket)ServerOpenTicketListDialog.this.c.getRowData(n);
                ServerOpenTicketListDialog.this.doCloseTicket(ticket);
                ServerOpenTicketListDialog.this.e();
            }
        };
        this.a(abstractAction, 5);
        this.a(abstractAction2, 6);
        this.a(abstractAction3, 7);
        this.f();
        TableColumnModelExt tableColumnModelExt = (TableColumnModelExt)this.b.getColumnModel();
        tableColumnModelExt.getColumnExt(2).setVisible(!this.i);
    }

    private void a(AbstractAction abstractAction, int n) {
        ButtonColumn buttonColumn = new ButtonColumn((JTable)this.b, abstractAction, n){

            @Override
            public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
                return super.getTableCellRendererComponent(jTable, object, false, bl2, n, n2);
            }

            @Override
            public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
                return super.getTableCellEditorComponent(jTable, object, false, n, n2);
            }
        };
        MatteBorder matteBorder = BorderFactory.createMatteBorder(3, 3, 3, 3, this.b.getBackground());
        MatteBorder matteBorder2 = BorderFactory.createMatteBorder(3, 3, 3, 3, this.b.getBackground());
        CompoundBorder compoundBorder = new CompoundBorder(matteBorder, this.h.getBorder());
        CompoundBorder compoundBorder2 = new CompoundBorder(matteBorder2, this.h.getBorder());
        buttonColumn.setUnselectedBorder(compoundBorder);
        buttonColumn.setFocusBorder(compoundBorder2);
    }

    private void a(Ticket ticket) {
        try {
            TicketTransferAction ticketTransferAction = new TicketTransferAction(ticket, this.f);
            ticketTransferAction.execute();
            if (!ticketTransferAction.isTransfered()) {
                return;
            }
            this.e();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Messages.getString("UserTransferDialog.4"));
            PosLog.error(this.getClass(), exception);
        }
    }

    protected void doCloseTicket(Ticket ticket) {
        int n;
        int n2 = (int)POSUtil.getDouble(ticket.getDueAmount());
        if (n2 != 0 && (n = POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), Messages.getString("ServerOpenTicketListDialog.0"), POSConstants.CONFIRM)) != 0) {
            return;
        }
        n = JOptionPane.showOptionDialog(Application.getPosWindow(), Messages.getString("SwitchboardView.6") + ticket.getId() + Messages.getString("SwitchboardView.7"), POSConstants.CONFIRM, 2, 1, null, null, null);
        if (n != 0) {
            return;
        }
        TicketDAO.closeOrders(ticket);
    }

    private void b() {
        List list = this.c.getRows();
        if (list == null || list.isEmpty()) {
            return;
        }
        UserListDialog userListDialog = new UserListDialog();
        userListDialog.setTitle(Messages.getString("UserTransferDialog.0"));
        userListDialog.setCaption(Messages.getString("UserTransferDialog.1"));
        userListDialog.setSize(PosUIManager.getSize(400, 600));
        userListDialog.open();
        if (userListDialog.isCanceled()) {
            return;
        }
        User user = userListDialog.getSelectedUser();
        if (user == null) {
            return;
        }
        try {
            for (Ticket ticket : list) {
                this.doTransferTicket(ticket, user);
            }
            POSMessageDialog.showMessage(Messages.getString("ServerOpenTicketListDialog.1"));
            this.e();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage());
        }
    }

    protected void doTransferTicket(Ticket ticket, User user) {
        ticket.setOwner(user);
        TicketDAO.getInstance().saveOrUpdate(ticket);
    }

    private void c() {
        List list = this.c.getRows();
        if (list == null || list.isEmpty()) {
            return;
        }
        int n = POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), Messages.getString("ServerOpenTicketListDialog.2"), POSConstants.CONFIRM);
        try {
            if (n == 0) {
                TicketDAO.closeOrders(list.toArray(new Ticket[list.size()]));
            }
            this.e();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void d() {
        List list = this.c.getRows();
        if (list == null || list.isEmpty()) {
            return;
        }
        ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
        for (Ticket ticket : list) {
            if (ticket.getOrderType().isBarTab().booleanValue()) continue;
            arrayList.add(ticket);
        }
        GroupSettleTicketAction groupSettleTicketAction = new GroupSettleTicketAction(arrayList, this.f);
        groupSettleTicketAction.actionPerformed(null);
        this.e();
    }

    private void e() {
        this.d = this.i ? TicketDAO.getInstance().findOpenTicketsForUser(this.g) : TicketDAO.getInstance().findOpenTickets();
        if (this.d != null) {
            for (Ticket ticket : this.d) {
                TicketDAO.getInstance().loadFullTicket(ticket);
            }
        }
        this.c.setItems(this.d);
        this.c.fireTableDataChanged();
    }

    private void f() {
        this.b.setAutoResizeMode(4);
        this.a(0, PosUIManager.getSize(100));
        this.a(1, PosUIManager.getSize(150));
    }

    private void a(int n, int n2) {
        TableColumn tableColumn = this.b.getColumnModel().getColumn(n);
        tableColumn.setPreferredWidth(n2);
        tableColumn.setMaxWidth(n2);
        tableColumn.setMinWidth(n2);
    }

    public void setInfo(String string) {
        this.a.setTitle(string);
    }

    private void a(ActionEvent actionEvent) {
        this.setCanceled(false);
        this.dispose();
    }

    public boolean hasOpenTickets() {
        return this.c.getRowCount() > 0;
    }

    class TableRenderer
    extends DefaultTableCellRenderer {
        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof Date) {
                jLabel.setHorizontalAlignment(4);
            }
            if (object instanceof Double) {
                jLabel.setHorizontalAlignment(4);
            } else if (n2 == 1) {
                jLabel.setHorizontalAlignment(2);
            } else {
                jLabel.setHorizontalAlignment(0);
            }
            return jLabel;
        }
    }

    class TicketTableModel
    extends ListTableModel<Ticket> {
        public TicketTableModel() {
            super(new String[]{POSConstants.TOKEN.toUpperCase(), POSConstants.ORDER_TYPE.toUpperCase(), POSConstants.SERVER.toUpperCase(), POSConstants.TOTAL.toUpperCase(), POSConstants.DUE.toUpperCase(), "", "", ""});
        }

        public void setItems(List<Ticket> list) {
            this.setRows(list);
        }

        @Override
        public int getRowCount() {
            if (ServerOpenTicketListDialog.this.d == null) {
                return 0;
            }
            int n = ServerOpenTicketListDialog.this.d.size();
            return n;
        }

        @Override
        public int getColumnCount() {
            return 8;
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return n2 == 5 || n2 == 6 || n2 == 7;
        }

        public Ticket getSelectedRow() {
            int n = ServerOpenTicketListDialog.this.b.getSelectedRow();
            if (n < 0) {
                return null;
            }
            n = ServerOpenTicketListDialog.this.b.convertRowIndexToModel(n);
            return (Ticket)ServerOpenTicketListDialog.this.c.getRowData(n);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (ServerOpenTicketListDialog.this.d == null) {
                return "";
            }
            Ticket ticket = (Ticket)ServerOpenTicketListDialog.this.d.get(n);
            switch (n2) {
                case 0: {
                    return ticket.getTokenNo();
                }
                case 1: {
                    return ticket.getOrderType();
                }
                case 2: {
                    return ticket.getOwner();
                }
                case 3: {
                    return ticket.getTotalAmountWithTips();
                }
                case 4: {
                    return ticket.getDueAmount();
                }
                case 5: {
                    return POSConstants.TRANSFER;
                }
                case 6: {
                    return POSConstants.SETTLE;
                }
                case 7: {
                    return POSConstants.CLOSE.toUpperCase();
                }
            }
            return "";
        }
    }
}

