/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.export_import;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.config.AppProperties;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.table.TableColumnModel;
import liquibase.util.file.FilenameUtils;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.hibernate.exception.ConstraintViolationException;

public class ExcelImportViewDialog
extends POSDialog {
    private TitlePanel a;
    private JPanel b;
    private String c;
    private JTabbedPane d;
    private ItemContainer e;
    private ItemContainer f;
    private List<Object> g;

    public ExcelImportViewDialog(String string) throws Exception {
        this.c = string;
        this.a();
        this.g();
    }

    private void a() {
        this.setTitle(AppProperties.getAppName());
        this.setLayout(new BorderLayout(5, 5));
        this.a = new TitlePanel();
        this.d = new JTabbedPane();
        this.e = new ItemContainer(this.c());
        this.f = new ItemContainer(this.b());
        this.d.addTab("Menu Item", this.e);
        this.d.addTab("Menu Modifier", this.f);
        this.add((Component)this.a, "North");
        this.add((Component)this.d, "Center");
        this.b = this.e();
        this.add((Component)this.b, "South");
    }

    private BeanTableModel b() {
        BeanTableModel beanTableModel = new BeanTableModel(MenuModifier.class);
        beanTableModel.addColumn(POSConstants.NAME.toUpperCase(), MenuModifier.PROP_NAME);
        beanTableModel.addColumn(POSConstants.PRICE.toUpperCase() + " (" + CurrencyUtil.getCurrencySymbol() + ")", MenuModifier.PROP_PRICE);
        beanTableModel.addColumn(POSConstants.ACTIVE.toUpperCase(), MenuModifier.PROP_ENABLE);
        beanTableModel.addColumn(POSConstants.PIZZA_MODIFIER.toUpperCase(), MenuModifier.PROP_PIZZA_MODIFIER);
        return beanTableModel;
    }

    private BeanTableModel c() {
        BeanTableModel beanTableModel = new BeanTableModel(MenuItem.class);
        beanTableModel.addColumn(POSConstants.CATEGORY.toUpperCase(), MenuItem.PROP_MENU_CATEGORY_NAME);
        beanTableModel.addColumn(POSConstants.GROUP.toUpperCase(), MenuItem.PROP_MENU_GROUP_NAME);
        beanTableModel.addColumn(POSConstants.NAME.toUpperCase(), MenuItem.PROP_NAME);
        beanTableModel.addColumn(POSConstants.DESCRIPTION.toUpperCase(), MenuItem.PROP_DESCRIPTION);
        beanTableModel.addColumn(POSConstants.PRICE.toUpperCase() + " (" + CurrencyUtil.getCurrencySymbol() + ")", MenuItem.PROP_PRICE);
        beanTableModel.addColumn(POSConstants.COST.toUpperCase(), MenuItem.PROP_COST);
        beanTableModel.addColumn(POSConstants.SKU.toUpperCase(), MenuItem.PROP_SKU);
        beanTableModel.addColumn(POSConstants.BARCODE.toUpperCase(), MenuItem.PROP_BARCODE);
        beanTableModel.addColumn(POSConstants.ACTIVE.toUpperCase(), MenuItem.PROP_VISIBLE);
        beanTableModel.addColumn(POSConstants.FRACTIONAL_UNIT.toUpperCase(), MenuItem.PROP_FRACTIONAL_UNIT);
        beanTableModel.addColumn(POSConstants.INVENTORY_ITEM.toUpperCase(), MenuItem.PROP_INVENTORY_ITEM);
        beanTableModel.addColumn(POSConstants.ALLOW_PRICE_OVERRIDE.toUpperCase(), MenuItem.PROP_EDITABLE_PRICE);
        return beanTableModel;
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth((Integer)this.d().get(i));
        }
    }

    private List d() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(90);
        arrayList.add(90);
        arrayList.add(130);
        arrayList.add(130);
        arrayList.add(90);
        arrayList.add(80);
        arrayList.add(110);
        arrayList.add(80);
        arrayList.add(80);
        arrayList.add(100);
        arrayList.add(105);
        arrayList.add(95);
        return arrayList;
    }

    private JPanel e() {
        JButton jButton = new JButton(POSConstants.DELETE.toUpperCase());
        jButton.setText(Messages.getString("MenuItemExplorer.19"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ExcelImportViewDialog.this.f();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage().toString());
                }
            }
        });
        JButton jButton2 = new JButton(POSConstants.SAVE.toUpperCase());
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ExcelImportViewDialog.this.setCanceled(false);
                    ExcelImportViewDialog.this.dispose();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage().toString());
                }
            }
        });
        JButton jButton3 = new JButton(POSConstants.CANCEL.toUpperCase());
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ExcelImportViewDialog.this.dispose();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage().toString());
                }
            }
        });
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("center", ""));
        jPanel.add(jButton2);
        jPanel.add(jButton);
        jPanel.add(jButton3);
        return jPanel;
    }

    private void f() {
        try {
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            int n = this.d.getSelectedIndex();
            ItemContainer itemContainer = (ItemContainer)this.d.getComponentAt(n);
            JTable jTable = itemContainer.c;
            BeanTableModel beanTableModel = itemContainer.b;
            int[] nArray = jTable.getSelectedRows();
            if (nArray.length <= 0) {
                return;
            }
            for (int i = 0; i < nArray.length; ++i) {
                beanTableModel.removeRow(nArray[i] - i);
            }
            this.a(beanTableModel.getRowCount());
        }
        catch (ConstraintViolationException constraintViolationException) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "This menu item is in use and cannot be deleted.");
            return;
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void g() throws Exception {
        String string = FilenameUtils.getExtension((String)this.c);
        if (string.equals("xlsx")) {
            this.g = this.h();
            if (this.g == null) {
                return;
            }
            for (Object object : this.g) {
                Comparable comparable;
                if (object instanceof MenuItem) {
                    comparable = (MenuItem)object;
                    this.e.b.addRow(comparable);
                    continue;
                }
                if (!(object instanceof MenuModifier)) continue;
                comparable = (MenuModifier)object;
                this.f.b.addRow(comparable);
            }
            this.a(this.g.size());
        } else if (string.equals("xls")) {
            this.g = this.i();
            if (this.g == null) {
                return;
            }
            for (Object object : this.g) {
                Comparable comparable;
                if (object instanceof MenuItem) {
                    comparable = (MenuItem)object;
                    this.e.b.addRow(comparable);
                    continue;
                }
                if (!(object instanceof MenuModifier)) continue;
                comparable = (MenuModifier)object;
                this.f.b.addRow(comparable);
            }
            this.a(this.g.size());
        } else {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectAnExcelFile"));
            return;
        }
    }

    private void a(int n) {
        this.a.setTitle("Imported " + n + " rows, Please review and then click save to make it permanent");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> h() throws Exception {
        XSSFWorkbook xSSFWorkbook = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        MenuCategory menuCategory = null;
        MenuGroup menuGroup = null;
        ModifierGroup modifierGroup = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(this.c);
            xSSFWorkbook = new XSSFWorkbook((InputStream)fileInputStream);
            this.a(arrayList, menuCategory, menuGroup, xSSFWorkbook.getSheetAt(0));
            this.a(arrayList, modifierGroup, xSSFWorkbook.getSheetAt(1));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("InvalidExcel"), exception);
            List<Object> list = null;
            return list;
        }
        finally {
            if (xSSFWorkbook != null) {
                xSSFWorkbook.close();
            }
        }
        return arrayList;
    }

    private void a(List<Object> list, MenuCategory menuCategory, MenuGroup menuGroup, XSSFSheet xSSFSheet) throws Exception {
        Iterator iterator = xSSFSheet.rowIterator();
        while (iterator.hasNext()) {
            XSSFRow xSSFRow = (XSSFRow)iterator.next();
            if (xSSFRow.getRowNum() == 0) continue;
            Iterator iterator2 = xSSFRow.cellIterator();
            MenuItem menuItem = null;
            while (iterator2.hasNext()) {
                Cell cell = (Cell)iterator2.next();
                String string = "";
                double d = 0.0;
                switch (cell.getCellTypeEnum()) {
                    case STRING: {
                        string = cell.getStringCellValue();
                        break;
                    }
                    case NUMERIC: {
                        d = cell.getNumericCellValue();
                    }
                }
                String string2 = xSSFSheet.getRow(0).getCell(cell.getColumnIndex()).getStringCellValue();
                if (string2.equals("Product Category")) {
                    menuCategory = MenuCategoryDAO.getInstance().findCategoriesByName(string);
                    if (menuCategory != null) continue;
                    menuCategory = new MenuCategory();
                    menuCategory.setName(string);
                    menuCategory.setVisible(true);
                    MenuCategoryDAO.getInstance().save(menuCategory);
                    continue;
                }
                if (string2.equals("Product Group")) {
                    menuGroup = MenuGroupDAO.getInstance().findMenuGroupByName(string);
                    if (menuGroup != null) continue;
                    menuGroup = new MenuGroup();
                    menuGroup.setName(string);
                    menuGroup.setVisible(true);
                    menuCategory = MenuCategoryDAO.getInstance().initialize(menuCategory);
                    menuGroup.setMenuCategoryId(menuCategory.getId());
                    MenuGroupDAO.getInstance().saveOrUpdate(menuGroup);
                    menuCategory.addTomenuGroups(menuGroup);
                    MenuCategoryDAO.getInstance().update(menuCategory);
                    continue;
                }
                if (string2.equals("Product Name")) {
                    menuItem = MenuItemDAO.getInstance().findByName(string);
                    if (menuItem == null) {
                        menuItem = new MenuItem();
                        menuItem.setName(string);
                        menuItem.setMenuCategoryId(menuCategory.getId());
                        menuItem.setMenuGroupId(menuGroup.getId());
                        menuItem.setMenuGroupName(menuGroup.getName());
                        menuItem.setMenuCategoryName(menuCategory.getName());
                        continue;
                    }
                    menuItem.setDescription("");
                    menuItem.setPrice(0.0);
                    menuItem.setCost(0.0);
                    menuItem.setSku("");
                    menuItem.setBarcode("");
                    continue;
                }
                if (string2.equals("Product Description")) {
                    menuItem.setDescription(string);
                    continue;
                }
                if (string2.equals("Price")) {
                    menuItem.setPrice(this.a(string, d));
                    continue;
                }
                if (string2.equals("Cost")) {
                    menuItem.setCost(this.a(string, d));
                    continue;
                }
                if (string2.equals("SKU")) {
                    menuItem.setSku(string);
                    continue;
                }
                if (string2.equals("Barcode")) {
                    menuItem.setBarcode(string);
                    continue;
                }
                if (string2.equals("Active")) {
                    menuItem.setVisible(this.a(string));
                    continue;
                }
                if (string2.equals("Fractional Unit")) {
                    menuItem.setFractionalUnit(this.a(string));
                    continue;
                }
                if (string2.equals("Inventory Item")) {
                    menuItem.setInventoryItem(this.a(string));
                    continue;
                }
                if (!string2.equals("Allow Price Override")) continue;
                menuItem.setEditablePrice(this.a(string));
            }
            if (menuItem == null) continue;
            list.add(menuItem);
        }
    }

    private void a(List<Object> list, ModifierGroup modifierGroup, XSSFSheet xSSFSheet) throws Exception {
        Iterator iterator = xSSFSheet.rowIterator();
        while (iterator.hasNext()) {
            XSSFRow xSSFRow = (XSSFRow)iterator.next();
            if (xSSFRow.getRowNum() == 0) continue;
            Iterator iterator2 = xSSFRow.cellIterator();
            MenuModifier menuModifier = null;
            while (iterator2.hasNext()) {
                Cell cell = (Cell)iterator2.next();
                String string = "";
                double d = 0.0;
                switch (cell.getCellTypeEnum()) {
                    case STRING: {
                        string = cell.getStringCellValue();
                        break;
                    }
                    case NUMERIC: {
                        d = cell.getNumericCellValue();
                    }
                }
                String string2 = xSSFSheet.getRow(0).getCell(cell.getColumnIndex()).getStringCellValue();
                if (string2.equals("Modifier Group")) {
                    modifierGroup = ModifierGroupDAO.getInstance().findModifierGroupByName(string);
                    if (modifierGroup != null) continue;
                    modifierGroup = new ModifierGroup();
                    modifierGroup.setName(string);
                    ModifierGroupDAO.getInstance().saveOrUpdate(modifierGroup);
                    continue;
                }
                if (string2.equals("Modifiers Name")) {
                    menuModifier = MenuModifierDAO.getInstance().findName(string);
                    if (menuModifier == null) {
                        menuModifier = new MenuModifier();
                        menuModifier.setName(string);
                        modifierGroup.addTomodifiers(menuModifier);
                        continue;
                    }
                    menuModifier.setPrice(0.0);
                    continue;
                }
                if (string2.equals("Price")) {
                    menuModifier.setPrice(this.a(string, d));
                    continue;
                }
                if (string2.equals("Active")) {
                    menuModifier.setEnable(this.a(string));
                    continue;
                }
                if (!string2.equals("Pizza Modifier")) continue;
                menuModifier.setPizzaModifier(this.a(string));
            }
            if (menuModifier == null) continue;
            list.add(menuModifier);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Object> i() throws Exception {
        HSSFWorkbook hSSFWorkbook = null;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        MenuCategory menuCategory = null;
        MenuGroup menuGroup = null;
        ModifierGroup modifierGroup = null;
        try {
            FileInputStream fileInputStream = new FileInputStream(this.c);
            hSSFWorkbook = new HSSFWorkbook((InputStream)fileInputStream);
            this.a(arrayList, menuCategory, menuGroup, hSSFWorkbook.getSheetAt(0));
            this.a(arrayList, modifierGroup, hSSFWorkbook.getSheetAt(1));
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("InvalidExcel"), exception);
            List<Object> list = null;
            return list;
        }
        finally {
            if (hSSFWorkbook != null) {
                hSSFWorkbook.close();
            }
        }
        return arrayList;
    }

    private void a(List<Object> list, MenuCategory menuCategory, MenuGroup menuGroup, HSSFSheet hSSFSheet) throws Exception {
        Iterator iterator = hSSFSheet.rowIterator();
        while (iterator.hasNext()) {
            HSSFRow hSSFRow = (HSSFRow)iterator.next();
            if (hSSFRow.getRowNum() == 0) continue;
            Iterator iterator2 = hSSFRow.cellIterator();
            MenuItem menuItem = null;
            while (iterator2.hasNext()) {
                Cell cell = (Cell)iterator2.next();
                String string = "";
                double d = 0.0;
                switch (cell.getCellTypeEnum()) {
                    case STRING: {
                        string = cell.getStringCellValue();
                        break;
                    }
                    case NUMERIC: {
                        d = cell.getNumericCellValue();
                    }
                }
                String string2 = hSSFSheet.getRow(0).getCell(cell.getColumnIndex()).getStringCellValue();
                if (string2.equals("Product Category")) {
                    menuCategory = MenuCategoryDAO.getInstance().findCategoriesByName(string);
                    if (menuCategory != null) continue;
                    menuCategory = new MenuCategory();
                    menuCategory.setName(string);
                    menuCategory.setVisible(true);
                    continue;
                }
                if (string2.equals("Product Group")) {
                    menuGroup = MenuGroupDAO.getInstance().findMenuGroupByName(string);
                    if (menuGroup != null) continue;
                    menuGroup = new MenuGroup();
                    menuGroup.setName(string);
                    menuGroup.setVisible(true);
                    menuCategory = MenuCategoryDAO.getInstance().initialize(menuCategory);
                    menuGroup.setMenuCategoryId(menuCategory.getId());
                    menuCategory.addTomenuGroups(menuGroup);
                    MenuCategoryDAO.getInstance().update(menuCategory);
                    continue;
                }
                if (string2.equals("Product Name")) {
                    menuItem = MenuItemDAO.getInstance().findByName(string);
                    if (menuItem == null) {
                        menuItem = new MenuItem();
                        menuItem.setName(string);
                        menuItem.setMenuCategoryId(menuCategory.getId());
                        menuItem.setMenuGroupId(menuGroup.getId());
                        menuItem.setMenuGroupName(menuGroup.getName());
                        menuItem.setMenuCategoryName(menuCategory.getName());
                        continue;
                    }
                    menuItem.setDescription("");
                    menuItem.setPrice(0.0);
                    menuItem.setCost(0.0);
                    menuItem.setSku("");
                    menuItem.setBarcode("");
                    continue;
                }
                if (string2.equals("Product Description")) {
                    menuItem.setDescription(string);
                    continue;
                }
                if (string2.equals("Price")) {
                    menuItem.setPrice(d);
                    continue;
                }
                if (string2.equals("Cost")) {
                    menuItem.setCost(d);
                    continue;
                }
                if (string2.equals("SKU")) {
                    menuItem.setSku(string);
                    continue;
                }
                if (string2.equals("Barcode")) {
                    menuItem.setBarcode(string);
                    continue;
                }
                if (string2.equals("Active")) {
                    menuItem.setVisible(this.a(string));
                    continue;
                }
                if (string2.equals("Fractional Unit")) {
                    menuItem.setFractionalUnit(this.a(string));
                    continue;
                }
                if (string2.equals("Inventory Item")) {
                    menuItem.setInventoryItem(this.a(string));
                    continue;
                }
                if (!string2.equals("Allow Price Override")) continue;
                menuItem.setEditablePrice(this.a(string));
            }
            if (menuItem == null) continue;
            list.add(menuItem);
        }
    }

    private void a(List<Object> list, ModifierGroup modifierGroup, HSSFSheet hSSFSheet) throws Exception {
        Iterator iterator = hSSFSheet.rowIterator();
        while (iterator.hasNext()) {
            HSSFRow hSSFRow = (HSSFRow)iterator.next();
            if (hSSFRow.getRowNum() == 0) continue;
            Iterator iterator2 = hSSFRow.cellIterator();
            MenuModifier menuModifier = null;
            while (iterator2.hasNext()) {
                Cell cell = (Cell)iterator2.next();
                String string = "";
                double d = 0.0;
                switch (cell.getCellTypeEnum()) {
                    case STRING: {
                        string = cell.getStringCellValue();
                        break;
                    }
                    case NUMERIC: {
                        d = cell.getNumericCellValue();
                    }
                }
                String string2 = hSSFSheet.getRow(0).getCell(cell.getColumnIndex()).getStringCellValue();
                if (string2.equals("Modifier Group")) {
                    modifierGroup = ModifierGroupDAO.getInstance().findModifierGroupByName(string);
                    if (modifierGroup != null) continue;
                    modifierGroup = new ModifierGroup();
                    modifierGroup.setName(string);
                    ModifierGroupDAO.getInstance().saveOrUpdate(modifierGroup);
                    continue;
                }
                if (string2.equals("Modifiers Name")) {
                    menuModifier = MenuModifierDAO.getInstance().findName(string);
                    if (menuModifier == null) {
                        menuModifier = new MenuModifier();
                        menuModifier.setName(string);
                        modifierGroup.addTomodifiers(menuModifier);
                        continue;
                    }
                    menuModifier.setPrice(0.0);
                    continue;
                }
                if (string2.equals("Price")) {
                    menuModifier.setPrice(this.a(string, d));
                    continue;
                }
                if (string2.equals("Active")) {
                    menuModifier.setEnable(this.a(string));
                    continue;
                }
                if (!string2.equals("Pizza Modifier")) continue;
                menuModifier.setPizzaModifier(this.a(string));
            }
            if (menuModifier == null) continue;
            list.add(menuModifier);
        }
    }

    private double a(String string, double d) {
        double d2 = 0.0;
        try {
            d2 = Double.parseDouble(string);
        }
        catch (Exception exception) {
            d2 = d;
        }
        return d2;
    }

    private boolean a(String string) {
        if (StringUtils.isEmpty((String)string)) {
            return false;
        }
        return string.equalsIgnoreCase("yes");
    }

    public List<Object> getItemsList() {
        return this.g;
    }

    class ItemContainer
    extends JPanel {
        private BeanTableModel b;
        private JTable c;

        public ItemContainer(BeanTableModel beanTableModel) {
            this.b = beanTableModel;
            this.a();
        }

        private void a() {
            this.setLayout(new BorderLayout());
            this.c = new JTable(this.b);
            this.c.setDefaultRenderer(Object.class, new CustomCellRenderer());
            this.c.setSelectionMode(2);
            this.c.setRowHeight(PosUIManager.getSize(50));
            ExcelImportViewDialog.this.resizeColumnWidth(this.c);
            this.add(new JScrollPane(this.c));
        }
    }
}

