/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.forms;

import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.main.Application;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.Store;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthDocument;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.ImageGalleryDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.forms.GeneratePasswordDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPasswordField;
import net.miginfocom.swing.MigLayout;

public class UserForm
extends BeanEditor {
    private FixedLengthTextField a;
    private FixedLengthTextField b;
    private FixedLengthTextField c;
    private JPasswordField d;
    private FixedLengthTextField e;
    private FixedLengthTextField f;
    private JComboBox g;
    private JLabel h;
    private DoubleTextField i;
    private JCheckBox j;
    private JCheckBox k;
    private JCheckBox l;
    private JCheckBox m;
    private JCheckBox n;
    private ImageResource o;
    private JCheckBox p;
    private JComboBox q = new JComboBox();
    private boolean r;
    private DoubleTextField s;

    public UserForm() {
        this.a();
        UserTypeDAO userTypeDAO = new UserTypeDAO();
        List<UserType> list = userTypeDAO.findAll();
        this.g.setModel(new DefaultComboBoxModel<Object>(list.toArray()));
        this.q.setModel(this.a(OutletDAO.getInstance().findAll()));
    }

    private ComboBoxModel a(List list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("");
        arrayList.addAll(list);
        return new ComboBoxModel(arrayList);
    }

    private void a() {
        this.setLayout((LayoutManager)new MigLayout("hidemode 3", "[134px][204px,grow][][]", ""));
        JLabel jLabel = new JLabel(Messages.getString("UserForm.31"));
        JLabel jLabel2 = new JLabel(Messages.getString("UserForm.28"));
        JLabel jLabel3 = new JLabel(Messages.getString("UserForm.7"));
        JLabel jLabel4 = new JLabel("SSN");
        JLabel jLabel5 = new JLabel(Messages.getString("UserForm.14"));
        JLabel jLabel6 = new JLabel(Messages.getString("UserForm.16"));
        JLabel jLabel7 = new JLabel(Messages.getString("UserForm.18"));
        JLabel jLabel8 = new JLabel(Messages.getString("UserForm.9"));
        this.f = new FixedLengthTextField();
        this.f.setLength(20);
        this.f.setColumns(20);
        this.d = new JPasswordField(new FixedLengthDocument(16), "", 10);
        this.d.setEditable(false);
        this.b = new FixedLengthTextField(128);
        this.e = new FixedLengthTextField();
        this.e.setLength(30);
        this.e.setColumns(30);
        this.a = new FixedLengthTextField();
        this.a.setColumns(30);
        this.a.setLength(30);
        this.c = new FixedLengthTextField();
        this.c.setLength(30);
        this.c.setColumns(30);
        this.i = new DoubleTextField();
        this.s = new DoubleTextField();
        this.g = new JComboBox();
        this.h = new JLabel("");
        this.h.setHorizontalAlignment(0);
        this.h.setBorder(BorderFactory.createTitledBorder(null, "Image", 2, 2));
        this.h.setPreferredSize(new Dimension(150, 150));
        JButton jButton = new JButton("Create Pass");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserForm.this.b();
            }
        });
        JButton jButton2 = new JButton("...");
        JButton jButton3 = new JButton(Messages.getString("MenuItemForm.34"));
        jButton3.setHorizontalAlignment(11);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserForm.this.doSelectImageFile();
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserForm.this.doClearImage();
            }
        });
        this.add((Component)jLabel3, "cell 1 0 ,alignx trailing,aligny center");
        this.add((Component)this.b, "cell 2 0");
        this.add((Component)jLabel8, "cell 1 1,alignx trailing");
        this.add((Component)this.f, "cell 2 1,growx,aligny center");
        this.add((Component)jLabel4, "cell 1 2,alignx trailing,aligny center");
        this.add((Component)this.e, "cell 2 2,growx,aligny center");
        this.add((Component)jLabel5, "cell 1 3,alignx trailing,aligny center");
        this.add((Component)this.a, "cell 2 3,growx,aligny center");
        this.add((Component)jLabel6, "cell 1 4, alignx trailing,aligny center");
        this.add((Component)this.c, "cell 2 4,growx,aligny center");
        this.add((Component)jLabel7, "cell 1 5,alignx trailing,aligny center");
        this.add((Component)this.d, "cell 2 5,growx,aligny center");
        this.add((Component)jLabel2, "cell 1 6,alignx trailing,aligny center");
        this.add((Component)this.i, "cell 2 6,growx,aligny center");
        this.add((Component)new JLabel("Overtime Rate Per Hour"), "cell 1 7,gapleft 80,alignx trailing,aligny center");
        this.add((Component)this.s, "cell 2 7,growx,aligny center");
        this.add((Component)jLabel, "cell 1 8,alignx trailing,aligny center");
        this.g.setModel(new DefaultComboBoxModel<String>(new String[]{Messages.getString("UserForm.33"), Messages.getString("UserForm.34"), Messages.getString("UserForm.35")}));
        this.add((Component)this.g, "cell 2 8,growx,aligny center");
        this.add((Component)new JLabel("Outlet"), "cell 1 9,alignx trailing,aligny center");
        this.add((Component)this.q, "cell 2 9,growx,aligny center");
        this.j = new JCheckBox(Messages.getString("UserForm.0"));
        this.k = new JCheckBox("Staff Bank");
        this.l = new JCheckBox("Auto start staff bank");
        this.m = new JCheckBox("Allow receive tips");
        this.n = new JCheckBox("Blind Accountable Amount");
        this.k.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UserForm.this.l.setEnabled(UserForm.this.k.isSelected());
                UserForm.this.n.setEnabled(UserForm.this.k.isSelected());
            }
        });
        this.l.setEnabled(this.k.isSelected());
        this.n.setEnabled(this.k.isSelected());
        this.add((Component)this.j, "cell 2 10");
        this.add((Component)this.k, "cell 2 11");
        this.add((Component)this.l, "cell 2 12");
        this.add((Component)this.n, "cell 2 13");
        this.add((Component)this.m, "cell 2 14");
        this.p = new JCheckBox("Active");
        this.add((Component)this.p, "cell 2 15");
        this.add((Component)this.h, "cell 0 0 6 6,growy");
        this.add((Component)jButton3, "cell 0 1 1 12,center");
        this.add((Component)jButton2, "cell 0 1 1 12,center");
        this.add((Component)jButton, "cell 3 5 ,center");
    }

    @Override
    public String getDisplayText() {
        if (this.isEditMode()) {
            return Messages.getString("UserForm.37");
        }
        return Messages.getString("UserForm.38");
    }

    @Override
    public boolean save() {
        try {
            this.updateModel();
        }
        catch (IllegalModelStateException illegalModelStateException) {
            POSMessageDialog.showError(this, illegalModelStateException.getMessage());
            return false;
        }
        User user = (User)this.getBean();
        UserDAO userDAO = UserDAO.getInstance();
        if (!this.r && userDAO.isUserExist(user.getId())) {
            POSMessageDialog.showError(this, Messages.getString("UserForm.39") + user.getId() + " " + Messages.getString("UserForm.1"));
            return false;
        }
        try {
            userDAO.saveOrUpdate(user, this.r);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, posException.getMessage(), posException);
            PosLog.error(this.getClass(), posException);
            return false;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, Messages.getString("UserForm.41"), exception);
            PosLog.error(this.getClass(), exception);
            return false;
        }
        return true;
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        Object object;
        User user = null;
        user = !(this.getBean() instanceof User) ? new User() : (User)this.getBean();
        String string = this.b.getText();
        String string2 = this.e.getText();
        String string3 = this.a.getText();
        String string4 = this.c.getText();
        String string5 = new String(this.d.getPassword());
        if (POSUtil.isBlankOrNull(string)) {
            throw new IllegalModelStateException(Messages.getString("UserForm.50"));
        }
        if (POSUtil.isBlankOrNull(string3)) {
            throw new IllegalModelStateException(Messages.getString("UserForm.43"));
        }
        if (POSUtil.isBlankOrNull(string5)) {
            throw new IllegalModelStateException(Messages.getString("UserForm.45"));
        }
        User user2 = UserDAO.getInstance().findUserBySecretKey(string5);
        if (user2 != null && !user2.equals(user)) {
            throw new IllegalModelStateException(Messages.getString("UserForm.48"));
        }
        double d = this.i.getDoubleOrZero();
        double d2 = this.s.getDoubleOrZero();
        if (d2 == 0.0) {
            d2 = d;
        }
        if ((object = this.q.getSelectedItem()) instanceof Outlet) {
            user.setOutletId(((Outlet)object).getId());
        } else {
            user.setOutletId(null);
        }
        Store store = Application.getInstance().getStore();
        double d3 = store.getOvertimeMarkup();
        if (d > 0.0 && d3 > 0.0 && d2 == 0.0) {
            d2 = d + d * (d3 / 100.0);
        }
        UserType userType = (UserType)this.g.getSelectedItem();
        user.setType(userType);
        user.setRoot(true);
        user.setCostPerHour(d);
        user.setSsn(string2);
        user.setId(string);
        user.setFirstName(string3);
        user.setLastName(string4);
        user.setPhoneNo(this.f.getText());
        user.setEncryptedPassword(string5);
        user.setDriver(this.j.isSelected());
        user.setStaffBank(this.k.isSelected());
        user.setActive(this.p.isSelected());
        user.setOvertimeRatePerHour(d2);
        user.setAllowReceiveTips(this.m.isSelected());
        if (this.k.isSelected()) {
            user.setAutoStartStaffBank(this.l.isSelected());
            user.setBlindAccountableAmount(this.n.isSelected());
        } else {
            user.setAutoStartStaffBank(false);
            user.setBlindAccountableAmount(false);
        }
        try {
            List<User> list = user.getLinkedUser();
            if (list == null || list.isEmpty()) {
                user.setParentUser(user);
                user.setRoot(true);
            }
            if (list != null) {
                for (User user3 : list) {
                    if (user.getId() != null || !user3.getType().getName().equals(userType.getName())) continue;
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "This role already exists.");
                    return false;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.o != null) {
            user.setImageId(this.o.getId());
        } else {
            user.setImageId(null);
        }
        this.setBean(user);
        return true;
    }

    @Override
    protected void updateView() {
        if (!(this.getBean() instanceof User)) {
            return;
        }
        User user = (User)this.getBean();
        this.a(user);
    }

    private void a(User user) {
        if (user.getId() != null) {
            this.b.setText(String.valueOf(user.getId()));
        } else {
            this.b.setText("");
        }
        if (user.getSsn() != null) {
            this.e.setText(user.getSsn());
        } else {
            this.e.setText("");
        }
        this.a.setText(user.getFirstName());
        this.c.setText(user.getLastName());
        this.d.setText(user.getPasswordAsPlainText());
        this.f.setText(user.getPhoneNo());
        this.g.setSelectedItem(user.getType());
        Double d = user.getCostPerHour();
        if (d == null) {
            d = 0.0;
        }
        this.i.setText(String.valueOf(d));
        this.j.setSelected(user.isDriver());
        this.k.setSelected(user.isStaffBank());
        this.l.setSelected(user.isAutoStartStaffBank());
        this.n.setSelected(user.isBlindAccountableAmount());
        this.p.setSelected(user.isActive());
        this.m.setSelected(user.isAllowReceiveTips());
        this.o = ImageResourceDAO.getInstance().findById(user.getImageId());
        if (this.o != null) {
            this.h.setIcon(this.o.getAsIcon());
        }
        this.l.setEnabled(this.k.isSelected());
        this.n.setEnabled(this.k.isSelected());
        this.q.setSelectedItem(user.getOutletId() == null ? "" : OutletDAO.getInstance().get(user.getOutletId()));
        if (user.getOvertimeRatePerHour() != null) {
            this.s.setText(String.valueOf(user.getOvertimeRatePerHour()));
        }
    }

    public boolean isEditMode() {
        return this.r;
    }

    public void setEditMode(boolean bl) {
        this.r = bl;
        if (bl) {
            this.b.setEditable(false);
        } else {
            this.b.setEditable(true);
        }
    }

    public void setId(Integer n) {
        if (n != null) {
            this.b.setText(String.valueOf(n));
        }
    }

    protected void doSelectImageFile() {
        ImageGalleryDialog imageGalleryDialog = ImageGalleryDialog.getInstance();
        imageGalleryDialog.setSelectBtnVisible(true);
        imageGalleryDialog.setTitle("Image Gallery");
        imageGalleryDialog.setSize(PosUIManager.getSize(650, 600));
        imageGalleryDialog.setResizable(false);
        imageGalleryDialog.open();
        if (imageGalleryDialog.isCanceled()) {
            return;
        }
        this.o = imageGalleryDialog.getImageResource();
        if (this.o != null) {
            this.h.setIcon(this.o.getAsIcon());
        }
    }

    protected void doClearImage() {
        this.h.setIcon(null);
        this.o = null;
    }

    private void b() {
        GeneratePasswordDialog generatePasswordDialog = new GeneratePasswordDialog();
        generatePasswordDialog.setSize(530, 340);
        generatePasswordDialog.open();
        if (generatePasswordDialog.isCanceled()) {
            return;
        }
        this.d.setText(generatePasswordDialog.getGenPassword());
    }
}

