/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.IntegerDocument;
import com.floreantpos.swing.ListComboBoxModel;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.PosGuiUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import net.miginfocom.swing.MigLayout;

public class ComboItemEntryDialog
extends POSDialog
implements ActionListener {
    private JComboBox a;
    private JComboBox b;
    private DoubleTextField c;
    private JLabel d;
    private JLabel e;

    public ComboItemEntryDialog(MenuItem menuItem) {
        super(POSUtil.getFocusedWindow(), "");
        this.a();
        this.b();
    }

    private void a() {
        this.setLayout(new BorderLayout(10, 10));
        this.setIconImage(Application.getPosWindow().getIconImage());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill,hidemode 3,inset 0 10 0 10"));
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle("Select item");
        this.add((Component)titlePanel, "North");
        this.a = new JComboBox();
        this.b = new JComboBox();
        this.c = new DoubleTextField(10);
        List<MenuGroup> list = MenuGroupDAO.getInstance().findAll();
        for (MenuGroup serializable2 : list) {
            this.a.addItem(serializable2);
        }
        this.a.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ComboItemEntryDialog.this.b();
            }
        });
        jPanel.add(new JLabel("Group"));
        jPanel.add((Component)this.a, "grow,wrap");
        this.d = new JLabel("Menu Item");
        jPanel.add(this.d);
        jPanel.add((Component)this.b, "grow,wrap");
        this.e = new JLabel("Quantity");
        jPanel.add(this.e);
        jPanel.add((Component)this.c, "grow,wrap");
        jPanel.add((Component)new JSeparator(), "gaptop 10,span 2,grow");
        PosButton posButton = new PosButton(POSConstants.OK);
        posButton.setFocusable(false);
        posButton.addActionListener(this);
        PosButton posButton2 = new PosButton(POSConstants.CANCEL);
        posButton2.setFocusable(false);
        posButton2.addActionListener(this);
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("center,ins 0 5 5 5", "", ""));
        jPanel2.add(posButton);
        jPanel2.add(posButton2);
        this.add((Component)jPanel2, "South");
        this.add(jPanel);
        this.pack();
    }

    private void b() {
        MenuGroup menuGroup = (MenuGroup)this.a.getSelectedItem();
        List<MenuItem> list = MenuItemDAO.getInstance().findByParent(null, menuGroup, false);
        Iterator<MenuItem> iterator = list.iterator();
        while (iterator.hasNext()) {
            MenuItem menuItem = iterator.next();
            if (!menuItem.isComboItem().booleanValue()) continue;
            iterator.remove();
        }
        this.b.setModel(new ListComboBoxModel(list));
    }

    public void setSelectedItem(MenuItem menuItem) {
        this.a.setSelectedItem(null);
        if (menuItem != null && menuItem.getMenuGroupId() != null) {
            PosGuiUtil.selectComboItemById(this.a, menuItem.getMenuGroupId());
        }
        this.b();
        this.b.setSelectedItem(menuItem);
    }

    public void setSelectedGroup(MenuGroup menuGroup) {
        this.e.setText("Max Quantity");
        this.d.setVisible(false);
        this.b.setVisible(false);
        if (menuGroup != null) {
            this.a.setSelectedItem(menuGroup);
        }
    }

    public void setQuantity(Double d) {
        this.c.setText(String.valueOf(d));
    }

    public void setQuantity(Integer n) {
        this.c.setText(String.valueOf(n));
    }

    private void c() {
        this.setCanceled(false);
        this.dispose();
    }

    public MenuItem getItem() {
        return (MenuItem)this.b.getSelectedItem();
    }

    public MenuGroup getSelectedGroup() {
        return (MenuGroup)this.a.getSelectedItem();
    }

    private void d() {
        this.setCanceled(true);
        this.dispose();
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (POSConstants.CANCEL.equalsIgnoreCase(string)) {
            this.d();
        } else if (POSConstants.OK.equalsIgnoreCase(string)) {
            this.c();
        }
    }

    public Double getQuantity() {
        if (Double.isNaN(this.c.getDouble())) {
            return 1.0;
        }
        return this.c.getDouble();
    }

    public void setFloatingPoint(boolean bl) {
        if (!bl) {
            this.c.setDocument(new IntegerDocument());
        }
    }

    public int getIntegerValue() {
        try {
            return Integer.parseInt(this.c.getText());
        }
        catch (Exception exception) {
            return 0;
        }
    }
}

