/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.model.Course;
import com.floreantpos.model.ImageResource;
import com.floreantpos.model.dao.CourseDAO;
import com.floreantpos.model.dao.ImageResourceDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.ImageGalleryDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class CourseForm
extends BeanEditor {
    private FixedLengthTextField a;
    private FixedLengthTextField b;
    private IntegerTextField c;
    private JLabel d;
    private ImageResource e;
    private List<Course> f;

    public CourseForm() {
        this(new Course());
    }

    public CourseForm(Course course) {
        this.a();
        this.setBean(course);
    }

    private void a() {
        this.setLayout((LayoutManager)new MigLayout("hidemode 3,wrap 2", "[134px][204px,grow]", ""));
        this.c = new IntegerTextField();
        this.a = new FixedLengthTextField();
        this.a.setLength(128);
        this.b = new FixedLengthTextField();
        this.b.setLength(3);
        this.d = new JLabel("");
        this.d.setText("Icon");
        this.d.setForeground(Color.gray);
        this.add((Component)new JLabel("Name"), "alignx trailing,aligny center");
        this.add((Component)this.a, "growx,aligny center");
        this.add((Component)new JLabel("Short Name"), "alignx trailing,aligny center");
        this.add((Component)this.b, "growx,aligny center");
        this.add((Component)new JLabel("Sort Order"), "alignx trailing,aligny center");
        this.add((Component)this.c, "w 100!,aligny center");
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("center", "", ""));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("center"));
        this.d.setHorizontalAlignment(0);
        jPanel2.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(null, "", 2, 2), BorderFactory.createEmptyBorder(10, 10, 10, 10)));
        jPanel2.setPreferredSize(new Dimension(70, 50));
        jPanel2.add((Component)this.d, "w 24!,h 24!,aligny center");
        this.add((Component)jPanel, "skip 1");
    }

    @Override
    public String getDisplayText() {
        if (((Course)this.getBean()).getId() == null) {
            return "New Course";
        }
        return "Edit Course";
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            Course course = (Course)this.getBean();
            CourseDAO courseDAO = CourseDAO.getInstance();
            courseDAO.saveOrUpdate(course);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, posException.getMessage(), posException);
            PosLog.error(this.getClass(), posException);
            return false;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, "Error", exception);
            PosLog.error(this.getClass(), exception);
            return false;
        }
        return true;
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        String string = this.a.getText();
        String string2 = this.b.getText();
        int n = this.c.getInteger();
        if (StringUtils.isEmpty((String)string)) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please enter course name.");
            return false;
        }
        if (StringUtils.isEmpty((String)string2)) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please enter short name.");
            return false;
        }
        if (n <= 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please enter sort order.");
            return false;
        }
        if (this.f != null) {
            for (Course course : this.f) {
                if (course.getSortOrder() != n) continue;
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Duplicate sort order cannot be allowed.");
                return false;
            }
        }
        Course course = (Course)this.getBean();
        course.setName(string);
        course.setShortName(string2);
        course.setSortOrder(n);
        return true;
    }

    @Override
    protected void updateView() {
        if (!(this.getBean() instanceof Course)) {
            return;
        }
        Course course = (Course)this.getBean();
        this.a(course);
    }

    private void a(Course course) {
        this.c.setText(String.valueOf(course.getSortOrder()));
        this.a.setText(course.getName());
        this.b.setText(course.getShortName());
        this.e = ImageResourceDAO.getInstance().findById(course.getIconId());
        if (this.e != null) {
            this.d.setIcon(this.e.getScaledImage(16, 16));
            this.d.setText("");
        } else {
            this.d.setText("Icon");
        }
    }

    protected void doSelectImageFile() {
        ImageGalleryDialog imageGalleryDialog = ImageGalleryDialog.getInstance();
        imageGalleryDialog.setSelectBtnVisible(true);
        imageGalleryDialog.setTitle("Image Gallery");
        imageGalleryDialog.setSize(PosUIManager.getSize(650, 600));
        imageGalleryDialog.setResizable(false);
        imageGalleryDialog.open();
        if (imageGalleryDialog.isCanceled()) {
            return;
        }
        this.e = imageGalleryDialog.getImageResource();
        if (this.e != null) {
            this.d.setIcon(this.e.getScaledImage(16, 16));
            this.d.setText("");
        } else {
            this.d.setText("Icon");
        }
    }

    protected void doClearImage() {
        this.d.setIcon(null);
        this.e = null;
    }

    public List<Course> getExistingCourses() {
        return this.f;
    }

    public void setExistingCourses(List<Course> list) {
        this.f = new ArrayList<Course>();
        Course course = (Course)this.getBean();
        int n = 1;
        for (Course course2 : list) {
            if (course.getId() != null && course2.getId().equals(course.getId())) continue;
            if (course2.getSortOrder() > n) {
                n = course2.getSortOrder();
            }
            this.f.add(course2);
        }
        if (this.c.getInteger() == 0) {
            this.c.setText(String.valueOf(n + 1));
        }
    }
}

