/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.model.Currency;
import com.floreantpos.model.dao.CurrencyDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.jidesoft.swing.AutoCompletionComboBox;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class CurrencyForm
extends BeanEditor {
    private FixedLengthTextField a;
    private FixedLengthTextField b;
    private FixedLengthTextField c;
    private DoubleTextField d;
    private DoubleTextField e;
    private JCheckBox f;
    private AutoCompletionComboBox g;

    public CurrencyForm() {
        this(new Currency());
    }

    public CurrencyForm(Currency currency) {
        this.b();
        this.a();
        this.setBean(currency);
    }

    private void a() {
        ComboBoxModel comboBoxModel = new ComboBoxModel();
        comboBoxModel.addElement((Object)null);
        comboBoxModel.setDataList(CurrencyForm.getAllCurrencies());
        this.g.setModel(comboBoxModel);
    }

    public static List<Currency> getAllCurrencies() {
        Set set = com.ibm.icu.util.Currency.getAvailableCurrencies();
        ArrayList<Currency> arrayList = new ArrayList<Currency>();
        for (com.ibm.icu.util.Currency currency : set) {
            Currency currency2 = new Currency();
            currency2.setName(currency.getDisplayName());
            currency2.setCode(currency.getCurrencyCode());
            String string = currency.getSymbol();
            currency2.setSymbol(string);
            arrayList.add(currency2);
        }
        Collections.sort(arrayList, new Comparator<Currency>(){

            @Override
            public int compare(Currency currency, Currency currency2) {
                return currency.getName().compareTo(currency2.getName());
            }
        });
        return arrayList;
    }

    private void b() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill"));
        JLabel jLabel = new JLabel(Messages.getString("CurrencyForm.1"));
        this.a = new FixedLengthTextField(10);
        JLabel jLabel2 = new JLabel(POSConstants.NAME + ":");
        this.b = new FixedLengthTextField();
        JLabel jLabel3 = new JLabel(Messages.getString("CurrencyForm.3"));
        this.d = new DoubleTextField();
        JLabel jLabel4 = new JLabel(Messages.getString("CurrencyForm.4"));
        this.e = new DoubleTextField();
        JLabel jLabel5 = new JLabel(Messages.getString("CurrencyForm.5"));
        this.c = new FixedLengthTextField(8);
        this.f = new JCheckBox(Messages.getString("CurrencyForm.6"));
        this.g = new AutoCompletionComboBox();
        this.g.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                Currency currency = (Currency)jComboBox.getSelectedItem();
                CurrencyForm.this.b.setText(currency.getName());
                CurrencyForm.this.c.setText(currency.getSymbol());
                CurrencyForm.this.a.setText(currency.getCode());
                CurrencyForm.this.d.setText("" + currency.getExchangeRate());
                CurrencyForm.this.e.setText("" + currency.getTolerance());
            }
        });
        jPanel.add((Component)new JLabel("Currency"), "");
        jPanel.add((Component)this.g, "grow, wrap");
        jPanel.add((Component)jLabel2, "");
        jPanel.add((Component)this.b, "grow, wrap");
        jPanel.add((Component)jLabel, "");
        jPanel.add((Component)this.a, "grow, wrap");
        jPanel.add((Component)jLabel5, "");
        jPanel.add((Component)this.c, "grow, wrap");
        jPanel.add((Component)jLabel3, "");
        jPanel.add((Component)this.d, "grow, wrap");
        jPanel.add((Component)jLabel4, "");
        jPanel.add((Component)this.e, "grow, wrap");
        jPanel.add((Component)this.f, "");
        this.add(jPanel);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            Currency currency = (Currency)this.getBean();
            CurrencyDAO currencyDAO = new CurrencyDAO();
            currencyDAO.saveOrUpdate(currency);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
            return false;
        }
        return true;
    }

    @Override
    protected void updateView() {
        Currency currency = (Currency)this.getBean();
        if (currency == null || StringUtils.isEmpty((String)currency.getId())) {
            return;
        }
        ComboBoxModel comboBoxModel = (ComboBoxModel)this.g.getModel();
        List list = comboBoxModel.getDataList();
        for (Currency currency2 : list) {
            if (!currency2.getCode().equals(currency.getCode())) continue;
            this.g.setSelectedItem((Object)currency2);
        }
        this.a.setText(currency.getCode());
        this.b.setText(currency.getName());
        this.c.setText(currency.getSymbol());
        this.d.setText("" + currency.getExchangeRate());
        this.e.setText("" + currency.getTolerance());
        this.f.setSelected(currency.isMain());
    }

    @Override
    protected boolean updateModel() {
        Currency currency = (Currency)this.getBean();
        String string = this.b.getText();
        if (POSUtil.isBlankOrNull(string)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CurrencyForm.64"));
            return false;
        }
        String string2 = this.a.getText();
        if (POSUtil.isBlankOrNull(string2)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CurrencyForm.0"));
            return false;
        }
        String string3 = this.c.getText();
        if (POSUtil.isBlankOrNull(string3)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("CurrencyForm.65"));
            return false;
        }
        double d = this.d.getDoubleOrZero();
        if (this.f.isSelected() && d != 1.0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("CurrencyForm.2"));
            return false;
        }
        currency.setCode(string2);
        currency.setName(string);
        currency.setSymbol(string3);
        currency.setMain(this.f.isSelected());
        if (d == 0.0) {
            currency.setExchangeRate(1.0);
        } else {
            currency.setExchangeRate(d);
        }
        currency.setTolerance(this.e.getDoubleOrZero());
        return true;
    }

    @Override
    public String getDisplayText() {
        Currency currency = (Currency)this.getBean();
        if (currency.getId() == null) {
            return Messages.getString("CurrencyForm.20");
        }
        return Messages.getString("CurrencyForm.21");
    }
}

