/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierMultiplierPrice;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.ModifierDAO;
import com.floreantpos.model.dao.MultiplierDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.DoubleTextField;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.IntegerTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.model.TaxForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import javax.swing.table.DefaultTableModel;
import net.miginfocom.swing.MigLayout;

public class MenuModifierForm
extends BeanEditor {
    private MenuModifier a;
    private JCheckBox b;
    private JComboBox c;
    private JFormattedTextField d;
    private FixedLengthTextField e;
    private DoubleTextField f;
    private DoubleTextField g;
    private IntegerTextField h;
    private JButton i;
    private JButton j;
    private JTable k;
    private JTabbedPane l;
    private Map<String, MultiplierPricePanel> m = new HashMap<String, MultiplierPricePanel>();
    private JCheckBox n;
    private JCheckBox o;

    public MenuModifierForm() throws Exception {
        this(new MenuModifier());
    }

    public MenuModifierForm(MenuModifier menuModifier) throws Exception {
        this.a = menuModifier;
        this.c();
        this.b();
        this.a();
        this.add(this.l);
        this.setBean(menuModifier);
    }

    private void a() {
        ComboBoxModel comboBoxModel = new ComboBoxModel();
        comboBoxModel.addElement((Object)null);
        List<TaxGroup> list = TaxGroupDAO.getInstance().findAll();
        for (TaxGroup taxGroup : list) {
            comboBoxModel.addElement(taxGroup);
        }
        this.c.setModel(comboBoxModel);
    }

    private void b() {
        this.setLayout(new BorderLayout(0, 0));
        this.l = new JTabbedPane();
        this.d = new JFormattedTextField();
        this.e = new FixedLengthTextField();
        this.f = new DoubleTextField();
        this.g = new DoubleTextField();
        this.h = new IntegerTextField();
        this.c = new JComboBox();
        JButton jButton = new JButton();
        this.b = new JCheckBox();
        this.n = new JCheckBox("Use fixed price");
        JPanel jPanel = new JPanel();
        JScrollPane jScrollPane = new JScrollPane();
        this.k = new JTable();
        JLabel jLabel = new JLabel(POSConstants.NAME + ":");
        JLabel jLabel2 = new JLabel(Messages.getString("MenuModifierForm.0"));
        JLabel jLabel3 = new JLabel(Messages.getString("MenuModifierForm.15"));
        JLabel jLabel4 = new JLabel("Tax Group:");
        JLabel jLabel5 = new JLabel();
        this.g.setText("0");
        jLabel5.setText("");
        this.f.setText("0");
        jButton.setText("...");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuModifierForm.this.a(actionEvent);
            }
        });
        this.b.setText(POSConstants.PRINT_TO_KITCHEN);
        this.b.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.b.setMargin(new Insets(0, 0, 0, 0));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        this.l.addTab(POSConstants.GENERAL, jPanel2);
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.setLayout((LayoutManager)new MigLayout("wrap 2,hidemode 3", "[90px][grow]", ""));
        transparentPanel.add((Component)jLabel, "alignx left,aligny center");
        transparentPanel.add((Component)this.d, "growx,aligny top");
        transparentPanel.add((Component)jLabel2, "alignx left,aligny center");
        transparentPanel.add((Component)this.e, "growx");
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("wrap 2", "[86px][grow]"));
        jPanel3.add((Component)jLabel4, "alignx left,aligny center,split 2");
        jPanel3.add((Component)jLabel5, "alignx left,aligny center");
        jPanel3.add((Component)this.c, "growx,aligny top,split 2");
        jPanel3.add((Component)jButton, "alignx left,aligny top");
        jPanel3.add((Component)jLabel3, "alignx left,aligny center");
        jPanel3.add((Component)this.h, "growx,aligny top");
        jPanel3.add((Component)this.b, "skip 1,alignx left,aligny top");
        this.o = new JCheckBox("Combo Modifier");
        jPanel3.add((Component)this.o, "skip 1,alignx left,aligny top");
        jPanel2.add(transparentPanel);
        jPanel2.add((Component)jPanel3, "East");
        JLabel jLabel6 = new JLabel(Messages.getString("MenuModifierForm.1"));
        this.i = new JButton("");
        this.i.setPreferredSize(new Dimension(140, 40));
        JLabel jLabel7 = new JLabel(Messages.getString("MenuModifierForm.27"));
        this.j = new JButton(Messages.getString("MenuModifierForm.29"));
        this.j.setPreferredSize(new Dimension(140, 40));
        JPanel jPanel4 = new JPanel((LayoutManager)new MigLayout("hidemode 3,wrap 2"));
        jPanel4.add(jLabel6);
        jPanel4.add(this.i);
        jPanel4.add(jLabel7);
        jPanel4.add(this.j);
        this.l.addTab("Button Style", jPanel4);
        this.i.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(MenuModifierForm.this, Messages.getString("MenuModifierForm.39"), MenuModifierForm.this.i.getBackground());
                MenuModifierForm.this.i.setBackground(color);
                MenuModifierForm.this.j.setBackground(color);
            }
        });
        this.j.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Color color = JColorChooser.showDialog(MenuModifierForm.this, Messages.getString("MenuModifierForm.40"), MenuModifierForm.this.j.getForeground());
                MenuModifierForm.this.j.setForeground(color);
            }
        });
        this.k.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null}, {null, null, null, null}, {null, null, null, null}, {null, null, null, null}}, new String[]{"Title 1", "Title 2", "Title 3", "Title 4"}));
        jScrollPane.setViewportView(this.k);
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        jPanel.add((Component)jScrollPane, "Center");
        JPanel jPanel5 = new JPanel();
        JPanel jPanel6 = new JPanel((LayoutManager)new MigLayout("fillx,wrap 1"));
        List<Multiplier> list = MultiplierDAO.getInstance().findAll();
        if (list != null) {
            for (Multiplier multiplier : list) {
                MultiplierPricePanel multiplierPricePanel = new MultiplierPricePanel(multiplier);
                jPanel6.add((Component)multiplierPricePanel, "grow");
                this.m.put(multiplier.getId(), multiplierPricePanel);
            }
        }
        JScrollPane jScrollPane2 = new JScrollPane(jPanel6);
        jScrollPane2.setBorder(new TitledBorder("Multiplier price"));
        transparentPanel.add((Component)jScrollPane2, "newline,skip 1,grow");
        jPanel.add((Component)jPanel5, "South");
        if (TerminalConfig.isMultipleOrderSupported()) {
            // empty if block
        }
    }

    private void c() {
        Multiplier multiplier = MultiplierDAO.getInstance().get("Regular");
        if (multiplier != null && multiplier.isMain().booleanValue()) {
            return;
        }
        if (multiplier == null) {
            multiplier = new Multiplier("Regular");
            multiplier.setRate(0.0);
            multiplier.setSortOrder(0);
            multiplier.setTicketPrefix("");
            multiplier.setDefaultMultiplier(true);
            multiplier.setMain(true);
            MultiplierDAO.getInstance().save(multiplier);
        } else {
            multiplier.setMain(true);
            MultiplierDAO.getInstance().update(multiplier);
        }
    }

    private void a(ActionEvent actionEvent) {
        try {
            TaxForm taxForm = new TaxForm();
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)taxForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            ComboBoxModel comboBoxModel = (ComboBoxModel)this.c.getModel();
            comboBoxModel.setDataList(TaxGroupDAO.getInstance().findAll());
        }
        catch (Exception exception) {
            MessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            MenuModifier menuModifier = (MenuModifier)this.getBean();
            ModifierDAO modifierDAO = new ModifierDAO();
            modifierDAO.saveMenuModifierFormData(menuModifier);
        }
        catch (Exception exception) {
            MessageDialog.showError(POSConstants.SAVE_ERROR, exception);
            return false;
        }
        return true;
    }

    @Override
    protected void updateView() {
        Object object;
        MenuModifier menuModifier = (MenuModifier)this.getBean();
        if (menuModifier == null) {
            this.d.setText("");
            this.f.setText("0");
            this.g.setText("0");
            return;
        }
        MenuModifierDAO.getInstance().initialize(menuModifier);
        this.d.setText(menuModifier.getName());
        this.e.setText(menuModifier.getTranslatedName());
        this.f.setText(String.valueOf(menuModifier.getPrice()));
        this.g.setText(String.valueOf(menuModifier.getExtraPrice()));
        this.b.setSelected(menuModifier.isShouldPrintToKitchen());
        this.o.setSelected(menuModifier.isComboModifier());
        this.n.setSelected(menuModifier.isFixedPrice());
        if (menuModifier.getSortOrder() != null) {
            this.h.setText(menuModifier.getSortOrder().toString());
        }
        if (menuModifier.getButtonColor() != null) {
            object = new Color(menuModifier.getButtonColor());
            this.i.setBackground((Color)object);
            this.j.setBackground((Color)object);
        }
        if (menuModifier.getTextColor() != null) {
            object = new Color(menuModifier.getTextColor());
            this.j.setForeground((Color)object);
        }
        if (menuModifier.getTaxGroup() != null) {
            this.c.setSelectedItem(menuModifier.getTaxGroup());
        }
        if ((object = menuModifier.getMultiplierPriceList()) != null) {
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                ModifierMultiplierPrice modifierMultiplierPrice = (ModifierMultiplierPrice)iterator.next();
                MultiplierPricePanel multiplierPricePanel = this.m.get(modifierMultiplierPrice.getMultiplier().getId());
                if (multiplierPricePanel == null) continue;
                multiplierPricePanel.setModifierMultiplierPrice(modifierMultiplierPrice);
            }
        }
        this.m.get((Object)"Regular").c.setText(String.valueOf(menuModifier.getPrice()));
    }

    @Override
    protected boolean updateModel() {
        MenuModifier menuModifier = (MenuModifier)this.getBean();
        String string = this.d.getText();
        if (POSUtil.isBlankOrNull(string)) {
            MessageDialog.showError(Messages.getString("MenuModifierForm.44"));
            return false;
        }
        menuModifier.setName(string);
        menuModifier.setExtraPrice(this.g.getDouble());
        menuModifier.setTaxGroup((TaxGroup)this.c.getSelectedItem());
        menuModifier.setShouldPrintToKitchen(this.b.isSelected());
        menuModifier.setComboModifier(this.o.isSelected());
        menuModifier.setTranslatedName(this.e.getText());
        menuModifier.setButtonColor(this.i.getBackground().getRGB());
        menuModifier.setTextColor(this.j.getForeground().getRGB());
        menuModifier.setSortOrder(this.h.getInteger());
        menuModifier.setFixedPrice(this.n.isSelected());
        ArrayList<ModifierMultiplierPrice> arrayList = new ArrayList<ModifierMultiplierPrice>();
        for (MultiplierPricePanel multiplierPricePanel : this.m.values()) {
            if (!multiplierPricePanel.isSelected()) continue;
            ModifierMultiplierPrice modifierMultiplierPrice = multiplierPricePanel.getMultiplierPrice();
            if (modifierMultiplierPrice == null) {
                modifierMultiplierPrice = new ModifierMultiplierPrice();
                modifierMultiplierPrice.setMultiplier(multiplierPricePanel.getMultiplier());
                modifierMultiplierPrice.setModifierId(menuModifier.getId());
            }
            modifierMultiplierPrice.setPrice(multiplierPricePanel.getPrice());
            arrayList.add(modifierMultiplierPrice);
        }
        menuModifier.setPrice(this.m.get("Regular").getPrice());
        menuModifier.setMultiplierPriceList(arrayList);
        return true;
    }

    @Override
    public String getDisplayText() {
        MenuModifier menuModifier = (MenuModifier)this.getBean();
        if (menuModifier.getId() == null) {
            return Messages.getString("MenuModifierForm.45");
        }
        return Messages.getString("MenuModifierForm.46");
    }

    protected void doCalculateMultiplierPrice() {
        MultiplierPricePanel multiplierPricePanel = this.m.get("Regular");
        if (multiplierPricePanel == null) {
            return;
        }
        for (MultiplierPricePanel multiplierPricePanel2 : this.m.values()) {
            multiplierPricePanel2.calculatePrice(this.getDoubleOrZero(multiplierPricePanel.c.getText()));
        }
    }

    public double getDouble(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (Exception exception) {
            return Double.NaN;
        }
    }

    public double getDoubleOrZero(String string) {
        try {
            return Double.parseDouble(string);
        }
        catch (Exception exception) {
            return 0.0;
        }
    }

    private class MultiplierPricePanel
    extends JPanel {
        ModifierMultiplierPrice a;
        Multiplier b;
        JTextField c;

        public MultiplierPricePanel(Multiplier multiplier) {
            this.b = multiplier;
            this.setLayout((LayoutManager)new MigLayout("inset 0,fillx", "[100px][grow][100px]", ""));
            this.c = new JTextField(multiplier.isMain() != false ? 6 : 9);
            this.c.setHorizontalAlignment(4);
            JLabel jLabel = new JLabel(multiplier.getId());
            if (multiplier.isMain().booleanValue()) {
                jLabel.setFont(new Font(null, 1, MenuModifierForm.this.d.getFont().getSize()));
            }
            this.add(jLabel);
            this.add((Component)new JLabel(multiplier.isMain() != false ? "Price" : "Additional price", 11), "grow, gapright 10px");
            this.add((Component)this.c, "split 2,grow");
            if (multiplier.isMain().booleanValue()) {
                JButton jButton = new JButton("Calc");
                jButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        MenuModifierForm.this.doCalculateMultiplierPrice();
                    }
                });
                this.add(jButton);
            }
        }

        public void calculatePrice(double d) {
            if (this.b.isMain().booleanValue()) {
                return;
            }
            this.c.setText(String.valueOf(d * this.b.getRate() / 100.0));
        }

        public Double getPrice() {
            return MenuModifierForm.this.getDoubleOrZero(this.c.getText());
        }

        public Multiplier getMultiplier() {
            return this.b;
        }

        public boolean isSelected() {
            Double d = MenuModifierForm.this.getDouble(this.c.getText());
            return !d.isNaN();
        }

        private void a() {
            if (this.a == null) {
                return;
            }
            this.c.setText(String.valueOf(this.a.getPrice()));
        }

        public void setModifierMultiplierPrice(ModifierMultiplierPrice modifierMultiplierPrice) {
            this.a = modifierMultiplierPrice;
            this.a();
        }

        public ModifierMultiplierPrice getMultiplierPrice() {
            return this.a;
        }
    }
}

