/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.model;

import com.floreantpos.POSConstants;
import com.floreantpos.model.Department;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.lang.StringUtils;

public class SalesAreaEntryForm
extends BeanEditor<SalesArea> {
    private SalesArea c;
    private FixedLengthTextField d;
    JLabel a = new JLabel("Department");
    JComboBox b = new JComboBox();

    public SalesAreaEntryForm(SalesArea salesArea) {
        this.c = salesArea;
        DepartmentDAO departmentDAO = new DepartmentDAO();
        List<Department> list = departmentDAO.findAll();
        this.b.setModel(new ComboBoxModel(list));
        this.initComponents();
        this.setBean(salesArea);
    }

    public void initComponents() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fill,alignx center", "[][]", ""));
        JLabel jLabel = new JLabel("Name");
        this.d = new FixedLengthTextField(20);
        jPanel.add(jLabel);
        jPanel.add((Component)this.d, "wrap");
        jPanel.add(this.a);
        jPanel.add((Component)this.b, "grow");
        this.add(jPanel);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            SalesArea salesArea = (SalesArea)this.getBean();
            SalesAreaDAO salesAreaDAO = new SalesAreaDAO();
            salesAreaDAO.saveOrUpdate(salesArea);
        }
        catch (Exception exception) {
            MessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
            return false;
        }
        return true;
    }

    @Override
    protected void updateView() {
        SalesArea salesArea = (SalesArea)this.getBean();
        this.d.setText(salesArea.getName());
        this.b.setSelectedItem(salesArea.getDepartment());
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        SalesArea salesArea = (SalesArea)this.getBean();
        String string = this.d.getText();
        if (StringUtils.isEmpty((String)string)) {
            POSMessageDialog.showError(this, "Sales area name can not be empty");
            return false;
        }
        this.c.setName(string);
        salesArea.setDepartment((Department)this.b.getSelectedItem());
        return true;
    }

    @Override
    public String getDisplayText() {
        SalesArea salesArea = (SalesArea)this.getBean();
        if (salesArea.getId() == null) {
            return "Add New Sales Area";
        }
        return "Edit Sales Area";
    }
}

