/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.tableselection;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.actions.GroupSettleTicketAction;
import com.floreantpos.actions.NewBarTabAction;
import com.floreantpos.actions.ReorderTicketAction;
import com.floreantpos.actions.SendToKitchenAction;
import com.floreantpos.actions.SettleTicketAction;
import com.floreantpos.actions.ShowOrderInfoAction;
import com.floreantpos.actions.ShowTransactionsAuthorizationsAction;
import com.floreantpos.actions.SplitTicketAction;
import com.floreantpos.actions.TicketEditAction;
import com.floreantpos.actions.TicketKitchenSentAction;
import com.floreantpos.extension.OrderServiceFactory;
import com.floreantpos.main.Application;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.ShopTable;
import com.floreantpos.model.ShopTableStatus;
import com.floreantpos.model.TableStatus;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.ShopTableDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.TicketService;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosBlinkButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ScrollableFlowPanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.tableselection.BarTabSelectionView;
import com.floreantpos.ui.tableselection.DefaultShopTableButton;
import com.floreantpos.ui.tableselection.TableSelectionListener;
import com.floreantpos.ui.tableselection.TableSelector;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.ui.views.payment.SplitedTicketSelectionDialog;
import com.floreantpos.util.TicketAlreadyExistsException;
import com.jidesoft.swing.JideScrollPane;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttMessage;

public class DefaultTableSelectionView
extends TableSelector
implements TableSelectionListener,
DataChangeListener,
ActionListener,
IMqttMessageListener {
    private ScrollableFlowPanel a;
    private static PosButton b;
    private PosButton c = new PosButton(POSConstants.SAVE_BUTTON_TEXT);
    private PosButton d = new PosButton(POSConstants.CANCEL);
    private PosButton e = new PosButton(Messages.getString("DefaultTableSelectionView.5"));
    private PosBlinkButton f;
    private ButtonGroup g = new ButtonGroup();
    private POSToggleButton h = new POSToggleButton(POSConstants.GROUP);
    private POSToggleButton i = new POSToggleButton(POSConstants.UNGROUP);
    private POSToggleButton j = new POSToggleButton(Messages.getString("DefaultTableSelectionView.0"));
    private POSToggleButton k = new POSToggleButton(Messages.getString("DefaultTableSelectionView.1"));
    private POSToggleButton l = new POSToggleButton(Messages.getString("DefaultTableSelectionView.3"));
    private POSToggleButton m = new POSToggleButton(Messages.getString("DefaultTableSelectionView.4"));
    private POSToggleButton n = new POSToggleButton(Messages.getString("DefaultTableSelectionView.8"));
    private PosButton o = new PosButton(Messages.getString("DefaultTableSelectionView.7"));
    private POSToggleButton p = new POSToggleButton("RELEASE");
    private POSToggleButton q;
    private Ticket r;
    private Map<Integer, DefaultShopTableButton> s = new HashMap<Integer, DefaultShopTableButton>();
    private List<Integer> t = new ArrayList<Integer>();
    private List<Integer> u = new ArrayList<Integer>();
    private boolean v = false;
    private BarTabSelectionView w;
    private JPanel x;
    private PosButton y;
    private JTabbedPane z;
    private static DefaultTableSelectionView A;

    public static DefaultTableSelectionView getInstance() {
        if (A == null) {
            return new DefaultTableSelectionView();
        }
        return A;
    }

    public DefaultTableSelectionView() {
        this.c();
        this.a();
        this.b();
    }

    private void a() {
        this.h.putClientProperty("buttonAction", "GROUP");
        this.i.putClientProperty("buttonAction", "UNGROUP");
        this.p.putClientProperty("buttonAction", "RELEASE");
        this.m.putClientProperty("ticketAction", new SettleTicketAction(this));
        this.l.putClientProperty("ticketAction", new SplitTicketAction(this));
        this.k.putClientProperty("ticketAction", new ShowOrderInfoAction(this));
        this.j.putClientProperty("ticketAction", new TicketKitchenSentAction(this));
        this.n.putClientProperty("ticketAction", new ReorderTicketAction(this));
        this.h.addActionListener(this);
        this.i.addActionListener(this);
        this.c.addActionListener(this);
        this.d.addActionListener(this);
        this.j.addActionListener(this);
        this.k.addActionListener(this);
        this.l.addActionListener(this);
        this.m.addActionListener(this);
        this.n.addActionListener(this);
        this.p.addActionListener(this);
        this.c.setVisible(false);
        this.d.setVisible(false);
    }

    private void b() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    OroMqttClient.getInstance().subscribeToStore("MQTT-COMMAND", 0, DefaultTableSelectionView.this);
                }
                catch (Exception exception) {
                    PosLog.error(this.getClass(), exception.getMessage());
                }
            }
        }).start();
    }

    private void c() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEmptyBorder(7, 0, 0, 0));
        TitledBorder titledBorder = BorderFactory.createTitledBorder(null, POSConstants.TABLES, 2, 0);
        this.x = new JPanel(new BorderLayout(5, 5));
        this.x.setBorder(new CompoundBorder(titledBorder, new EmptyBorder(2, 2, 2, 2)));
        this.a = new ScrollableFlowPanel(1);
        JideScrollPane jideScrollPane = new JideScrollPane((Component)this.a, 20, 31);
        jideScrollPane.getVerticalScrollBar().setPreferredSize(PosUIManager.getSize(60, 0));
        this.x.add((Component)jideScrollPane, "Center");
        this.w = new BarTabSelectionView();
        this.z = new JTabbedPane();
        this.z.addTab(Messages.getString("DefaultTableSelectionView.9"), this.x);
        this.z.addTab(Messages.getString("DefaultTableSelectionView.11"), this.w);
        this.add((Component)this.z, "Center");
        this.add((Component)this.d(), "East");
    }

    private JPanel d() {
        TitledBorder titledBorder = BorderFactory.createTitledBorder(null, "-", 2, 0);
        JPanel jPanel = new JPanel(new BorderLayout(20, 20));
        jPanel.setPreferredSize(PosUIManager.getSize(125, 0));
        jPanel.setBorder(new CompoundBorder(titledBorder, new EmptyBorder(2, 2, 6, 2)));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("ins 2 2 0 2, hidemode 3, flowy", "sg fill, grow", ""));
        this.h.setIcon(new ImageIcon(this.getClass().getResource("/images/plus.png")));
        this.i.setIcon(new ImageIcon(this.getClass().getResource("/images/minus2.png")));
        this.y = new PosButton(Messages.getString("DefaultTableSelectionView.10"));
        this.y.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                List<ShopTable> list = DefaultTableSelectionView.this.getSelectedTables();
                new NewBarTabAction(DefaultTableSelectionView.this.orderType, list, Application.getPosWindow()).actionPerformed(actionEvent);
            }
        });
        this.g.add(this.h);
        this.g.add(this.i);
        this.g.add(this.j);
        this.g.add(this.k);
        this.g.add(this.l);
        this.g.add(this.m);
        this.g.add(this.n);
        this.g.add(this.p);
        jPanel2.add((Component)this.h, "grow");
        jPanel2.add((Component)this.i, "grow");
        jPanel2.add((Component)this.y, "grow");
        jPanel2.add((Component)this.j, "grow");
        jPanel2.add((Component)this.k, "grow");
        jPanel2.add((Component)this.l, "grow");
        jPanel2.add((Component)this.m, "grow");
        jPanel2.add((Component)this.o, "grow");
        jPanel2.add((Component)this.n, "grow");
        jPanel2.add((Component)this.e, "grow");
        jPanel2.add((Component)this.p, "grow");
        jPanel2.add((Component)this.c, "grow");
        jPanel2.add((Component)this.d, "grow");
        jPanel.add(jPanel2);
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("ins 2 2 0 2, hidemode 3, flowy", "grow", ""));
        this.f = new PosBlinkButton(POSConstants.REFRESH);
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultTableSelectionView.this.v = false;
                DefaultTableSelectionView.this.rendererTables();
            }
        });
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new ShowTransactionsAuthorizationsAction().execute();
            }
        });
        this.o.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                new GroupSettleTicketAction(Application.getCurrentUser()).actionPerformed(null);
                DefaultTableSelectionView.this.rendererTables();
            }
        });
        jPanel3.add((Component)this.f, "grow");
        b = new PosButton(POSConstants.CANCEL);
        b.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                DefaultTableSelectionView.this.a(true);
            }
        });
        jPanel3.add((Component)b, "grow");
        jPanel.add((Component)jPanel3, "South");
        return jPanel;
    }

    @Override
    public synchronized void rendererTables() {
        this.clearSelection();
        List<ShopTable> list = ShopTableDAO.getInstance().findAll();
        for (ShopTable shopTable : list) {
            DefaultShopTableButton defaultShopTableButton = this.s.get(shopTable.getId());
            if (defaultShopTableButton == null) {
                defaultShopTableButton = new DefaultShopTableButton(shopTable);
                defaultShopTableButton.setTableSelectionListener(this);
                defaultShopTableButton.updateView();
                this.s.put(shopTable.getId(), defaultShopTableButton);
                this.a.add(defaultShopTableButton);
                continue;
            }
            defaultShopTableButton.setShopTable(shopTable);
            defaultShopTableButton.updateView();
        }
        this.w.updateView(this.orderType);
        this.v = true;
    }

    private void a(boolean bl) {
        Window window = SwingUtilities.getWindowAncestor(this);
        if (window instanceof POSDialog) {
            ((POSDialog)window).setCanceled(bl);
            window.dispose();
        }
    }

    @Override
    public List<ShopTable> getSelectedTables() {
        ArrayList<ShopTable> arrayList = new ArrayList<ShopTable>();
        for (Integer n : this.t) {
            DefaultShopTableButton defaultShopTableButton = this.s.get(n);
            arrayList.add(defaultShopTableButton.getShopTable());
        }
        return arrayList;
    }

    @Override
    public void clearSelection() {
        this.t.clear();
        this.u.clear();
        this.g.clearSelection();
        this.h.setVisible(true);
        this.i.setVisible(true);
        this.j.setVisible(true);
        this.k.setVisible(true);
        this.l.setVisible(true);
        this.m.setVisible(true);
        this.o.setVisible(true);
        this.e.setVisible(true);
        this.c.setVisible(false);
        this.d.setVisible(false);
        this.q = null;
        if (this.getOrderType() != null) {
            if (this.getOrderType().isEnableReorder().booleanValue()) {
                this.n.setVisible(true);
            } else {
                this.n.setVisible(false);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof POSToggleButton) {
            this.q = (POSToggleButton)object;
        }
        if (object == this.h) {
            if (this.isCreateNewTicket()) {
                this.t.clear();
            }
            this.i.setVisible(false);
            this.j.setVisible(false);
            this.k.setVisible(false);
            this.l.setVisible(false);
            this.m.setVisible(false);
            this.o.setVisible(false);
            this.n.setVisible(false);
            this.e.setVisible(false);
            this.c.setVisible(true);
            this.d.setVisible(true);
        } else if (object == this.i) {
            this.u.clear();
            this.h.setVisible(false);
            this.j.setVisible(false);
            this.k.setVisible(false);
            this.l.setVisible(false);
            this.m.setVisible(false);
            this.o.setVisible(false);
            this.n.setVisible(false);
            this.e.setVisible(false);
            this.c.setVisible(true);
            this.d.setVisible(true);
        } else if (object == this.c) {
            if (this.h.isSelected()) {
                this.f();
                this.clearSelection();
            } else if (this.i.isSelected()) {
                this.g();
                this.clearSelection();
            }
        } else if (object == this.d) {
            this.clearSelection();
            this.rendererTables();
        }
    }

    private void e() {
        try {
            List<ShopTable> list = this.getSelectedTables();
            if (list.isEmpty()) {
                this.clearSelection();
                return;
            }
            OrderServiceFactory.getOrderService().createNewTicket(this.getOrderType(), list, null);
            ShopTableDAO.getInstance().updateTableStatus(this.t, (Integer)TableStatus.Booked.getValue(), null, false);
            this.clearSelection();
        }
        catch (TicketAlreadyExistsException ticketAlreadyExistsException) {
            PosLog.error(this.getClass(), ticketAlreadyExistsException);
        }
    }

    private boolean a(Integer n) {
        this.a(false);
        Ticket ticket = this.s.get(n).getTicket();
        TicketDAO.getInstance().loadFullTicket(ticket);
        OrderView.getInstance().setCurrentTicket(ticket);
        RootView.getInstance().showView("ORDER_VIEW");
        return true;
    }

    private void f() {
        if (this.isCreateNewTicket()) {
            this.e();
        }
        this.a(false);
    }

    private void g() {
        if (this.u == null || this.u.isEmpty()) {
            return;
        }
        DefaultShopTableButton defaultShopTableButton = this.s.get(this.u.get(0));
        if (!defaultShopTableButton.hasUserAccess()) {
            return;
        }
        this.h();
        if (!this.isCreateNewTicket()) {
            this.a(false);
        }
    }

    private void h() {
        Iterator<Integer> iterator = this.u.iterator();
        while (iterator.hasNext()) {
            Integer n = iterator.next();
            DefaultShopTableButton defaultShopTableButton = this.s.get(n);
            ShopTable shopTable = defaultShopTableButton.getShopTable();
            if (this.t.contains(shopTable.getId())) {
                this.t.remove(shopTable.getId());
            }
            iterator.remove();
            defaultShopTableButton.setTicket(null);
        }
        this.clearSelection();
    }

    @Override
    public void setTicket(Ticket ticket) {
        if (ticket == null) {
            return;
        }
        this.ticket = ticket;
        List<ShopTable> list = ShopTableDAO.getInstance().getTables(ticket);
        if (list == null) {
            return;
        }
        this.t.clear();
        for (ShopTable shopTable : list) {
            DefaultShopTableButton defaultShopTableButton = this.s.get(shopTable.getId());
            this.t.add(defaultShopTableButton.getShopTable().getId());
            defaultShopTableButton.updateView();
        }
    }

    @Override
    public void updateView(boolean bl) {
        b.setVisible(bl);
    }

    @Override
    public void tableSelected(ShopTable shopTable) {
        if (shopTable == null) {
            return;
        }
        ShopTableStatus shopTableStatus = shopTable.getShopTableStatus();
        DefaultShopTableButton defaultShopTableButton = this.s.get(shopTable.getId());
        if (shopTableStatus.hasMultipleTickets()) {
            this.a(new TicketEditAction(), defaultShopTableButton.getTicket(), shopTableStatus);
        } else if (shopTable.getTicketId() != null) {
            this.a(shopTable.getId());
        } else {
            if (!this.isCreateNewTicket() && !this.h.isSelected() && this.t.size() >= 1) {
                this.u.addAll(this.t);
                this.h();
            }
            this.t.add(shopTable.getId());
            if (this.isCreateNewTicket()) {
                this.e();
            }
        }
        this.a(false);
    }

    @Override
    public AbstractButton getTableActionButton() {
        return this.q;
    }

    @Override
    public List getAddedTableList() {
        return this.t;
    }

    @Override
    public List getReleasesTableList() {
        return this.u;
    }

    @Override
    public void dataAdded(Object object) {
        this.a(object);
    }

    private void a(Object object) {
        if (object == null) {
            return;
        }
        Ticket ticket = (Ticket)object;
        List<Integer> list = ticket.getTableNumbers();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (Integer n : list) {
            DefaultShopTableButton defaultShopTableButton = this.s.get(n);
            if (ticket.isClosed().booleanValue()) {
                defaultShopTableButton.setTicket(null);
                continue;
            }
            defaultShopTableButton.setTicket(ticket);
        }
    }

    @Override
    public void dataChanged(Object object) {
        this.a(object);
    }

    @Override
    public void dataRemoved(Object object) {
        this.a(object);
    }

    @Override
    public Object getSelectedData() {
        return this.r;
    }

    @Override
    public void dataSetUpdated() {
        this.v = false;
        this.rendererTables();
    }

    @Override
    public void tableActionSelected(ShopTable shopTable, AbstractAction abstractAction, Ticket ticket) {
        this.r = ticket;
        ShopTableStatus shopTableStatus = shopTable.getShopTableStatus();
        DefaultShopTableButton defaultShopTableButton = this.s.get(shopTable.getId());
        if (shopTableStatus.hasMultipleTickets()) {
            this.a(abstractAction, defaultShopTableButton.getTicket(), shopTableStatus);
        } else {
            if (this.isCreateNewTicket()) {
                abstractAction.actionPerformed(null);
                this.a(false);
            }
            this.clearSelection();
            ticket = TicketService.getTicket(ticket.getId());
        }
    }

    private void a(AbstractAction abstractAction, Ticket ticket, ShopTableStatus shopTableStatus) {
        ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
        for (String object2 : shopTableStatus.getListOfTicketNumbers()) {
            Ticket ticket2 = TicketDAO.getInstance().loadFullTicket(object2);
            if (ticket2 == null) continue;
            arrayList.add(ticket2);
        }
        Object object3 = "";
        object3 = abstractAction instanceof SendToKitchenAction ? POSConstants.SEND_TO_KITCHEN : (abstractAction instanceof ShowOrderInfoAction ? POSConstants.ORDER_INFO : (abstractAction instanceof SettleTicketAction ? POSConstants.SETTLE : (abstractAction instanceof SplitTicketAction ? POSConstants.SPLIT_TICKET : (abstractAction instanceof ReorderTicketAction ? POSConstants.REORDER_TICKET_BUTTON_TEXT : POSConstants.EDIT))));
        SplitedTicketSelectionDialog splitedTicketSelectionDialog = new SplitedTicketSelectionDialog(arrayList);
        splitedTicketSelectionDialog.setDefaultCloseOperation(2);
        splitedTicketSelectionDialog.setSelectedAction((String)object3);
        splitedTicketSelectionDialog.setSize(PosUIManager.getSize(800, 600));
        splitedTicketSelectionDialog.open();
        this.rendererTables();
        if (splitedTicketSelectionDialog.isCanceled()) {
            return;
        }
        if (((String)object3).equals(POSConstants.EDIT)) {
            this.a(false);
        }
    }

    @Override
    public Ticket getTicket(Integer n) {
        return this.s.get(n).getTicket();
    }

    @Override
    public void dataChangeCanceled(Object object) {
        if (object == null) {
            return;
        }
        Ticket ticket = (Ticket)object;
        List<Integer> list = ticket.getTableNumbers();
        if (list == null || list.isEmpty()) {
            return;
        }
        for (Integer n : list) {
            DefaultShopTableButton defaultShopTableButton = this.s.get(n);
            defaultShopTableButton.setTicket(null);
        }
    }

    @Override
    public void setOrderType(OrderType orderType) {
        super.setOrderType(orderType);
        if (orderType == null) {
            return;
        }
        this.y.setVisible(orderType.isBarTab());
    }

    public void messageArrived(String string, MqttMessage mqttMessage) throws Exception {
        String string2 = new String(mqttMessage.getPayload());
        if ("1".equals(string2) || "2".equals(string2)) {
            this.f.setBlinking(true);
        }
    }

    static {
        A = null;
    }
}

