/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.ticket;

import com.floreantpos.Messages;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemCookingInstruction;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.ui.ticket.TicketItemRowCreator;
import com.floreantpos.ui.ticket.TicketViewerTableChangeListener;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import org.apache.commons.lang.StringUtils;

public class TicketViewerTableModel
extends AbstractTableModel {
    private final JTable a;
    protected Ticket ticket;
    private double b;
    protected final HashMap<String, ITicketItem> tableRows = new LinkedHashMap<String, ITicketItem>();
    private boolean c = false;
    private TicketViewerTableChangeListener d;
    protected String[] columnNames = new String[]{Messages.getString("TicketViewerTableModel.0"), Messages.getString("TicketViewerTableModel.3")};
    private boolean e;
    private boolean f;
    private boolean g;
    private boolean h;

    public TicketViewerTableModel(JTable jTable) {
        this(jTable, null);
    }

    public TicketViewerTableModel(JTable jTable, Ticket ticket) {
        this.a = jTable;
        this.setTicket(ticket);
    }

    public int getItemCount() {
        return this.tableRows.size();
    }

    @Override
    public int getRowCount() {
        int n = this.tableRows.size();
        return n;
    }

    public int getActualRowCount() {
        return this.tableRows.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnNames.length;
    }

    @Override
    public String getColumnName(int n) {
        return this.columnNames[n];
    }

    @Override
    public Object getValueAt(int n, int n2) {
        ITicketItem iTicketItem = this.tableRows.get(String.valueOf(n));
        if (iTicketItem == null) {
            return null;
        }
        switch (n2) {
            case 0: {
                TicketItem ticketItem;
                String string = "";
                String string2 = "";
                if (iTicketItem instanceof TicketItem && (ticketItem = (TicketItem)iTicketItem).getCourseName() != null) {
                    string = "[" + ticketItem.getCourseName() + "]  ";
                }
                string2 = string + iTicketItem.getNameDisplay();
                return string2;
            }
            case 1: {
                return iTicketItem.getSubTotalAmountDisplay();
            }
        }
        return null;
    }

    protected void calculateRows() {
        TicketItemRowCreator.calculateTicketRows(this.ticket, this.tableRows, true);
    }

    public int addTicketItem(TicketItem ticketItem) {
        if (ticketItem.isHasModifiers().booleanValue()) {
            return this.a(ticketItem);
        }
        Object[] objectArray = this.tableRows.values().toArray();
        if (objectArray == null || objectArray.length == 0) {
            this.b = ticketItem.getQuantity();
            return this.a(ticketItem);
        }
        Object object = objectArray[objectArray.length - 1];
        if (object instanceof TicketItem) {
            TicketItem ticketItem2 = (TicketItem)object;
            String string = ticketItem.getMenuItemId();
            if (StringUtils.isEmpty((String)string) || string.equals("0")) {
                return this.a(ticketItem);
            }
            if (string.equals(ticketItem2.getMenuItemId()) && ticketItem2.getQuantity() > 0.0 && !ticketItem2.isComboItem().booleanValue() && !ticketItem2.isPrintedToKitchen().booleanValue() && ticketItem2.getUnitPrice().equals(ticketItem.getUnitPrice())) {
                this.b = ticketItem2.getQuantity();
                if (ticketItem.isFractionalUnit().booleanValue()) {
                    ticketItem2.setFractionalUnit(true);
                    ticketItem2.setQuantity(this.b + ticketItem.getQuantity());
                    this.b = ticketItem2.getQuantity();
                } else {
                    ticketItem2.setQuantity(ticketItem2.getQuantity() + 1.0);
                }
                this.fireTableRowsUpdated(objectArray.length - 1, objectArray.length - 1);
                return objectArray.length - 1;
            }
        }
        this.b = ticketItem.getQuantity();
        return this.a(ticketItem);
    }

    private int a(TicketItem ticketItem) {
        int n = this.tableRows.size();
        this.ticket.addToticketItems(ticketItem);
        this.calculateRows();
        int n2 = this.tableRows.size();
        this.fireTableRowsInserted(n, n2);
        return n2 - 1;
    }

    public int addTicketDiscount(TicketDiscount ticketDiscount) {
        int n = this.tableRows.size();
        this.ticket.addTodiscounts(ticketDiscount);
        this.calculateRows();
        int n2 = this.tableRows.size();
        this.fireTableRowsInserted(n, n2);
        return n2 - 1;
    }

    public void addAllTicketItem(TicketItem ticketItem) {
        if (ticketItem.isHasModifiers().booleanValue()) {
            List<TicketItem> list = this.ticket.getTicketItems();
            list.add(ticketItem);
            this.calculateRows();
            this.fireTableDataChanged();
        } else {
            List<TicketItem> list = this.ticket.getTicketItems();
            boolean bl = false;
            for (TicketItem ticketItem2 : list) {
                if (!ticketItem2.getName().equals(ticketItem.getName())) continue;
                double d = ticketItem2.getQuantity();
                ticketItem2.setQuantity(d += ticketItem.getQuantity().doubleValue());
                bl = true;
                this.a.repaint();
                return;
            }
            if (!bl) {
                this.ticket.addToticketItems(ticketItem);
                this.calculateRows();
                this.fireTableDataChanged();
            }
        }
    }

    public boolean containsTicketItem(TicketItem ticketItem) {
        if (ticketItem.isHasModifiers().booleanValue()) {
            return false;
        }
        List<TicketItem> list = this.ticket.getTicketItems();
        for (TicketItem ticketItem2 : list) {
            if (!ticketItem2.getName().equals(ticketItem.getName())) continue;
            return true;
        }
        return false;
    }

    public void removeModifier(TicketItem ticketItem, TicketItemModifier ticketItemModifier) {
        List<TicketItemModifier> list = ticketItem.getTicketItemModifiers();
        Iterator<TicketItemModifier> iterator = list.iterator();
        while (iterator.hasNext()) {
            TicketItemModifier ticketItemModifier2 = iterator.next();
            if (ticketItemModifier2.getItemId() != ticketItemModifier.getItemId()) continue;
            iterator.remove();
            if (ticketItemModifier2.isPrintedToKitchen().booleanValue()) {
                this.ticket.addDeletedItems(ticketItemModifier2);
            }
            this.calculateRows();
            this.fireTableDataChanged();
            return;
        }
    }

    public Object delete(int n) {
        if (n < 0 || n >= this.tableRows.size()) {
            return null;
        }
        ITicketItem iTicketItem = this.tableRows.get(String.valueOf(n));
        if (iTicketItem instanceof TicketItem) {
            TicketItem ticketItem = (TicketItem)iTicketItem;
            int n2 = ticketItem.getTableRowNum();
            List<TicketItem> list = this.ticket.getTicketItems();
            Iterator<TicketItem> iterator = list.iterator();
            while (iterator.hasNext()) {
                TicketItem ticketItem2 = iterator.next();
                if (ticketItem2.getTableRowNum() != n2) continue;
                iterator.remove();
                if (ticketItem2.isPrintedToKitchen().booleanValue() || ticketItem2.getInventoryAdjustQty() > 0.0) {
                    this.ticket.addDeletedItems(ticketItem2);
                }
                break;
            }
        } else if (iTicketItem instanceof TicketItemModifier) {
            TicketItemModifier ticketItemModifier = (TicketItemModifier)iTicketItem;
            TicketItem ticketItem = ticketItemModifier.getTicketItem();
            List<TicketItemModifier> list = ticketItem.getTicketItemModifiers();
            if (list != null) {
                Iterator<TicketItemModifier> iterator = list.iterator();
                while (iterator.hasNext()) {
                    TicketItemModifier ticketItemModifier2 = iterator.next();
                    if (ticketItemModifier.getTableRowNum() != ticketItemModifier2.getTableRowNum()) continue;
                    iterator.remove();
                    if (!ticketItemModifier2.isPrintedToKitchen().booleanValue()) continue;
                    this.ticket.addDeletedItems(ticketItemModifier2);
                }
            }
        } else if (iTicketItem instanceof TicketItemCookingInstruction) {
            TicketItemCookingInstruction ticketItemCookingInstruction = (TicketItemCookingInstruction)iTicketItem;
            int n3 = ticketItemCookingInstruction.getTableRowNum();
            TicketItem ticketItem = null;
            while (n3 > 0) {
                ITicketItem iTicketItem2;
                if (!((iTicketItem2 = this.tableRows.get(String.valueOf(--n3))) instanceof TicketItem)) continue;
                ticketItem = (TicketItem)iTicketItem2;
                break;
            }
            if (ticketItem != null) {
                ticketItem.removeCookingInstruction(ticketItemCookingInstruction);
            }
        } else if (iTicketItem instanceof TicketItemDiscount) {
            TicketItemDiscount ticketItemDiscount = (TicketItemDiscount)iTicketItem;
            int n4 = ticketItemDiscount.getTableRowNum();
            TicketItem ticketItem = null;
            while (n4 > 0) {
                ITicketItem iTicketItem3;
                if (!((iTicketItem3 = this.tableRows.get(String.valueOf(--n4))) instanceof TicketItem)) continue;
                ticketItem = (TicketItem)iTicketItem3;
                break;
            }
            if (ticketItem != null) {
                ticketItem.removeTicketItemDiscount(ticketItemDiscount);
                if (this.d != null) {
                    this.d.ticketDataChanged();
                }
            }
        }
        this.calculateRows();
        this.fireTableRowsDeleted(n, n);
        return iTicketItem;
    }

    @Override
    public boolean isCellEditable(int n, int n2) {
        if (this.g && n2 == 0) {
            return this.get(n) instanceof TicketItemDiscount || this.h;
        }
        return false;
    }

    public void removeAll() {
        if (this.tableRows.size() <= 0) {
            return;
        }
        this.ticket.getTicketItems().clear();
        this.tableRows.clear();
        this.fireTableDataChanged();
    }

    public Object get(int n) {
        if (n < 0 || n >= this.tableRows.size()) {
            return null;
        }
        return this.tableRows.get(String.valueOf(n));
    }

    public Ticket getTicket() {
        return this.ticket;
    }

    public void setTicket(Ticket ticket) {
        this.ticket = ticket;
        if (ticket != null && ticket.getOrderType() != null) {
            this.h = ticket.getOrderType().isEnableCourse();
        }
        this.update();
    }

    public void update() {
        this.calculateRows();
        this.fireTableDataChanged();
    }

    public boolean isForReciptPrint() {
        return this.e;
    }

    public void setForReciptPrint(boolean bl) {
        this.e = bl;
    }

    public boolean isPrintCookingInstructions() {
        return this.f;
    }

    public void setPrintCookingInstructions(boolean bl) {
        this.f = bl;
    }

    public boolean isPriceIncludesTax() {
        return this.c;
    }

    public void setPriceIncludesTax(boolean bl) {
        this.c = bl;
    }

    public void setEditable(boolean bl) {
        this.g = bl;
    }

    public void addTicketDataChangeListener(TicketViewerTableChangeListener ticketViewerTableChangeListener) {
        this.d = ticketViewerTableChangeListener;
    }

    public boolean isOrganizeTable() {
        return this.h;
    }
}

