/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.actions.ClockInOutAction;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.config.ui.DatabaseConfigurationDialog;
import com.floreantpos.main.Application;
import com.floreantpos.model.User;
import com.floreantpos.swing.MessageDialog;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.PasswordEntryDialog;
import com.floreantpos.util.ShiftException;
import com.floreantpos.util.UserNotFoundException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.logging.LogFactory;

class LoginPasswordEntryView
extends JPanel {
    private PosButton b;
    private PosButton c;
    private JPanel d;
    private JPanel e;
    Action a = new AbstractAction(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (POSConstants.LOGIN.equals(string)) {
                LoginPasswordEntryView.this.doLogin();
            } else if (POSConstants.SHUTDOWN.equals(string)) {
                Application.getInstance().shutdownPOS();
            } else if ("DBCONFIG".equalsIgnoreCase(string)) {
                DatabaseConfigurationDialog.show(Application.getPosWindow());
            }
        }
    };
    private PosButton f;
    private JLabel g;
    private JToggleButton h = new JToggleButton("<html><center>REGULAR<br/>MODE</center></html>");
    private JToggleButton i = new JToggleButton("<html><center>KITCHEN<br/>MODE</center></html>");

    LoginPasswordEntryView() {
        this.a();
        this.applyComponentOrientation(ComponentOrientation.getOrientation(Locale.getDefault()));
    }

    private void a() {
        this.d = new JPanel();
        this.e = new JPanel();
        this.c = new PosButton();
        this.setPreferredSize(new Dimension(320, 593));
        this.setLayout(new BorderLayout());
        this.d.setOpaque(false);
        this.d.setPreferredSize(new Dimension(200, 180));
        this.d.setLayout((LayoutManager)new MigLayout("", "[111px][111px][111px,grow]", "[60px][60px][60px][60px]"));
        this.g = new JLabel("TERMINAL ID:");
        this.g.setForeground(Color.BLACK);
        this.g.setFont(new Font("Dialog", 1, 18));
        this.g.setHorizontalAlignment(0);
        this.add((Component)this.g, "North");
        this.e.setLayout((LayoutManager)new MigLayout("hidemode 3, fill"));
        this.e.setBorder(BorderFactory.createEmptyBorder(0, 10, 0, 10));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.h);
        buttonGroup.add(this.i);
        this.h.setFocusable(false);
        this.i.setFocusable(false);
        ModeSelectionListener modeSelectionListener = new ModeSelectionListener();
        this.h.addActionListener(modeSelectionListener);
        this.i.addActionListener(modeSelectionListener);
        this.h.setSelected(TerminalConfig.isRegularMode());
        this.i.setSelected(TerminalConfig.isKitchenMode());
        if (!this.h.isSelected() && !this.i.isSelected()) {
            this.h.setSelected(true);
        }
        JPanel jPanel = new JPanel(new GridLayout(1, 0, 2, 2));
        jPanel.add(this.h);
        jPanel.add(this.i);
        this.e.add((Component)jPanel, "h 60!, grow, wrap");
        this.f = new PosButton();
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LoginPasswordEntryView.this.doLogin();
            }
        });
        this.f.setText("LOGIN");
        this.e.add((Component)this.f, "grow, wrap, gapbottom 20px");
        PosButton posButton = new PosButton(new ClockInOutAction(false, true));
        this.e.add((Component)posButton, "grow, wrap, h 60!");
        if (TerminalConfig.isShowDbConfigureButton()) {
            this.b = new PosButton();
            this.b.setAction(this.a);
            this.b.setText(POSConstants.CONFIGURE_DATABASE);
            this.b.setFocusable(false);
            this.b.setActionCommand("DBCONFIG");
            this.e.add((Component)this.b, "grow, wrap, h 60!");
        }
        this.c.setAction(this.a);
        this.c.setText(POSConstants.SHUTDOWN);
        this.c.setFocusable(false);
        if (TerminalConfig.isKioskMode()) {
            if (this.b != null) {
                this.b.setVisible(false);
            }
            if (this.c != null) {
                this.c.setVisible(false);
            }
        }
        this.e.add((Component)this.c, "grow, wrap, h 60!");
        this.add((Component)this.e, "South");
        this.g.setText("");
    }

    public synchronized void doLogin() {
        try {
            User user = PasswordEntryDialog.getUser(Application.getPosWindow(), "", "");
            if (user == null) {
                return;
            }
            Application application = Application.getInstance();
            application.doLogin(user);
        }
        catch (UserNotFoundException userNotFoundException) {
            LogFactory.getLog(Application.class).error((Object)userNotFoundException);
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("LoginPasswordEntryView.15"));
        }
        catch (ShiftException shiftException) {
            LogFactory.getLog(Application.class).error((Object)shiftException);
            MessageDialog.showError(shiftException.getMessage());
        }
        catch (Exception exception) {
            LogFactory.getLog(Application.class).error((Object)exception);
            String string = exception.getMessage();
            if (string != null && string.contains("Cannot open connection")) {
                MessageDialog.showError("", exception);
                DatabaseConfigurationDialog.show(Application.getPosWindow());
            }
            MessageDialog.showError("", exception);
        }
    }

    public void setTerminalId(int n) {
        this.g.setText(Messages.getString("LoginPasswordEntryView.19") + n);
    }

    class ModeSelectionListener
    implements ActionListener {
        ModeSelectionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            TerminalConfig.setRegularMode(LoginPasswordEntryView.this.h.isSelected());
            TerminalConfig.setKitchenMode(LoginPasswordEntryView.this.i.isSelected());
        }
    }
}

