/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order;

import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.actions.VoidTicketItemAction;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.ModifiableTicketItem;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemCookingInstruction;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosScrollPane;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.ComboTicketItemSelectionDialog;
import com.floreantpos.ui.dialog.ItemSearchDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.SendToKitchenOptionSelectionDialog;
import com.floreantpos.ui.ticket.TicketViewerTable;
import com.floreantpos.ui.views.CookingInstructionSelectionView;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.RootView;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.ui.views.order.actions.OrderListener;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.hibernate.StaleStateException;

public class TicketView
extends JPanel {
    private final Vector<OrderListener> a = new Vector();
    private Ticket b;
    private PosButton c;
    private final PosButton d = new PosButton(IconFactory.getIcon("/ui_icons/", "page-up.png"));
    private final PosButton e = new PosButton(IconFactory.getIcon("/ui_icons/", "page-down.png"));
    private final PosButton f = new PosButton();
    private final PosButton g = new PosButton();
    private final PosButton h = new PosButton(IconFactory.getIcon("/ui_icons/", "edit.png"));
    private final PosButton i = new PosButton(IconFactory.getIcon("/ui_icons/", "add-multiple.png"));
    private PosButton j;
    private final PosButton k = new PosButton();
    private TransparentPanel l;
    private JScrollPane m;
    private PosButton n;
    private TicketViewerTable o;
    private ItemSearchDialog p = new ItemSearchDialog(Application.getPosWindow());
    private JPanel q;
    private JTextField r;
    private final PosButton s = new PosButton(IconFactory.getIcon("/ui_icons/", "cooking-instruction.png"));
    private final TitledBorder t = new TitledBorder("");
    private final Border u = new CompoundBorder(this.t, new EmptyBorder(2, 2, 2, 2));
    private boolean v;
    private boolean w;
    public static final String VIEW_NAME = "TICKET_VIEW";

    public TicketView() {
        this.a();
    }

    private void a() {
        this.t.setTitleJustification(2);
        this.setBorder(this.u);
        this.setLayout(new BorderLayout(5, 5));
        this.q = new JPanel();
        this.l = new TransparentPanel();
        this.c = new PosButton();
        this.j = new PosButton();
        this.o = new TicketViewerTable();
        this.m = new PosScrollPane(this.o);
        this.m.setHorizontalScrollBarPolicy(31);
        this.m.setVerticalScrollBarPolicy(21);
        this.m.setPreferredSize(PosUIManager.getSize(180, 200));
        this.h.setEnabled(false);
        this.s.setEnabled(false);
        this.c();
        this.d();
        this.b();
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        jPanel.add(this.m);
        this.add((Component)this.q, "North");
        this.add(jPanel);
        this.add((Component)this.l, "East");
        this.o.getRenderer().setInTicketScreen(true);
        this.o.getSelectionModel().addListSelectionListener(new TicketItemSelectionListener());
        this.setPreferredSize(PosUIManager.getSize(320, 463));
    }

    private void b() {
        this.q.setLayout(new BorderLayout(5, 5));
        PosButton posButton = new PosButton(IconFactory.getIcon("/ui_icons/", "search.png"));
        posButton.setPreferredSize(PosUIManager.getSize(50, 40));
        this.r = new JTextField();
        this.r.requestFocusInWindow();
        this.r.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = TicketView.this.r.getText();
                if (string.equals("")) {
                    POSMessageDialog.showMessage(Messages.getString("TicketView.5"));
                    return;
                }
                MenuItem menuItem = MenuItemDAO.getInstance().getMenuItemByBarcodeOrSKU(string);
                if (menuItem != null) {
                    OrderView.getInstance().getOrderController().itemSelected(menuItem);
                }
                TicketView.this.r.setText("");
            }
        });
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketView.this.p.setTitle(Messages.getString("TicketView.7"));
                TicketView.this.p.updateFilterPanel(TicketView.this.b.getOrderType());
                TicketView.this.p.pack();
                TicketView.this.p.openFullScreen();
                if (TicketView.this.p.isCanceled()) {
                    return;
                }
                TicketView.this.r.requestFocus();
                if (TicketView.this.p.getMenuItem() == null) {
                    POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("TicketView.8"));
                    return;
                }
                OrderView.getInstance().getOrderController().itemSelected(TicketView.this.p.getMenuItem());
            }
        });
        this.q.add(this.r);
        this.q.add((Component)posButton, "East");
    }

    private void c() {
        this.n = new PosButton(POSConstants.TOTAL.toUpperCase());
        this.n.setFont(this.n.getFont().deriveFont(1));
        if (!Application.getInstance().getTerminal().isHasCashDrawer().booleanValue()) {
            this.n.setEnabled(false);
        }
        this.n.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketView.this.g();
            }
        });
        this.add((Component)this.n, "South");
    }

    private void d() {
        this.l.setLayout((LayoutManager)new MigLayout("fill, hidemode 3, ins 0 0 0 0", "sg, fill", ""));
        this.k.setIcon(IconFactory.getIcon("/ui_icons/", "up.png"));
        this.k.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketView.this.k();
            }
        });
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketView.this.l();
            }
        });
        this.j.setIcon(IconFactory.getIcon("/ui_icons/", "down.png"));
        this.j.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketView.this.j();
            }
        });
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketView.this.m();
            }
        });
        this.f.setText("");
        this.f.setIcon(IconFactory.getIcon("/ui_icons/", "delete.png"));
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketView.this.h();
            }
        });
        this.h.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketView.this.i();
            }
        });
        this.i.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketView.this.e();
            }
        });
        this.s.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketView.this.doAddCookingInstruction();
            }
        });
        this.l.add((Component)this.d, "grow, wrap");
        this.l.add((Component)this.k, "grow, wrap");
        this.l.add((Component)this.i, "grow, wrap");
        this.l.add((Component)this.f, "grow, wrap");
        this.l.add((Component)this.h, "grow, wrap");
        this.l.add((Component)this.s, "grow, wrap");
        this.l.add((Component)this.j, "grow, wrap");
        this.l.add((Component)this.e, "grow");
        this.l.setPreferredSize(PosUIManager.getSize(50, 0));
    }

    private void e() {
        ITicketItem iTicketItem = this.o.getSelected();
        if (iTicketItem == null) {
            return;
        }
        if (!(iTicketItem instanceof TicketItem) || ((TicketItem)iTicketItem).isTreatAsSeat().booleanValue()) {
            return;
        }
        TicketItem ticketItem = (TicketItem)iTicketItem;
        OrderView.getInstance().getOrderController().doEditTicketItemQuantity(ticketItem);
        this.updateView();
        int n = this.o.getSelectedRow();
        this.o.getModel().fireTableRowsUpdated(n, n);
        this.o.fireTicketItemUpdated(this.getTicket(), ticketItem);
    }

    public synchronized void doFinishOrder() {
        this.saveTicketIfNeeded();
        this.sendTicketToKitchen();
        this.a(false);
    }

    public synchronized void sendTicketToKitchenByOption(RefreshableView refreshableView) {
        if (this.b.getTicketItems() == null || this.b.getTicketItems().size() == 0) {
            throw new PosException(POSConstants.TICKET_IS_EMPTY_);
        }
        SendToKitchenOptionSelectionDialog sendToKitchenOptionSelectionDialog = new SendToKitchenOptionSelectionDialog(this.b, refreshableView);
        sendToKitchenOptionSelectionDialog.pack();
        sendToKitchenOptionSelectionDialog.open();
        if (sendToKitchenOptionSelectionDialog.isCanceled()) {
            return;
        }
        this.setCancelable(false);
        this.setAllowToLogOut(false);
    }

    public synchronized void sendTicketToKitchen() {
        if (this.b.getOrderType().isShouldPrintToKitchen().booleanValue() && this.b.needsKitchenPrint()) {
            ReceiptPrintService.printToKitchen(this.b);
            this.setCancelable(false);
            this.setAllowToLogOut(false);
        }
    }

    public synchronized void doHoldOrder() {
        this.f();
        OrderController.saveOrder(this.b);
        this.a(false);
    }

    public void saveTicketIfNeeded() {
        try {
            this.f();
            OrderController.saveOrder(this.b);
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), OrderView.getInstance());
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(boolean bl) {
        DataChangeListener dataChangeListener = RootView.getInstance().getHomeView().getDataChangeListener();
        if (dataChangeListener != null) {
            if (bl) {
                dataChangeListener.dataChangeCanceled(this.b);
            } else {
                dataChangeListener.dataChanged(this.b);
            }
        }
        RootView.getInstance().showDefaultView();
    }

    public void doCancelOrder() {
        this.a(true);
    }

    private synchronized void f() {
        if (this.b.getTicketItems() == null || this.b.getTicketItems().size() == 0) {
            throw new PosException(POSConstants.TICKET_IS_EMPTY_);
        }
        this.b.calculatePrice();
    }

    private void g() {
        try {
            this.firePayOrderSelected();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(posException.getMessage());
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("OrderView.0"));
            return;
        }
    }

    private void h() {
        ITicketItem iTicketItem = this.o.getSelected();
        if (iTicketItem == null) {
            return;
        }
        boolean bl = false;
        if (iTicketItem instanceof TicketItem) {
            boolean bl2 = bl = ((TicketItem)iTicketItem).getInventoryAdjustQty() > 0.0;
        }
        if (iTicketItem.isPrintedToKitchen().booleanValue() || bl) {
            TicketItem ticketItem = (TicketItem)iTicketItem;
            if (this.a(ticketItem)) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), "Void item quantity limit exceed.");
                return;
            }
            VoidTicketItemAction voidTicketItemAction = new VoidTicketItemAction(this.b, ticketItem);
            voidTicketItemAction.actionPerformed(null);
            if (voidTicketItemAction.isDataChanged()) {
                this.o.updateView();
                this.updateView();
            }
        } else {
            this.o.deleteSelectedItem();
            this.updateView();
        }
    }

    private boolean a(TicketItem ticketItem) {
        double d = 0.0;
        for (TicketItem ticketItem2 : this.b.getTicketItems()) {
            String string;
            String string2;
            if (ticketItem2.isTreatAsSeat().booleanValue() || !(string2 = ticketItem.getMenuItemId().equals("0") ? ticketItem.getName() : ticketItem.getMenuItemId()).equals(string = ticketItem2.getMenuItemId().equals("0") ? ticketItem2.getName() : ticketItem2.getMenuItemId())) continue;
            d += ticketItem2.getQuantity().doubleValue();
        }
        return d <= 0.0;
    }

    private void i() {
        ITicketItem iTicketItem = this.o.getSelected();
        if (iTicketItem == null) {
            return;
        }
        if (iTicketItem instanceof TicketItem) {
            TicketItem ticketItem = (TicketItem)iTicketItem;
            if (ticketItem.isTreatAsSeat().booleanValue()) {
                if (!OrderView.getInstance().updateSeat(ticketItem)) {
                    return;
                }
            } else if (ticketItem.isComboItem().booleanValue()) {
                ComboTicketItemSelectionDialog comboTicketItemSelectionDialog = new ComboTicketItemSelectionDialog(ticketItem.getMenuItem(), ticketItem);
                comboTicketItemSelectionDialog.setTitle("SELECT COMBO ITEMS");
                comboTicketItemSelectionDialog.setSize(PosUIManager.getSize(800, 600));
                comboTicketItemSelectionDialog.open();
                if (comboTicketItemSelectionDialog.isCanceled()) {
                    return;
                }
            } else {
                OrderController.openModifierDialog(iTicketItem);
            }
        } else {
            OrderController.openModifierDialog(iTicketItem);
        }
        this.o.rowTobeSelectedOnResize = -1;
        this.updateView();
    }

    private void j() {
        this.o.scrollDown();
    }

    private void k() {
        this.o.scrollUp();
    }

    private void l() {
        this.o.scrollUpTen();
    }

    private void m() {
        this.o.scrollDownTen();
    }

    public Ticket getTicket() {
        return this.b;
    }

    public void setTicket(Ticket ticket) {
        this.b = ticket;
        this.o.setTicket(ticket);
        this.updateView();
        this.setCancelable(true);
        this.setAllowToLogOut(true);
    }

    public void addTicketItem(TicketItem ticketItem) {
        this.o.addTicketItem(ticketItem);
        this.updateView();
    }

    public void removeModifier(TicketItem ticketItem, TicketItemModifier ticketItemModifier) {
        ticketItemModifier.setItemQuantity(0.0);
        this.o.removeModifier(ticketItem, ticketItemModifier);
    }

    public void selectRow(int n) {
        this.o.selectRow(n);
    }

    public void updateView() {
        if (this.b == null) {
            this.n.setText(POSConstants.TOTAL.toUpperCase() + " " + CurrencyUtil.getCurrencySymbol() + "0.00");
            this.t.setTitle(this.b.getOrderType().toString() + "[New Ticket]");
            return;
        }
        this.b.calculatePrice();
        if (this.b.getDueAmount() < 0.0) {
            String string = NumberUtil.formatNumber(this.b.getDueAmount(), true);
            String string2 = "DUE: -" + CurrencyUtil.getCurrencySymbol() + string.replaceFirst("-", "");
            this.n.setText(string2);
        } else {
            String string = NumberUtil.formatNumber(this.b.getDueAmount(), true);
            this.n.setText("DUE: " + CurrencyUtil.getCurrencySymbol() + string);
        }
        this.updateTicketTitle();
        this.a(this.o.getSelected());
    }

    public void updateTicketTitle() {
        String string = this.b.getOrderType().toString();
        if (this.b.getId() == null) {
            this.t.setTitle(string + " [New Ticket]");
        } else {
            StringBuilder stringBuilder = new StringBuilder();
            String string2 = Messages.getString("TicketView.37");
            stringBuilder.append(string);
            stringBuilder.append(" [ " + string2 + " " + this.b.getTokenNo() + " ]");
            this.t.setTitle(stringBuilder.toString());
        }
        this.repaint();
    }

    public void addOrderListener(OrderListener orderListener) {
        this.a.add(orderListener);
    }

    public void removeOrderListener(OrderListener orderListener) {
        this.a.remove(orderListener);
    }

    public void firePayOrderSelected() {
        for (OrderListener orderListener : this.a) {
            orderListener.payOrderSelected(this.getTicket());
        }
    }

    public void setControlsVisible(boolean bl) {
        if (bl) {
            this.g.setEnabled(true);
            this.c.setEnabled(true);
            this.f.setEnabled(true);
        } else {
            this.g.setEnabled(false);
            this.c.setEnabled(false);
            this.f.setEnabled(false);
        }
    }

    public TicketViewerTable getTicketViewerTable() {
        return this.o;
    }

    private String a(ITicketItem iTicketItem, String string) {
        String string2;
        String string3;
        double d;
        String string4 = iTicketItem.getNameDisplay();
        string4 = string4.length() > 10 ? iTicketItem.getNameDisplay().substring(0, 10) : iTicketItem.getNameDisplay();
        String string5 = String.format("%-10s %9s", string4, NumberUtil.formatNumber(d = iTicketItem.getSubTotalAmountDisplay() == null ? 0.0 : iTicketItem.getSubTotalAmountDisplay(), true));
        if (string5.length() > 20) {
            string5 = string5.substring(0, 20);
        }
        if ((string3 = String.format("%-8s %11s", string2 = Messages.getString("TicketView.29") + CurrencyUtil.getCurrencySymbol(), string)).length() > 20) {
            string3 = string3.substring(0, 20);
        }
        return string5 + string3;
    }

    public boolean isCancelable() {
        return this.v;
    }

    public void setCancelable(boolean bl) {
        this.v = bl;
    }

    public boolean isAllowToLogOut() {
        return this.w;
    }

    public void setAllowToLogOut(boolean bl) {
        this.w = bl;
    }

    public boolean isStockAvailable(MenuItem menuItem, TicketItem ticketItem, double d) {
        if (!menuItem.isDisableWhenStockAmountIsZero().booleanValue()) {
            return true;
        }
        List<TicketItem> list = this.o.getTicketItems();
        if (menuItem.isFractionalUnit().booleanValue()) {
            if (list == null || list.isEmpty()) {
                return !(menuItem.getAvailableUnit() < ticketItem.getQuantity());
            }
            double d2 = 0.0;
            for (TicketItem ticketItem2 : list) {
                if (!menuItem.getName().equals(ticketItem2.getName())) continue;
                d2 += ticketItem2.getQuantity().doubleValue();
                if (!(menuItem.getAvailableUnit() < d2)) continue;
                return false;
            }
            if (d != -1.0) {
                d2 -= ticketItem.getQuantity().doubleValue();
                d2 += d;
            } else {
                d2 += ticketItem.getQuantity().doubleValue();
            }
            return !(menuItem.getAvailableUnit() < d2);
        }
        if (list == null || list.isEmpty()) {
            return !(menuItem.getAvailableUnit() < ticketItem.getQuantity());
        }
        int n = 0;
        for (TicketItem ticketItem3 : list) {
            if (!ticketItem3.getName().equals(menuItem.getName())) continue;
            n = (int)((double)n + ticketItem3.getQuantity());
            if (!(menuItem.getAvailableUnit() <= (double)n)) continue;
            return false;
        }
        return true;
    }

    protected void doAddCookingInstruction() {
        try {
            ITicketItem iTicketItem = this.o.getSelected();
            if (!(iTicketItem instanceof TicketItem)) {
                POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("TicketView.20"));
                return;
            }
            TicketItem ticketItem = (TicketItem)iTicketItem;
            if (ticketItem.isPrintedToKitchen().booleanValue()) {
                POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("TicketView.21"));
                return;
            }
            CookingInstructionSelectionView cookingInstructionSelectionView = new CookingInstructionSelectionView();
            cookingInstructionSelectionView.setSize(800, 600);
            cookingInstructionSelectionView.setLocationRelativeTo(Application.getPosWindow());
            cookingInstructionSelectionView.setVisible(true);
            if (cookingInstructionSelectionView.isCanceled()) {
                return;
            }
            List<TicketItemCookingInstruction> list = cookingInstructionSelectionView.getTicketItemCookingInstructions();
            ticketItem.addCookingInstructions(list);
            this.o.updateView();
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
            POSMessageDialog.showError(exception.getMessage());
        }
    }

    public void showSettleButton(boolean bl) {
        this.n.setVisible(bl);
        this.h.setVisible(bl);
        this.s.setVisible(bl);
    }

    private void a(Object object) {
        if (TerminalConfig.isActiveCustomerDisplay()) {
            TicketItem ticketItem = null;
            if (object instanceof TicketItemModifier) {
                ticketItem = ((TicketItemModifier)object).getTicketItem();
            } else if (object instanceof TicketItem) {
                ticketItem = (TicketItem)object;
            }
            if (ticketItem != null) {
                String string = this.a(ticketItem, NumberUtil.formatNumber(this.b.getTotalAmountWithTips(), true));
                DrawerUtil.setItemDisplay(TerminalConfig.getCustomerDisplayPort(), string);
            }
        }
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        if (bl) {
            if (this.r.getParent() == null) {
                this.q.add(this.r);
            }
            this.r.requestFocus();
        } else {
            this.q.remove(this.r);
        }
    }

    private class TicketItemSelectionListener
    implements ListSelectionListener {
        private TicketItemSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            ITicketItem iTicketItem = TicketView.this.o.getSelected();
            if (!(iTicketItem instanceof ITicketItem)) {
                return;
            }
            TicketView.this.h.setEnabled(true);
            TicketView.this.c.setEnabled(true);
            TicketView.this.g.setEnabled(true);
            TicketView.this.f.setEnabled(true);
            TicketView.this.s.setEnabled(true);
            TicketView.this.i.setEnabled(true);
            ITicketItem iTicketItem2 = iTicketItem;
            TicketView.this.s.setEnabled(iTicketItem2.canAddCookingInstruction());
            if (iTicketItem2.isPrintedToKitchen().booleanValue()) {
                TicketView.this.g.setEnabled(false);
                TicketView.this.c.setEnabled(false);
                TicketView.this.s.setEnabled(false);
                TicketView.this.i.setEnabled(false);
            } else if (iTicketItem instanceof TicketItemModifier) {
                TicketView.this.h.setEnabled(true);
                TicketView.this.f.setEnabled(false);
            } else {
                TicketView.this.f.setEnabled(true);
                TicketView.this.h.setEnabled(false);
                if (iTicketItem instanceof TicketItem) {
                    TicketItem ticketItem = (TicketItem)iTicketItem;
                    TicketView.this.i.setEnabled(ticketItem.getInventoryAdjustQty() == 0.0 && ticketItem.isVoided() == false);
                    TicketView.this.f.setEnabled(ticketItem.getId() == null || ticketItem.isVoided() == false);
                    if (ticketItem.isPrintedToKitchen().booleanValue()) {
                        // empty if block
                    }
                    if (ticketItem.isTreatAsSeat().booleanValue() || ticketItem.isComboItem().booleanValue()) {
                        TicketView.this.h.setEnabled(ticketItem.isPrintedToKitchen() == false);
                    } else if (ticketItem instanceof ModifiableTicketItem) {
                        TicketView.this.h.setEnabled(true);
                    } else if (ticketItem.isFractionalUnit().booleanValue()) {
                        TicketView.this.f.setEnabled(true);
                    }
                }
            }
            if (TicketView.this.b.isSourceOnline()) {
                TicketView.this.h.setEnabled(false);
                TicketView.this.c.setEnabled(false);
                TicketView.this.g.setEnabled(false);
                TicketView.this.f.setEnabled(false);
                TicketView.this.s.setEnabled(false);
                TicketView.this.i.setEnabled(false);
            }
            TicketView.this.a(iTicketItem);
        }
    }
}

