/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.order.multipart;

import com.floreantpos.IconFactory;
import com.floreantpos.POSConstants;
import com.floreantpos.main.Application;
import com.floreantpos.model.ITicketItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuItemSize;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.Multiplier;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PizzaCrust;
import com.floreantpos.model.PizzaPrice;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.modifier.ModifierSelectionListener;
import com.floreantpos.ui.views.order.multipart.PizzaModifierView;
import com.floreantpos.ui.views.order.multipart.PizzaTicketItemTableModel;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.Ellipse2D;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.JViewport;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXCollapsiblePane;

public class PizzaModifierSelectionDialog
extends POSDialog
implements ModifierSelectionListener,
ActionListener,
ChangeListener {
    private static final String b = "pizzaPrice";
    private SizeAndCrustSelectionPane c;
    private PizzaModifierView d;
    private List<Section> e;
    private boolean f = false;
    private Section g;
    private Section h;
    private Section i;
    private Section j;
    private Section k;
    private Section l;
    private Section m;
    private TicketItemModifier n;
    private CardLayout o = new CardLayout();
    JPanel a = new Pizza(this.o);
    private JPanel p = new TransparentPanel(new GridLayout(1, 1, 2, 2));
    private JPanel q = new TransparentPanel(new GridLayout(1, 2, 2, 2));
    private JPanel r = new TransparentPanel(new GridLayout(2, 2, 2, 2));
    private JTable s;
    private MenuItemSize t;
    private MenuItemSize u;
    private TicketItem v;
    private JPanel w;
    private final MenuItem x;
    private PizzaTicketItemTableModel y;
    private boolean z;
    private PosButton A;
    private double B;
    private POSToggleButton C;
    private POSToggleButton D;
    private JToggleButton E;
    private ButtonGroup F;
    private JToggleButton G;
    private Ticket H;
    private JPanel I;
    private POSToggleButton J;
    private POSToggleButton K;
    private POSToggleButton L;
    private POSToggleButton M;
    private POSToggleButton N;
    private POSToggleButton O;
    private POSToggleButton P;
    private ButtonGroup Q;

    public PizzaModifierSelectionDialog(Ticket ticket, TicketItem ticketItem, MenuItem menuItem, boolean bl) {
        this.H = ticket;
        this.x = menuItem;
        this.v = ticketItem;
        this.z = bl;
        this.g();
        this.a();
        this.c();
    }

    private void a() {
        this.setTitle("MODIFY PIZZA");
        this.setLayout(new BorderLayout(10, 10));
        JPanel jPanel = (JPanel)this.getContentPane();
        jPanel.setBorder(BorderFactory.createEmptyBorder(7, 7, 7, 7));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.add((Component)this.d(), "Center");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.setPreferredSize(PosUIManager.getSize(0, 200));
        this.s = new JTable();
        this.y = new PizzaTicketItemTableModel();
        this.s.setModel(this.y);
        this.s.setRowHeight(30);
        this.s.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.s.setAutoResizeMode(3);
        TableColumnModel tableColumnModel = this.s.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(200);
        tableColumnModel.getColumn(1).setPreferredWidth(50);
        JScrollPane jScrollPane = new JScrollPane(this.s);
        jPanel4.add(jScrollPane);
        int n = PosUIManager.getSize(40);
        JXCollapsiblePane jXCollapsiblePane = new JXCollapsiblePane();
        jXCollapsiblePane.setBackground(Color.WHITE);
        jXCollapsiblePane.setLayout((LayoutManager)new MigLayout("fillx,ins 2 0 2 0", "[" + n + "px][grow][" + n + "px]", "[" + n + "]"));
        jXCollapsiblePane.setAnimated(true);
        jXCollapsiblePane.setCollapsed(false);
        jXCollapsiblePane.setVisible(true);
        PosButton posButton = new PosButton();
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PizzaModifierSelectionDialog.a(PizzaModifierSelectionDialog.this);
                PizzaModifierSelectionDialog.this.A.setText(NumberUtil.trimDecilamIfNotNeeded(PizzaModifierSelectionDialog.this.B));
            }
        });
        this.A = new PosButton(NumberUtil.trimDecilamIfNotNeeded(this.B));
        this.A.setForeground(Color.BLUE);
        this.A.setBackground(Color.WHITE);
        Border border = BorderFactory.createLineBorder(new Color(0.0f, 0.0f, 0.0f, 0.1f), 1);
        this.A.setBorder(border);
        this.A.setFont(new Font(this.A.getFont().getName(), 1, 20));
        this.A.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NumberSelectionDialog2 numberSelectionDialog2 = new NumberSelectionDialog2();
                numberSelectionDialog2.setTitle("Enter quantity");
                numberSelectionDialog2.setFloatingPoint(false);
                numberSelectionDialog2.pack();
                numberSelectionDialog2.open();
                if (numberSelectionDialog2.isCanceled()) {
                    return;
                }
                PizzaModifierSelectionDialog.this.B = (int)numberSelectionDialog2.getValue();
                PizzaModifierSelectionDialog.this.A.setText(NumberUtil.trimDecilamIfNotNeeded(PizzaModifierSelectionDialog.this.B));
            }
        });
        PosButton posButton2 = new PosButton();
        posButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PizzaModifierSelectionDialog.this.B == 1.0) {
                    return;
                }
                PizzaModifierSelectionDialog.d(PizzaModifierSelectionDialog.this);
                PizzaModifierSelectionDialog.this.A.setText(NumberUtil.trimDecilamIfNotNeeded(PizzaModifierSelectionDialog.this.B));
            }
        });
        posButton.setIcon(IconFactory.getIcon("/ui_icons/", "plus_32.png"));
        posButton2.setIcon(IconFactory.getIcon("/ui_icons/", "minus_32.png"));
        jXCollapsiblePane.add((Component)posButton2);
        jXCollapsiblePane.add((Component)this.A, (Object)"grow");
        jXCollapsiblePane.add((Component)posButton);
        jPanel4.add((Component)jXCollapsiblePane, "South");
        jPanel2.add((Component)jPanel4, "North");
        this.c = new SizeAndCrustSelectionPane();
        jPanel3.add((Component)this.c, "North");
        this.d = new PizzaModifierView(this.H, this.v, this.x, this);
        this.d.addModifierSelectionListener(this);
        jPanel3.add((Component)this.d, "Center");
        this.add((Component)jPanel3, "Center");
        this.add((Component)jPanel2, "West");
        this.createButtonPanel();
        this.l();
    }

    private JPanel b() {
        this.I = new JPanel((LayoutManager)new MigLayout("fill, hidemode 3, ins 7 0"));
        this.I.setBorder(null);
        this.Q = new ButtonGroup();
        this.J = new POSToggleButton("WHOLE");
        this.K = new POSToggleButton("H1");
        this.L = new POSToggleButton("H2");
        this.M = new POSToggleButton("Q1");
        this.N = new POSToggleButton("Q2");
        this.O = new POSToggleButton("Q3");
        this.P = new POSToggleButton("Q4");
        this.J.addChangeListener(this);
        this.K.addChangeListener(this);
        this.L.addChangeListener(this);
        this.M.addChangeListener(this);
        this.N.addChangeListener(this);
        this.O.addChangeListener(this);
        this.P.addChangeListener(this);
        this.Q.add(this.J);
        this.Q.add(this.K);
        this.Q.add(this.L);
        this.Q.add(this.M);
        this.Q.add(this.N);
        this.Q.add(this.O);
        this.Q.add(this.P);
        this.I.add((Component)this.J, "grow");
        this.I.add((Component)this.K, "grow");
        this.I.add((Component)this.L, "grow");
        this.I.add((Component)this.M, "grow");
        this.I.add((Component)this.N, "grow");
        this.I.add((Component)this.O, "grow");
        this.I.add((Component)this.P, "grow");
        return this.I;
    }

    private void c() {
        if (this.v.getSizeModifier() == null) {
            if (this.n != null) {
                this.v.setSizeModifier(this.n);
                this.v.getSizeModifier().calculatePrice();
            }
        } else {
            this.v.getSizeModifier().calculatePrice();
        }
        this.y.setTicketItem(this.v);
        this.y.updateView();
        List<TicketItemModifier> list = this.v.getTicketItemModifiers();
        if (list == null) {
            return;
        }
        for (Section section : this.e) {
            for (TicketItemModifier ticketItemModifier : list) {
                if (ticketItemModifier.isInfoOnly().booleanValue() || !section.getSectionName().equals(ticketItemModifier.getSectionName())) continue;
                section.j.addItem(ticketItemModifier);
            }
        }
        if (this.v.getPizzaSectionMode() != null) {
            if (this.v.getPizzaSectionMode() == TicketItem.PIZZA_SECTION_MODE.FULL) {
                this.C.setSelected(true);
                this.G = this.C;
                this.j();
                if (this.v.isPrintedToKitchen().booleanValue()) {
                    this.D.setEnabled(false);
                    this.E.setEnabled(false);
                }
            } else if (this.v.getPizzaSectionMode() == TicketItem.PIZZA_SECTION_MODE.HALF) {
                this.D.setSelected(true);
                this.G = this.D;
                this.l();
                if (this.v.isPrintedToKitchen().booleanValue()) {
                    this.C.setEnabled(false);
                    this.E.setEnabled(false);
                }
            } else if (this.v.getPizzaSectionMode() == TicketItem.PIZZA_SECTION_MODE.QUARTER) {
                this.E.setSelected(true);
                this.G = this.E;
                this.n();
                if (this.v.isPrintedToKitchen().booleanValue()) {
                    this.D.setEnabled(false);
                    this.C.setEnabled(false);
                }
            }
        }
    }

    private JPanel d() {
        JPanel jPanel = new JPanel(new BorderLayout(5, 5));
        this.e = new ArrayList<Section>();
        this.m = new Section("WHOLE", "WHOLE", 0, true, 1.0);
        this.g = new Section("Quarter 1", "Quarter 1", 1, false, 0.25);
        this.h = new Section("Quarter 2", "Quarter 2", 2, false, 0.25);
        this.i = new Section("Quarter 3", "Quarter 3", 3, false, 0.25);
        this.j = new Section("Quarter 4", "Quarter 4", 4, false, 0.25);
        this.k = new Section("Half 1", "Half 1", 5, false, 0.5);
        this.l = new Section("Half 2", "Half 2", 6, false, 0.5);
        this.e.add(this.m);
        this.e.add(this.g);
        this.e.add(this.h);
        this.e.add(this.i);
        this.e.add(this.j);
        this.e.add(this.k);
        this.e.add(this.l);
        this.p.add(this.m);
        this.q.add(this.k);
        this.q.add(this.l);
        this.r.add(this.g);
        this.r.add(this.h);
        this.r.add(this.i);
        this.r.add(this.j);
        this.a.add((Component)this.p, "full");
        this.a.add((Component)this.q, "half");
        this.a.add((Component)this.r, "quarter");
        this.w = new JPanel((LayoutManager)new MigLayout("fill,ins 0 0 0 0"));
        this.w.setOpaque(false);
        jPanel.setOpaque(false);
        jPanel.add((Component)this.b(), "North");
        jPanel.add((Component)this.a, "Center");
        jPanel.add((Component)this.w, "South");
        jPanel.setPreferredSize(PosUIManager.getSize(300, 0));
        return jPanel;
    }

    public void createButtonPanel() {
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.setLayout((LayoutManager)new MigLayout("fill, ins 2", "", ""));
        this.F = new ButtonGroup();
        this.C = new POSToggleButton("FULL");
        this.G = this.C;
        this.C.addActionListener(this);
        this.D = new POSToggleButton("HALF");
        this.D.setSelected(true);
        this.D.addActionListener(this);
        this.E = new POSToggleButton("QUARTER");
        this.E.addActionListener(this);
        this.F.add(this.C);
        this.F.add(this.D);
        this.F.add(this.E);
        PosButton posButton = new PosButton("CLEAR");
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Section section = PizzaModifierSelectionDialog.this.getSelectedSection();
                if (section == null) {
                    return;
                }
                section.clearSelectedItem();
            }
        });
        PosButton posButton2 = new PosButton("CLEAR ALL");
        posButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Section section = PizzaModifierSelectionDialog.this.getSelectedSection();
                if (section == null) {
                    return;
                }
                section.clearItems();
            }
        });
        PosButton posButton3 = new PosButton("DONE");
        posButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (PizzaModifierSelectionDialog.this.e()) {
                    PizzaModifierSelectionDialog.this.setCanceled(false);
                    PizzaModifierSelectionDialog.this.dispose();
                }
            }
        });
        PosButton posButton4 = new PosButton(POSConstants.CANCEL.toUpperCase());
        posButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PizzaModifierSelectionDialog.this.setCanceled(true);
                PizzaModifierSelectionDialog.this.dispose();
            }
        });
        int n = PosUIManager.getSize(97);
        JSeparator jSeparator = new JSeparator(1);
        transparentPanel.add((Component)this.C, "w " + n + "!, split 5");
        transparentPanel.add((Component)this.D, "w " + n + "!");
        transparentPanel.add((Component)this.E, "w " + n + "!");
        transparentPanel.add((Component)jSeparator, "growy");
        transparentPanel.add((Component)posButton, "grow");
        transparentPanel.add((Component)posButton2, "grow");
        transparentPanel.add((Component)posButton4, "grow");
        transparentPanel.add((Component)posButton3, "grow");
        this.add((Component)transparentPanel, "South");
    }

    private boolean e() {
        if (!this.f) {
            POSMessageDialog.showError("Please select size and crust.");
            return false;
        }
        List<MenuItemModifierSpec> list = this.v.getMenuItem().getMenuItemModiferSpecs();
        for (MenuItemModifierSpec comparable : list) {
            if (this.v.requiredModifiersAdded(comparable)) continue;
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), String.format("Required modifiers for group %s not added!", comparable.getModifierGroup().getDisplayName()));
            return false;
        }
        this.f();
        if (!this.z) {
            OrderView.getInstance().getTicketView().addTicketItem(this.v);
            int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Do you want to create more pizza?", "More Pizza");
            if (n == 0) {
                TicketItem ticketItem = this.v.clone();
                ticketItem.setId(null);
                this.v = ticketItem;
                this.h();
                return false;
            }
        }
        return true;
    }

    private void f() {
        this.v.setQuantity(this.B);
        this.v.calculatePrice();
    }

    private void g() {
        this.B = this.v.getQuantity();
        this.v.setQuantity(1.0);
        List<TicketItemModifier> list = this.v.getTicketItemModifiers();
        if (list != null) {
            for (TicketItemModifier ticketItemModifier : list) {
                if (ticketItemModifier.isInfoOnly().booleanValue()) continue;
                ticketItemModifier.setItemQuantity(ticketItemModifier.getItemQuantity() / this.B);
            }
        }
        this.v.calculatePrice();
    }

    private void h() {
        for (Section section : this.e) {
            if (section.j.getRows() == null) continue;
            Iterator iterator = section.j.getRows().iterator();
            while (iterator.hasNext()) {
                TicketItemModifier ticketItemModifier = (TicketItemModifier)iterator.next();
                if (ticketItemModifier == null) continue;
                iterator.remove();
            }
            section.j.fireTableDataChanged();
            section.repaint();
        }
        this.d.getModifierGroupView().selectFirst();
        this.v.setSizeModifier(this.i());
        this.v.getSizeModifier().calculatePrice();
        if (this.v.getTicketItemModifiers() != null) {
            this.v.getTicketItemModifiers().clear();
        }
        this.y.setTicketItem(this.v);
        this.y.updateView();
    }

    private boolean a(MenuItemModifierSpec menuItemModifierSpec, int n) {
        int n2 = menuItemModifierSpec.getMinQuantity();
        int n3 = menuItemModifierSpec.getMaxQuantity();
        if (n3 < n2) {
            n3 = n2;
        }
        return n >= n3;
    }

    @Override
    public void modifierSelected(MenuModifier menuModifier, Multiplier multiplier) {
        int n;
        int n2;
        MenuItemModifierSpec menuItemModifierSpec = menuModifier.getMenuItemModifierGroup();
        if (this.a(menuItemModifierSpec, n2 = this.v.countModifierFromGroup(menuItemModifierSpec))) {
            POSMessageDialog.showError("You have added maximum number of allowed modifiers from group " + menuModifier.getMenuItemModifierGroup().getDisplayName());
            this.modifierGroupSelectionDone(menuItemModifierSpec);
            this.d.revalidate();
            this.d.repaint();
            return;
        }
        Section section = this.getSelectedSection();
        boolean bl = false;
        this.u = this.c.getMenuItemSize();
        if (this.u != null) {
            if (this.t != null) {
                if (this.t == this.u) {
                    bl = true;
                }
            } else {
                this.t = this.u;
                bl = true;
            }
        }
        TicketItemModifier ticketItemModifier = this.v.findTicketItemModifierFor(menuModifier, this.getMainSection().getSectionName(), null);
        TicketItemModifier ticketItemModifier2 = this.v.findTicketItemModifierFor(menuModifier, section.getSectionName(), null);
        if (!section.c) {
            n = 0;
            for (Section section2 : this.e) {
                int n3;
                TicketItemModifier ticketItemModifier3;
                if (section2.getSectionName().startsWith("Half")) {
                    if (section2 == section || (ticketItemModifier3 = this.v.findTicketItemModifierFor(menuModifier, section2.getSectionName(), null)) == null || ticketItemModifier2 != null) continue;
                    if (ticketItemModifier != null) {
                        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Item already added in WHOLE section!");
                        return;
                    }
                    n3 = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Would you like to add this item in WHOLE section?", "Add Modifier");
                    if (n3 != 0) break;
                    section2.clearItem(ticketItemModifier3, section2.j);
                    section = this.getMainSection();
                    continue;
                }
                if (!section2.getSectionName().startsWith("Quarter") || section2 == section || (ticketItemModifier3 = this.v.findTicketItemModifierFor(menuModifier, section2.getSectionName(), null)) == null || ticketItemModifier2 != null) continue;
                if (n == 2) {
                    if (ticketItemModifier != null) {
                        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Item already added in WHOLE section!");
                        return;
                    }
                    n3 = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Would you like to add this item in WHOLE section?", "Add Modifier");
                    if (n3 == 0) {
                        for (Section section3 : this.e) {
                            if (section3.getSectionName().startsWith("Quarter")) {
                                section3.clearItem(ticketItemModifier3, section3.j);
                            }
                            section3.repaint();
                        }
                        section = this.getMainSection();
                    }
                }
                ++n;
            }
        }
        if (ticketItemModifier != null && !section.c && ticketItemModifier2 == null && (n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Item already added in pizza, Would you like to add again?", "Add Modifier")) == 1) {
            return;
        }
        if (ticketItemModifier2 == null || ticketItemModifier2.isPrintedToKitchen().booleanValue() || !bl) {
            OrderType orderType = this.v.getTicket().getOrderType();
            ticketItemModifier2 = this.a(this.v, menuModifier, orderType, multiplier);
            ticketItemModifier2.setSectionName(section.getSectionName());
            ticketItemModifier2.setMenuModifier(menuModifier);
            if (ticketItemModifier2.isShouldSectionWisePrice().booleanValue()) {
                ticketItemModifier2.setUnitPrice(section.calculatePrice(ticketItemModifier2.getUnitPrice()));
            }
            section.addItem(ticketItemModifier2);
            TicketItemModifier ticketItemModifier4 = this.a(section.getSectionName());
            if (ticketItemModifier4 != null) {
                this.v.addToticketItemModifiers(ticketItemModifier4);
            }
            this.v.addToticketItemModifiers(ticketItemModifier2);
            if (!ticketItemModifier2.isInfoOnly().booleanValue()) {
                double d = this.x.getDefaultSellPortion().intValue();
                this.v.updateModifiersUnitPrice(d);
            }
        } else {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Item already added!");
            this.d.revalidate();
            this.d.repaint();
            return;
        }
        if (n2 + 1 >= menuItemModifierSpec.getMinQuantity()) {
            this.modifierGroupSelectionDone(menuItemModifierSpec);
        }
        this.y.updateView();
        this.d.revalidate();
        this.d.repaint();
        this.revalidate();
        this.repaint();
    }

    private TicketItemModifier a(String string) {
        TicketItemModifier ticketItemModifier;
        List<TicketItemModifier> list = this.v.getTicketItemModifiers();
        if (this.y.getRowCount() == 1 && string.equals("WHOLE")) {
            return null;
        }
        if (list != null && !list.isEmpty() && string.equals((ticketItemModifier = list.get(list.size() - 1)).getSectionName())) {
            return null;
        }
        ticketItemModifier = new TicketItemModifier();
        ticketItemModifier.setName("== " + string + " ==");
        ticketItemModifier.setModifierType(6);
        ticketItemModifier.setInfoOnly(true);
        ticketItemModifier.setSectionName(string);
        ticketItemModifier.setTicketItem(this.v);
        return ticketItemModifier;
    }

    @Override
    public void clearModifiers(MenuItemModifierSpec menuItemModifierSpec) {
    }

    @Override
    public void modifierGroupSelectionDone(MenuItemModifierSpec menuItemModifierSpec) {
        if (!PizzaModifierSelectionDialog.isRequiredModifiersAdded(this.v, menuItemModifierSpec)) {
            this.a(menuItemModifierSpec);
            this.d.getModifierGroupView().setSelectedModifierGroup(menuItemModifierSpec);
            return;
        }
        if (menuItemModifierSpec.isJumpGroup().booleanValue() && this.d.getModifierGroupView().hasNextMandatoryGroup()) {
            this.d.getModifierGroupView().selectNextGroup();
        }
    }

    public static boolean isRequiredModifiersAdded(TicketItem ticketItem, MenuItemModifierSpec menuItemModifierSpec) {
        return true;
    }

    private TicketItemModifier a(TicketItem ticketItem, MenuModifier menuModifier, OrderType orderType, Multiplier multiplier) {
        TicketItemModifier ticketItemModifier = new TicketItemModifier();
        ticketItemModifier.setTaxIncluded(Application.getInstance().isPriceIncludesTax());
        ticketItemModifier.setItemId(menuModifier.getId());
        MenuItemModifierSpec menuItemModifierSpec = menuModifier.getMenuItemModifierGroup();
        if (menuItemModifierSpec != null) {
            ticketItemModifier.setGroupId(menuItemModifierSpec.getId());
        }
        ticketItemModifier.setItemQuantity(1.0);
        ticketItemModifier.setName(menuModifier.getDisplayName().trim());
        ticketItemModifier.setTicketItem(ticketItem);
        double d = menuModifier.getPriceForSizeAndMultiplier(this.getSelectedSize(), false, multiplier);
        if (multiplier != null) {
            ticketItemModifier.setMultiplierName(multiplier.getId());
            ticketItemModifier.setName(multiplier.getTicketPrefix() + " " + menuModifier.getDisplayName());
        }
        ticketItemModifier.setUnitPrice(d);
        ticketItemModifier.setTaxes(menuModifier.getTaxByOrderType(orderType));
        ticketItemModifier.setModifierType(1);
        ticketItemModifier.setShouldPrintToKitchen(menuModifier.isShouldPrintToKitchen());
        ticketItemModifier.setShouldSectionWisePrice(menuModifier.isShouldSectionWisePrice());
        return ticketItemModifier;
    }

    public MenuItemSize getSelectedSize() {
        List<POSToggleButton> list = this.c.b;
        for (POSToggleButton pOSToggleButton : list) {
            if (!pOSToggleButton.isSelected()) continue;
            PizzaPrice pizzaPrice = (PizzaPrice)pOSToggleButton.getClientProperty(b);
            return pizzaPrice.getSize();
        }
        return null;
    }

    public void setSelectedSection(Section section) {
        if (section.isSelected()) {
            return;
        }
        for (Section section2 : this.e) {
            section2.d.setBackground(Color.lightGray);
            section2.setSelected(false);
            section2.setBorder(null);
        }
        section.d.setBackground(Color.green);
        section.setSelected(true);
        this.w.revalidate();
        this.w.repaint();
    }

    public Section getSelectedSection() {
        for (Section section : this.e) {
            if (!section.isSelected()) continue;
            return section;
        }
        return this.getMainSection();
    }

    public Section getMainSection() {
        for (Section section : this.e) {
            if (!section.c) continue;
            return section;
        }
        return null;
    }

    private TicketItemModifier i() {
        if (this.v != null && this.v.getSizeModifier() != null) {
            this.n = this.v.getSizeModifier();
            return this.n;
        }
        return this.n;
    }

    @Override
    public void modifierRemoved(TicketItemModifier ticketItemModifier) {
    }

    private void a(MenuItemModifierSpec menuItemModifierSpec) {
        String string = menuItemModifierSpec.getModifierGroup().getDisplayName();
        int n = menuItemModifierSpec.getMinQuantity();
        POSMessageDialog.showError("You must select at least " + n + " modifiers from group " + string);
    }

    private void a(POSToggleButton pOSToggleButton) {
        PizzaPrice pizzaPrice = (PizzaPrice)pOSToggleButton.getClientProperty(b);
        this.v.setUnitPrice(pizzaPrice.getPrice(this.x.getDefaultSellPortion()));
        TicketItemModifier ticketItemModifier = this.i();
        if (ticketItemModifier != null) {
            ticketItemModifier.setName(pizzaPrice.getSize().getName() + " " + pizzaPrice.getCrust());
            this.n = ticketItemModifier;
        } else {
            this.n = new TicketItemModifier();
            this.n.setName(pizzaPrice.getSize().getName() + " " + pizzaPrice.getCrust());
            this.n.setModifierType(5);
            this.n.setInfoOnly(true);
            this.n.setTicketItem(this.v);
        }
        this.f = true;
    }

    private void j() {
        this.w.removeAll();
        this.p.removeAll();
        this.p.add(this.m);
        this.o.show(this.a, "full");
        this.v.setPizzaSectionMode(TicketItem.PIZZA_SECTION_MODE.FULL);
        this.I.setVisible(false);
        this.m();
    }

    private void k() {
        for (Section section : this.e) {
            if (section.j.getRows() == null) continue;
            section.clearItems();
        }
    }

    private void l() {
        this.w.add((Component)this.m, "grow");
        this.o.show(this.a, "half");
        this.v.setPizzaSectionMode(TicketItem.PIZZA_SECTION_MODE.HALF);
        this.I.setVisible(true);
        this.K.setVisible(true);
        this.L.setVisible(true);
        this.M.setVisible(false);
        this.N.setVisible(false);
        this.O.setVisible(false);
        this.P.setVisible(false);
        this.m();
        this.J.setSelected(true);
    }

    private void m() {
        this.Q.clearSelection();
        for (Section section : this.e) {
            section.d.setBackground(Color.lightGray);
            section.setSelected(false);
            section.setBorder(null);
        }
        this.w.setBorder(null);
    }

    private void n() {
        this.w.add((Component)this.m, "grow");
        this.o.show(this.a, "quarter");
        this.v.setPizzaSectionMode(TicketItem.PIZZA_SECTION_MODE.QUARTER);
        this.I.setVisible(true);
        this.K.setVisible(false);
        this.L.setVisible(false);
        this.M.setVisible(true);
        this.N.setVisible(true);
        this.O.setVisible(true);
        this.P.setVisible(true);
        this.m();
        this.J.setSelected(true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand() == "FULL") {
            if (this.v.getTicketItemModifiers() != null && this.v.getTicketItemModifiers().size() > 0) {
                int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Items of the section will be deleted, Are you sure to change section mode?", "Change Section Mode");
                if (n != 0) {
                    this.G.setSelected(true);
                    return;
                }
                this.k();
            }
            this.j();
        } else if (actionEvent.getActionCommand() == "HALF") {
            if (this.v.getTicketItemModifiers() != null && this.v.getTicketItemModifiers().size() > 0) {
                int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Items of the section will be deleted, Are you sure to change section mode?", "Change Section Mode");
                if (n != 0) {
                    this.G.setSelected(true);
                    return;
                }
                this.k();
            }
            this.l();
        } else if (actionEvent.getActionCommand() == "QUARTER") {
            if (this.v.getTicketItemModifiers() != null && this.v.getTicketItemModifiers().size() > 0) {
                int n = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Items of the section will be deleted, Are you sure to change section mode?", "Change Section Mode");
                if (n != 0) {
                    this.G.setSelected(true);
                    return;
                }
                this.k();
            }
            this.n();
        }
        this.G = (JToggleButton)actionEvent.getSource();
    }

    private void a(Section section) {
        if (section.getSectionName().equals("WHOLE")) {
            this.J.setSelected(true);
        } else if (section.getSectionName().equals("Quarter 1")) {
            this.M.setSelected(true);
        } else if (section.getSectionName().equals("Quarter 2")) {
            this.N.setSelected(true);
        } else if (section.getSectionName().equals("Quarter 3")) {
            this.O.setSelected(true);
        } else if (section.getSectionName().equals("Quarter 4")) {
            this.P.setSelected(true);
        } else if (section.getSectionName().equals("Half 1")) {
            this.K.setSelected(true);
        } else if (section.getSectionName().equals("Half 2")) {
            this.L.setSelected(true);
        }
    }

    @Override
    public void finishModifierSelection() {
    }

    @Override
    public void stateChanged(ChangeEvent changeEvent) {
        JToggleButton jToggleButton = (JToggleButton)changeEvent.getSource();
        if (jToggleButton.getText().equals("WHOLE")) {
            for (Section section : this.e) {
                section.d.setBackground(Color.lightGray);
                section.setSelected(false);
            }
        } else if (jToggleButton.getText().equals("H1")) {
            this.setSelectedSection(this.k);
        } else if (jToggleButton.getText().equals("H2")) {
            this.setSelectedSection(this.l);
        } else if (jToggleButton.getText().equals("Q1")) {
            this.setSelectedSection(this.g);
        } else if (jToggleButton.getText().equals("Q2")) {
            this.w.setBorder(null);
            this.setSelectedSection(this.h);
        } else if (jToggleButton.getText().equals("Q3")) {
            this.setSelectedSection(this.i);
        } else if (jToggleButton.getText().equals("Q4")) {
            this.setSelectedSection(this.j);
        }
    }

    public void updateTicketItemModifierPrices() {
        List<TicketItemModifier> list = this.v.getTicketItemModifiers();
        if (list != null) {
            for (TicketItemModifier ticketItemModifier : list) {
                MenuModifier menuModifier = ticketItemModifier.getMenuModifier();
                if (menuModifier == null) continue;
                double d = menuModifier.getPriceForSizeAndMultiplier(this.getSelectedSize(), false, this.d.getSelectedMultiplier());
                ticketItemModifier.setUnitPrice(d);
            }
        }
        this.o();
        if (this.v.getSizeModifier() != null) {
            this.v.getSizeModifier().calculatePrice();
            this.y.updateView();
        }
    }

    private void o() {
        for (Section section : this.e) {
            section.j.fireTableDataChanged();
        }
    }

    static /* synthetic */ double a(PizzaModifierSelectionDialog pizzaModifierSelectionDialog) {
        double d = pizzaModifierSelectionDialog.B;
        pizzaModifierSelectionDialog.B = d + 1.0;
        return d;
    }

    static /* synthetic */ double d(PizzaModifierSelectionDialog pizzaModifierSelectionDialog) {
        double d = pizzaModifierSelectionDialog.B;
        pizzaModifierSelectionDialog.B = d - 1.0;
        return d;
    }

    class SectionModifierTableModel
    extends ListTableModel<TicketItemModifier> {
        public SectionModifierTableModel() {
            super(new String[]{"Item", "Price"});
        }

        @Override
        public Object getValueAt(int n, int n2) {
            TicketItemModifier ticketItemModifier = (TicketItemModifier)this.rows.get(n);
            if (ticketItemModifier instanceof TicketItemModifier) {
                ticketItemModifier.calculatePrice();
            }
            switch (n2) {
                case 0: {
                    if (ticketItemModifier instanceof TicketItemModifier) {
                        return ticketItemModifier.getName();
                    }
                    return " " + ticketItemModifier.getNameDisplay();
                }
                case 1: {
                    Double d = null;
                    if (ticketItemModifier instanceof TicketItemModifier) {
                        d = ticketItemModifier.getUnitPrice();
                        return NumberUtil.roundToTwoDigit(d);
                    }
                    return null;
                }
            }
            return null;
        }

        public void deleteGivenItem(TicketItemModifier ticketItemModifier) {
            Iterator iterator = this.rows.iterator();
            while (iterator.hasNext()) {
                TicketItemModifier ticketItemModifier2 = (TicketItemModifier)iterator.next();
                if (ticketItemModifier != ticketItemModifier2) continue;
                iterator.remove();
            }
            this.fireTableDataChanged();
        }

        public void deleteGivenItemByName(TicketItemModifier ticketItemModifier) {
            Iterator iterator = this.rows.iterator();
            while (iterator.hasNext()) {
                TicketItemModifier ticketItemModifier2 = (TicketItemModifier)iterator.next();
                if (!ticketItemModifier.getName().equals(ticketItemModifier2.getName())) continue;
                iterator.remove();
            }
            this.fireTableDataChanged();
        }
    }

    public class ModifierTableCellRenderer
    extends PosTableRenderer {
        private boolean b = false;

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            ITicketItem iTicketItem;
            Component component = null;
            SectionModifierTableModel sectionModifierTableModel = (SectionModifierTableModel)jTable.getModel();
            Object e = sectionModifierTableModel.getRowData(n);
            if (n2 == 1) {
                component = super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            } else {
                component = super.getTableCellRendererComponent(jTable, object, bl, false, n, n2);
                if (n2 == 0) {
                    this.setHorizontalAlignment(0);
                } else {
                    this.setHorizontalAlignment(4);
                }
            }
            if (bl) {
                component.setBackground(Color.BLUE);
                component.setForeground(Color.WHITE);
                return component;
            }
            component.setBackground(jTable.getBackground());
            component.setForeground(Color.BLACK);
            if (e instanceof TicketItemModifier && (iTicketItem = (ITicketItem)e).isPrintedToKitchen().booleanValue()) {
                component.setBackground(Color.YELLOW);
                component.setForeground(Color.BLACK);
            }
            return component;
        }
    }

    class SizeAndCrustSelectionPane
    extends JPanel {
        List<PizzaPrice> a;
        List<POSToggleButton> b = new ArrayList<POSToggleButton>();
        List<POSToggleButton> c = new ArrayList<POSToggleButton>();
        JPanel d = new JPanel();
        JPanel e = new JPanel();
        ButtonGroup f = new ButtonGroup();
        ButtonGroup g = new ButtonGroup();
        MenuItemSize h;
        PizzaCrust i;

        public SizeAndCrustSelectionPane() {
            this.a = PizzaModifierSelectionDialog.this.x.getPizzaPriceList();
            this.setLayout(new BorderLayout());
            this.d.setBorder(BorderFactory.createTitledBorder(null, "SIZE", 2, 2));
            this.e.setBorder(BorderFactory.createTitledBorder(null, "CRUST", 2, 2));
            this.e.setLayout(new FlowLayout());
            HashSet<MenuItemSize> hashSet = new HashSet<MenuItemSize>();
            for (PizzaPrice pizzaPrice : this.a) {
                MenuItemSize menuItemSize = pizzaPrice.getSize();
                if (hashSet.contains(menuItemSize)) continue;
                hashSet.add(menuItemSize);
                this.a(pizzaPrice, menuItemSize);
            }
            this.a();
            this.add((Component)this.d, "West");
            this.add(this.e);
        }

        private void a() {
            TicketItemModifier ticketItemModifier = PizzaModifierSelectionDialog.this.i();
            if (ticketItemModifier != null) {
                PizzaPrice pizzaPrice;
                String string = ticketItemModifier.getName();
                String[] stringArray = string.split(" ");
                String string2 = stringArray[0];
                String pizzaPrice2 = stringArray[1];
                for (POSToggleButton pOSToggleButton : this.b) {
                    pizzaPrice = (PizzaPrice)pOSToggleButton.getClientProperty(PizzaModifierSelectionDialog.b);
                    if (pizzaPrice.getSize().getName().equalsIgnoreCase(string2)) {
                        pOSToggleButton.setSelected(true);
                        this.renderCrusts(pizzaPrice.getSize());
                        continue;
                    }
                    if (!PizzaModifierSelectionDialog.this.v.isPrintedToKitchen().booleanValue()) continue;
                    pOSToggleButton.setEnabled(false);
                }
                for (POSToggleButton pOSToggleButton : this.c) {
                    pizzaPrice = (PizzaPrice)pOSToggleButton.getClientProperty(PizzaModifierSelectionDialog.b);
                    if (pizzaPrice.getCrust().getName().startsWith(pizzaPrice2)) {
                        pOSToggleButton.setSelected(true);
                        PizzaModifierSelectionDialog.this.f = true;
                        continue;
                    }
                    if (!PizzaModifierSelectionDialog.this.v.isPrintedToKitchen().booleanValue()) continue;
                    pOSToggleButton.setEnabled(false);
                }
            } else if (!this.b.isEmpty()) {
                ArrayList<Boolean> arrayList = new ArrayList<Boolean>();
                for (POSToggleButton serializable : this.b) {
                    if (!serializable.isSelected()) continue;
                    PizzaPrice pizzaPrice = (PizzaPrice)serializable.getClientProperty(PizzaModifierSelectionDialog.b);
                    this.renderCrusts(pizzaPrice.getSize());
                    arrayList.add(true);
                }
                if (arrayList.isEmpty() || arrayList.contains(false)) {
                    POSToggleButton pOSToggleButton = this.b.get(0);
                    PizzaPrice pizzaPrice = (PizzaPrice)pOSToggleButton.getClientProperty(PizzaModifierSelectionDialog.b);
                    this.renderCrusts(pizzaPrice.getSize());
                    pOSToggleButton.setSelected(true);
                }
            }
        }

        private void a(PizzaPrice pizzaPrice, MenuItemSize menuItemSize) {
            POSToggleButton pOSToggleButton = new POSToggleButton(menuItemSize.getName());
            pOSToggleButton.putClientProperty(PizzaModifierSelectionDialog.b, pizzaPrice);
            if (menuItemSize.isDefaultSize().booleanValue()) {
                pOSToggleButton.setSelected(true);
            }
            pOSToggleButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    POSToggleButton pOSToggleButton = (POSToggleButton)actionEvent.getSource();
                    PizzaPrice pizzaPrice = (PizzaPrice)pOSToggleButton.getClientProperty(PizzaModifierSelectionDialog.b);
                    SizeAndCrustSelectionPane.this.renderCrusts(pizzaPrice.getSize());
                    TicketItemModifier ticketItemModifier = PizzaModifierSelectionDialog.this.i();
                    if (ticketItemModifier != null) {
                        PizzaModifierSelectionDialog.this.v.setSizeModifier(ticketItemModifier);
                        ticketItemModifier.calculatePrice();
                        PizzaModifierSelectionDialog.this.y.updateView();
                    }
                    PizzaModifierSelectionDialog.this.updateTicketItemModifierPrices();
                    PizzaModifierSelectionDialog.this.d.updateView();
                    PizzaModifierSelectionDialog.this.d.revalidate();
                    PizzaModifierSelectionDialog.this.d.repaint();
                    SizeAndCrustSelectionPane.this.revalidate();
                    SizeAndCrustSelectionPane.this.repaint();
                }
            });
            this.f.add(pOSToggleButton);
            this.b.add(pOSToggleButton);
            this.d.add(pOSToggleButton);
        }

        protected void renderCrusts(MenuItemSize menuItemSize) {
            this.setMenuItemSize(menuItemSize);
            for (POSToggleButton serializable2 : this.c) {
                this.g.remove(serializable2);
            }
            this.e.removeAll();
            Set<PizzaPrice> set = PizzaModifierSelectionDialog.this.x.getAvailablePrices(menuItemSize);
            TicketItemModifier ticketItemModifier = PizzaModifierSelectionDialog.this.i();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                final PizzaPrice pizzaPrice = (PizzaPrice)iterator.next();
                POSToggleButton pOSToggleButton = new POSToggleButton();
                pOSToggleButton.setText("<html><center>" + pizzaPrice.getCrust().getName() + "<br/>" + CurrencyUtil.getCurrencySymbol() + pizzaPrice.getPrice(PizzaModifierSelectionDialog.this.x.getDefaultSellPortion()) + "</center></html>");
                pOSToggleButton.putClientProperty(PizzaModifierSelectionDialog.b, pizzaPrice);
                if (set.size() == 1) {
                    PizzaModifierSelectionDialog.this.f = true;
                    pOSToggleButton.setSelected(true);
                    PizzaModifierSelectionDialog.this.a(pOSToggleButton);
                    this.setPizzaCrust(pizzaPrice.getCrust());
                }
                if (pizzaPrice.getCrust().isDefaultCrust().booleanValue() && ticketItemModifier == null) {
                    PizzaModifierSelectionDialog.this.f = true;
                    pOSToggleButton.setSelected(true);
                    PizzaModifierSelectionDialog.this.a(pOSToggleButton);
                    this.setPizzaCrust(pizzaPrice.getCrust());
                }
                if (ticketItemModifier != null) {
                    String string = ticketItemModifier.getName();
                    String[] stringArray = string.split(" ");
                    String string2 = stringArray[1];
                    if (pizzaPrice.getCrust().getName().startsWith(string2)) {
                        PizzaModifierSelectionDialog.this.f = true;
                        pOSToggleButton.setSelected(true);
                        PizzaModifierSelectionDialog.this.a(pOSToggleButton);
                        this.setPizzaCrust(pizzaPrice.getCrust());
                    }
                }
                pOSToggleButton.addActionListener(new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent actionEvent) {
                        POSToggleButton pOSToggleButton = (POSToggleButton)actionEvent.getSource();
                        PizzaModifierSelectionDialog.this.a(pOSToggleButton);
                        SizeAndCrustSelectionPane.this.setPizzaCrust(pizzaPrice.getCrust());
                        if (PizzaModifierSelectionDialog.this.i() != null) {
                            PizzaModifierSelectionDialog.this.v.setSizeModifier(PizzaModifierSelectionDialog.this.i());
                            if (PizzaModifierSelectionDialog.this.v.getSizeModifier() == null) {
                                return;
                            }
                            PizzaModifierSelectionDialog.this.v.getSizeModifier().calculatePrice();
                            PizzaModifierSelectionDialog.this.y.updateView();
                            SizeAndCrustSelectionPane.this.revalidate();
                            SizeAndCrustSelectionPane.this.repaint();
                        }
                    }
                });
                this.g.add(pOSToggleButton);
                this.c.add(pOSToggleButton);
                this.e.add(pOSToggleButton);
            }
            this.e.revalidate();
            this.e.repaint();
            this.revalidate();
            this.repaint();
        }

        public MenuItemSize getMenuItemSize() {
            return this.h;
        }

        public void setMenuItemSize(MenuItemSize menuItemSize) {
            this.h = menuItemSize;
        }

        public PizzaCrust getPizzaCrust() {
            return this.i;
        }

        public void setPizzaCrust(PizzaCrust pizzaCrust) {
            this.i = pizzaCrust;
        }
    }

    public class Pizza
    extends JPanel {
        int a;

        public Pizza(LayoutManager layoutManager) {
            super(layoutManager);
            this.setOpaque(false);
            this.setBackground(Color.white);
            this.setPreferredSize(PosUIManager.getSize(200, 200));
        }

        public void setSize(int n) {
            this.a = n;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            int n = this.getHeight();
            int n2 = 30;
            int n3 = this.getWidth() - 2 * n2;
            int n4 = 0;
            if (n > n3) {
                n4 = n / 2 - n3 / 2;
            } else {
                n2 = (int)((double)(this.getWidth() - n) / 1.65);
                n4 = n / 15;
                n3 = n - this.getWidth() / n4;
            }
            n = n3;
            graphics.setColor(Color.WHITE);
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics.setColor(new Color(255, 251, 211));
            Ellipse2D.Double double_ = new Ellipse2D.Double(n2, n4, n3, n);
            graphics2D.fill(double_);
            Graphics2D graphics2D2 = (Graphics2D)graphics;
            graphics2D2.setColor(Color.green);
            Section section = PizzaModifierSelectionDialog.this.getSelectedSection();
            if (section == null) {
                return;
            }
            if (section.getSectionName().equalsIgnoreCase("Quarter 1")) {
                this.a(graphics2D2, n2, n4, n3);
            } else if (section.getSectionName().equalsIgnoreCase("Quarter 2")) {
                this.b(graphics2D2, n2, n4, n3);
            } else if (section.getSectionName().equalsIgnoreCase("Quarter 3")) {
                this.c(graphics2D2, n2, n4, n3);
            } else if (section.getSectionName().equalsIgnoreCase("Quarter 4")) {
                this.d(graphics2D2, n2, n4, n3);
            } else if (section.getSectionName().equalsIgnoreCase("Half 1")) {
                this.e(graphics2D2, n2, n4, n3);
            } else if (section.getSectionName().equalsIgnoreCase("Half 2")) {
                this.f(graphics2D2, n2, n4, n3);
            }
        }

        void a(Graphics graphics, int n, int n2, int n3) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            graphics2D.setStroke(new BasicStroke(2.0f));
            graphics2D.setColor(Color.lightGray);
            graphics.drawOval(n - n3, n2 - n3, 2 * n3, 2 * n3);
        }

        void a(Graphics2D graphics2D, int n, int n2, int n3) {
            graphics2D.fillArc(n, n2, n3, n3, 90, 90);
        }

        void b(Graphics2D graphics2D, int n, int n2, int n3) {
            graphics2D.fillArc(n, n2, n3, n3, 360, 90);
        }

        void c(Graphics2D graphics2D, int n, int n2, int n3) {
            graphics2D.fillArc(n, n2, n3, n3, 180, 90);
        }

        void d(Graphics2D graphics2D, int n, int n2, int n3) {
            graphics2D.fillArc(n, n2, n3, n3, 270, 90);
        }

        void e(Graphics2D graphics2D, int n, int n2, int n3) {
            graphics2D.fillArc(n, n2, n3, n3, 90, 180);
        }

        void f(Graphics2D graphics2D, int n, int n2, int n3) {
            graphics2D.fillArc(n, n2, n3, n3, 270, 180);
        }
    }

    private class Section
    extends JPanel
    implements MouseListener {
        boolean a;
        private boolean c;
        private PosButton d;
        private final String e;
        private final int f;
        private final String g;
        private final double h;
        private JTable i;
        private SectionModifierTableModel j;

        public Section(String string, String string2, int n, boolean bl, double d) {
            this.e = string;
            this.g = string2;
            this.f = n;
            this.c = bl;
            this.h = d;
            this.setLayout(new BorderLayout());
            this.d = new PosButton(string);
            this.d.setBackground(Color.LIGHT_GRAY);
            this.d.setHorizontalAlignment(0);
            this.d.setFont(this.d.getFont().deriveFont(1, 14.0f));
            this.d.setOpaque(true);
            this.setOpaque(false);
            this.setPreferredSize(PosUIManager.getSize(160, 170));
            this.setBorder(null);
            this.i = new JTable();
            this.i.setTableHeader(null);
            this.i.setRowHeight(PosUIManager.getSize(30));
            this.j = new SectionModifierTableModel();
            this.i.setDefaultRenderer(Object.class, new ModifierTableCellRenderer());
            this.i.setModel(this.j);
            JScrollPane jScrollPane = new JScrollPane(this.i);
            jScrollPane.setBorder(null);
            JViewport jViewport = jScrollPane.getViewport();
            jViewport.setOpaque(false);
            jScrollPane.setOpaque(false);
            jScrollPane.setBorder(null);
            this.add((Component)jScrollPane, "Center");
            this.i.addMouseListener(this);
            this.resizeColumnWidth(this.i);
        }

        public void resizeColumnWidth(JTable jTable) {
            TableColumnModel tableColumnModel = jTable.getColumnModel();
            for (int i = 0; i < jTable.getColumnCount(); ++i) {
                tableColumnModel.getColumn(i).setPreferredWidth((Integer)this.a().get(i));
            }
        }

        private List a() {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            arrayList.add(70);
            arrayList.add(30);
            return arrayList;
        }

        @Override
        public void paintComponent(Graphics graphics) {
            Graphics2D graphics2D = (Graphics2D)graphics;
            AlphaComposite alphaComposite = (AlphaComposite)graphics2D.getComposite();
            AlphaComposite alphaComposite2 = alphaComposite.derive(0.75f);
            graphics2D.setComposite(alphaComposite2);
            super.paintComponent(graphics);
        }

        public boolean isEmpty() {
            return this.j.getRows().size() <= 0;
        }

        public void clearItems() {
            boolean bl = false;
            Iterator<TicketItemModifier> iterator = PizzaModifierSelectionDialog.this.v.getTicketItemModifiers().iterator();
            while (iterator.hasNext()) {
                TicketItemModifier ticketItemModifier = iterator.next();
                if (!ticketItemModifier.isPrintedToKitchen().booleanValue()) {
                    if (!ticketItemModifier.getSectionName().equals(this.getSectionName())) continue;
                    iterator.remove();
                    PizzaModifierSelectionDialog.this.v.deleteTicketItemModifier(ticketItemModifier);
                    this.j.deleteGivenItem(ticketItemModifier);
                    continue;
                }
                bl = true;
            }
            PizzaModifierSelectionDialog.this.y.updateView();
            this.i.repaint();
            this.repaint();
            if (bl) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Modifiers that sent to kitchen can not be deleted!");
            }
            PizzaModifierSelectionDialog.this.t = null;
        }

        public void clearSelectedItem() {
            boolean bl = false;
            if (this.j.getRows() == null) {
                return;
            }
            if (this.j.getRows().size() == 0) {
                return;
            }
            int n = this.i.getSelectedRow();
            if (n < 0) {
                return;
            }
            TicketItemModifier ticketItemModifier = (TicketItemModifier)this.j.getRowData(n);
            if (ticketItemModifier == null) {
                return;
            }
            if (!ticketItemModifier.isPrintedToKitchen().booleanValue()) {
                PizzaModifierSelectionDialog.this.v.deleteTicketItemModifier(ticketItemModifier);
                this.j.deleteGivenItem(ticketItemModifier);
                if (this.j.getRows().size() == 0) {
                    this.clearItems();
                }
            } else {
                bl = true;
            }
            PizzaModifierSelectionDialog.this.y.updateView();
            this.repaint();
            if (bl) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Modifiers that sent to kitchen can not be deleted!");
            }
            PizzaModifierSelectionDialog.this.t = null;
        }

        public void clearItem(TicketItemModifier ticketItemModifier, SectionModifierTableModel sectionModifierTableModel) {
            boolean bl = false;
            if (sectionModifierTableModel.getRows() == null) {
                return;
            }
            if (sectionModifierTableModel.getRows().size() == 0) {
                return;
            }
            if (!ticketItemModifier.isPrintedToKitchen().booleanValue()) {
                PizzaModifierSelectionDialog.this.v.deleteTicketItemModifierByName(ticketItemModifier);
                sectionModifierTableModel.deleteGivenItemByName(ticketItemModifier);
                if (sectionModifierTableModel.getRows().size() == 0) {
                    this.clearItems();
                }
            } else {
                bl = true;
            }
            PizzaModifierSelectionDialog.this.y.updateView();
            this.repaint();
            if (bl) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Modifiers that sent to kitchen can not be deleted!");
            }
            PizzaModifierSelectionDialog.this.t = null;
        }

        public void setSelected(boolean bl) {
            this.a = bl;
            this.repaint();
        }

        public boolean isSelected() {
            return this.a;
        }

        public void addItem(TicketItemModifier ticketItemModifier) {
            this.j.addItem(ticketItemModifier);
            this.repaint();
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            PizzaModifierSelectionDialog.this.a(this);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        public String getSectionName() {
            return this.e;
        }

        public double getPrice() {
            return this.h;
        }

        public double calculatePrice(double d) {
            return d * this.getPrice();
        }
    }
}

