/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.actions.ActionCommand;
import com.floreantpos.actions.CloseDialogAction;
import com.floreantpos.config.CardConfig;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.swing.POSToggleButton;
import com.floreantpos.swing.PosButton;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.TransactionListView;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.payment.AuthorizationDialog;
import com.floreantpos.ui.views.payment.CardProcessor;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import net.miginfocom.swing.MigLayout;

public class AuthorizableTicketBrowser
extends POSDialog {
    private TransactionListView a = new TransactionListView();
    private TransactionListView b = new TransactionListView();
    private JPanel c;
    private POSToggleButton d = new POSToggleButton(Messages.getString("AuthorizableTicketBrowser.12"));
    private POSToggleButton e = new POSToggleButton(Messages.getString("AuthorizableTicketBrowser.13"));
    private User f;
    private Terminal g;

    public AuthorizableTicketBrowser(JFrame jFrame, User user, Terminal terminal) {
        this.f = user;
        this.g = terminal;
        this.a();
    }

    private void a() {
        this.setTitle(POSConstants.AUTHORIZE_BUTTON_TEXT);
        TitlePanel titlePanel = new TitlePanel();
        titlePanel.setTitle(Messages.getString("TicketAuthorizationDialog.0"));
        this.add((Component)titlePanel, "North");
        this.c = new JPanel(new BorderLayout());
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("", "sg,fill", ""));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.d);
        buttonGroup.add(this.e);
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AuthorizableTicketBrowser.this.c.remove(AuthorizableTicketBrowser.this.a);
                AuthorizableTicketBrowser.this.c.add(AuthorizableTicketBrowser.this.b);
                AuthorizableTicketBrowser.this.c.revalidate();
                AuthorizableTicketBrowser.this.c.repaint();
            }
        });
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                AuthorizableTicketBrowser.this.c.remove(AuthorizableTicketBrowser.this.b);
                AuthorizableTicketBrowser.this.c.add(AuthorizableTicketBrowser.this.a);
                AuthorizableTicketBrowser.this.c.revalidate();
                AuthorizableTicketBrowser.this.c.repaint();
            }
        });
        jPanel.add(this.d);
        jPanel.add(this.e);
        this.d.setSelected(true);
        this.c.add((Component)jPanel, "North");
        this.c.add(this.b);
        this.b.setBorder(BorderFactory.createEmptyBorder(5, 8, 5, 8));
        this.a.setBorder(BorderFactory.createEmptyBorder(5, 8, 5, 8));
        JPanel jPanel2 = new JPanel((LayoutManager)new MigLayout("al center", "sg, fill", ""));
        ActionHandler actionHandler = new ActionHandler();
        jPanel2.add((Component)new PosButton(ActionCommand.EDIT_TIPS, actionHandler), "grow");
        jPanel2.add((Component)new PosButton(ActionCommand.CAPTURE, actionHandler), "grow");
        jPanel2.add((Component)new PosButton(ActionCommand.CAPTURE_ALL, actionHandler), "grow");
        jPanel2.add((Component)new PosButton(ActionCommand.VOID_TRANS, actionHandler), "grow");
        jPanel2.add(new PosButton(new CloseDialogAction(this)));
        this.c.add((Component)jPanel2, "South");
        JPanel jPanel3 = new JPanel(new BorderLayout());
        JPanel jPanel4 = new JPanel((LayoutManager)new MigLayout("al center", "sg, fill", ""));
        jPanel4.add((Component)new PosButton(ActionCommand.VOID_TRANS, actionHandler), "grow");
        jPanel4.add(new PosButton(new CloseDialogAction(this)));
        jPanel3.add(this.a);
        jPanel3.add((Component)jPanel4, "South");
        this.add(this.c);
        this.updateTransactiontList();
    }

    public void updateTransactiontList() {
        User user = null;
        if (!this.f.isAdministrator() && !this.f.isManager()) {
            user = this.f;
        }
        this.b.setTransactions(PosTransactionDAO.getInstance().findUnauthorizedTransactions(user));
        this.a.setTransactions(PosTransactionDAO.getInstance().findCapturedTransactions(user));
    }

    private boolean a(String string) {
        int n = JOptionPane.showConfirmDialog(this, string, Messages.getString("TicketAuthorizationDialog.1"), 2);
        return n == 0;
    }

    private void b() {
        try {
            List<PosTransaction> list = this.b.getSelectedTransactions();
            if (list == null || list.size() == 0) {
                POSMessageDialog.showMessage(this, Messages.getString("TicketAuthorizationDialog.2"));
                return;
            }
            if (!this.a(Messages.getString("TicketAuthorizationDialog.3"))) {
                return;
            }
            AuthorizationDialog authorizationDialog = new AuthorizationDialog(this, list);
            authorizationDialog.setVisible(true);
            this.updateTransactiontList();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, "We are sorry, an unexpected error has occured.");
            PosLog.error(this.getClass(), exception);
        }
    }

    public void doAuthorizeAll() {
        try {
            List<PosTransaction> list = this.b.getAllTransactions();
            if (list == null || list.size() == 0) {
                POSMessageDialog.showMessage(this, Messages.getString("TicketAuthorizationDialog.5"));
                return;
            }
            if (!this.a(Messages.getString("TicketAuthorizationDialog.6"))) {
                return;
            }
            AuthorizationDialog authorizationDialog = new AuthorizationDialog(this, list);
            authorizationDialog.setVisible(true);
            this.updateTransactiontList();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, "We are sorry, an unexpected error has occured.");
            PosLog.error(this.getClass(), exception);
        }
    }

    private void c() {
        try {
            PosTransaction posTransaction = this.b.getFirstSelectedTransaction();
            if (posTransaction == null) {
                return;
            }
            Ticket ticket = TicketDAO.getInstance().loadFullTicket(posTransaction.getTicket().getId());
            Set<PosTransaction> set = ticket.getTransactions();
            for (PosTransaction posTransaction2 : set) {
                if (!posTransaction.getId().equals(posTransaction2.getId())) continue;
                posTransaction = posTransaction2;
                break;
            }
            double d = posTransaction.getTipsAmount();
            double d2 = NumberSelectionDialog2.show(this, Messages.getString("TicketAuthorizationDialog.8"), d);
            if (Double.isNaN(d2)) {
                return;
            }
            posTransaction.setTipsAmount(d2);
            posTransaction.setAmount(posTransaction.getAmount() - d + d2);
            if (ticket.hasGratuity()) {
                double d3 = ticket.getGratuity().getAmount();
                double d4 = ticket.getPaidAmount();
                double d5 = d3 - d + d2;
                double d6 = d4 - d + d2;
                ticket.setGratuityAmount(d5);
                ticket.setPaidAmount(d6);
            } else {
                ticket.setGratuityAmount(d2);
                ticket.setPaidAmount(ticket.getPaidAmount() + d2);
            }
            ticket.calculatePrice();
            TicketDAO.getInstance().saveOrUpdate(ticket);
            this.updateTransactiontList();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, "We are sorry, an unexpected error has occured.");
            PosLog.error(this.getClass(), exception);
        }
    }

    private void d() {
        try {
            PosTransaction posTransaction = this.b.getSelectedTransaction();
            if (this.e.isSelected()) {
                posTransaction = this.a.getSelectedTransaction();
            }
            if (posTransaction == null) {
                POSMessageDialog.showMessage(this, "Please select transaction to void");
                return;
            }
            int n = POSMessageDialog.showYesNoQuestionDialog(this, Messages.getString("AuthorizableTicketBrowser.14"), Messages.getString("AuthorizableTicketBrowser.15"));
            if (n != 0) {
                return;
            }
            CardProcessor cardProcessor = CardConfig.getPaymentGateway().getProcessor();
            cardProcessor.voidTransaction(posTransaction);
            PosTransactionDAO.getInstance().saveOrUpdate(posTransaction);
            POSMessageDialog.showMessage(this, "Transaction voided");
            this.updateTransactiontList();
        }
        catch (PosException posException) {
            POSMessageDialog.showError(this, posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, "We are sorry, voiding transaction failed because of an unexpected error.");
            PosLog.error(this.getClass(), exception);
        }
    }

    class ActionHandler
    implements ActionListener {
        ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ActionCommand actionCommand = ActionCommand.valueOf(actionEvent.getActionCommand());
            try {
                switch (actionCommand) {
                    case EDIT_TIPS: {
                        AuthorizableTicketBrowser.this.c();
                        break;
                    }
                    case CAPTURE: {
                        AuthorizableTicketBrowser.this.b();
                        break;
                    }
                    case CAPTURE_ALL: {
                        AuthorizableTicketBrowser.this.doAuthorizeAll();
                        break;
                    }
                    case VOID_TRANS: {
                        AuthorizableTicketBrowser.this.d();
                        break;
                    }
                }
            }
            catch (Exception exception) {
                POSMessageDialog.showError(AuthorizableTicketBrowser.this, exception.getMessage(), exception);
            }
        }
    }
}

