/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.main.Application;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.ui.dialog.GlobalInputDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class RefundProcessor {
    private Ticket a;
    private double b = 0.0;

    public RefundProcessor(Ticket ticket) {
        this.a = ticket;
    }

    public void doRefund(List<PosTransaction> list, boolean bl) throws Exception {
        this.a(list, bl, false);
    }

    private void a(List<PosTransaction> list, boolean bl, boolean bl2) throws Exception {
        double d;
        double d2 = this.a();
        String string = null;
        if (bl2) {
            GlobalInputDialog globalInputDialog = new GlobalInputDialog();
            globalInputDialog.setCaption("Enter gift card number ");
            globalInputDialog.open();
            if (globalInputDialog.isCanceled()) {
                return;
            }
            string = globalInputDialog.getInput();
            if (string == null) {
                return;
            }
        }
        if ((d = NumberSelectionDialog2.takeDoubleInput("Enter refund amount", d2)) < 0.0) {
            return;
        }
        if (d == 0.0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Refund amount must be greater than zero.");
            return;
        }
        double d3 = this.b(list);
        double d4 = NumberUtil.roundToTwoDigit(this.a.getPaidAmount()) - d3;
        if (d > d2 || d > NumberUtil.roundToTwoDigit(this.a(list) - d3)) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Refund amount cannot be greater than selected transaction amount.");
            return;
        }
        if (d > (d4 = NumberUtil.roundToTwoDigit(d4))) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Refund amount cannot be greater than paid amount.");
            return;
        }
        Double d5 = NumberUtil.roundToTwoDigit(this.b * d / this.a.getPaidAmount());
        double d6 = PosTransactionService.getInstance().refundTicket(this.a, d, d5, Application.getCurrentUser(), list, bl, string);
        POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Refunded " + CurrencyUtil.getCurrencySymbol() + d6);
    }

    private double a(List<PosTransaction> list) {
        double d = 0.0;
        for (PosTransaction posTransaction : list) {
            if (posTransaction.isVoided().booleanValue()) continue;
            d += posTransaction.getAmount().doubleValue();
        }
        return d;
    }

    private double a() {
        double d = 0.0;
        if (this.a.getDueAmount() >= 0.0) {
            return 0.0;
        }
        d = Math.abs(this.a.getDueAmount());
        return NumberUtil.roundToTwoDigit(d);
    }

    private double b(List<PosTransaction> list) {
        double d = 0.0;
        for (PosTransaction posTransaction : list) {
            String string;
            if (posTransaction.isVoided().booleanValue() || !StringUtils.isNotEmpty((String)(string = posTransaction.getProperty("REFUNDED_AMOUNT")))) continue;
            try {
                d += Double.parseDouble(string);
            }
            catch (Exception exception) {}
        }
        return NumberUtil.roundToTwoDigit(d);
    }
}

