/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.ui.views.payment;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.actions.SplitTicketAction;
import com.floreantpos.actions.VoidTicketAction;
import com.floreantpos.config.CardConfig;
import com.floreantpos.config.GiftCardConfig;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.extension.GiftCardPaymentPlugin;
import com.floreantpos.extension.InginicoPlugin;
import com.floreantpos.extension.PaymentGatewayPlugin;
import com.floreantpos.main.Application;
import com.floreantpos.model.CardReader;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.CustomPaymentTransaction;
import com.floreantpos.model.CustomerAccountTransaction;
import com.floreantpos.model.Gratuity;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.report.ReceiptPrintService;
import com.floreantpos.services.PosTransactionService;
import com.floreantpos.services.PostPaymentProcessor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.dialog.RefundDialog;
import com.floreantpos.ui.dialog.TicketDiscountSelectionDialog;
import com.floreantpos.ui.dialog.TicketItemDiscountSelectionDialog;
import com.floreantpos.ui.dialog.TransactionCompletionDialog;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.order.OrderView;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.ui.views.payment.AuthorizationCodeDialog;
import com.floreantpos.ui.views.payment.CardInputListener;
import com.floreantpos.ui.views.payment.CardInputProcessor;
import com.floreantpos.ui.views.payment.CardProcessor;
import com.floreantpos.ui.views.payment.ConfirmPayDialog;
import com.floreantpos.ui.views.payment.CustomPaymentSelectionDialog;
import com.floreantpos.ui.views.payment.GiftCardProcessor;
import com.floreantpos.ui.views.payment.GratuityInputDialog;
import com.floreantpos.ui.views.payment.ManualCardEntryDialog;
import com.floreantpos.ui.views.payment.PaymentListener;
import com.floreantpos.ui.views.payment.PaymentProcessWaitDialog;
import com.floreantpos.ui.views.payment.PaymentReferenceEntryDialog;
import com.floreantpos.ui.views.payment.PosPaymentWaitDialog;
import com.floreantpos.ui.views.payment.SwipeCardDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.DrawerUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import com.orocube.rest.service.mqtt.NotificationServiceUtils;
import java.awt.HeadlessException;
import java.awt.Window;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Vector;
import org.apache.commons.lang.StringUtils;
import org.hibernate.StaleStateException;

public class SettleTicketProcessor
implements CardInputListener {
    public static PosPaymentWaitDialog waitDialog = new PosPaymentWaitDialog();
    private Vector<PaymentListener> a = new Vector(3);
    private Ticket b;
    private double c;
    private PaymentType d;
    private User e;
    private RefreshableView f;

    public SettleTicketProcessor(User user, RefreshableView refreshableView) {
        this.e = user;
        this.f = refreshableView;
    }

    public Ticket getTicket() {
        return this.b;
    }

    public void setTicket(Ticket ticket) {
        this.b = ticket;
    }

    public double getTenderAmount() {
        return this.c;
    }

    public void setTenderAmount(double d) {
        this.c = d;
    }

    public void addPaymentListener(PaymentListener paymentListener) {
        this.a.add(paymentListener);
    }

    public void removePaymentListener(PaymentListener paymentListener) {
        this.a.remove(paymentListener);
    }

    public void doSettle(PaymentType paymentType, double d) throws Exception {
        this.c = d;
        if (this.b == null) {
            return;
        }
        if (!POSUtil.checkDrawerAssignment()) {
            return;
        }
        this.d = paymentType;
        PosTransaction posTransaction = null;
        switch (paymentType) {
            case CASH: {
                if (!this.a()) {
                    return;
                }
                DrawerUtil.kickDrawer();
                posTransaction = this.doPayByCash(paymentType);
                break;
            }
            case CUSTOM_PAYMENT: {
                CustomPaymentSelectionDialog customPaymentSelectionDialog = new CustomPaymentSelectionDialog();
                customPaymentSelectionDialog.setTitle(Messages.getString("SettleTicketDialog.8"));
                customPaymentSelectionDialog.pack();
                customPaymentSelectionDialog.open();
                if (customPaymentSelectionDialog.isCanceled()) {
                    return;
                }
                if (!this.a()) {
                    return;
                }
                posTransaction = paymentType.createTransaction();
                CustomPaymentTransaction customPaymentTransaction = (CustomPaymentTransaction)posTransaction;
                customPaymentTransaction.setCustomPaymentFieldName(customPaymentSelectionDialog.getPaymentFieldName());
                customPaymentTransaction.setCustomPaymentName(customPaymentSelectionDialog.getPaymentName());
                customPaymentTransaction.setCustomPaymentRef(customPaymentSelectionDialog.getPaymentRef());
                this.doPayByCustomPayment(customPaymentTransaction);
                break;
            }
            case CREDIT_CARD: 
            case DEBIT_CARD: {
                this.b(d);
                break;
            }
            case GIFT_CERTIFICATE: {
                this.a(d);
                break;
            }
            case MEMBER_ACCOUNT: {
                if (!this.a()) {
                    return;
                }
                CustomerAccountTransaction customerAccountTransaction = (CustomerAccountTransaction)paymentType.createTransaction();
                customerAccountTransaction.setTicket(this.b);
                customerAccountTransaction.setCaptured(true);
                this.b(customerAccountTransaction);
                customerAccountTransaction.setCustomerId(this.b.getCustomerId());
                this.a(customerAccountTransaction);
                break;
            }
        }
    }

    public PosTransaction doPayByCash(PaymentType paymentType) {
        PosTransaction posTransaction = paymentType.createTransaction();
        posTransaction.setTicket(this.b);
        posTransaction.setCaptured(true);
        this.b(posTransaction);
        this.a(posTransaction);
        return posTransaction;
    }

    public void payByCustomPayment(CustomPayment customPayment, double d) {
        this.c = d;
        CustomPaymentTransaction customPaymentTransaction = new CustomPaymentTransaction();
        customPaymentTransaction.setCustomPaymentFieldName(customPayment.getRefNumberFieldName());
        customPaymentTransaction.setCustomPaymentName(customPayment.getName());
        if (customPayment.isRequiredRefNumber().booleanValue() && StringUtils.isEmpty((String)customPaymentTransaction.getCustomPaymentRef())) {
            PaymentReferenceEntryDialog paymentReferenceEntryDialog = new PaymentReferenceEntryDialog(customPayment);
            paymentReferenceEntryDialog.pack();
            paymentReferenceEntryDialog.open();
            if (paymentReferenceEntryDialog.isCanceled()) {
                return;
            }
            customPaymentTransaction.setCustomPaymentRef(paymentReferenceEntryDialog.getPaymentRef());
        }
        this.doPayByCustomPayment(customPaymentTransaction);
    }

    public void doPayByCustomPayment(CustomPaymentTransaction customPaymentTransaction) {
        customPaymentTransaction.setPaymentType(PaymentType.CUSTOM_PAYMENT);
        customPaymentTransaction.setTicket(this.b);
        customPaymentTransaction.setCaptured(true);
        this.b(customPaymentTransaction);
        this.a(customPaymentTransaction);
    }

    private void a(double d) throws Exception {
        try {
            GiftCardPaymentPlugin giftCardPaymentPlugin = GiftCardConfig.getPaymentGateway();
            if (giftCardPaymentPlugin == null) {
                throw new PosException("Gift card payment gateway is not configured.");
            }
            SwipeCardDialog swipeCardDialog = new SwipeCardDialog(this, this.d);
            swipeCardDialog.setAuthorizationEntryVisible(false);
            swipeCardDialog.pack();
            swipeCardDialog.open();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
        }
    }

    private boolean a() {
        if (!TerminalConfig.isUseSettlementPrompt()) {
            return true;
        }
        ConfirmPayDialog confirmPayDialog = new ConfirmPayDialog();
        confirmPayDialog.setAmount(this.c);
        confirmPayDialog.open();
        return !confirmPayDialog.isCanceled();
    }

    public void doSettleBarTabTicket(Ticket ticket, User user) {
        try {
            String string = "Do you want to settle ticket?";
            int n = POSMessageDialog.showYesNoQuestionDialog(null, string, Messages.getString("NewBarTabAction.4"));
            if (n != 0) {
                return;
            }
            for (PosTransaction posTransaction : ticket.getTransactions()) {
                posTransaction.setAmount(ticket.getDueAmount());
                posTransaction.setTenderAmount(ticket.getDueAmount());
                posTransaction.setAuthorizable(true);
                this.a(posTransaction);
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.f);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private void a(PosTransaction posTransaction) {
        this.settleTicket(posTransaction, null);
    }

    public void settleTicket(PosTransaction posTransaction, PostPaymentProcessor postPaymentProcessor) {
        try {
            this.c(posTransaction);
            double d = this.b.getDueAmount();
            PosTransactionService posTransactionService = PosTransactionService.getInstance();
            if (postPaymentProcessor == null) {
                posTransactionService.settleTicket(this.b, posTransaction, this.getCurrentUser());
            } else {
                posTransactionService.settleTicket(this.b, posTransaction, this.getCurrentUser(), postPaymentProcessor);
            }
            this.doAfterSettleTask(posTransaction, d, true);
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.f);
        }
        catch (UnknownHostException unknownHostException) {
            POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("SettleTicketDialog.12"));
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage(), posException);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public void doAfterSettleTask(PosTransaction posTransaction, double d, boolean bl) throws HeadlessException {
        if (bl) {
            SettleTicketProcessor.printTicket(this.b, posTransaction);
        }
        SettleTicketProcessor.showTransactionCompleteMsg(d, posTransaction.getTenderAmount(), this.b, posTransaction);
        if (NumberUtil.isZero(this.b.getDueAmount())) {
            this.d();
        } else {
            this.setTicket(this.b);
            this.doInformListenerPaymentUpdate();
        }
        NotificationServiceUtils.pulishTicket(this.b.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void cardInputted(CardInputProcessor cardInputProcessor, PaymentType paymentType, String string) {
        Window window = POSUtil.getFocusedWindow();
        PaymentProcessWaitDialog paymentProcessWaitDialog = new PaymentProcessWaitDialog(window);
        try {
            paymentProcessWaitDialog.setVisible(true);
            switch (paymentType) {
                case GIFT_CERTIFICATE: {
                    this.b(cardInputProcessor, paymentType, string);
                    return;
                }
                case CREDIT_CARD: 
                case DEBIT_CARD: {
                    this.a(cardInputProcessor, paymentType, string);
                    return;
                }
            }
            return;
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(window, this.f);
            return;
        }
        catch (PosException posException) {
            POSMessageDialog.showError(window, posException.getMessage(), posException);
            return;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(window, "Could not make payment. Please try again or consult system administrator.", exception);
            return;
        }
        finally {
            paymentProcessWaitDialog.setVisible(false);
        }
    }

    private void b(double d) throws Exception {
        try {
            PaymentGatewayPlugin paymentGatewayPlugin = CardConfig.getPaymentGateway();
            if (paymentGatewayPlugin instanceof InginicoPlugin) {
                waitDialog.setVisible(true);
                if (!waitDialog.isCanceled()) {
                    this.d();
                }
                return;
            }
            if (!paymentGatewayPlugin.shouldShowCardInputProcessor()) {
                PosTransaction posTransaction = this.d.createTransaction();
                posTransaction.setTicket(this.b);
                if (!this.a()) {
                    return;
                }
                posTransaction.setCaptured(false);
                posTransaction.setCardMerchantGateway(paymentGatewayPlugin.getProductName());
                this.b(posTransaction);
                if (this.b.getOrderType().isPreAuthCreditCard().booleanValue()) {
                    paymentGatewayPlugin.getProcessor().preAuth(posTransaction);
                } else {
                    paymentGatewayPlugin.getProcessor().chargeAmount(posTransaction);
                }
                this.a(posTransaction);
                return;
            }
            CardReader cardReader = CardConfig.getCardReader();
            switch (cardReader) {
                case SWIPE: {
                    SwipeCardDialog swipeCardDialog = new SwipeCardDialog(this, this.d);
                    swipeCardDialog.pack();
                    swipeCardDialog.open();
                    break;
                }
                case MANUAL: {
                    ManualCardEntryDialog manualCardEntryDialog = new ManualCardEntryDialog(this, this.d);
                    manualCardEntryDialog.pack();
                    manualCardEntryDialog.open();
                    break;
                }
                case EXTERNAL_TERMINAL: {
                    AuthorizationCodeDialog authorizationCodeDialog = new AuthorizationCodeDialog(this, this.d);
                    authorizationCodeDialog.pack();
                    authorizationCodeDialog.open();
                    break;
                }
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.f);
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private void a(CardInputProcessor cardInputProcessor, PaymentType paymentType, String string) throws Exception {
        if (paymentType != null) {
            this.d = paymentType;
        }
        PosTransaction posTransaction = this.d.createTransaction();
        posTransaction.setTicket(this.b);
        PaymentGatewayPlugin paymentGatewayPlugin = CardConfig.getPaymentGateway();
        if (paymentGatewayPlugin == null) {
            throw new PosException("No credit card payment gateway is configured.");
        }
        CardProcessor cardProcessor = paymentGatewayPlugin.getProcessor();
        if (cardInputProcessor instanceof SwipeCardDialog) {
            SwipeCardDialog swipeCardDialog = (SwipeCardDialog)cardInputProcessor;
            String string2 = swipeCardDialog.getCardString();
            if (StringUtils.isEmpty((String)string2) || string2.length() < 16) {
                throw new RuntimeException(Messages.getString("SettleTicketDialog.16"));
            }
            if (!this.a()) {
                return;
            }
            posTransaction.setCardType(string);
            posTransaction.setCardTrack(string2);
            posTransaction.setCaptured(false);
            posTransaction.setCardMerchantGateway(paymentGatewayPlugin.getProductName());
            posTransaction.setCardReader(CardReader.SWIPE.name());
            this.b(posTransaction);
            if (this.b.getOrderType().isPreAuthCreditCard().booleanValue()) {
                cardProcessor.preAuth(posTransaction);
            } else {
                cardProcessor.chargeAmount(posTransaction);
            }
            this.a(posTransaction);
        } else if (cardInputProcessor instanceof ManualCardEntryDialog) {
            ManualCardEntryDialog manualCardEntryDialog = (ManualCardEntryDialog)cardInputProcessor;
            posTransaction.setCaptured(false);
            posTransaction.setCardMerchantGateway(paymentGatewayPlugin.getProductName());
            posTransaction.setCardReader(CardReader.MANUAL.name());
            posTransaction.setCardHolderName(manualCardEntryDialog.getCardHolderName());
            posTransaction.setCardNumber(manualCardEntryDialog.getCardNumber());
            posTransaction.setCardExpMonth(manualCardEntryDialog.getExpMonth());
            posTransaction.setCardExpYear(manualCardEntryDialog.getExpYear());
            this.b(posTransaction);
            if (this.b.getOrderType().isPreAuthCreditCard().booleanValue()) {
                cardProcessor.preAuth(posTransaction);
            } else {
                cardProcessor.chargeAmount(posTransaction);
            }
            this.a(posTransaction);
        } else if (cardInputProcessor instanceof AuthorizationCodeDialog) {
            PosTransaction posTransaction2 = paymentType.createTransaction();
            posTransaction2.setTicket(this.b);
            AuthorizationCodeDialog authorizationCodeDialog = (AuthorizationCodeDialog)cardInputProcessor;
            String string3 = authorizationCodeDialog.getAuthorizationCode();
            if (StringUtils.isEmpty((String)string3)) {
                throw new PosException(Messages.getString("SettleTicketDialog.17"));
            }
            posTransaction2.setCardType(string);
            posTransaction2.setCaptured(true);
            posTransaction2.setAuthorizable(false);
            posTransaction2.setCardReader(CardReader.EXTERNAL_TERMINAL.name());
            posTransaction2.setCardAuthCode(string3);
            this.b(posTransaction2);
            this.a(posTransaction2);
        }
    }

    private void b(CardInputProcessor cardInputProcessor, PaymentType paymentType, String string) throws Exception {
        if (paymentType != null) {
            this.d = paymentType;
        }
        PosTransaction posTransaction = this.d.createTransaction();
        posTransaction.setTicket(this.b);
        GiftCardPaymentPlugin giftCardPaymentPlugin = GiftCardConfig.getPaymentGateway();
        if (giftCardPaymentPlugin == null) {
            throw new PosException("No payment gateway is configured for gift card.");
        }
        GiftCardProcessor giftCardProcessor = giftCardPaymentPlugin.getProcessor();
        if (cardInputProcessor instanceof SwipeCardDialog) {
            SwipeCardDialog swipeCardDialog = (SwipeCardDialog)cardInputProcessor;
            String string2 = swipeCardDialog.getCardString();
            giftCardProcessor.validateCardNo(string2);
            posTransaction.setCardType(string);
            posTransaction.setGiftCertNumber(string2);
            posTransaction.setCaptured(false);
            posTransaction.setCardMerchantGateway(giftCardPaymentPlugin.getProductName());
            posTransaction.setCardReader(CardReader.SWIPE.name());
            this.b(posTransaction);
            giftCardProcessor.chargeAmount(posTransaction);
            this.a(posTransaction);
        } else if (cardInputProcessor instanceof ManualCardEntryDialog) {
            ManualCardEntryDialog manualCardEntryDialog = (ManualCardEntryDialog)cardInputProcessor;
            giftCardProcessor.validateCardNo(manualCardEntryDialog.getCardNumber());
            posTransaction.setCaptured(false);
            posTransaction.setCardMerchantGateway(giftCardPaymentPlugin.getProductName());
            posTransaction.setCardReader(CardReader.MANUAL.name());
            posTransaction.setCardHolderName(manualCardEntryDialog.getCardHolderName());
            posTransaction.setGiftCertNumber(manualCardEntryDialog.getCardNumber());
            posTransaction.setCardExpMonth(manualCardEntryDialog.getExpMonth());
            posTransaction.setCardExpYear(manualCardEntryDialog.getExpYear());
            this.b(posTransaction);
            giftCardProcessor.chargeAmount(posTransaction);
            this.a(posTransaction);
        }
    }

    private void b() {
        if (this.b == null) {
            return;
        }
        this.b.calculatePrice();
    }

    public void doApplyCoupon(int n) {
        try {
            if (this.b == null) {
                return;
            }
            if (!this.getCurrentUser().hasPermission(UserPermission.ADD_DISCOUNT)) {
                POSMessageDialog.showError(Application.getPosWindow(), Messages.getString("SettleTicketDialog.7"));
                return;
            }
            if (n == 1) {
                TicketDiscountSelectionDialog ticketDiscountSelectionDialog = new TicketDiscountSelectionDialog(this.b);
                ticketDiscountSelectionDialog.openFullScreen();
                if (ticketDiscountSelectionDialog.isCanceled()) {
                    return;
                }
            } else {
                TicketItemDiscountSelectionDialog ticketItemDiscountSelectionDialog = new TicketItemDiscountSelectionDialog(this.b);
                ticketItemDiscountSelectionDialog.openFullScreen();
                if (ticketItemDiscountSelectionDialog.isCanceled()) {
                    return;
                }
            }
            this.b();
            this.doInformListenerPaymentUpdate();
            if (OrderView.getInstance().isVisible()) {
                OrderView.getInstance().setCurrentTicket(this.b);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public void doSetGratuity() {
        if (this.b == null) {
            return;
        }
        GratuityInputDialog gratuityInputDialog = new GratuityInputDialog();
        gratuityInputDialog.pack();
        gratuityInputDialog.setResizable(false);
        gratuityInputDialog.open();
        if (gratuityInputDialog.isCanceled()) {
            return;
        }
        double d = gratuityInputDialog.getGratuityAmount();
        Gratuity gratuity = this.b.createGratuity();
        gratuity.setAmount(d);
        this.b.setGratuity(gratuity);
        this.b.calculatePrice();
        this.doInformListenerPaymentUpdate();
    }

    public void doInformListenerPaymentUpdate() {
        for (PaymentListener paymentListener : this.a) {
            paymentListener.paymentDataChanged();
        }
    }

    private void b(PosTransaction posTransaction) {
        posTransaction.setTenderAmount(this.c);
        if (this.c >= this.b.getDueAmount()) {
            posTransaction.setAmount(this.b.getDueAmount());
        } else {
            posTransaction.setAmount(this.c);
        }
    }

    public void doHoldTicket() {
        try {
            if (this.b.isReOpened().booleanValue() && this.b.getDueAmount() == 0.0) {
                this.b.setClosed(true);
            }
            TicketDAO.getInstance().saveOrUpdate(this.b);
            for (PaymentListener paymentListener : this.a) {
                paymentListener.paymentDone();
            }
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.f);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
        }
    }

    public void printTicket(Ticket ticket) {
        if (StringUtils.isEmpty((String)ticket.getId())) {
            OrderController.saveOrder(ticket);
        }
        ReceiptPrintService.printTicket(ticket);
        for (PaymentListener paymentListener : this.a) {
            paymentListener.paymentDataChanged();
        }
    }

    public void doSplitTicket() {
        DataChangeListener dataChangeListener = new DataChangeListener(){

            @Override
            public Object getSelectedData() {
                return SettleTicketProcessor.this.b;
            }

            @Override
            public void dataSetUpdated() {
            }

            @Override
            public void dataRemoved(Object object) {
            }

            @Override
            public void dataChanged(Object object) {
                if (object == null) {
                    return;
                }
                Ticket ticket = (Ticket)object;
                String string = ticket.getId();
                if (StringUtils.isNotEmpty((String)string)) {
                    OrderType orderType = ticket.getOrderType();
                    if (orderType != null && orderType.isRetailOrder().booleanValue()) {
                        SettleTicketProcessor.this.e();
                    } else {
                        SettleTicketProcessor.this.d();
                    }
                } else {
                    SettleTicketProcessor.this.doInformListenerPaymentUpdate();
                }
            }

            @Override
            public void dataChangeCanceled(Object object) {
            }

            @Override
            public void dataAdded(Object object) {
            }
        };
        SplitTicketAction splitTicketAction = new SplitTicketAction();
        splitTicketAction.setDataChangedListener(dataChangeListener);
        splitTicketAction.execute();
    }

    public void cancelPayment() {
        for (PaymentListener paymentListener : this.a) {
            paymentListener.paymentCanceled();
        }
    }

    public static void showTransactionCompleteMsg(double d, double d2, Ticket ticket, PosTransaction posTransaction) {
        TransactionCompletionDialog transactionCompletionDialog = new TransactionCompletionDialog(posTransaction);
        transactionCompletionDialog.setCompletedTransaction(posTransaction);
        transactionCompletionDialog.setTenderedAmount(d2);
        transactionCompletionDialog.setTotalAmount(d);
        transactionCompletionDialog.setPaidAmount(posTransaction.getAmount());
        transactionCompletionDialog.setDueAmount(ticket.getDueAmount());
        transactionCompletionDialog.setGratuityAmount(posTransaction.getTipsAmount());
        transactionCompletionDialog.setChangeAmount(posTransaction.getChangeAmount());
        transactionCompletionDialog.updateView();
        transactionCompletionDialog.pack();
        transactionCompletionDialog.open();
    }

    public static void printTicket(Ticket ticket, PosTransaction posTransaction) {
        try {
            if (ticket.getOrderType().isShouldPrintToKitchen().booleanValue() && ticket.needsKitchenPrint()) {
                ReceiptPrintService.printToKitchen(ticket);
            }
            if (DataProvider.get().getCurrentTerminal().isAutoPrintReceipt()) {
                ReceiptPrintService.printTransaction(posTransaction);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.PRINT_ERROR, exception);
        }
    }

    public void doRefund() {
        new RefundAction().actionPerformed(null);
    }

    private void c() {
        double d = this.b.getPaidAmount();
        try {
            double d2 = NumberSelectionDialog2.takeDoubleInput("Enter refund amount", Math.abs(this.b.getDueAmount()));
            if (d2 <= 0.0) {
                return;
            }
            if (d2 > Math.abs(this.b.getDueAmount())) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Refund amount cannot be greater than paid amount.");
                return;
            }
            PosTransaction posTransaction = PaymentType.CASH.createTransaction();
            posTransaction.setTicket(this.b);
            posTransaction.setCaptured(true);
            posTransaction.setAmount(d2);
            posTransaction.setTenderAmount(d2);
            posTransaction.setTransactionType(TransactionType.CREDIT.name());
            posTransaction.setPaymentType(posTransaction.getPaymentType());
            posTransaction.setTerminal(Application.getInstance().getTerminal());
            posTransaction.setUser(this.getCurrentUser());
            posTransaction.setServer(this.getCurrentUser());
            posTransaction.setCashDrawer(this.getCurrentUser().getActiveDrawerPullReport());
            posTransaction.setTransactionTime(new Date());
            ArrayList<PosTransaction> arrayList = new ArrayList<PosTransaction>();
            arrayList.add(posTransaction);
            double d3 = Math.abs(this.b.getTaxAmount());
            Double d4 = NumberUtil.roundToTwoDigit(d3 * d2 / Math.abs(this.b.getDueAmount()));
            double d5 = PosTransactionService.getInstance().refundTicket(this.b, d2, d4, this.getCurrentUser(), arrayList, true);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Refunded " + CurrencyUtil.getCurrencySymbol() + d5);
            this.d();
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(POSUtil.getFocusedWindow(), this.f);
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
            this.b.setPaidAmount(d);
        }
    }

    public void doVoidTicket() {
        if (this.b.getId() == null) {
            this.d();
            return;
        }
        this.b.calculatePrice();
        if (this.b.getPaidAmount() > 0.0) {
            POSMessageDialog.showMessage(Application.getPosWindow(), "Cannot void paid ticket");
            return;
        }
        VoidTicketAction voidTicketAction = new VoidTicketAction(this.b);
        voidTicketAction.actionPerformed(null);
        if (this.b.isVoided().booleanValue()) {
            this.d();
        }
    }

    private void c(PosTransaction posTransaction) {
        if (!this.b.hasGratuity()) {
            return;
        }
        if (this.b.getDueAmount() != posTransaction.getAmount() && this.b.getPaidAmount() + posTransaction.getTenderAmount() >= this.b.getTotalAmount()) {
            Gratuity gratuity = this.b.getGratuity();
            gratuity.setAmount(gratuity.getAmount() - (this.b.getDueAmount() - posTransaction.getAmount()));
            this.b.calculatePrice();
        }
    }

    private void d() {
        for (PaymentListener paymentListener : this.a) {
            paymentListener.paymentDone();
        }
    }

    private void e() {
        for (PaymentListener paymentListener : this.a) {
            paymentListener.paymentCanceled();
        }
    }

    public User getCurrentUser() {
        return this.e != null ? this.e : Application.getCurrentUser();
    }

    public void setCurrentUser(User user) {
        this.e = user;
    }

    private class RefundAction
    extends PosAction {
        public RefundAction() {
            this.setRequiredPermission(UserPermission.PERFORM_MANAGER_TASK);
            this.setMandatoryPermission(true);
        }

        @Override
        public void execute() {
            try {
                double d;
                if (SettleTicketProcessor.this.b.getTransactions() == null) {
                    SettleTicketProcessor.this.b.setTransactions(new HashSet<PosTransaction>());
                }
                if ((d = SettleTicketProcessor.this.b.getDueAmount().doubleValue()) >= 0.0) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "No valid refund amount found.");
                    return;
                }
                RefundDialog refundDialog = new RefundDialog(POSUtil.getFocusedWindow(), SettleTicketProcessor.this.b, SettleTicketProcessor.this);
                refundDialog.setSize(810, 600);
                refundDialog.open();
                SettleTicketProcessor.this.b.calculatePrice();
                if (NumberUtil.isZero(SettleTicketProcessor.this.b.getDueAmount())) {
                    SettleTicketProcessor.this.d();
                } else {
                    SettleTicketProcessor.this.doInformListenerPaymentUpdate();
                }
            }
            catch (PosException posException) {
                POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
            }
            catch (Exception exception) {
                POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
            }
        }
    }
}

