/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.util;

import com.floreantpos.StoreAlreadyOpenException;
import com.floreantpos.model.SequenceNumber;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.StoreSessionControl;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.SequenceNumberDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.StoreSessionControlDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.util.DataProvider;
import java.util.Date;

public class StoreUtil {
    public static StoreSession getCurrentStoreSession() {
        StoreSessionControl storeSessionControl = StoreUtil.getCurrentStoreOperation();
        if (storeSessionControl == null) {
            return null;
        }
        return storeSessionControl.getCurrentData();
    }

    public static StoreSessionControl getCurrentStoreOperation() {
        return StoreSessionControlDAO.getInstance().getCurrent();
    }

    public static boolean isStoreOpen() {
        return StoreUtil.getCurrentStoreOperation().getCurrentData() != null;
    }

    public static void openStore(User user) {
        StoreSessionControl storeSessionControl = StoreUtil.getCurrentStoreOperation();
        if (storeSessionControl.getCurrentData() != null) {
            throw new StoreAlreadyOpenException("Store is already open.");
        }
        StoreSession storeSession = new StoreSession();
        storeSession.setOpenedBy(user);
        storeSession.setOpenTime(new Date());
        storeSessionControl.setCurrentData(storeSession);
        SequenceNumber sequenceNumber = SequenceNumberDAO.getInstance().get("TICKET_TOKEN_NUMBER");
        if (sequenceNumber == null) {
            sequenceNumber = new SequenceNumber("TICKET_TOKEN_NUMBER");
        }
        sequenceNumber.setNextSequenceNumber(1);
        TerminalDAO.getInstance().performBatchSave(storeSession, storeSessionControl, sequenceNumber);
        DataProvider.get().setStoreSession(storeSession);
    }

    public static void closeStore(User user) throws Exception {
        StoreDAO.getInstance().closeStore(user);
        DataProvider.get().setStoreSession(null);
    }
}

