/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.webservice;

import com.floreantpos.Database;
import com.floreantpos.IconFactory;
import com.floreantpos.Messages;
import com.floreantpos.PosException;
import com.floreantpos.config.AppConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.Address;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Customer;
import com.floreantpos.model.Department;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PriceRule;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.PriceTableItem;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Shift;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.base.BaseOutlet;
import com.floreantpos.model.base.BaseSalesArea;
import com.floreantpos.model.base.BaseTaxGroup;
import com.floreantpos.model.dao.AddressDAO;
import com.floreantpos.model.dao.BaseCurrencyDAO;
import com.floreantpos.model.dao.BaseDepartmentDAO;
import com.floreantpos.model.dao.BasePriceRuleDAO;
import com.floreantpos.model.dao.BaseTaxDAO;
import com.floreantpos.model.dao.BaseTaxGroupDAO;
import com.floreantpos.model.dao.CurrencyDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.DepartmentDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.model.dao.OrderTypeDAO;
import com.floreantpos.model.dao.OutletDAO;
import com.floreantpos.model.dao.PriceRuleDAO;
import com.floreantpos.model.dao.PriceShiftDAO;
import com.floreantpos.model.dao.PriceTableDAO;
import com.floreantpos.model.dao.PriceTableItemDAO;
import com.floreantpos.model.dao.SalesAreaDAO;
import com.floreantpos.model.dao.ShiftDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.StoreSessionDAO;
import com.floreantpos.model.dao.TaxDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.swing.POSPasswordField;
import com.floreantpos.swing.POSTextField;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.ui.TitlePanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.webservice.PosWebService;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JSeparator;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.ws.rs.core.GenericEntity;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;

public class CloudSyncDialog
extends POSDialog
implements ActionListener {
    private static final String a = "CD";
    private static final String b = "UD";
    private static final String c = "SAVE";
    private static final String d = "cancel";
    private static final String e = "test";
    private POSTextField f;
    private POSTextField g;
    private POSTextField h;
    private POSPasswordField i;
    private PosButton j;
    private PosButton k;
    private PosButton l;
    private JButton m;
    private PosButton n;
    private JComboBox o;
    private TitlePanel p;
    private JLabel q;
    private JLabel r;
    private JLabel s;
    private JLabel t;
    private boolean u;
    private JLabel v;
    private JProgressBar w;
    private JLabel x;
    private JTabbedPane y;
    private JPanel z;

    public CloudSyncDialog() throws HeadlessException {
        super(POSUtil.getBackOfficeWindow());
        this.c();
        this.b();
    }

    @Override
    public void setVisible(boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                CloudSyncDialog.this.a(false);
            }
        });
        super.setVisible(bl);
    }

    @Override
    protected void initUI() {
        this.y = new JTabbedPane();
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("inset 5 20 20 20,fill,hidemode 3"));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new MigLayout("fill"));
        jPanel.add((Component)jPanel2, "growx,span");
        this.y.addTab("Download/Upload", jPanel);
        this.v = new JLabel();
        this.v.setFont(new Font("Arial", 1, 20));
        this.w = new JProgressBar();
        this.w.setValue(0);
        this.w.setMaximum(100);
        this.w.setStringPainted(true);
        this.w.setPreferredSize(new Dimension(0, 30));
        this.x = new JLabel("Click download/upload to sync with server.");
        this.w.setVisible(false);
        this.m = new JButton(Messages.getString("DatabaseConfigurationDialog.28").toUpperCase());
        this.m.setActionCommand(d);
        jPanel.add((Component)new JSeparator(), "newline,grow");
        jPanel.add((Component)this.x, "right,newline,split 2");
        jPanel.add((Component)this.w, "grow");
        jPanel.add((Component)new JLabel("Connection Status:"), "newline,split 3");
        jPanel.add(this.v);
        this.r = new JLabel("Store Id:");
        this.r.setFont(new Font("Arial", 1, 16));
        this.r.setForeground(Color.GRAY);
        jPanel.add((Component)this.v, "grow");
        jPanel.add((Component)this.r, "right,grow");
        jPanel.add((Component)new JSeparator(), "newline,grow");
        jPanel.add((Component)this.m, "newline,center,span");
        this.z = new JPanel();
        this.z.setLayout((LayoutManager)new MigLayout("fill", "[][fill, grow]", ""));
        this.p = new TitlePanel();
        this.f = new POSTextField();
        this.g = new POSTextField();
        this.h = new POSTextField();
        this.i = new POSPasswordField();
        this.o = new JComboBox<Database>(Database.values());
        String string = AppConfig.getDatabaseProviderName();
        if (StringUtils.isNotEmpty((String)string)) {
            this.o.setSelectedItem((Object)Database.getByProviderName(string));
        }
        this.updateTitle();
        this.z.add((Component)this.p, "span, grow, wrap");
        this.q = new JLabel("Server Address:");
        this.z.add(this.q);
        this.z.add((Component)this.f, "grow, wrap");
        JLabel jLabel = new JLabel("Store Id:");
        this.s = new JLabel("Username:");
        this.z.add(new JLabel("Store Id:"));
        this.z.add((Component)this.g, "grow, wrap");
        this.z.add(this.s);
        this.z.add((Component)this.h, "grow, wrap");
        this.t = new JLabel("Password:");
        this.z.add(this.t);
        this.z.add((Component)this.i, "grow, wrap");
        this.z.add((Component)new JSeparator(), "span, grow, gaptop 10");
        this.j = new PosButton(Messages.getString("DatabaseConfigurationDialog.26").toUpperCase());
        this.j.setActionCommand(e);
        this.n = new PosButton(Messages.getString("DatabaseConfigurationDialog.27").toUpperCase());
        this.n.setActionCommand(c);
        JPanel jPanel3 = new JPanel((LayoutManager)new MigLayout("inset 0, fill", "grow", ""));
        this.k = new PosButton("UPLOAD");
        this.k.setActionCommand(a);
        this.l = new PosButton("DOWNLOAD");
        this.l.setActionCommand(b);
        this.l.setIcon(IconFactory.getIcon("/ui_icons/", "page-down.png"));
        this.k.setIcon(IconFactory.getIcon("/ui_icons/", "page-up.png"));
        JButton jButton = new JButton(IconFactory.getIcon("/ui_icons/", "backoffice.png"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                POSDialog pOSDialog = new POSDialog(POSUtil.getFocusedWindow());
                pOSDialog.add(CloudSyncDialog.this.z);
                pOSDialog.setSize(CloudSyncDialog.this.getSize());
                pOSDialog.open();
            }
        });
        this.l.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                final Worker worker = new Worker();
                worker.setActionCommand(CloudSyncDialog.b);
                worker.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if ("progress".equals(propertyChangeEvent.getPropertyName())) {
                            CloudSyncDialog.this.w.setValue((Integer)propertyChangeEvent.getNewValue());
                        } else if (propertyChangeEvent.getNewValue() == SwingWorker.StateValue.DONE) {
                            try {
                                worker.get();
                            }
                            catch (InterruptedException | ExecutionException exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                });
                worker.execute();
            }
        });
        this.k.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                final Worker worker = new Worker();
                worker.setActionCommand(CloudSyncDialog.a);
                worker.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                        if ("progress".equals(propertyChangeEvent.getPropertyName())) {
                            CloudSyncDialog.this.w.setValue((Integer)propertyChangeEvent.getNewValue());
                        } else if (propertyChangeEvent.getNewValue() == SwingWorker.StateValue.DONE) {
                            try {
                                worker.get();
                            }
                            catch (InterruptedException | ExecutionException exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                });
                worker.execute();
            }
        });
        jPanel2.add((Component)jButton, "right,wrap");
        jPanel2.add((Component)this.l, "split 2,gaptop 20,center");
        jPanel2.add(this.k);
        PosButton posButton = new PosButton("EXIT");
        posButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CloudSyncDialog.this.a();
            }
        });
        jPanel2.add(posButton);
        jPanel3.add(this.j);
        jPanel3.add(this.n);
        jPanel3.add(posButton);
        this.z.add((Component)jPanel3, "span,right");
        this.add(this.y);
    }

    private void a() {
        Window window = SwingUtilities.getWindowAncestor(this.z);
        if (window instanceof POSDialog) {
            ((POSDialog)window).setCanceled(false);
            window.dispose();
        }
    }

    private void b() {
        this.j.addActionListener(this);
        this.k.addActionListener(this);
        this.n.addActionListener(this);
        this.m.addActionListener(this);
        this.l.addActionListener(this);
    }

    private void c() {
        Store store = Application.getInstance().getStore();
        this.f.setText(store.getProperty("web.service.url"));
        this.g.setText(store.getProperty("web.service.schema"));
        this.h.setText(store.getProperty("web.service.username"));
        this.i.setText(store.getProperty("web.service.password"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            String string = actionEvent.getActionCommand();
            if (d.equalsIgnoreCase(string)) {
                this.dispose();
                return;
            }
            this.setCursor(Cursor.getPredefinedCursor(3));
            if (e.equalsIgnoreCase(string)) {
                this.u = this.a(false);
                if (!this.u) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("DatabaseConfigurationDialog.32"));
                } else {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("DatabaseConfigurationDialog.31"));
                }
            } else if (c.equalsIgnoreCase(string)) {
                this.a(true);
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Successfully saved.");
                this.a();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            POSMessageDialog.showMessage(this, exception.getMessage());
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    public void updateTitle() {
        super.setTitle("Sync with cloud");
        this.p.setTitle("Please enter server information.");
    }

    private boolean a(boolean bl) {
        String[] stringArray;
        Object object;
        String string = this.f.getText();
        String string2 = this.g.getText();
        String string3 = this.h.getText();
        String string4 = new String(this.i.getPassword());
        if (bl) {
            object = Application.getInstance().getStore();
            ((Store)object).addProperty("web.service.url", string);
            ((Store)object).addProperty("web.service.schema", string2);
            ((Store)object).addProperty("web.service.username", string3);
            ((Store)object).addProperty("web.service.password", string4);
            StoreDAO.getInstance().saveOrUpdate((Store)object);
        }
        if ((stringArray = ((String)(object = PosWebService.checkConnection(string, string2, string3, string4))).split(",")).length > 0) {
            if (stringArray[0].equals("success")) {
                if (bl && stringArray.length > 1) {
                    System.out.println("Connected");
                }
                this.v.setText("Connected");
                this.v.setForeground(Color.GREEN);
                this.r.setText("Store Id: " + string2);
                return true;
            }
            this.v.setText(stringArray[1]);
            this.v.setForeground(Color.RED);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void d() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            try {
                List<PriceTableItem> list;
                long l;
                Object object;
                Object object2;
                Object object3;
                this.w.setVisible(true);
                this.w.setValue(0);
                this.x.setForeground(Color.BLUE);
                this.x.setText("Downloading taxes..");
                List<Tax> list3 = PosWebService.getTaxes();
                for (Tax list22 : list3) {
                    object3 = TaxDAO.getInstance();
                    Tax tax = ((BaseTaxDAO)object3).get(list22.getId());
                    if (tax != null) {
                        object2 = tax.getId();
                        long l2 = tax.getVersion();
                        PropertyUtils.copyProperties((Object)tax, (Object)list22);
                        tax.setId((String)object2);
                        tax.setVersion(l2);
                        ((BaseTaxDAO)object3).update(tax);
                        continue;
                    }
                    list22.setVersion(0L);
                    ((BaseTaxDAO)object3).save(list22);
                }
                this.w.setValue(5);
                List<TaxGroup> list4 = PosWebService.getTaxGroups();
                Iterator iterator = list4.iterator();
                while (iterator.hasNext()) {
                    object3 = (TaxGroup)iterator.next();
                    ArrayList<Tax> arrayList = new ArrayList<Tax>();
                    if (((BaseTaxGroup)object3).getTaxes() != null) {
                        for (Tax tax : ((BaseTaxGroup)object3).getTaxes()) {
                            object = TaxDAO.getInstance().get(tax.getId());
                            if (arrayList == null) continue;
                            arrayList.add((Tax)object);
                        }
                    }
                    ((BaseTaxGroup)object3).setTaxes(arrayList);
                    object2 = TaxGroupDAO.getInstance();
                    TaxGroup taxGroup = ((BaseTaxGroupDAO)object2).get(((BaseTaxGroup)object3).getId());
                    if (taxGroup != null) {
                        object = taxGroup.getId();
                        l = taxGroup.getVersion();
                        PropertyUtils.copyProperties((Object)taxGroup, (Object)object3);
                        taxGroup.setId((String)object);
                        taxGroup.setVersion(l);
                        ((BaseTaxGroupDAO)object2).update(taxGroup);
                        continue;
                    }
                    ((BaseTaxGroup)object3).setVersion(0L);
                    ((BaseTaxGroupDAO)object2).save((TaxGroup)object3);
                }
                this.w.setValue(10);
                this.x.setText("Downloading currencies..");
                List<Currency> list2 = PosWebService.getCurrencies();
                for (Currency currency : list2) {
                    object2 = CurrencyDAO.getInstance();
                    Currency currency2 = ((BaseCurrencyDAO)object2).get(currency.getId());
                    if (currency2 != null) {
                        object = currency2.getId();
                        l = currency2.getVersion();
                        PropertyUtils.copyProperties((Object)currency2, (Object)currency);
                        currency2.setId((String)object);
                        currency2.setVersion(l);
                        ((BaseCurrencyDAO)object2).update(currency2);
                        continue;
                    }
                    currency.setVersion(0L);
                    ((BaseCurrencyDAO)object2).save(currency);
                }
                this.w.setValue(15);
                this.x.setText("Downloading outlets..");
                object3 = PosWebService.getOutlets();
                Iterator iterator2 = object3.iterator();
                while (iterator2.hasNext()) {
                    object2 = (Outlet)iterator2.next();
                    OutletDAO outletDAO = OutletDAO.getInstance();
                    object = outletDAO.get(((BaseOutlet)object2).getId());
                    if (object != null) {
                        String string = ((BaseOutlet)object).getId();
                        long l3 = ((BaseOutlet)object).getVersion();
                        PropertyUtils.copyProperties((Object)object, object2);
                        ((BaseOutlet)object).setId(string);
                        ((BaseOutlet)object).setVersion(l3);
                        outletDAO.update((Outlet)object);
                        continue;
                    }
                    ((BaseOutlet)object2).setVersion(0L);
                    outletDAO.save((Outlet)object2);
                }
                this.w.setValue(20);
                this.x.setText("Downloading departments..");
                List<Department> list5 = PosWebService.getDepartments();
                for (Department department : list5) {
                    object = DepartmentDAO.getInstance();
                    Department department2 = ((BaseDepartmentDAO)object).get(department.getId());
                    if (department2 != null) {
                        String string = department2.getId();
                        long l4 = department2.getVersion();
                        PropertyUtils.copyProperties((Object)department2, (Object)department);
                        department2.setId(string);
                        department2.setVersion(l4);
                        ((BaseDepartmentDAO)object).update(department2);
                        continue;
                    }
                    department.setVersion(0L);
                    ((BaseDepartmentDAO)object).save(department);
                }
                this.w.setValue(25);
                this.x.setText("Downloading sales area..");
                object2 = PosWebService.getSalesArea();
                Iterator iterator3 = object2.iterator();
                while (iterator3.hasNext()) {
                    object = (SalesArea)iterator3.next();
                    SalesAreaDAO salesAreaDAO = SalesAreaDAO.getInstance();
                    SalesArea salesArea = salesAreaDAO.get(((BaseSalesArea)object).getId());
                    if (salesArea != null) {
                        String string = salesArea.getId();
                        long l5 = salesArea.getVersion();
                        PropertyUtils.copyProperties((Object)salesArea, object);
                        salesArea.setId(string);
                        salesArea.setVersion(l5);
                        salesAreaDAO.update(salesArea);
                        continue;
                    }
                    ((BaseSalesArea)object).setVersion(0L);
                    salesAreaDAO.save((SalesArea)object);
                }
                this.w.setValue(30);
                this.x.setText("Downloading order types..");
                List<OrderType> list6 = PosWebService.getOrderTypes();
                for (OrderType orderType : list6) {
                    OrderTypeDAO orderTypeDAO = OrderTypeDAO.getInstance();
                    OrderType orderType2 = orderTypeDAO.get(orderType.getId());
                    if (orderType2 != null) {
                        String string = orderType2.getId();
                        long l6 = orderType2.getVersion();
                        PropertyUtils.copyProperties((Object)orderType2, (Object)orderType);
                        orderType2.setId(string);
                        orderType2.setVersion(l6);
                        orderTypeDAO.update(orderType2);
                        continue;
                    }
                    orderType.setVersion(0L);
                    orderTypeDAO.save(orderType);
                }
                this.w.setValue(40);
                this.x.setText("Downloading terminal type..");
                this.w.setValue(65);
                this.x.setText("Downloading menu categories..");
                object = PosWebService.getMenuCategories();
                Object object4 = object.iterator();
                while (object4.hasNext()) {
                    MenuCategory menuCategory = (MenuCategory)object4.next();
                    MenuCategoryDAO menuCategoryDAO = MenuCategoryDAO.getInstance();
                    MenuCategory menuCategory2 = menuCategoryDAO.get(menuCategory.getId());
                    if (menuCategory2 != null) {
                        String string = menuCategory2.getId();
                        long l7 = menuCategory2.getVersion();
                        PropertyUtils.copyProperties((Object)menuCategory2, (Object)menuCategory);
                        menuCategory2.setId(string);
                        menuCategory2.setVersion(l7);
                        menuCategoryDAO.update(menuCategory2);
                        continue;
                    }
                    menuCategory.setVersion(0L);
                    menuCategoryDAO.save(menuCategory);
                }
                this.w.setValue(70);
                this.x.setText("Downloading menu groups..");
                object4 = PosWebService.getMenuGroups();
                Object object5 = object4.iterator();
                while (object5.hasNext()) {
                    MenuGroup menuGroup = (MenuGroup)object5.next();
                    MenuGroupDAO menuGroupDAO = MenuGroupDAO.getInstance();
                    MenuGroup menuGroup2 = menuGroupDAO.get(menuGroup.getId());
                    if (menuGroup2 != null) {
                        String string = menuGroup2.getId();
                        long l8 = menuGroup2.getVersion();
                        PropertyUtils.copyProperties((Object)menuGroup2, (Object)menuGroup);
                        menuGroup2.setId(string);
                        menuGroup2.setVersion(l8);
                        menuGroupDAO.update(menuGroup2);
                        continue;
                    }
                    menuGroup.setVersion(0L);
                    menuGroupDAO.save(menuGroup);
                }
                this.w.setValue(75);
                this.x.setText("Downloading menu items..");
                object5 = PosWebService.getMenuItems();
                Object object6 = object5.iterator();
                while (object6.hasNext()) {
                    MenuItem menuItem = (MenuItem)object6.next();
                    MenuItemDAO menuItemDAO = MenuItemDAO.getInstance();
                    MenuItem menuItem2 = menuItemDAO.get(menuItem.getId());
                    if (menuItem2 != null) {
                        String string = menuItem2.getId();
                        long l9 = menuItem2.getVersion();
                        PropertyUtils.copyProperties((Object)menuItem2, (Object)menuItem);
                        menuItem2.setId(string);
                        menuItem2.setVersion(l9);
                        menuItemDAO.update(menuItem2);
                        continue;
                    }
                    menuItem.setVersion(0L);
                    menuItemDAO.save(menuItem);
                }
                this.w.setValue(80);
                this.x.setText("Downloading modifier groups..");
                object6 = PosWebService.getModifierGroups();
                Object object7 = object6.iterator();
                while (object7.hasNext()) {
                    ModifierGroup modifierGroup = (ModifierGroup)object7.next();
                    ModifierGroupDAO modifierGroupDAO = ModifierGroupDAO.getInstance();
                    ModifierGroup modifierGroup2 = modifierGroupDAO.get(modifierGroup.getId());
                    if (modifierGroup2 != null) {
                        String string = modifierGroup2.getId();
                        long l10 = modifierGroup2.getVersion();
                        PropertyUtils.copyProperties((Object)modifierGroup2, (Object)modifierGroup);
                        modifierGroup2.setId(string);
                        modifierGroup2.setVersion(l10);
                        modifierGroupDAO.update(modifierGroup2);
                        continue;
                    }
                    modifierGroup.setVersion(0L);
                    modifierGroupDAO.save(modifierGroup);
                }
                this.w.setValue(85);
                this.x.setText("Downloading modifiers..");
                object7 = PosWebService.getMenuModifiers();
                Object object8 = object7.iterator();
                while (object8.hasNext()) {
                    MenuModifier menuModifier = (MenuModifier)object8.next();
                    MenuModifierDAO menuModifierDAO = MenuModifierDAO.getInstance();
                    MenuModifier menuModifier2 = menuModifierDAO.get(menuModifier.getId());
                    if (menuModifier2 != null) {
                        String string = menuModifier2.getId();
                        long l11 = menuModifier2.getVersion();
                        PropertyUtils.copyProperties((Object)menuModifier2, (Object)menuModifier);
                        menuModifier2.setId(string);
                        menuModifier2.setVersion(l11);
                        menuModifierDAO.update(menuModifier2);
                        continue;
                    }
                    menuModifier.setVersion(0L);
                    menuModifierDAO.save(menuModifier);
                }
                this.w.setValue(90);
                this.x.setText("Downloading price list..");
                object8 = PosWebService.getPriceShift();
                Object object9 = object8.iterator();
                while (object9.hasNext()) {
                    PriceShift priceShift = (PriceShift)object9.next();
                    PriceShiftDAO priceShiftDAO = PriceShiftDAO.getInstance();
                    Shift shift = ShiftDAO.getInstance().findByName(priceShift.getName());
                    if (shift != null) continue;
                    priceShiftDAO.save(priceShift);
                }
                object9 = PosWebService.getPriceList();
                Object object10 = object9.iterator();
                while (object10.hasNext()) {
                    PriceTable priceTable = (PriceTable)object10.next();
                    PriceTableDAO priceTableDAO = PriceTableDAO.getInstance();
                    PriceTable priceTable2 = PriceTableDAO.getInstance().get(priceTable.getId());
                    if (priceTable2 != null) {
                        list = priceTable2.getId();
                        long l12 = priceTable2.getVersion();
                        PropertyUtils.copyProperties((Object)priceTable2, (Object)priceTable);
                        priceTable2.setId((String)((Object)list));
                        priceTable2.setVersion(l12);
                        priceTableDAO.update(priceTable2);
                    } else {
                        priceTable.setVersion(0L);
                        priceTableDAO.save(priceTable);
                    }
                    if ((list = priceTable.getPriceTableItems()) == null) continue;
                    for (PriceTableItem priceTableItem : list) {
                        PriceTableItem priceTableItem2 = PriceTableItemDAO.getInstance().get(priceTableItem.getId());
                        if (priceTableItem2 != null) {
                            String string = priceTableItem2.getId();
                            long l13 = priceTable2.getVersion();
                            PropertyUtils.copyProperties((Object)priceTableItem2, (Object)priceTableItem);
                            priceTableItem2.setId(string);
                            priceTableItem2.setVersion(l13);
                            PriceTableItemDAO.getInstance().update(priceTableItem2);
                            continue;
                        }
                        priceTableItem.setVersion(0L);
                        PriceTableItemDAO.getInstance().save(priceTableItem);
                    }
                }
                object10 = PosWebService.getPriceRules();
                Iterator iterator4 = object10.iterator();
                while (iterator4.hasNext()) {
                    PriceRule priceRule = (PriceRule)iterator4.next();
                    PriceShift priceShift = priceRule.getPriceShift();
                    if (priceShift != null) {
                        priceRule.setPriceShift((PriceShift)ShiftDAO.getInstance().findByName(priceShift.getName()));
                    }
                    list = PriceRuleDAO.getInstance();
                    PriceRule priceRule2 = PriceRuleDAO.getInstance().get(priceRule.getId());
                    if (priceRule2 != null) {
                        String string = priceRule2.getId();
                        long l14 = priceRule2.getVersion();
                        PropertyUtils.copyProperties((Object)priceRule2, (Object)priceRule);
                        priceRule2.setId(string);
                        priceRule2.setVersion(l14);
                        ((BasePriceRuleDAO)((Object)list)).update(priceRule2);
                        continue;
                    }
                    priceRule.setVersion(0L);
                    ((BasePriceRuleDAO)((Object)list)).save(priceRule);
                }
                this.w.setValue(100);
                this.x.setText("Download complete");
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.x.setText("Download failed .");
                this.x.setForeground(Color.RED);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            POSMessageDialog.showError("Download Failed");
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void e() {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            this.x.setForeground(Color.BLUE);
            this.w.setVisible(true);
            this.w.setValue(5);
            this.k();
            this.l();
            this.j();
            this.h();
            this.g();
            this.i();
            this.f();
            this.m();
            this.n();
            this.o();
            this.p();
            this.q();
            this.x.setText("Uploading store session data..");
            List<StoreSession> list = StoreSessionDAO.getInstance().findAll();
            PosWebService.uploadStoreSessionData(list);
            this.w.setValue(100);
            this.x.setText("Upload complete");
            this.x.setForeground(Color.GREEN);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            this.x.setForeground(Color.RED);
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), "Upload Failed");
            this.w.setValue(0);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void f() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<MenuItem> list = MenuItemDAO.getInstance().findAllUnSyncMenuItems();
        if (list != null && !list.isEmpty()) {
            this.x.setText("Uploading menuitems..");
            for (MenuItem object : list) {
                arrayList.add(object.getId());
                this.a(object);
            }
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<MenuItem>>(list){}, "menuitem");
                this.w.setValue(50);
                MenuItemDAO.getInstance().updateMenuItemSync(arrayList, Boolean.TRUE);
            }
            catch (Exception exception) {
                String string = "Uploading menuitems failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            }
        }
    }

    private void a(MenuItem menuItem) {
        MenuItemDAO.getInstance().initialize(menuItem);
        String string = menuItem.getParentMenuItemId();
        menuItem.setStockUnits(null);
        menuItem.setComboGroups(null);
        menuItem.setComboItems(null);
        menuItem.setParentMenuItem(null);
        menuItem.setParentMenuItemId(string);
        menuItem.setPizzaPriceList(null);
        menuItem.setAttributes(null);
        menuItem.setMenuItemModiferSpecs(null);
        menuItem.setPrinterGroup(null);
        menuItem.setVariants(null);
        MenuGroup menuGroup = menuItem.getParent();
        if (menuGroup != null) {
            MenuCategory menuCategory = menuGroup.getParent();
            MenuCategory menuCategory2 = new MenuCategory();
            if (menuCategory != null) {
                try {
                    PropertyUtils.copyProperties((Object)menuCategory2, (Object)menuCategory);
                    menuCategory2.setDepartments(null);
                    menuCategory2.setOrderTypes(null);
                }
                catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    reflectiveOperationException.printStackTrace();
                }
            }
            menuGroup.setParent(menuCategory2);
        }
    }

    private void g() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<ModifierGroup> list = ModifierGroupDAO.getInstance().findAllUnSyncModifierGroup();
        if (list != null && !list.isEmpty()) {
            for (ModifierGroup object : list) {
                arrayList.add(object.getId());
                this.a(object);
            }
            this.x.setText("Uploading modifier groups..");
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<ModifierGroup>>(list){}, "modifiergroup");
                this.w.setValue(40);
                ModifierGroupDAO.getInstance().updateModifierGroupSync(arrayList, Boolean.TRUE);
            }
            catch (Exception exception) {
                String string = "Uploading modifier groups failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            }
        }
    }

    private void a(ModifierGroup modifierGroup) {
        modifierGroup.setModifiers(null);
    }

    private void h() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<MenuModifier> list = MenuModifierDAO.getInstance().findAllUnSyncMenuModifier();
        if (list != null && !list.isEmpty()) {
            this.x.setText("Uploading menu modifiers..");
            for (MenuModifier object : list) {
                arrayList.add(object.getId());
                this.a(object);
            }
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<MenuModifier>>(list){}, "modifier");
                this.w.setValue(35);
                MenuModifierDAO.getInstance().updateMenuModifierSync(arrayList, Boolean.TRUE);
            }
            catch (Exception exception) {
                String string = "Uploading menu modifiers failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            }
        }
    }

    private void a(MenuModifier menuModifier) {
        menuModifier.setMultiplierPriceList(null);
        menuModifier.setMenuItemModifierGroup(null);
        menuModifier.setPizzaModifierPriceList(null);
    }

    private void i() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<MenuGroup> list = MenuGroupDAO.getInstance().findAllUnSyncMenuGroup();
        if (list != null && !list.isEmpty()) {
            for (MenuGroup object : list) {
                arrayList.add(object.getId());
                this.a(object);
            }
            this.x.setText("Uploading menu groups..");
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<MenuGroup>>(list){}, "menugroup");
                this.w.setValue(45);
                MenuGroupDAO.getInstance().updateMenuGroupSync(arrayList, true);
            }
            catch (Exception exception) {
                String string = "Uploading menu groups failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            }
        }
    }

    private void a(MenuGroup menuGroup) {
        menuGroup.setMenuPages(null);
        MenuCategory menuCategory = menuGroup.getParent();
        menuCategory = MenuCategoryDAO.getInstance().initialize(menuCategory);
        if (menuCategory != null) {
            this.a(menuCategory);
        }
    }

    private void j() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<MenuCategory> list = MenuCategoryDAO.getInstance().findAllUnSyncMenuCategory();
        if (list != null && !list.isEmpty()) {
            this.x.setText("Uploading menu categories..");
            for (MenuCategory object : list) {
                arrayList.add(object.getId());
                this.a(object);
            }
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<MenuCategory>>(list){}, "menucategory");
                this.w.setValue(30);
                MenuCategoryDAO.getInstance().updateMenuCategoriesSync(arrayList, true);
            }
            catch (Exception exception) {
                String string = "Uploading menu categories failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            }
        }
    }

    private void a(MenuCategory menuCategory) {
        menuCategory.setDepartments(null);
        menuCategory.setMenuGroups(null);
        menuCategory.setMenuShifts(null);
        menuCategory.setOrderTypes(null);
        menuCategory.setTerminalTypes(null);
    }

    private void k() {
        Object object;
        ArrayList<Outlet> arrayList = new ArrayList<Outlet>();
        ArrayList<Address> arrayList2 = new ArrayList<Address>();
        Store store = StoreDAO.getRestaurant();
        Outlet outlet = OutletDAO.getInstance().get(String.valueOf(store.getUniqueId()));
        if (store.getAddress() == null) {
            throw new PosException("Address cannot be null");
        }
        String string = store.getAddress().getId();
        Address address = AddressDAO.getInstance().findAddressById(string);
        if (outlet == null) {
            outlet = new Outlet();
            outlet.setId(String.valueOf(store.getUniqueId()));
            outlet.setName(store.getOutletName());
            OutletDAO.getInstance().save(outlet);
            List<Terminal> list = TerminalDAO.getInstance().findAll();
            if (list != null) {
                for (Terminal terminal : list) {
                    terminal.setOutlet(outlet);
                    TerminalDAO.getInstance().saveOrUpdate(terminal);
                }
            }
        } else {
            OutletDAO.getInstance().initialize(outlet);
            outlet.setId(String.valueOf(store.getUniqueId()));
            outlet.setName(store.getOutletName());
        }
        arrayList2.add(address);
        if (arrayList2 != null && !arrayList2.isEmpty()) {
            this.x.setText("Uploading address..");
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<Address>>(arrayList2){}, "address");
                this.w.setValue(10);
            }
            catch (Exception exception) {
                object = "Uploading address failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), (String)object, exception);
            }
        }
        outlet.setAddressId(address.getId());
        outlet.setDepartments(null);
        arrayList.add(outlet);
        if (arrayList != null && !arrayList.isEmpty()) {
            this.x.setText("Uploading outlet..");
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<Outlet>>(arrayList){}, "outlet");
                this.w.setValue(15);
            }
            catch (Exception exception) {
                object = "Uploading outlet failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), (String)object, exception);
            }
        }
    }

    private void l() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<Tax> list2 = TaxDAO.getInstance().findAllUnSyncTax();
        if (list2 != null && !list2.isEmpty()) {
            this.x.setText("Uploading taxes..");
            for (Tax list3 : list2) {
                arrayList.add(list3.getId());
            }
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<Tax>>(list2){}, "tax");
                this.w.setValue(20);
                TaxDAO.getInstance().updateTaxSync(arrayList, true);
            }
            catch (Exception exception) {
                String string = "Uploading tax failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            }
        }
        ArrayList arrayList2 = new ArrayList();
        List<TaxGroup> list = TaxGroupDAO.getInstance().findAllUnSyncTaxGroup();
        if (list != null && !list.isEmpty()) {
            this.x.setText("Uploading tax group ..");
            for (TaxGroup taxGroup : list) {
                arrayList2.add(taxGroup.getId());
            }
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<TaxGroup>>(list){}, "taxgroup");
                this.w.setValue(25);
                TaxGroupDAO.getInstance().updateTaxGroupSync(arrayList2, true);
            }
            catch (Exception exception) {
                String string = "Uploading tax group failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            }
        }
    }

    private void m() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<Customer> list = CustomerDAO.getInstance().findAllUnSyncCustomer();
        if (list != null && !list.isEmpty()) {
            this.x.setText("Uploading Customer..");
            for (Customer object : list) {
                arrayList.add(object.getId());
                CloudSyncDialog.a(object);
            }
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<Customer>>(list){}, "customer");
                this.w.setValue(55);
                CustomerDAO.getInstance().updateCustomerSync(arrayList, true);
            }
            catch (Exception exception) {
                String string = "Uploading customer failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            }
        }
    }

    private void n() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<OrderType> list = OrderTypeDAO.getInstance().findAllUnSyncOrderType();
        if (list != null && !list.isEmpty()) {
            this.x.setText("Uploading OrderType..");
            for (OrderType object : list) {
                arrayList.add(object.getId());
                CloudSyncDialog.a(object);
            }
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<OrderType>>(list){}, "ordertype");
                OrderTypeDAO.getInstance().updateOrderTypeSync(arrayList, true);
                this.w.setValue(60);
            }
            catch (Exception exception) {
                String string = "Uploading OrderType failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            }
        }
    }

    private void o() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<Department> list = DepartmentDAO.getInstance().findAllUnSyncDepartment();
        if (list != null && !list.isEmpty()) {
            this.x.setText("Uploading departments..");
            for (Department object : list) {
                arrayList.add(object.getId());
                CloudSyncDialog.a(object);
            }
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<Department>>(list){}, "departments");
                this.w.setValue(65);
                DepartmentDAO.getInstance().updateDepartmentSync(arrayList, true);
            }
            catch (Exception exception) {
                String string = "Uploading departments failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            }
        }
    }

    private void p() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<UserType> list = UserTypeDAO.getInstance().findAllUnSyncUserType();
        if (list != null && !list.isEmpty()) {
            this.x.setText("Uploading User type ..");
            for (UserType object : list) {
                arrayList.add(object.getId());
            }
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<UserType>>(list){}, "usertypes");
                this.w.setValue(70);
                UserTypeDAO.getInstance().updateUserTypeSync(arrayList, true);
            }
            catch (Exception exception) {
                String string = "Uploading User type failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            }
        }
    }

    private void q() {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<User> list = UserDAO.getInstance().findAllUnSyncUser();
        if (list != null && !list.isEmpty()) {
            this.x.setText("Uploading User..");
            for (User object : list) {
                arrayList.add(object.getId());
                this.a(object);
            }
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<User>>(list){}, "users");
                this.w.setValue(75);
                UserDAO.getInstance().updateUserSync(arrayList, true);
            }
            catch (Exception exception) {
                String string = "Uploading user failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            }
        }
    }

    private void a(User user) {
        if (user == null) {
            return;
        }
        user.setCurrentCashDrawer(null);
        user.setLinkedUser(null);
    }

    private static void a(Department department) {
        if (department == null) {
            return;
        }
        department.setOrderTypes(null);
        department.setOutlets(null);
    }

    private static void a(OrderType orderType) {
        if (orderType == null) {
            return;
        }
        orderType.setTerminalTypes(null);
        orderType.setCategories(null);
        orderType.setDepartments(null);
    }

    private static void a(Customer customer) {
        if (customer == null) {
            return;
        }
        customer.setDeliveryAddresses(null);
        customer.setDeliveryInstructions(null);
        customer.setCustomerGroup(null);
    }

    public static CloudSyncDialog show(Frame frame) {
        CloudSyncDialog cloudSyncDialog = new CloudSyncDialog();
        cloudSyncDialog.setSize(PosUIManager.getSize(500, 350));
        cloudSyncDialog.open();
        return cloudSyncDialog;
    }

    class Worker
    extends SwingWorker<Void, Void> {
        String a;

        public void setActionCommand(String string) {
            this.a = string;
        }

        @Override
        protected Void doInBackground() throws Exception {
            CloudSyncDialog.this.l.setEnabled(false);
            CloudSyncDialog.this.k.setEnabled(false);
            CloudSyncDialog.this.m.setEnabled(false);
            if (this.a.equals(CloudSyncDialog.b)) {
                CloudSyncDialog.this.d();
            } else if (this.a.equals(CloudSyncDialog.a)) {
                CloudSyncDialog.this.e();
            }
            return null;
        }

        @Override
        protected void done() {
            super.done();
            CloudSyncDialog.this.w.setVisible(false);
            CloudSyncDialog.this.l.setEnabled(true);
            CloudSyncDialog.this.k.setEnabled(true);
            CloudSyncDialog.this.m.setEnabled(true);
        }
    }
}

