/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.webservice;

import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.Currency;
import com.floreantpos.model.Department;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.OrderType;
import com.floreantpos.model.Outlet;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.PriceRule;
import com.floreantpos.model.PriceShift;
import com.floreantpos.model.PriceTable;
import com.floreantpos.model.SalesArea;
import com.floreantpos.model.Store;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.TerminalType;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketDiscount;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemDiscount;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.PosTransactionDAO;
import com.floreantpos.model.dao.StoreDAO;
import com.floreantpos.model.dao.StoreSessionDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.report.CashDrawerReportService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.core.util.MultivaluedMapImpl;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.ws.rs.core.GenericEntity;
import org.apache.commons.beanutils.PropertyUtils;
import org.hibernate.Hibernate;

public class PosWebService {
    public static List getDataList(String string) throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/" + string);
            ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)clientResponse.getEntity((GenericType)new GenericType<List>(){});
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    public static List<OrderType> getOrderTypes() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/ordertype");
            ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)clientResponse.getEntity((GenericType)new GenericType<List<OrderType>>(){});
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    public static List<Outlet> getOutlets() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/outlet");
            ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)clientResponse.getEntity((GenericType)new GenericType<List<Outlet>>(){});
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    public static List<SalesArea> getSalesArea() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/salesarea");
            ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)clientResponse.getEntity((GenericType)new GenericType<List<SalesArea>>(){});
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    public static List<Department> getDepartments() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/department");
            ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)clientResponse.getEntity((GenericType)new GenericType<List<Department>>(){});
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    public static List<TerminalType> getTerminalTypes() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/terminaltype");
            ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)clientResponse.getEntity((GenericType)new GenericType<List<TerminalType>>(){});
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    public static List<Terminal> getTerminals() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/terminal");
            ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)clientResponse.getEntity((GenericType)new GenericType<List<Terminal>>(){});
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    public static List<Currency> getCurrencies() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/currency");
            ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)clientResponse.getEntity((GenericType)new GenericType<List<Currency>>(){});
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    public static List<UserPermission> getUserPermissions() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/userpermission");
            ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)clientResponse.getEntity((GenericType)new GenericType<List<UserPermission>>(){});
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    public static List<UserType> getUserTypes() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/usertype");
            ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)clientResponse.getEntity((GenericType)new GenericType<List<UserType>>(){});
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    public static List<User> getUsers() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/user");
            ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)clientResponse.getEntity((GenericType)new GenericType<List<User>>(){});
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    public static List<Tax> getTaxes() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/tax");
            ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)clientResponse.getEntity((GenericType)new GenericType<List<Tax>>(){});
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    public static List<TaxGroup> getTaxGroups() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/taxgroup");
            ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)clientResponse.getEntity((GenericType)new GenericType<List<TaxGroup>>(){});
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    public static List<MenuCategory> getMenuCategories() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/MenuCategory");
            ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)clientResponse.getEntity((GenericType)new GenericType<List<MenuCategory>>(){});
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    public static List<MenuGroup> getMenuGroups() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/MenuGroup");
            ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)clientResponse.getEntity((GenericType)new GenericType<List<MenuGroup>>(){});
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    public static List<MenuItem> getMenuItems() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/MenuItem");
            ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)clientResponse.getEntity((GenericType)new GenericType<List<MenuItem>>(){});
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    public static List<ModifierGroup> getModifierGroups() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/ModifierGroup");
            ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)clientResponse.getEntity((GenericType)new GenericType<List<ModifierGroup>>(){});
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    public static List<MenuModifier> getMenuModifiers() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/MenuModifier");
            ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)clientResponse.getEntity((GenericType)new GenericType<List<MenuModifier>>(){});
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    public static List<PriceRule> getPriceRules() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/PriceRule");
            ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)clientResponse.getEntity((GenericType)new GenericType<List<PriceRule>>(){});
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    public static List<PriceTable> getPriceList() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/PriceTable");
            ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)clientResponse.getEntity((GenericType)new GenericType<List<PriceTable>>(){});
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    public static List<PriceShift> getPriceShift() throws Exception {
        try {
            Client client = Client.create();
            client.getProperties();
            WebResource webResource = client.resource(Store.getWebServiceUrl() + "/PriceShift");
            ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).get(ClientResponse.class);
            return (List)clientResponse.getEntity((GenericType)new GenericType<List<PriceShift>>(){});
        }
        catch (Exception exception) {
            throw new Exception(exception);
        }
    }

    public static String checkConnection(String string, String string2, String string3, String string4) {
        try {
            Client client = Client.create();
            client.getProperties();
            MultivaluedMapImpl multivaluedMapImpl = new MultivaluedMapImpl();
            multivaluedMapImpl.add((Object)"store_id", (Object)string2);
            multivaluedMapImpl.add((Object)"user_name", (Object)string3);
            multivaluedMapImpl.add((Object)"password", (Object)string4);
            WebResource webResource = client.resource(string + "/service/data/access");
            ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).post(ClientResponse.class, (Object)multivaluedMapImpl);
            if (clientResponse.getStatus() != 200) {
                throw new RuntimeException("Failed : HTTP error code : " + clientResponse.getStatus());
            }
            String string5 = (String)clientResponse.getEntity(String.class);
            if (string5.length() > 50) {
                return "error,Invalid server address";
            }
            return string5;
        }
        catch (Exception exception) {
            return "error, Connection failed.";
        }
    }

    public static void uploadStoreSessionData(List<StoreSession> list) throws Exception {
        if (list != null) {
            for (StoreSession storeSession : list) {
                PosWebService.uploadStoreSessionData(storeSession);
            }
        }
    }

    public static void uploadStoreSessionData(StoreSession storeSession) throws Exception {
        StoreSession storeSession2 = new StoreSession();
        PropertyUtils.copyProperties((Object)storeSession2, (Object)storeSession);
        if (!storeSession2.isCloudSynced().booleanValue()) {
            storeSession2.setOutletId(String.valueOf(StoreDAO.getRestaurant().getUniqueId()));
            PosWebService.a(storeSession2.getClosedBy());
            PosWebService.a(storeSession2.getOpenedBy());
            ArrayList<StoreSession> arrayList = new ArrayList<StoreSession>();
            arrayList.add(storeSession2);
            try {
                GenericEntity<List<StoreSession>> genericEntity = new GenericEntity<List<StoreSession>>(arrayList){};
                PosWebService.uploadData((GenericEntity)genericEntity, "storesession");
            }
            catch (Exception exception) {
                String string = "Uploading storesession failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            }
            PosWebService.b(storeSession2);
            PosWebService.a(storeSession2);
            PosWebService.c(storeSession2);
            if (storeSession.getCloseTime() != null) {
                storeSession.setCloudSynced(true);
                StoreSessionDAO.getInstance().update(storeSession);
            }
        }
    }

    public static void uploadTerminal() {
        List<Terminal> list = TerminalDAO.getInstance().findAll();
        if (list != null && !list.isEmpty()) {
            for (Terminal object : list) {
                PosWebService.a(object);
            }
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<Terminal>>(list){}, "terminal");
            }
            catch (Exception exception) {
                String string = "Uploading terminal failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            }
        }
    }

    private static void a(StoreSession storeSession) throws Exception {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<CashDrawer> list = CashDrawerDAO.getInstance().findByUnSyncStoreOperationData(storeSession);
        if (list != null && !list.isEmpty()) {
            for (CashDrawer object : list) {
                CashDrawer cashDrawer = new CashDrawer();
                PropertyUtils.copyProperties((Object)cashDrawer, (Object)object);
                if (object.getReportTime() != null) {
                    arrayList.add(cashDrawer.getId());
                }
                if (object.getStartTime() != null) {
                    CashDrawerReportService cashDrawerReportService = new CashDrawerReportService(object);
                    cashDrawerReportService.populateReport();
                }
                PosWebService.a(object);
            }
            try {
                PosWebService.uploadData((GenericEntity)new GenericEntity<List<CashDrawer>>(list){}, "cashdrawer");
                CashDrawerDAO.getInstance().updateCashDrawerSync(arrayList);
            }
            catch (Exception exception) {
                String string = "Uploading cashdrawer failed...";
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
            }
        }
    }

    private static void a(CashDrawer cashDrawer) {
        cashDrawer.setTransactions(null);
    }

    private static void a(User user) {
        if (user == null) {
            return;
        }
        user.setCurrentCashDrawer(null);
        user.setLinkedUser(null);
    }

    private static void a(Terminal terminal) {
        if (terminal == null) {
            return;
        }
        terminal.setCurrentCashDrawer(null);
        terminal.setAssignedUser(null);
    }

    private static void b(StoreSession storeSession) {
        TicketDAO ticketDAO = TicketDAO.getInstance();
        ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
        List<Ticket> list = ticketDAO.getTicketsOfCurrentSession(storeSession);
        Store store = StoreDAO.getRestaurant();
        String string = String.valueOf(store.getUniqueId());
        if (list != null && !list.isEmpty()) {
            for (Ticket object : list) {
                ticketDAO.loadFullTicket(object);
                PosWebService.b(object);
                object.setOutletId(string);
                arrayList.add(object);
            }
        }
        try {
            GenericEntity<List<Ticket>> genericEntity = new GenericEntity<List<Ticket>>(arrayList){};
            PosWebService.uploadData((GenericEntity)genericEntity, "tickets");
            ticketDAO.updateTicketAndTicketItemSync(ticketDAO.getTicketsOfCurrentSession(storeSession), true);
        }
        catch (Exception exception) {
            String string2 = "Uploading tickets failed...";
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), string2, exception);
        }
    }

    private static void c(StoreSession storeSession) {
        ArrayList<String> arrayList = new ArrayList<String>();
        List<PosTransaction> list = PosTransactionDAO.getInstance().getUnSyncTransactionsByStoreSession(storeSession);
        Store store = StoreDAO.getRestaurant();
        if (list != null && !list.isEmpty()) {
            for (PosTransaction object : list) {
                arrayList.add(object.getId());
                String string = String.valueOf(store.getUniqueId());
                object.setOutletId(string);
                PosWebService.a(object.getTicket());
            }
        }
        try {
            GenericEntity<List<PosTransaction>> genericEntity = new GenericEntity<List<PosTransaction>>(list){};
            PosWebService.uploadData((GenericEntity)genericEntity, "transactions");
            PosTransactionDAO.getInstance().updatePosTransSync(arrayList, true);
        }
        catch (Exception exception) {
            String string = "Uploading transactions failed...";
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), string, exception);
        }
    }

    private static void a(Ticket ticket) {
        ticket.setTicketItems(null);
        ticket.setProperties(null);
        ticket.setTransactions(null);
        ticket.setDepartment(null);
        ticket.setDiscounts(null);
        ticket.setCashier(null);
        ticket.setOwner(null);
        ticket.setOrderType(null);
        ticket.setGratuity(null);
    }

    private static void b(Ticket ticket) {
        Object object;
        Object object2;
        ticket.setProperties(null);
        ticket.setTransactions(null);
        ticket.setDepartment(null);
        List<TicketDiscount> list = ticket.getDiscounts();
        if (list != null && list.size() > 0) {
            object2 = list.iterator();
            while (object2.hasNext()) {
                object = (TicketDiscount)object2.next();
                PosWebService.a((TicketDiscount)object);
            }
        }
        if ((object2 = ticket.getOrderType()) != null) {
            PosWebService.a((OrderType)object2);
        }
        if ((object = ticket.getTicketItems()) != null) {
            Hibernate.initialize(object);
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                TicketItem ticketItem = (TicketItem)iterator.next();
                PosWebService.a(ticketItem);
            }
        }
    }

    private static void a(TicketDiscount ticketDiscount) {
        ticketDiscount.setTicket(null);
    }

    private static void a(TicketItem ticketItem) {
        ticketItem.setTicket(null);
        ticketItem.setTicketItemModifiers(null);
        ticketItem.setParentTicketItem(null);
        ticketItem.setMenuItem(null);
        List<TicketItemDiscount> list = ticketItem.getDiscounts();
        if (list != null && list.size() > 0) {
            for (TicketItemDiscount ticketItemDiscount : list) {
                PosWebService.a(ticketItemDiscount);
            }
        }
    }

    private static void a(TicketItemDiscount ticketItemDiscount) {
        ticketItemDiscount.setTicketItem(null);
    }

    private static void a(OrderType orderType) {
        orderType.setTerminalTypes(null);
        orderType.setCategories(null);
        orderType.setDepartments(null);
    }

    public static void uploadData(GenericEntity genericEntity, String string) throws Exception {
        Client client = Client.create();
        client.getProperties();
        WebResource webResource = client.resource(Store.getWebServiceUrl() + "/" + string + "/save");
        ClientResponse clientResponse = (ClientResponse)webResource.accept(new String[]{"application/json"}).post(ClientResponse.class, (Object)genericEntity);
        if (clientResponse.getStatus() == 200) {
            System.out.println("uploaded...");
        } else if (clientResponse.getStatus() == 500) {
            throw new Exception("upload Failed..");
        }
    }
}

