/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.rest.service.mqtt;

import com.floreantpos.PosException;
import com.floreantpos.PosLog;
import com.floreantpos.config.AppConfig;
import com.floreantpos.main.Application;
import com.floreantpos.main.UpdateManager;
import com.floreantpos.model.Store;
import com.orocube.common.util.TerminalUtil;
import org.eclipse.paho.client.mqttv3.IMqttDeliveryToken;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttCallback;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class OroMqttClient {
    private MqttClient oroMqttClient;
    private int qos = 0;
    private static OroMqttClient instance;
    private String storeUniqueId;
    private String deviceId;

    private OroMqttClient(String string) {
        this.deviceId = string;
    }

    public static OroMqttClient getInstance() {
        if (instance == null) {
            instance = new OroMqttClient(TerminalUtil.getSystemUID() + Math.random());
        }
        return instance;
    }

    public MqttClient getMqttClient() {
        return OroMqttClient.getInstance().oroMqttClient;
    }

    public boolean isConnectedToServer() {
        return this.oroMqttClient.isConnected();
    }

    public void initMqttClient() throws Exception {
        if (Application.getInstance().isDevelopmentMode()) {
            this.initMqttClient(new DebugCallbackHandler());
        } else {
            this.initMqttClient(null);
        }
    }

    public void initMqttClient(MqttCallback mqttCallback) throws Exception {
        String string = "tcp://oroposcloud.com:1883";
        this.oroMqttClient = new MqttClient(string, this.deviceId, (MqttClientPersistence)new MemoryPersistence());
        MqttConnectOptions mqttConnectOptions = new MqttConnectOptions();
        mqttConnectOptions.setCleanSession(true);
        mqttConnectOptions.setConnectionTimeout(2000);
        mqttConnectOptions.setAutomaticReconnect(true);
        mqttConnectOptions.setKeepAliveInterval(120);
        this.oroMqttClient.setCallback(mqttCallback);
        this.oroMqttClient.connect(mqttConnectOptions);
        this.subscribe();
    }

    public void subscribe() throws Exception {
        Application application = Application.getInstance();
        String string = "";
        Store store = application.getStore();
        if (application != null && store != null) {
            string = store.getUuid();
        }
        this.storeUniqueId = AppConfig.getString("store_uuid", string) + "/";
        this.oroMqttClient.subscribe(this.storeUniqueId + "pos_notification", this.qos);
        this.oroMqttClient.subscribe(this.storeUniqueId + "mobile_notification", this.qos);
        UpdateManager updateManager = Application.getInstance().getUpdateManager();
        if (updateManager != null) {
            updateManager.subscribeToUpdateService(this, this.storeUniqueId);
        }
    }

    public void subscribeToStore(String string, int n, IMqttMessageListener iMqttMessageListener) throws Exception {
        this.subscribe(this.storeUniqueId + string, n, iMqttMessageListener);
    }

    public void subscribe(String string, int n, IMqttMessageListener iMqttMessageListener) throws Exception {
        if (!this.oroMqttClient.isConnected()) {
            throw new PosException("Failed to subscribe, mqtt is not connected");
        }
        PosLog.debug(this.getClass(), "subscribing to topic: " + string);
        this.oroMqttClient.subscribe(string, n, iMqttMessageListener);
    }

    protected void showMqttNotification(String string) {
        PosLog.info(this.getClass(), string);
    }

    public void publishOnThread(String string, String string2) {
        this.publishData(string, string2);
    }

    public void publishData(String string, String string2) {
        try {
            if (!this.isConnectedToServer()) {
                return;
            }
            PosLog.debug(this.getClass(), "publishing to topic: " + this.storeUniqueId + string);
            this.oroMqttClient.publish(this.storeUniqueId + string, string2.getBytes(), this.qos, false);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), "Notification service error. " + exception.getMessage());
        }
    }

    protected void debug(String string) {
        PosLog.debug(OroMqttClient.class, string);
    }

    class DebugCallbackHandler
    implements MqttCallback {
        DebugCallbackHandler() {
        }

        public void connectionLost(Throwable throwable) {
            PosLog.debug(this.getClass(), "mqtt connection lost");
        }

        public void deliveryComplete(IMqttDeliveryToken iMqttDeliveryToken) {
            PosLog.debug(this.getClass(), "mqtt delivery complete");
        }

        public void messageArrived(String string, MqttMessage mqttMessage) throws Exception {
            PosLog.debug(this.getClass(), "message arrived. topic: " + string + ", message: " + mqttMessage);
        }
    }
}

