/*
 * Decompiled with CFR 0.152.
 */
package com.orocube.rest.service.server;

import com.floreantpos.PosLog;
import com.floreantpos.jdbc.SchemaResolver;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.CashTransaction;
import com.floreantpos.model.CreditCardTransaction;
import com.floreantpos.model.PaymentType;
import com.floreantpos.model.PosTransaction;
import com.floreantpos.model.Terminal;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.TicketItem;
import com.floreantpos.model.TicketItemModifier;
import com.floreantpos.model.TransactionType;
import com.floreantpos.model.dao.CashDrawerDAO;
import com.floreantpos.model.dao.CustomerDAO;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.report.CashDrawerReportService;
import com.floreantpos.util.StoreUtil;
import com.orocube.rest.service.PosResponse;
import com.orocube.rest.service.ServiceUtils;
import com.orocube.rest.service.mqtt.NotificationServiceUtils;
import com.orocube.rest.service.mqtt.OroMqttClient;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Path;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.hibernate.Session;
import org.hibernate.Transaction;

@Path(value="data")
public class RestDataService {
    public PosResponse saveOrUpdateTickets(List<Ticket> list) {
        return this.saveOrUpdateTickets(list, null);
    }

    public PosResponse saveOrUpdateTickets(List<Ticket> list, String string) {
        PosResponse posResponse = new PosResponse();
        if (list == null || list.isEmpty()) {
            posResponse.setResponseCode(0);
            posResponse.setMsg("empty data");
            return posResponse;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList<Ticket> arrayList2 = new ArrayList<Ticket>();
        HashMap<String, CashDrawer> hashMap = new HashMap<String, CashDrawer>();
        for (Ticket ticket : list) {
            Ticket ticket2 = this.saveOrUpdateTicket(hashMap, ticket);
            if (ticket2 != null) {
                arrayList.add(ticket.getId());
                arrayList2.add(ticket2);
            }
            if (hashMap.size() <= 0) continue;
            for (CashDrawer cashDrawer : hashMap.values()) {
                if (cashDrawer.isOpen()) continue;
                CashDrawerReportService cashDrawerReportService = new CashDrawerReportService(cashDrawer);
                cashDrawerReportService.populateReport();
                CashDrawerDAO.getInstance().saveOrUpdate(cashDrawer);
            }
        }
        posResponse.setResponseCode(1);
        posResponse.setMsg("saved");
        posResponse.setData(((Object)arrayList).toString());
        this.publishUpdatedTickets(arrayList2, string);
        return posResponse;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Ticket saveOrUpdateTicket(Map<String, CashDrawer> map, Ticket ticket) {
        ticket.getDiscounts();
        Ticket ticket2 = TicketDAO.getInstance().loadFullTicket(ticket.getId());
        Session session = null;
        Transaction transaction = null;
        try {
            Object object;
            boolean bl;
            session = TicketDAO.getInstance().createNewSession();
            transaction = session.beginTransaction();
            boolean bl2 = ticket.isClosed();
            boolean bl3 = bl = ticket2 == null;
            if (bl) {
                ticket2 = ticket;
            } else {
                this.clearExistingTicket(ticket2, session);
                long l = ticket2.getVersion();
                int n = ticket2.getTokenNo();
                try {
                    PropertyUtils.copyProperties((Object)ticket2, (Object)ticket);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ticket2.setVersion(l);
                ticket2.setTokenNo(n);
            }
            List<TicketItem> list = ticket2.getTicketItems();
            Object object2 = list.iterator();
            while (object2.hasNext()) {
                TicketItem ticketItem = object2.next();
                ticketItem.setId(null);
                ticketItem.getDiscounts();
                ticketItem.getTaxes();
                if (ticketItem.getTicketItemModifiers() != null) {
                    for (TicketItemModifier comparable : ticketItem.getTicketItemModifiers()) {
                        comparable.setId(null);
                        comparable.setTicketItem(ticketItem);
                    }
                }
                ticketItem.setTicket(ticket2);
            }
            if (ticket.getCustomer() != null && (object2 = CustomerDAO.getInstance().get(ticket.getCustomerId())) == null) {
                session.save((Object)ticket.getCustomer());
            }
            object2 = ticket.getTransactions();
            HashSet<PosTransaction> hashSet = new HashSet<PosTransaction>();
            if (object2 != null && object2.size() > 0) {
                object = object2.iterator();
                while (object.hasNext()) {
                    PosTransaction posTransaction = (PosTransaction)object.next();
                    PosTransaction posTransaction2 = null;
                    PaymentType paymentType = posTransaction.getPaymentType();
                    String string = posTransaction.getPaymentTypeString();
                    if (string == null || string.equals(PaymentType.CASH.getDisplayString())) {
                        posTransaction2 = new CashTransaction();
                        posTransaction2.setPaymentType(PaymentType.CASH);
                    } else if (string.equals(PaymentType.CREDIT_CARD.getDisplayString())) {
                        posTransaction2 = new CreditCardTransaction();
                        posTransaction2.setPaymentType(PaymentType.CREDIT_CARD);
                    }
                    posTransaction2.setPaymentType(paymentType);
                    posTransaction2.setId(null);
                    posTransaction2.setTicket(ticket2);
                    posTransaction2.setTerminalId(posTransaction.getTerminalId());
                    posTransaction2.setUserId(posTransaction.getUserId());
                    posTransaction2.setTransactionType(TransactionType.CREDIT.name());
                    String string2 = posTransaction.getCashDrawerId();
                    if (StringUtils.isNotEmpty((String)string2)) {
                        CashDrawer cashDrawer = map.get(string2);
                        if (cashDrawer == null && (cashDrawer = CashDrawerDAO.getInstance().get(string2, session)) != null) {
                            map.put(cashDrawer.getId(), cashDrawer);
                        }
                        if (cashDrawer == null) {
                            this.createNewCashDrawer(session, posTransaction.getCashDrawer(), posTransaction2);
                        }
                    }
                    posTransaction2.setCashDrawerId(string2);
                    posTransaction2.setTransactionTime(new Date());
                    posTransaction2.setCardExpMonth(posTransaction.getCardExpMonth());
                    posTransaction2.setCardHolderName(posTransaction.getCardHolderName());
                    posTransaction2.setCardAuthCode(posTransaction.getCardAuthCode());
                    posTransaction2.setCardMerchantGateway(posTransaction.getCardMerchantGateway());
                    posTransaction2.setCardNumber(posTransaction.getCardNumber());
                    posTransaction2.setCardTrack(posTransaction.getCardTrack());
                    posTransaction2.setCardTransactionId(posTransaction.getCardTransactionId());
                    posTransaction2.setCardReader(posTransaction.getCardReader());
                    posTransaction2.setCardType(posTransaction.getCardType());
                    posTransaction2.setAmount(posTransaction.getAmount());
                    posTransaction2.setTenderAmount(posTransaction.getTenderAmount());
                    posTransaction2.setStoreSessionId(StoreUtil.getCurrentStoreSession().getId());
                    hashSet.add(posTransaction2);
                }
                ticket2.setTransactions(hashSet);
            } else {
                ticket2.setTransactions(null);
            }
            ticket2.setClosed(bl2);
            ticket2.calculatePrice();
            TicketDAO.getInstance().saveOrUpdate(ticket2, session);
            transaction.commit();
            object = ticket2;
            return object;
        }
        catch (Exception exception) {
            try {
                transaction.rollback();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            PosLog.error(this.getClass(), exception);
        }
        finally {
            TicketDAO.getInstance().closeSession(session);
        }
        return null;
    }

    private void publishUpdatedTickets(final List<Ticket> list, final String string) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    if (StringUtils.isNotEmpty((String)string)) {
                        SchemaResolver.initTenant(string);
                    }
                    if (list != null && list.size() > 0) {
                        for (Ticket ticket : list) {
                            ticket.setDiscounts(null);
                        }
                        String string2 = ServiceUtils.createPosResponseAsString(list);
                        if (StringUtils.isEmpty((String)string)) {
                            OroMqttClient.getInstance().publishData("mobile_notification", string2);
                        } else {
                            Ticket ticket;
                            ticket = new MqttMessage();
                            ticket.setPayload(string2.getBytes());
                            OroMqttClient.getInstance().getMqttClient().publish(string + "/" + "mobile_notification", string2.getBytes(), 0, false);
                        }
                    }
                }
                catch (Exception exception) {
                    PosLog.error(NotificationServiceUtils.class, exception);
                }
            }
        }).start();
    }

    private void createNewCashDrawer(Session session, CashDrawer cashDrawer, PosTransaction posTransaction) {
        if (cashDrawer != null) {
            cashDrawer.setStoreOperationData(StoreUtil.getCurrentStoreSession());
            session.save((Object)cashDrawer);
        }
        Integer n = posTransaction.getTerminalId();
        Terminal terminal = TerminalDAO.getInstance().get(n, session);
        if (terminal != null && cashDrawer != null) {
            terminal.setAssignedUser(cashDrawer.getAssignedUser());
            terminal.setCurrentCashDrawer(cashDrawer);
            session.saveOrUpdate((Object)terminal);
        }
    }

    private void clearExistingTicket(Ticket ticket, Session session) {
        for (TicketItem comparable : ticket.getTicketItems()) {
            session.delete((Object)comparable);
        }
        if (ticket.getTransactions() != null) {
            for (PosTransaction posTransaction : ticket.getTransactions()) {
                session.delete((Object)posTransaction);
            }
        }
    }
}

