/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.util.DataProvider;
import com.floreantpos.print.PosPrintService;
import com.floreantpos.services.report.CashDrawerReportService;
import com.floreantpos.ui.dialog.CashReconciliationDialog;
import com.floreantpos.ui.dialog.MultiCurrencyAmountSelectionDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.NumberUtil;
import com.floreantpos.util.POSUtil;
import java.awt.Dialog;
import java.awt.Window;

public class StaffBankCloseAction
extends PosAction {
    public static final double FORCE_CLOSE_RECONCILE_AMOUNT = 0.0;
    private CashDrawer a;
    private User b;

    public StaffBankCloseAction(CashDrawer cashDrawer, User user) {
        super("CLOSE STAFF BANK");
        this.a = cashDrawer;
        this.b = user;
        this.updateActionText();
    }

    public void updateActionText() {
    }

    @Override
    public void execute() {
        try {
            int n = POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), "Are you sure you want to close staff bank?", "Confirm");
            if (n != 0) {
                return;
            }
            this.performCloseStaffBank();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    public void performCloseStaffBank() throws Exception {
        Object object;
        CashDrawerReportService cashDrawerReportService = new CashDrawerReportService(this.a);
        cashDrawerReportService.populateReport();
        Double d = 0.0;
        DataProvider dataProvider = DataProvider.get();
        if (dataProvider.getStore().isUseDetailedReconciliation().booleanValue()) {
            object = new CashReconciliationDialog(this.a);
            ((Window)object).pack();
            ((POSDialog)object).open();
            if (((POSDialog)object).isCanceled()) {
                return;
            }
            d = ((CashReconciliationDialog)object).getTotalReconcilieAmount();
        } else if (dataProvider.getCurrentTerminal().isEnableMultiCurrency().booleanValue()) {
            object = new MultiCurrencyAmountSelectionDialog(this.a, this.a.getDrawerAccountable(), CurrencyUtil.getAllCurrency());
            ((Dialog)object).setTitle("Cash reconciliation");
            ((OkCancelOptionDialog)object).setCaption("Cash reconciliation");
            ((MultiCurrencyAmountSelectionDialog)object).setReconcile(true);
            ((Window)object).pack();
            ((POSDialog)object).open();
            if (((POSDialog)object).isCanceled()) {
                return;
            }
            d = ((MultiCurrencyAmountSelectionDialog)object).getTotalAmount();
        } else {
            d = this.a(this.a);
            if (d.isNaN()) {
                return;
            }
        }
        this.a.setCashToDeposit(d);
        object = new TerminalDAO();
        ((TerminalDAO)object).resetStaffBank(this.b, this.a);
        Application.getInstance().refreshCurrentUser();
        PosPrintService.printDrawerPullReport(this.a);
        this.updateActionText();
    }

    public void performForceCloseStaffBank(User user) throws Exception {
        CashDrawerReportService cashDrawerReportService = new CashDrawerReportService(this.a);
        cashDrawerReportService.populateReport();
        this.a.setCashToDeposit(0.0);
        TerminalDAO terminalDAO = new TerminalDAO();
        terminalDAO.resetStaffBank(user, this.a);
        Application.getInstance().refreshCurrentUser();
        PosPrintService.printDrawerPullReport(this.a);
        this.updateActionText();
    }

    private Double a(CashDrawer cashDrawer) {
        String string = "Enter reconcile amount & tips";
        String string2 = "Reconcile";
        double d = this.b.isBlindAccountableAmount() != false ? 0.0 : NumberUtil.roundToTwoDigit(cashDrawer.getDrawerAccountable());
        Double d2 = NumberSelectionDialog2.takeDoubleInput(string, string2, d);
        if (Double.isNaN(d2)) {
            return Double.NaN;
        }
        if (d2 < cashDrawer.getDrawerAccountable()) {
            String string3 = "Do you want to save partial reconciliation?";
            String string4 = "Confirm";
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), string3, string4) == 0) {
                return d2;
            }
            return this.a(cashDrawer);
        }
        return d2;
    }
}

