/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.CashDrawer;
import com.floreantpos.model.User;
import com.floreantpos.model.dao.TerminalDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.print.PosPrintService;
import com.floreantpos.services.report.CashDrawerReportService;
import com.floreantpos.ui.dialog.CashReconciliationDialog;
import com.floreantpos.ui.dialog.MultiCurrencyAmountSelectionDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.OkCancelOptionDialog;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.CurrencyUtil;
import com.floreantpos.util.POSUtil;
import java.awt.Dialog;
import java.awt.Window;

public class StaffBankStartStopAction
extends PosAction {
    public static final double FORCE_CLOSE_RECONCILE_AMOUNT = 0.0;
    private User a;

    public StaffBankStartStopAction(User user) {
        super("Start Staff Bank");
        this.a = user;
        this.updateActionText();
    }

    public void updateActionText() {
    }

    @Override
    public void execute() {
        try {
            if (this.a.isStaffBankStarted().booleanValue()) {
                int n = POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), "Are you sure you want to close staff bank?", "Confirm");
                if (n != 0) {
                    return;
                }
                this.performCloseStaffBank();
            } else {
                this.performStartStaffBank();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    public void performStartStaffBank() throws Exception {
        if (!this.a.isClockedIn().booleanValue()) {
            POSMessageDialog.showError("Can't start staff bank. You are not clocked in.");
            return;
        }
        UserDAO.getInstance().startStaffBank(this.a);
        Application.getInstance().refreshCurrentUser();
        this.updateActionText();
    }

    public void performCloseStaffBank() throws Exception {
        Object object;
        CashDrawer cashDrawer = this.a.getActiveDrawerPullReport();
        CashDrawerReportService cashDrawerReportService = new CashDrawerReportService(cashDrawer);
        cashDrawerReportService.populateReport();
        Double d = 0.0;
        Application application = Application.getInstance();
        if (application.getStore().isUseDetailedReconciliation().booleanValue()) {
            object = new CashReconciliationDialog(cashDrawer);
            ((Window)object).pack();
            ((POSDialog)object).open();
            if (((POSDialog)object).isCanceled()) {
                return;
            }
            d = ((CashReconciliationDialog)object).getTotalReconcilieAmount();
        } else if (application.getTerminal().isEnableMultiCurrency().booleanValue()) {
            object = new MultiCurrencyAmountSelectionDialog(cashDrawer, cashDrawer.getDrawerAccountable(), CurrencyUtil.getAllCurrency());
            ((Dialog)object).setTitle("Cash reconciliation");
            ((OkCancelOptionDialog)object).setCaption("Cash reconciliation");
            ((MultiCurrencyAmountSelectionDialog)object).setReconcile(true);
            ((Window)object).pack();
            ((POSDialog)object).open();
            if (((POSDialog)object).isCanceled()) {
                return;
            }
            d = ((MultiCurrencyAmountSelectionDialog)object).getTotalAmount();
        } else {
            d = this.a(cashDrawer);
            if (d.isNaN()) {
                return;
            }
        }
        cashDrawer.setCashToDeposit(d);
        object = new TerminalDAO();
        ((TerminalDAO)object).resetStaffBank(this.a, cashDrawer);
        User user = Application.getCurrentUser();
        if (user != null && user.getId().equals(cashDrawer.getAssignedUser().getId())) {
            Application.getInstance().setCurrentUser(UserDAO.getInstance().get(user.getId()));
        }
        PosPrintService.printDrawerPullReport(cashDrawer);
        this.updateActionText();
    }

    private Double a(CashDrawer cashDrawer) {
        Double d = NumberSelectionDialog2.takeDoubleInput("Enter reconcile amount & tips", "Reconcile", this.a.isBlindAccountableAmount() != false ? 0.0 : cashDrawer.getDrawerAccountable());
        if (Double.isNaN(d)) {
            return Double.NaN;
        }
        if (d < cashDrawer.getDrawerAccountable()) {
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), "Do you want to save partial reconciliation?", "Confirm") == 0) {
                return d;
            }
            return this.a(cashDrawer);
        }
        return d;
    }
}

