/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.actions;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosException;
import com.floreantpos.actions.PosAction;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.services.TicketService;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.order.OrderController;
import com.floreantpos.ui.views.order.TicketSelectionDialog;
import com.floreantpos.ui.views.order.actions.DataChangeListener;
import com.floreantpos.util.POSUtil;
import java.util.List;
import javax.swing.JOptionPane;

public class TicketCloseAction
extends PosAction {
    public TicketCloseAction() {
        super(POSConstants.CLOSE_ORDER_BUTTON_TEXT);
    }

    public TicketCloseAction(DataChangeListener dataChangeListener) {
        super(POSConstants.CLOSE_ORDER_BUTTON_TEXT, dataChangeListener);
    }

    @Override
    public void execute() {
        try {
            Object object = this.getSelectedObject();
            if (object != null) {
                if (!this.hasPermissionToAccessTicket((Ticket)object)) {
                    return;
                }
                this.a(object);
            } else {
                this.a();
            }
        }
        catch (PosException posException) {
            POSMessageDialog.showError(Application.getPosWindow(), posException.getMessage());
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    private void a() {
        List<Ticket> list = TicketDAO.getInstance().getTicketsWithSpecificFields(Ticket.PROP_ID, Ticket.PROP_DUE_AMOUNT, Ticket.PROP_TOKEN_NO, Ticket.PROP_TICKET_TABLE_NUMBERS);
        TicketSelectionDialog ticketSelectionDialog = new TicketSelectionDialog(list);
        ticketSelectionDialog.setCaption("Select tickets to close");
        ticketSelectionDialog.openFullScreen();
        if (ticketSelectionDialog.isCanceled()) {
            return;
        }
        List<Ticket> list2 = ticketSelectionDialog.getSelectedTickets();
        if (list2 == null) {
            return;
        }
        int n = POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), "Are you sure to close tickets?", "Confirmation to close");
        if (n == 0) {
            TicketDAO.closeOrders(list2.toArray(new Ticket[list2.size()]));
        }
    }

    private void a(Object object) {
        int n;
        Ticket ticket = null;
        ticket = object instanceof Ticket ? (Ticket)object : TicketService.getTicket((String)object);
        if (ticket == null) {
            return;
        }
        if (ticket.isVoided().booleanValue()) {
            POSMessageDialog.showMessage(Application.getPosWindow(), POSConstants.TICKET_IS_VOIDED);
            return;
        }
        ticket = TicketDAO.getInstance().loadFullTicket(ticket.getId());
        int n2 = (int)POSUtil.getDouble(ticket.getDueAmount());
        if (n2 != 0 && (n = POSMessageDialog.showYesNoQuestionDialog(Application.getPosWindow(), "Ticket is not fully paid, do you still want to close it?", "Confirm")) != 0) {
            return;
        }
        n = JOptionPane.showOptionDialog(Application.getPosWindow(), Messages.getString("SwitchboardView.6") + ticket.getId() + Messages.getString("SwitchboardView.7"), POSConstants.CONFIRM, 2, 1, null, null, null);
        if (n != 0) {
            return;
        }
        OrderController.closeOrder(ticket);
        if (this.listener != null) {
            this.listener.dataChanged(ticket);
        }
    }
}

