/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.actions;

import com.floreantpos.Messages;
import com.floreantpos.bo.actions.DataExportAction;
import com.floreantpos.bo.actions.DataImportDialog;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.InventoryUnit;
import com.floreantpos.model.InventoryUnitGroup;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuItemModifierPage;
import com.floreantpos.model.MenuItemModifierPageItem;
import com.floreantpos.model.MenuItemModifierSpec;
import com.floreantpos.model.MenuModifier;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.PrinterGroup;
import com.floreantpos.model.Tax;
import com.floreantpos.model.TaxGroup;
import com.floreantpos.model.User;
import com.floreantpos.model.UserType;
import com.floreantpos.model.base.BaseInventoryUnit;
import com.floreantpos.model.base.BaseInventoryUnitGroup;
import com.floreantpos.model.base.BaseMenuCategory;
import com.floreantpos.model.base.BaseMenuGroup;
import com.floreantpos.model.base.BaseMenuItem;
import com.floreantpos.model.base.BaseMenuModifier;
import com.floreantpos.model.base.BaseModifierGroup;
import com.floreantpos.model.base.BasePrinterGroup;
import com.floreantpos.model.base.BaseTax;
import com.floreantpos.model.base.BaseTaxGroup;
import com.floreantpos.model.base.BaseUser;
import com.floreantpos.model.base.BaseUserType;
import com.floreantpos.model.dao.InventoryUnitDAO;
import com.floreantpos.model.dao.InventoryUnitGroupDAO;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuItemModifierSpecDAO;
import com.floreantpos.model.dao.MenuModifierDAO;
import com.floreantpos.model.dao.MenuPageDAO;
import com.floreantpos.model.dao.MenuPageItemDAO;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.model.dao.PrinterGroupDAO;
import com.floreantpos.model.dao.TaxDAO;
import com.floreantpos.model.dao.TaxGroupDAO;
import com.floreantpos.model.dao.UserDAO;
import com.floreantpos.model.dao.UserTypeDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.ProgressObserver;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.datamigrate.Elements;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Unmarshaller;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.io.IOUtils;
import org.hibernate.Session;

public class DataImportAction
extends AbstractAction {
    public DataImportAction() {
        super(Messages.getString("DataImportAction.0"));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = DataExportAction.getFileChooser();
        int n = jFileChooser.showOpenDialog(POSUtil.getBackOfficeWindow());
        if (n != 0) {
            return;
        }
        File file = jFileChooser.getSelectedFile();
        try {
            DataImportDialog dataImportDialog = new DataImportDialog(file);
            dataImportDialog.setSize(PosUIManager.getSize(800, 550));
            dataImportDialog.open();
            if (dataImportDialog.isCanceled()) {
                return;
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
        }
    }

    public static Elements importMenuItemsFromFile(File file) throws Exception {
        if (file == null) {
            new FileNotFoundException("File Not Found");
        }
        FileInputStream fileInputStream = new FileInputStream(file);
        return DataImportAction.loadMenuItems(fileInputStream);
    }

    public static boolean saveImportedMenuItems(Elements elements, ProgressObserver progressObserver) throws Exception {
        try {
            DataImportAction.importMenuItems(elements, progressObserver);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw exception;
        }
        DataImportAction.b();
        return true;
    }

    public static Elements loadMenuItems(InputStream inputStream) throws Exception {
        try {
            Elements elements;
            JAXBContext jAXBContext = JAXBContext.newInstance((Class[])new Class[]{Elements.class});
            Unmarshaller unmarshaller = jAXBContext.createUnmarshaller();
            Elements elements2 = elements = (Elements)unmarshaller.unmarshal(inputStream);
            return elements2;
        }
        catch (Exception exception) {
            throw exception;
        }
        finally {
            IOUtils.closeQuietly((InputStream)inputStream);
        }
    }

    public static void importMenuItems(Elements elements, ProgressObserver progressObserver) throws Exception {
        Comparable comparable;
        Comparable comparable2;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        Object object9;
        Object object10;
        List<Comparable> list;
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        TaxGroup taxGroup = DataImportAction.a();
        List<TaxGroup> list2 = elements.getTaxGroups();
        if (list2 != null) {
            list = list2.iterator();
            while (list.hasNext()) {
                object10 = (TaxGroup)list.next();
                object9 = TaxGroupDAO.getInstance().get(((BaseTaxGroup)object10).getId());
                object8 = new ArrayList();
                if (((BaseTaxGroup)object10).getTaxes() != null) {
                    object7 = ((BaseTaxGroup)object10).getTaxes().iterator();
                    while (object7.hasNext()) {
                        object6 = (Tax)object7.next();
                        object5 = (Tax)hashMap.get(((Tax)object6).getUniqueId());
                        object8.add(object5);
                    }
                }
                ((BaseTaxGroup)object10).setTaxes((List<Tax>)object8);
                if (object9 == null) {
                    TaxGroupDAO.getInstance().save((TaxGroup)object10);
                } else {
                    ((BaseTaxGroup)object10).setId(((BaseTaxGroup)object9).getId());
                    ((BaseTaxGroup)object10).setVersion(((BaseTaxGroup)object9).getVersion());
                    PropertyUtils.copyProperties((Object)object9, (Object)object10);
                    TaxGroupDAO.getInstance().update((TaxGroup)object9);
                    object10 = object9;
                }
                hashMap.put(((TaxGroup)object10).getUniqueId(), object10);
                progressObserver.progress("Tax Group " + ((TaxGroup)object10).toString());
            }
        } else {
            list = elements.getTaxes();
            if (list != null) {
                object10 = list.iterator();
                while (object10.hasNext()) {
                    object9 = (Tax)object10.next();
                    object8 = TaxDAO.getInstance().get(((BaseTax)object9).getId());
                    if (object8 == null) {
                        TaxDAO.getInstance().save((Tax)object9);
                        taxGroup.addTotaxes((Tax)object8);
                        TaxGroupDAO.getInstance().update(taxGroup);
                    } else {
                        ((BaseTax)object9).setId(((BaseTax)object8).getId());
                        ((BaseTax)object9).setVersion(((BaseTax)object8).getVersion());
                        PropertyUtils.copyProperties((Object)object8, (Object)object9);
                        TaxDAO.getInstance().update((Tax)object8);
                        taxGroup.addTotaxes((Tax)object8);
                        TaxGroupDAO.getInstance().update(taxGroup);
                        object9 = object8;
                    }
                    progressObserver.progress("Tax " + ((Tax)object9).toString());
                    hashMap.put(((Tax)object9).getUniqueId(), object9);
                }
            }
        }
        if ((list = elements.getUnitGroups()) != null) {
            object10 = list.iterator();
            while (object10.hasNext()) {
                object9 = (InventoryUnitGroup)object10.next();
                object8 = InventoryUnitGroupDAO.getInstance().findByName(((BaseInventoryUnitGroup)object9).getName());
                ((BaseInventoryUnitGroup)object9).setUnits(null);
                if (object8 == null) {
                    InventoryUnitGroupDAO.getInstance().save((InventoryUnitGroup)object9);
                } else {
                    ((BaseInventoryUnitGroup)object9).setId(((BaseInventoryUnitGroup)object8).getId());
                    ((BaseInventoryUnitGroup)object9).setVersion(((BaseInventoryUnitGroup)object8).getVersion());
                    PropertyUtils.copyProperties((Object)object8, (Object)object9);
                    InventoryUnitGroupDAO.getInstance().update((InventoryUnitGroup)object8);
                    object9 = object8;
                }
                if (object8 == null) {
                    hashMap.put(((BaseInventoryUnitGroup)object9).getId(), object9);
                } else {
                    hashMap.put(((BaseInventoryUnitGroup)object8).getId(), object9);
                }
                progressObserver.progress("Unit Group " + ((InventoryUnitGroup)object9).toString());
            }
        }
        if ((object10 = elements.getUnits()) != null) {
            object9 = object10.iterator();
            while (object9.hasNext()) {
                object8 = (InventoryUnit)object9.next();
                object7 = InventoryUnitDAO.getInstance().get(((BaseInventoryUnit)object8).getId());
                object6 = ((BaseInventoryUnit)object8).getUnitGroupId();
                object5 = (InventoryUnitGroup)hashMap.get(object6);
                if (object5 != null) {
                    ((BaseInventoryUnit)object8).setUnitGroupId(((BaseInventoryUnitGroup)object5).getId());
                } else {
                    ((BaseInventoryUnit)object8).setUnitGroupId(null);
                }
                if (object7 == null) {
                    InventoryUnitDAO.getInstance().save((InventoryUnit)object8);
                } else {
                    ((BaseInventoryUnit)object8).setId(((BaseInventoryUnit)object7).getId());
                    ((BaseInventoryUnit)object8).setVersion(((BaseInventoryUnit)object7).getVersion());
                    PropertyUtils.copyProperties((Object)object7, (Object)object8);
                    InventoryUnitDAO.getInstance().update((InventoryUnit)object7);
                    object8 = object7;
                }
                hashMap.put(((InventoryUnit)object8).getUniqueId(), object8);
                progressObserver.progress("Unit " + ((InventoryUnit)object8).toString());
            }
        }
        if ((object9 = elements.getMenuCategories()) != null) {
            object8 = object9.iterator();
            while (object8.hasNext()) {
                object7 = (MenuCategory)object8.next();
                object6 = MenuCategoryDAO.getInstance().get(((BaseMenuCategory)object7).getId());
                if (object6 == null) {
                    MenuCategoryDAO.getInstance().save((MenuCategory)object7);
                } else {
                    ((BaseMenuCategory)object7).setId(((BaseMenuCategory)object6).getId());
                    ((BaseMenuCategory)object7).setVersion(((BaseMenuCategory)object6).getVersion());
                    PropertyUtils.copyProperties((Object)object6, (Object)object7);
                    MenuCategoryDAO.getInstance().update((MenuCategory)object7);
                    object7 = object6;
                }
                hashMap.put(((MenuCategory)object7).getUniqueId(), object7);
                progressObserver.progress("Menu Category " + ((MenuCategory)object7).toString());
            }
        }
        if ((object8 = elements.getMenuGroups()) != null) {
            object7 = object8.iterator();
            while (object7.hasNext()) {
                object6 = (MenuGroup)object7.next();
                object5 = MenuGroupDAO.getInstance().get(((BaseMenuGroup)object6).getId());
                if (object5 == null) {
                    MenuGroupDAO.getInstance().save((MenuGroup)object6);
                } else {
                    ((BaseMenuGroup)object6).setId(((BaseMenuGroup)object5).getId());
                    ((BaseMenuGroup)object6).setVersion(((BaseMenuGroup)object5).getVersion());
                    PropertyUtils.copyProperties((Object)object5, (Object)object6);
                    MenuGroupDAO.getInstance().update((MenuGroup)object5);
                    object6 = object5;
                }
                hashMap.put(((MenuGroup)object6).getUniqueId(), object6);
                progressObserver.progress("Menu Group " + ((MenuGroup)object6).toString());
            }
        }
        if ((object7 = elements.getMenuModifiers()) != null) {
            object6 = object7.iterator();
            while (object6.hasNext()) {
                object5 = (MenuModifier)object6.next();
                object4 = MenuModifierDAO.getInstance().get(((BaseMenuModifier)object5).getId());
                object3 = ((MenuModifier)object5).getTaxGroup();
                if (object3 != null) {
                    object3 = (TaxGroup)hashMap.get(((TaxGroup)object3).getUniqueId());
                    ((MenuModifier)object5).setTaxGroup((TaxGroup)object3);
                }
                ((MenuModifier)object5).setTaxGroup(null);
                if (object4 == null) {
                    MenuModifierDAO.getInstance().save((MenuModifier)object5);
                } else {
                    ((BaseMenuModifier)object5).setId(((BaseMenuModifier)object4).getId());
                    ((BaseMenuModifier)object5).setVersion(((BaseMenuModifier)object4).getVersion());
                    PropertyUtils.copyProperties((Object)object4, (Object)object5);
                    MenuModifierDAO.getInstance().update((MenuModifier)object4);
                    object5 = object4;
                }
                hashMap.put(((MenuModifier)object5).getUniqueId(), object5);
                progressObserver.progress("Menu Modifier " + ((MenuModifier)object5).toString());
            }
        }
        if ((object6 = elements.getModifierGroups()) != null) {
            object5 = object6.iterator();
            while (object5.hasNext()) {
                object4 = (ModifierGroup)object5.next();
                object3 = ModifierGroupDAO.getInstance().get(((BaseModifierGroup)object4).getId());
                object2 = new ArrayList();
                if (((BaseModifierGroup)object4).getModifiers() != null) {
                    object = ((BaseModifierGroup)object4).getModifiers().iterator();
                    while (object.hasNext()) {
                        comparable2 = (MenuModifier)object.next();
                        comparable = (MenuModifier)hashMap.get(((MenuModifier)comparable2).getUniqueId());
                        object2.add(comparable);
                    }
                }
                ((BaseModifierGroup)object4).setModifiers((List<MenuModifier>)object2);
                if (object3 == null) {
                    ModifierGroupDAO.getInstance().save((ModifierGroup)object4);
                } else {
                    ((BaseModifierGroup)object4).setId(((BaseModifierGroup)object3).getId());
                    ((BaseModifierGroup)object4).setVersion(((BaseModifierGroup)object3).getVersion());
                    PropertyUtils.copyProperties((Object)object3, (Object)object4);
                    ModifierGroupDAO.getInstance().update((ModifierGroup)object3);
                    object4 = object3;
                }
                hashMap.put(((ModifierGroup)object4).getUniqueId(), object4);
                progressObserver.progress("Modifier Group " + ((ModifierGroup)object4).toString());
            }
        }
        if ((object5 = elements.getMenuItems()) != null) {
            object4 = object5.iterator();
            while (object4.hasNext()) {
                List<MenuItemModifierSpec> list3;
                object3 = (MenuItem)object4.next();
                object2 = null;
                if (((BaseMenuItem)object3).getId() != null) {
                    object2 = MenuItemDAO.getInstance().get(((BaseMenuItem)object3).getId());
                }
                if ((object = ((MenuItem)object3).getPrinterGroup()) != null) {
                    comparable2 = PrinterGroupDAO.getInstance().findByName(((BasePrinterGroup)object).getName());
                    if (comparable2 == null) {
                        comparable2 = new PrinterGroup();
                        PropertyUtils.copyProperties((Object)comparable2, (Object)object);
                        PrinterGroupDAO.getInstance().save((PrinterGroup)comparable2);
                    }
                    ((BasePrinterGroup)object).setId(((BasePrinterGroup)comparable2).getId());
                }
                if ((comparable2 = ((MenuItem)object3).getTaxGroup()) != null) {
                    comparable2 = (TaxGroup)hashMap.get(((TaxGroup)comparable2).getUniqueId());
                    ((MenuItem)object3).setTaxGroup((TaxGroup)comparable2);
                }
                if ((comparable = ((MenuItem)object3).getUnit()) != null) {
                    comparable = (InventoryUnit)hashMap.get(comparable.getUniqueId());
                    ((MenuItem)object3).setUnit((InventoryUnit)comparable);
                }
                if ((list3 = ((BaseMenuItem)object3).getMenuItemModiferSpecs()) != null) {
                    MenuItem.copyModifierSpecsToMenuItem((MenuItem)object3, list3);
                    for (MenuItemModifierSpec menuItemModifierSpec : ((BaseMenuItem)object3).getMenuItemModiferSpecs()) {
                        Set<MenuItemModifierPage> set;
                        ModifierGroup modifierGroup = menuItemModifierSpec.getModifierGroup();
                        if (modifierGroup != null) {
                            menuItemModifierSpec.setModifierGroup((ModifierGroup)hashMap.get(modifierGroup.getUniqueId()));
                        }
                        if ((set = menuItemModifierSpec.getModifierPages()) != null) {
                            for (MenuItemModifierPage menuItemModifierPage : set) {
                                List<MenuItemModifierPageItem> list4 = menuItemModifierPage.getPageItems();
                                if (list4 == null) continue;
                                for (MenuItemModifierPageItem menuItemModifierPageItem : list4) {
                                    MenuModifier menuModifier = menuItemModifierPageItem.getMenuModifier();
                                    if (menuModifier == null) continue;
                                    menuItemModifierPageItem.setMenuModifier((MenuModifier)hashMap.get(menuModifier.getUniqueId()));
                                }
                            }
                        }
                        MenuItemModifierSpecDAO.getInstance().save(menuItemModifierSpec);
                    }
                }
                ((BaseMenuItem)object3).setAttributes(null);
                ((BaseMenuItem)object3).setComboItems(null);
                ((BaseMenuItem)object3).setComboGroups(null);
                ((MenuItem)object3).setParentMenuItem(null);
                ((BaseMenuItem)object3).setVariants(null);
                ((BaseMenuItem)object3).setStockUnits(null);
                try {
                    if (object2 == null) {
                        MenuItemModifierSpec menuItemModifierSpec;
                        ((BaseMenuItem)object3).setVersion(0L);
                        Session session = MenuItemDAO.getInstance().createNewSession();
                        menuItemModifierSpec = session.beginTransaction();
                        MenuItemDAO.getInstance().save((MenuItem)object3, session);
                        menuItemModifierSpec.commit();
                        session.close();
                    } else {
                        ((BaseMenuItem)object3).setId(((BaseMenuItem)object2).getId());
                        ((BaseMenuItem)object3).setVersion(((BaseMenuItem)object2).getVersion());
                        PropertyUtils.copyProperties((Object)object2, (Object)object3);
                        MenuItemDAO.getInstance().update((MenuItem)object2);
                        object3 = object2;
                    }
                    hashMap.put(((MenuItem)object3).getUniqueId(), object3);
                    progressObserver.progress("Menu Item " + ((MenuItem)object3).toString());
                }
                catch (Exception exception) {}
            }
        }
        if ((object4 = elements.getUsers()) != null) {
            object3 = object4.iterator();
            while (object3.hasNext()) {
                object2 = (User)object3.next();
                object = UserDAO.getInstance().get(((BaseUser)object2).getId());
                if (object == null) {
                    UserDAO.getInstance().save((User)object2);
                } else {
                    ((BaseUser)object2).setId(((BaseUser)object).getId());
                    ((BaseUser)object2).setVersion(((BaseUser)object).getVersion());
                    PropertyUtils.copyProperties((Object)object, (Object)object2);
                    UserDAO.getInstance().update((User)object2);
                    object2 = object;
                }
                hashMap.put(((BaseUser)object2).getId(), object2);
                progressObserver.progress("User " + ((User)object2).toString());
            }
        }
        if ((object3 = elements.getUserTypes()) != null) {
            object2 = object3.iterator();
            while (object2.hasNext()) {
                object = (UserType)object2.next();
                comparable2 = UserTypeDAO.getInstance().get(((BaseUserType)object).getId());
                if (comparable2 == null) {
                    UserTypeDAO.getInstance().save((UserType)object);
                } else {
                    ((BaseUserType)object).setId(((BaseUserType)comparable2).getId());
                    ((BaseUserType)object).setVersion(((BaseUserType)comparable2).getVersion());
                    PropertyUtils.copyProperties((Object)comparable2, (Object)object);
                    UserTypeDAO.getInstance().update((UserType)object);
                    object = comparable2;
                }
                hashMap.put(((BaseUserType)object).getId(), object);
                progressObserver.progress("User type " + ((UserType)object).toString());
            }
        }
    }

    private static TaxGroup a() {
        TaxGroup taxGroup;
        List<TaxGroup> list = TaxGroupDAO.getInstance().findAll();
        if (list.size() > 0) {
            taxGroup = list.get(0);
        } else {
            taxGroup = new TaxGroup();
            taxGroup.setName("default");
            TaxGroupDAO.getInstance().save(taxGroup);
        }
        return taxGroup;
    }

    private static void b() {
        List<MenuGroup> list = MenuGroupDAO.getInstance().findAll();
        if (list == null) {
            return;
        }
        for (MenuGroup menuGroup : list) {
            List<MenuItem> list2 = MenuItemDAO.getInstance().findByParent(null, menuGroup, true);
            if (list2 == null || list2.isEmpty()) continue;
            int n = 0;
            DataImportAction.a(menuGroup, list2, n, 1);
        }
    }

    private static void a(MenuGroup menuGroup, List<MenuItem> list, int n, int n2) {
        try {
            MenuPage menuPage = new MenuPage();
            menuPage.setMenuGroupId(menuGroup.getId());
            menuPage.setName("Page " + n2);
            menuPage.setRows(4);
            menuPage.setCols(4);
            for (int i = 0; i < 4 && n < list.size(); ++i) {
                for (int j = 0; j < 4 && n < list.size(); ++n, ++j) {
                    MenuPageItem menuPageItem = new MenuPageItem(j, i);
                    menuPageItem.setMenuPage(menuPage);
                    menuPageItem.setMenuItem(list.get(n));
                    MenuPageItemDAO.getInstance().saveOrUpdate(menuPageItem);
                }
            }
            MenuPageDAO.getInstance().saveOrUpdate(menuPage);
            if (n >= list.size()) {
                return;
            }
            DataImportAction.a(menuGroup, list, n, n2++);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            BOMessageDialog.showError(exception.getMessage());
        }
    }
}

