/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.DayPart;
import com.floreantpos.model.Shift;
import com.floreantpos.model.dao.DayPartDAO;
import com.floreantpos.model.dao.ShiftDAO;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.ShiftEntryDialog;
import com.floreantpos.util.POSUtil;
import com.floreantpos.util.ShiftUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import org.hibernate.exception.ConstraintViolationException;

public class BusinessHourExplorer
extends TransparentPanel {
    private JTable a;
    private ShiftTableModel b;

    public BusinessHourExplorer() {
        List<DayPart> list = new DayPartDAO().findAll();
        this.b = new ShiftTableModel(list);
        this.a = new JTable(this.b);
        this.a.setRowHeight(PosUIManager.getSize(30));
        this.a.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane(this.a));
        this.a.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    this.a();
                }
            }

            private void a() {
                try {
                    int n = BusinessHourExplorer.this.a.getSelectedRow();
                    if (n < 0) {
                        return;
                    }
                    DayPart dayPart = (DayPart)BusinessHourExplorer.this.b.getRowData(n);
                    ShiftEntryDialog shiftEntryDialog = new ShiftEntryDialog();
                    shiftEntryDialog.setShift(dayPart);
                    shiftEntryDialog.open();
                    if (shiftEntryDialog.isCanceled()) {
                        return;
                    }
                    BusinessHourExplorer.this.b.updateItem(n);
                }
                catch (Throwable throwable) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        JButton jButton = new JButton(POSConstants.ADD);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ShiftEntryDialog shiftEntryDialog = new ShiftEntryDialog();
                    shiftEntryDialog.open();
                    if (shiftEntryDialog.isCanceled()) {
                        return;
                    }
                    DayPart dayPart = shiftEntryDialog.getShift();
                    BusinessHourExplorer.this.b.addItem(dayPart);
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        JButton jButton2 = new JButton(POSConstants.EDIT);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = BusinessHourExplorer.this.a.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), "Please select a row to edit!");
                        return;
                    }
                    DayPart dayPart = (DayPart)BusinessHourExplorer.this.b.getRowData(n);
                    ShiftEntryDialog shiftEntryDialog = new ShiftEntryDialog();
                    shiftEntryDialog.setShift(dayPart);
                    shiftEntryDialog.open();
                    if (shiftEntryDialog.isCanceled()) {
                        return;
                    }
                    BusinessHourExplorer.this.b.updateItem(n);
                }
                catch (Throwable throwable) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        JButton jButton3 = new JButton(POSConstants.DELETE);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = BusinessHourExplorer.this.a.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), "Please select a row to delete!");
                        return;
                    }
                    if (ConfirmDeleteDialog.showMessage(BusinessHourExplorer.this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                        Shift shift = (Shift)BusinessHourExplorer.this.b.getRowData(n);
                        ShiftDAO.getInstance().delete(shift);
                        BusinessHourExplorer.this.b.deleteItem(n);
                    }
                }
                catch (ConstraintViolationException constraintViolationException) {
                    BOMessageDialog.showError(POSConstants.SHIFT_ERROR, constraintViolationException);
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(jButton);
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton3);
        this.add((Component)transparentPanel, "South");
    }

    class ShiftTableModel
    extends ListTableModel {
        ShiftTableModel(List list) {
            super(new String[]{POSConstants.ID, POSConstants.NAME, POSConstants.START_TIME, POSConstants.END_TIME}, list);
        }

        @Override
        public Object getValueAt(int n, int n2) {
            DayPart dayPart = (DayPart)this.rows.get(n);
            switch (n2) {
                case 0: {
                    return String.valueOf(dayPart.getId());
                }
                case 1: {
                    return dayPart.getName();
                }
                case 2: {
                    return ShiftUtil.buildShiftTimeRepresentation(dayPart.getStartTime());
                }
                case 3: {
                    return ShiftUtil.buildShiftTimeRepresentation(dayPart.getEndTime());
                }
            }
            return null;
        }
    }
}

