/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.ComboGroup;
import com.floreantpos.model.ComboItem;
import com.floreantpos.model.MenuItem;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.model.ComboGroupItemSelectionDialog;
import com.floreantpos.ui.model.ComboItemEntryDialog;
import com.floreantpos.util.NumberUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import net.miginfocom.swing.MigLayout;

public class ComboItemExplorer
extends TransparentPanel
implements ActionListener {
    private JTable a;
    private JTable b;
    private final ComboItemExplorerTableModel c;
    private final ComboGroupExplorerTableModel d;
    private MenuItem e;

    public ComboItemExplorer() {
        this.a();
        this.c = new ComboItemExplorerTableModel();
        this.a.setModel(this.c);
        this.d = new ComboGroupExplorerTableModel();
        this.b.setModel(this.d);
        this.b();
    }

    private void a() {
        this.setLayout((LayoutManager)new MigLayout("fill"));
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.a = new JTable();
        this.a.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.a.setRowHeight(30);
        JButton jButton = new JButton(POSConstants.ADD);
        jButton.setActionCommand(POSConstants.ADD);
        jButton.addActionListener(this);
        JButton jButton2 = new JButton(POSConstants.EDIT);
        jButton2.setActionCommand(POSConstants.EDIT);
        jButton2.addActionListener(this);
        JButton jButton3 = new JButton(POSConstants.DELETE);
        jButton3.setActionCommand(POSConstants.DELETE);
        jButton3.addActionListener(this);
        TransparentPanel transparentPanel = new TransparentPanel((LayoutManager)new MigLayout("inset 0 0 10 0"));
        transparentPanel.add(jButton);
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton3);
        this.add((Component)new JScrollPane(this.a), "grow");
        this.add((Component)transparentPanel, "grow,newline");
        this.b = new JTable();
        this.b.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.b.setRowHeight(30);
        JButton jButton4 = new JButton(POSConstants.ADD);
        jButton4.setActionCommand(POSConstants.ADD);
        JButton jButton5 = new JButton(POSConstants.EDIT);
        jButton5.setActionCommand(POSConstants.EDIT);
        JButton jButton6 = new JButton(POSConstants.DELETE);
        jButton6.setActionCommand(POSConstants.DELETE);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = actionEvent.getActionCommand();
                if (POSConstants.ADD.equals(string)) {
                    ComboItemExplorer.this.d();
                } else if (POSConstants.EDIT.equals(string)) {
                    int n = ComboItemExplorer.this.b.getSelectedRow();
                    if (n < 0) {
                        BOMessageDialog.showError("Please select one item.");
                        return;
                    }
                    ComboGroup comboGroup = ComboItemExplorer.this.d.getComboGroup(n);
                    ComboItemExplorer.this.a(comboGroup);
                } else if (POSConstants.DELETE.equals(string)) {
                    int n = ComboItemExplorer.this.b.getSelectedRow();
                    if (n < 0) {
                        BOMessageDialog.showError(POSConstants.SELECT_ITEM_TO_DELETE);
                        return;
                    }
                    ComboGroup comboGroup = ComboItemExplorer.this.d.getComboGroup(n);
                    ComboItemExplorer.this.a(n, comboGroup);
                }
            }
        };
        jButton4.addActionListener(actionListener);
        jButton5.addActionListener(actionListener);
        jButton6.addActionListener(actionListener);
        TransparentPanel transparentPanel2 = new TransparentPanel((LayoutManager)new MigLayout("inset 0 0 10 0"));
        transparentPanel2.add(jButton4);
        transparentPanel2.add(jButton5);
        transparentPanel2.add(jButton6);
        this.add((Component)new JScrollPane(this.b), "grow,newline");
        this.add((Component)transparentPanel2, "grow,newline");
    }

    private void b() {
        this.b.setAutoResizeMode(4);
        this.a(0, PosUIManager.getSize(300));
        this.a(1, PosUIManager.getSize(100));
        this.a(2, PosUIManager.getSize(100));
    }

    private void a(int n, int n2) {
        TableColumn tableColumn = this.b.getColumnModel().getColumn(n);
        tableColumn.setPreferredWidth(n2);
        tableColumn.setMaxWidth(n2);
        tableColumn.setMinWidth(n2);
    }

    public void setMenuItem(MenuItem menuItem) {
        this.e = menuItem;
        this.c.setItems(menuItem.getComboItems());
        this.d.setItems(menuItem.getComboGroups());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (POSConstants.ADD.equals(string)) {
            this.c();
        } else if (POSConstants.EDIT.equals(string)) {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                BOMessageDialog.showError("Please select one item.");
                return;
            }
            ComboItem comboItem = this.c.getComboItem(n);
            this.a(comboItem);
        } else if (POSConstants.DELETE.equals(string)) {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                BOMessageDialog.showError(POSConstants.SELECT_ITEM_TO_DELETE);
                return;
            }
            ComboItem comboItem = this.c.getComboItem(n);
            this.a(n, comboItem);
        }
    }

    private void c() {
        try {
            MenuItemSelectionDialog menuItemSelectionDialog = new MenuItemSelectionDialog(new ArrayList<MenuItem>());
            menuItemSelectionDialog.setSize(PosUIManager.getSize(600, 515));
            menuItemSelectionDialog.open();
            if (menuItemSelectionDialog.isCanceled()) {
                return;
            }
            ArrayList<MenuItem> arrayList = new ArrayList<MenuItem>();
            for (ComboItem object2 : this.c.getItems()) {
                arrayList.add(object2.getMenuItem());
            }
            List<MenuItem> list = menuItemSelectionDialog.getSelectedItems();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                MenuItem menuItem = (MenuItem)iterator.next();
                if (arrayList == null || arrayList.contains(menuItem)) continue;
                ComboItem comboItem = new ComboItem();
                comboItem.setMenuItem(menuItem);
                comboItem.setQuantity(1.0);
                this.c.addComboItem(comboItem);
            }
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(ComboItem comboItem) {
        try {
            ComboItemEntryDialog comboItemEntryDialog = new ComboItemEntryDialog(this.e);
            comboItemEntryDialog.setSelectedItem(comboItem.getMenuItem());
            comboItemEntryDialog.setQuantity(comboItem.getQuantity());
            comboItemEntryDialog.open();
            if (comboItemEntryDialog.isCanceled()) {
                return;
            }
            MenuItem menuItem = comboItemEntryDialog.getItem();
            comboItem.setMenuItem(menuItem);
            comboItem.setQuantity(comboItemEntryDialog.getQuantity());
            this.c.fireTableDataChanged();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void a(int n, ComboItem comboItem) {
        try {
            if (ConfirmDeleteDialog.showMessage(this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                this.c.deleteItem(comboItem, n);
            }
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void d() {
        try {
            ComboGroup comboGroup = new ComboGroup();
            ComboGroupItemSelectionDialog comboGroupItemSelectionDialog = new ComboGroupItemSelectionDialog(this.e, comboGroup);
            comboGroupItemSelectionDialog.setSize(PosUIManager.getSize(600, 600));
            comboGroupItemSelectionDialog.open();
            if (comboGroupItemSelectionDialog.isCanceled()) {
                return;
            }
            this.d.addComboGroup(comboGroup);
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void a(ComboGroup comboGroup) {
        try {
            ComboGroupItemSelectionDialog comboGroupItemSelectionDialog = new ComboGroupItemSelectionDialog(this.e, comboGroup, true);
            comboGroupItemSelectionDialog.setSize(PosUIManager.getSize(600, 600));
            comboGroupItemSelectionDialog.open();
            if (comboGroupItemSelectionDialog.isCanceled()) {
                return;
            }
            this.d.fireTableDataChanged();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void a(int n, ComboGroup comboGroup) {
        try {
            if (ConfirmDeleteDialog.showMessage(this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                this.d.deleteItem(comboGroup, n);
            }
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    public List<ComboItem> getSelectedComboItems() {
        return this.c.getItems();
    }

    public List<ComboGroup> getSelectedComboGroups() {
        return this.d.getGroups();
    }

    private class ComboGroupExplorerTableModel
    extends AbstractTableModel {
        String[] a = new String[]{"Group Name", "Min Quantity", "Max Quantity", "Items"};
        List<ComboGroup> b = new ArrayList<ComboGroup>();

        public void setItems(List<ComboGroup> list) {
            if (list == null) {
                return;
            }
            this.b.addAll(list);
        }

        @Override
        public int getRowCount() {
            if (this.b == null) {
                return 0;
            }
            return this.b.size();
        }

        @Override
        public int getColumnCount() {
            return this.a.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.a[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.b == null) {
                return "";
            }
            ComboGroup comboGroup = this.b.get(n);
            if (comboGroup == null) {
                return "";
            }
            switch (n2) {
                case 0: {
                    return comboGroup.getName();
                }
                case 1: {
                    return comboGroup.getMinQuantity();
                }
                case 2: {
                    return comboGroup.getMaxQuantity();
                }
                case 3: {
                    return comboGroup.getItems();
                }
            }
            return null;
        }

        public void addComboGroup(ComboGroup comboGroup) {
            int n = this.b.size();
            this.b.add(comboGroup);
            this.fireTableRowsInserted(n, n);
        }

        public void deleteItem(ComboGroup comboGroup, int n) {
            Iterator<ComboGroup> iterator = this.b.iterator();
            while (iterator.hasNext()) {
                ComboGroup comboGroup2 = iterator.next();
                if (!comboGroup.getName().equals(comboGroup2.getName())) continue;
                iterator.remove();
                break;
            }
            this.fireTableRowsDeleted(n, n);
        }

        public ComboGroup getComboGroup(int n) {
            return this.b.get(n);
        }

        public List<ComboGroup> getGroups() {
            return this.b;
        }
    }

    private class ComboItemExplorerTableModel
    extends AbstractTableModel {
        String[] a = new String[]{"Item Name", "Quantity", "Price"};
        List<ComboItem> b = new ArrayList<ComboItem>();

        public void setItems(List<ComboItem> list) {
            if (list == null) {
                return;
            }
            this.b.addAll(list);
        }

        public List<ComboItem> getItems() {
            return this.b;
        }

        @Override
        public int getRowCount() {
            if (this.b == null) {
                return 0;
            }
            return this.b.size();
        }

        @Override
        public int getColumnCount() {
            return this.a.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.a[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (this.b == null) {
                return "";
            }
            ComboItem comboItem = this.b.get(n);
            if (comboItem == null) {
                return "";
            }
            switch (n2) {
                case 0: {
                    return comboItem.getName();
                }
                case 1: {
                    return NumberUtil.trimDecilamIfNotNeeded(comboItem.getQuantity());
                }
                case 2: {
                    return comboItem.getPrice() * comboItem.getQuantity();
                }
            }
            return null;
        }

        public void addComboItem(ComboItem comboItem) {
            int n = this.b.size();
            this.b.add(comboItem);
            this.fireTableRowsInserted(n, n);
        }

        public void deleteItem(ComboItem comboItem, int n) {
            Iterator<ComboItem> iterator = this.b.iterator();
            while (iterator.hasNext()) {
                ComboItem comboItem2 = iterator.next();
                if (comboItem.getMenuItem() != comboItem2.getMenuItem()) continue;
                iterator.remove();
            }
            this.fireTableRowsDeleted(n, n);
        }

        public ComboItem getComboItem(int n) {
            return this.b.get(n);
        }
    }
}

