/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.CustomCellRenderer;
import com.floreantpos.main.Application;
import com.floreantpos.model.GiftCard;
import com.floreantpos.model.User;
import com.floreantpos.model.UserPermission;
import com.floreantpos.model.UserType;
import com.floreantpos.model.dao.GiftCardDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.POSDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.views.GiftCardBatchNumberEntryDialog;
import com.floreantpos.ui.views.GiftCardGeneratorView;
import com.floreantpos.ui.views.GiftCardHolderNameEntryView;
import com.floreantpos.ui.views.GiftCardImportCheckingDialog;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.LayoutManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.StringSelection;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;

public class GiftCardExplorer
extends TransparentPanel {
    private JXTable a;
    private BeanTableModel<GiftCard> b;
    private JTextField c;
    private Date d;
    private Date e;
    private JXDatePicker f;
    private JXDatePicker g;
    private Set<UserPermission> h;
    private Clipboard i;
    private JButton j;
    private JButton k;
    private JButton l;
    private JButton m;
    private JButton n;
    private JTextField o;
    private JButton p;
    private JButton q;
    private JButton r;
    private JButton s;
    private JButton t;
    private JButton u;
    private JLabel v;
    private JComboBox<GiftCardStatus> w;

    public GiftCardExplorer() {
        this.a();
        this.f();
    }

    private void a() {
        this.setLayout(new BorderLayout(5, 5));
        this.b = new BeanTableModel(GiftCard.class);
        this.b.addColumn(Messages.getString("GiftCardExplorer.42"), "customCardNumber");
        this.b.addColumn(Messages.getString("GiftCardExplorer.44"), "ownerName");
        this.b.addColumn(Messages.getString("GiftCardExplorer.46"), "pinNumber");
        this.b.addColumn(Messages.getString("GiftCardExplorer.48"), "batchNo");
        this.b.addColumn(Messages.getString("GiftCardExplorer.50"), "balance");
        this.b.addColumn(Messages.getString("GiftCardExplorer.52"), "issueDate");
        this.b.addColumn(Messages.getString("GiftCardExplorer.54"), "activationDate");
        this.b.addColumn(Messages.getString("GiftCardExplorer.56"), "deActivationDate");
        this.b.addColumn(Messages.getString("GiftCardExplorer.58"), "expiryDate");
        this.b.addColumn(Messages.getString("GiftCardExplorer.60"), "active");
        this.b.addColumn(Messages.getString("GiftCardExplorer.62"), "disable");
        this.b.addColumn(Messages.getString("GiftCardExplorer.64"), "duration");
        this.b.addColumn(Messages.getString("GiftCardExplorer.66"), "durationType");
        this.b.addColumn(Messages.getString("GiftCardExplorer.68"), "point");
        this.a = new JXTable(this.b);
        this.a.setDefaultRenderer(Object.class, (TableCellRenderer)new CustomCellRenderer());
        this.a.setRowHeight(PosUIManager.getSize(30));
        this.t = new JButton("<<< Previous");
        this.u = new JButton("Next >>>");
        this.v = new JLabel();
        this.t.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GiftCardExplorer.this.b.setCurrentRowIndex(GiftCardExplorer.this.b.getPreviousRowIndex());
                GiftCardExplorer.this.f();
            }
        });
        this.u.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GiftCardExplorer.this.b.setCurrentRowIndex(GiftCardExplorer.this.b.getNextRowIndex());
                GiftCardExplorer.this.f();
            }
        });
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx"));
        jPanel.add((Component)this.g(), "center");
        jPanel.add((Component)this.v, "right, split 3");
        jPanel.add(this.t);
        jPanel.add(this.u);
        this.add(new JScrollPane((Component)this.a));
        this.add((Component)jPanel, "South");
        this.add((Component)this.e(), "North");
        this.resizeColumnWidth((JTable)this.a);
        this.i();
        this.a.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (GiftCardExplorer.this.a.getSelectedRow() < 0) {
                    GiftCardExplorer.this.i();
                } else {
                    GiftCardExplorer.this.j();
                }
            }
        });
    }

    private void b() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                return;
            }
            this.i = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringBuilder stringBuilder = new StringBuilder(this.a.getStringAt(n, 0));
            for (int i = 0; i < stringBuilder.length(); ++i) {
                if (i != 4 && i != 8 && i != 12) continue;
                stringBuilder.deleteCharAt(i);
            }
            StringSelection stringSelection = new StringSelection(stringBuilder.toString());
            this.i.setContents(stringSelection, null);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Card no. copied to clipboard.");
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void c() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                return;
            }
            this.i = Toolkit.getDefaultToolkit().getSystemClipboard();
            StringBuilder stringBuilder = new StringBuilder(this.a.getStringAt(n, 3));
            StringSelection stringSelection = new StringSelection(stringBuilder.toString());
            this.i.setContents(stringSelection, null);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.0"));
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    private void d() {
        try {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(0);
            jFileChooser.setAcceptAllFileFilterUsed(false);
            jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("*.csv", "csv"));
            int n = jFileChooser.showOpenDialog(this);
            if (n == 1) {
                return;
            }
            File file = jFileChooser.getSelectedFile();
            if (file == null) {
                return;
            }
            GiftCardImportCheckingDialog giftCardImportCheckingDialog = new GiftCardImportCheckingDialog(file);
            giftCardImportCheckingDialog.openFullScreen();
            if (giftCardImportCheckingDialog.isCanceled()) {
                return;
            }
            List<GiftCard> list = giftCardImportCheckingDialog.getGiftCards();
            GiftCardDAO.getInstance().saveAsList(list);
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Data has been imported successfully.");
            this.f();
        }
        catch (Exception exception) {
            PosLog.error(GiftCardExplorer.class, exception.getMessage(), exception);
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), "Some error has been occured during import data!");
        }
    }

    public static String getSysClipboardText() {
        String string = "";
        Clipboard clipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
        Transferable transferable = clipboard.getContents(null);
        if (transferable != null && transferable.isDataFlavorSupported(DataFlavor.stringFlavor)) {
            try {
                string = (String)transferable.getTransferData(DataFlavor.stringFlavor);
            }
            catch (Exception exception) {
                PosLog.error(GiftCardExplorer.class, exception);
            }
        }
        return string;
    }

    private JPanel e() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("", "[][]15[][]15[][][]15[][]15[][]15[][]5[]", "[]5[]"));
        this.f = new JXDatePicker();
        this.g = new JXDatePicker();
        JLabel jLabel = new JLabel(Messages.getString("GiftCardExplorer.45"));
        this.c = new JTextField(15);
        JLabel jLabel2 = new JLabel(Messages.getString("GiftCardExplorer.47"));
        this.o = new JTextField(15);
        JLabel jLabel3 = new JLabel("Status");
        this.w = new JComboBox();
        this.w.setModel(new DefaultComboBoxModel<GiftCardStatus>(GiftCardStatus.values()));
        try {
            JButton jButton = new JButton(Messages.getString("MenuItemExplorer.3"));
            JButton jButton2 = new JButton(Messages.getString("GiftCardExplorer.1"));
            JButton jButton3 = new JButton(Messages.getString("GiftCardExplorer.2"));
            jPanel.add((Component)jLabel, "align label");
            jPanel.add(this.c);
            jPanel.add((Component)jLabel2, "align label");
            jPanel.add(this.o);
            jPanel.add(new JLabel(Messages.getString("GiftCardExplorer.3")));
            jPanel.add(new JLabel(Messages.getString("GiftCardExplorer.4")));
            jPanel.add((Component)this.f);
            jPanel.add(new JLabel(Messages.getString("GiftCardExplorer.5")));
            jPanel.add((Component)this.g);
            jPanel.add(jLabel3);
            jPanel.add(this.w);
            jPanel.add(jButton);
            jPanel.add(jButton2);
            jPanel.add(jButton3);
            Border border = BorderFactory.createEtchedBorder(1);
            TitledBorder titledBorder = BorderFactory.createTitledBorder(border, Messages.getString("GiftCardExplorer.49"));
            titledBorder.setTitleJustification(1);
            jPanel.setBorder(titledBorder);
            this.c.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GiftCardExplorer.this.f();
                }
            });
            this.o.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GiftCardExplorer.this.f();
                }
            });
            jButton3.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GiftCardExplorer.this.f.getEditor().setText(null);
                    GiftCardExplorer.this.g.getEditor().setText(null);
                    GiftCardExplorer.this.f.setDate(null);
                    GiftCardExplorer.this.g.setDate(null);
                    GiftCardExplorer.this.c.setText("");
                    GiftCardExplorer.this.o.setText("");
                    GiftCardExplorer.this.d = null;
                    GiftCardExplorer.this.e = null;
                    GiftCardExplorer.this.w.setSelectedItem((Object)GiftCardStatus.ALL);
                }
            });
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GiftCardExplorer.this.f();
                }
            });
            jButton2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GiftCardExplorer.this.f();
                }
            });
            this.c.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    GiftCardExplorer.this.f();
                }
            });
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
        return jPanel;
    }

    private void f() {
        String string = this.c.getText();
        String string2 = this.o.getText();
        this.d = this.f.getDate();
        this.e = this.g.getDate();
        if (this.d != null && this.e != null && this.d.after(this.e)) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        if (this.d != null) {
            this.d = DateUtil.startOfDay(this.d);
        }
        if (this.e != null) {
            this.e = DateUtil.endOfDay(this.e);
        }
        if (this.d == null && this.e != null) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.6"));
            return;
        }
        if (this.d != null && this.e == null) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.7"));
            return;
        }
        GiftCardStatus giftCardStatus = (GiftCardStatus)((Object)this.w.getSelectedItem());
        GiftCardDAO.getInstance().searchByCardAndIssueDate(string, string2, this.d, this.e, giftCardStatus.name(), this.b);
        int n = this.b.getCurrentRowIndex() + 1;
        int n2 = this.b.getNextRowIndex();
        int n3 = this.b.getNumRows();
        if (n2 > n3) {
            n2 = n3;
        }
        this.v.setText(String.format("Showing %s to %s of %s", n, n2, n3));
        this.t.setEnabled(this.b.hasPrevious());
        this.u.setEnabled(this.b.hasNext());
    }

    private TransparentPanel g() {
        this.j = new JButton(Messages.getString("GiftCardExplorer.9"));
        JButton jButton = new JButton("Add Gift Card");
        JButton jButton2 = new JButton(Messages.getString("GiftCardExplorer.10"));
        this.k = new JButton(Messages.getString("GiftCardExplorer.11"));
        this.l = new JButton(Messages.getString("GiftCardExplorer.12"));
        this.m = new JButton(Messages.getString("GiftCardExplorer.13"));
        this.n = new JButton(Messages.getString("GiftCardExplorer.14"));
        this.p = new JButton(Messages.getString("GiftCardExplorer.15"));
        this.q = new JButton(Messages.getString("GiftCardExplorer.16"));
        this.s = new JButton("Import CSV File");
        this.r = new JButton(Messages.getString("GiftCardExplorer.17"));
        User user = Application.getCurrentUser();
        UserType userType = user.getType();
        if (userType != null) {
            this.h = userType.getPermissions();
        }
        this.s.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GiftCardExplorer.this.d();
            }
        });
        this.r.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    GiftCardExplorer.this.l();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(GiftCardExplorer.this, exception.getMessage(), exception);
                }
            }
        });
        this.j.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GiftCardExplorer.this.b();
            }
        });
        this.p.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GiftCardExplorer.this.c();
            }
        });
        this.q.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GiftCardExplorer.this.k();
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GiftCardExplorer.this.r();
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GiftCardExplorer.this.q();
            }
        });
        this.n.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GiftCardExplorer.this.m();
            }
        });
        this.k.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GiftCardExplorer.this.n();
            }
        });
        this.l.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GiftCardExplorer.this.o();
            }
        });
        this.m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GiftCardExplorer.this.p();
            }
        });
        TransparentPanel transparentPanel = new TransparentPanel();
        if (this.h != null && this.h.contains(UserPermission.GENERATE_GIFT_CARD)) {
            transparentPanel.add(jButton);
            transparentPanel.add(jButton2);
            transparentPanel.add(this.j);
            transparentPanel.add(this.p);
            transparentPanel.add(this.k);
            transparentPanel.add(this.n);
            transparentPanel.add(this.l);
            transparentPanel.add(this.m);
            transparentPanel.add(this.q);
            transparentPanel.add(this.s);
            transparentPanel.add(this.r);
        }
        return transparentPanel;
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth((Integer)this.h().get(i));
        }
    }

    private List h() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(120);
        arrayList.add(150);
        arrayList.add(70);
        arrayList.add(100);
        arrayList.add(70);
        arrayList.add(70);
        arrayList.add(85);
        arrayList.add(90);
        arrayList.add(70);
        arrayList.add(50);
        arrayList.add(50);
        arrayList.add(50);
        arrayList.add(70);
        arrayList.add(50);
        return arrayList;
    }

    private void i() {
        this.j.setEnabled(false);
        this.k.setEnabled(false);
        this.n.setEnabled(false);
        this.l.setEnabled(false);
        this.m.setEnabled(false);
        this.p.setEnabled(false);
    }

    private void j() {
        this.j.setEnabled(true);
        this.k.setEnabled(true);
        this.n.setEnabled(true);
        this.l.setEnabled(true);
        this.m.setEnabled(true);
        this.p.setEnabled(true);
        this.r.setEnabled(true);
    }

    private void k() {
        try {
            GiftCardBatchNumberEntryDialog giftCardBatchNumberEntryDialog = new GiftCardBatchNumberEntryDialog();
            giftCardBatchNumberEntryDialog.setTitle(Messages.getString("GiftCardExplorer.23"));
            giftCardBatchNumberEntryDialog.setDefaultCloseOperation(2);
            giftCardBatchNumberEntryDialog.setSize(PosUIManager.getSize(400, 300));
            giftCardBatchNumberEntryDialog.setLocationRelativeTo(POSUtil.getFocusedWindow());
            giftCardBatchNumberEntryDialog.setVisible(true);
            if (giftCardBatchNumberEntryDialog.isCanceled()) {
                return;
            }
            if (giftCardBatchNumberEntryDialog.isActive()) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.24"));
                return;
            }
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            GiftCardDAO.getInstance().deleteCardListByBatchNumber(giftCardBatchNumberEntryDialog.getBatchNumber());
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.25"));
            this.f();
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void l() throws Exception {
        GiftCardDAO giftCardDAO = new GiftCardDAO();
        GiftCardBatchNumberEntryDialog giftCardBatchNumberEntryDialog = new GiftCardBatchNumberEntryDialog();
        giftCardBatchNumberEntryDialog.setTitle(Messages.getString("GiftCardExplorer.18"));
        giftCardBatchNumberEntryDialog.setDefaultCloseOperation(2);
        giftCardBatchNumberEntryDialog.setSize(PosUIManager.getSize(400, 300));
        giftCardBatchNumberEntryDialog.setLocationRelativeTo(POSUtil.getFocusedWindow());
        giftCardBatchNumberEntryDialog.setVisible(true);
        String string = giftCardBatchNumberEntryDialog.getBatchNumber();
        if (giftCardBatchNumberEntryDialog.isCanceled()) {
            return;
        }
        if (StringUtils.isEmpty((String)string)) {
            POSMessageDialog.showMessage(this, Messages.getString("GiftCardExplorer.19"));
            return;
        }
        List<GiftCard> list = giftCardDAO.findByBatchNumber(string);
        if (list == null) {
            POSMessageDialog.showMessage(this, Messages.getString("GiftCardExplorer.22") + string);
            return;
        }
        JFileChooser jFileChooser = this.a(string);
        Integer n = jFileChooser.showSaveDialog(this);
        if (n != 0) {
            return;
        }
        CSVPrinter cSVPrinter = null;
        FileWriter fileWriter = null;
        try {
            File file = jFileChooser.getSelectedFile();
            fileWriter = new FileWriter(file);
            CSVFormat cSVFormat = CSVFormat.DEFAULT.withRecordSeparator("\n");
            cSVPrinter = new CSVPrinter((Appendable)fileWriter, cSVFormat);
            Object[] objectArray = new Object[]{"Card Number", "Owner Name", "Balance", "Issue Date", "Activation Date", "Deactivation Date", "Expiration Date", "Active", "Disable", "Duration Type", "Duration", "Pin Number", "Point", "Batch Number", "Email", "Type"};
            cSVPrinter.printRecord(objectArray);
            for (GiftCard giftCard : list) {
                Object[] objectArray2 = new Object[16];
                String string2 = giftCard.getCardNumber();
                objectArray2[0] = "\"" + string2 + "\"";
                objectArray2[1] = giftCard.getOwnerName();
                objectArray2[2] = giftCard.getBalance();
                objectArray2[3] = giftCard.getIssueDate() != null ? DateUtil.formatDateAsString(giftCard.getIssueDate()) : "";
                objectArray2[4] = giftCard.getActivationDate() != null ? DateUtil.formatDateAsString(giftCard.getActivationDate()) : "";
                objectArray2[5] = giftCard.getDeActivationDate() != null ? DateUtil.formatDateAsString(giftCard.getDeActivationDate()) : "";
                objectArray2[6] = giftCard.getExpiryDate() != null ? DateUtil.formatDateAsString(giftCard.getExpiryDate()) : "";
                objectArray2[7] = giftCard.isActive();
                objectArray2[8] = giftCard.isDisable();
                objectArray2[9] = giftCard.getDurationType();
                objectArray2[10] = giftCard.getDuration();
                objectArray2[11] = giftCard.getPinNumber();
                objectArray2[12] = giftCard.getPoint();
                objectArray2[13] = giftCard.getBatchNo();
                objectArray2[14] = giftCard.getEmail();
                objectArray2[15] = giftCard.getType();
                cSVPrinter.printRecord(objectArray2);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(fileWriter);
            if (cSVPrinter != null) {
                cSVPrinter.close();
            }
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)fileWriter);
        if (cSVPrinter != null) {
            cSVPrinter.close();
        }
    }

    private JFileChooser a(String string) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.addChoosableFileFilter(new FileNameExtensionFilter("*.csv", "csv"));
        jFileChooser.setSelectedFile(new File(Messages.getString("GiftCardExplorer.20") + string + ".csv"));
        jFileChooser.setFileFilter(new FileFilter(){

            @Override
            public String getDescription() {
                return Messages.getString("GiftCardExplorer.21");
            }

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".csv");
            }
        });
        return jFileChooser;
    }

    private void m() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            GiftCard giftCard = this.b.getRow(n);
            giftCard = GiftCardDAO.getInstance().initialize(giftCard);
            String string = JOptionPane.showInputDialog(POSUtil.getFocusedWindow(), (Object)Messages.getString("GiftCardExplorer.27"));
            if (string == null) {
                return;
            }
            if (!StringUtils.isEmpty((String)string)) {
                if (string.length() > 8) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.28"));
                    return;
                }
                giftCard.setPinNumber(string);
                GiftCardDAO.getInstance().saveOrUpdate(giftCard);
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.29"));
                this.f();
            } else {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("PinCantEmpty"));
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    private void n() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            GiftCard giftCard = this.b.getRow(n);
            giftCard = GiftCardDAO.getInstance().initialize(giftCard);
            int n2 = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.30"), Messages.getString("GiftCardExplorer.31"));
            if (n2 == 0) {
                Serializable serializable;
                if (giftCard.isActive().booleanValue()) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.32"));
                    return;
                }
                if (giftCard.getOwnerName() == null) {
                    serializable = new GiftCardHolderNameEntryView();
                    ((Dialog)serializable).setTitle(Messages.getString("GiftCardExplorer.33"));
                    ((JDialog)serializable).setDefaultCloseOperation(2);
                    ((Window)serializable).setSize(PosUIManager.getSize(400, 300));
                    ((Window)serializable).setLocationRelativeTo(POSUtil.getFocusedWindow());
                    ((Dialog)serializable).setVisible(true);
                    if (((POSDialog)serializable).isCanceled()) {
                        return;
                    }
                    giftCard.setOwnerName(((GiftCardHolderNameEntryView)serializable).getCardHolderName());
                }
                serializable = Calendar.getInstance();
                Date date = ((Calendar)serializable).getTime();
                if (giftCard.getDurationType() != null) {
                    if (giftCard.getDurationType().equals("DAY")) {
                        ((Calendar)serializable).add(5, giftCard.getDuration());
                    } else if (giftCard.getDurationType().equals("MONTH")) {
                        ((Calendar)serializable).add(2, giftCard.getDuration());
                    } else {
                        ((Calendar)serializable).add(1, giftCard.getDuration());
                    }
                }
                Date date2 = ((Calendar)serializable).getTime();
                giftCard.setActive(true);
                giftCard.setActivationDate(date);
                giftCard.setDeActivationDate(null);
                giftCard.setExpiryDate(date2);
                giftCard.setActive(true);
                giftCard.setDisable(false);
                GiftCardDAO.getInstance().saveOrUpdate(giftCard);
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.34"));
                this.f();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    private void o() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            GiftCard giftCard = this.b.getRow(n);
            giftCard = GiftCardDAO.getInstance().initialize(giftCard);
            int n2 = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.35"), Messages.getString("GiftCardExplorer.36"));
            if (n2 == 0) {
                if (!giftCard.isActive().booleanValue()) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.37"));
                    return;
                }
                giftCard.setActive(false);
                giftCard.setDeActivationDate(new Date());
                GiftCardDAO.getInstance().saveOrUpdate(giftCard);
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.38"));
                this.f();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    private void p() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            GiftCard giftCard = this.b.getRow(n);
            giftCard = GiftCardDAO.getInstance().initialize(giftCard);
            int n2 = POSMessageDialog.showYesNoQuestionDialog(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.39"), Messages.getString("GiftCardExplorer.40"));
            if (n2 == 0) {
                giftCard.setDisable(true);
                giftCard.setActive(false);
                giftCard.setDeActivationDate(new Date());
                GiftCardDAO.getInstance().saveOrUpdate(giftCard);
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), Messages.getString("GiftCardExplorer.41"));
                this.f();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    private void q() {
        try {
            GiftCardGeneratorView giftCardGeneratorView = new GiftCardGeneratorView();
            giftCardGeneratorView.setTitle(Messages.getString("GiftCardExplorer.26"));
            giftCardGeneratorView.setDefaultCloseOperation(2);
            giftCardGeneratorView.setSize(PosUIManager.getSize(600, 400));
            giftCardGeneratorView.setLocationRelativeTo(POSUtil.getFocusedWindow());
            giftCardGeneratorView.setVisible(true);
            this.f();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    private void r() {
        try {
            GiftCardGeneratorView giftCardGeneratorView = new GiftCardGeneratorView(true);
            giftCardGeneratorView.setTitle(Messages.getString("GiftCardExplorer.26"));
            giftCardGeneratorView.setDefaultCloseOperation(2);
            giftCardGeneratorView.setSize(PosUIManager.getSize(600, 400));
            giftCardGeneratorView.setLocationRelativeTo(POSUtil.getFocusedWindow());
            giftCardGeneratorView.setVisible(true);
            this.f();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    public static class CellTransferable
    implements Transferable {
        public static final DataFlavor CELL_DATA_FLAVOR = new DataFlavor(Object.class, "application/x-cell-value");
        private Object a;

        public CellTransferable(Object object) {
            this.a = object;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return new DataFlavor[]{CELL_DATA_FLAVOR};
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            return CELL_DATA_FLAVOR.equals(dataFlavor);
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            return this.a;
        }
    }

    public static enum GiftCardStatus {
        ALL,
        ACTIVE,
        DEACTIVE,
        DISABLED;

    }
}

