/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.ExplorerButtonPanel;
import com.floreantpos.bo.ui.explorer.ExplorerView;
import com.floreantpos.model.ModifierGroup;
import com.floreantpos.model.dao.ModifierGroupDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.ModifierGroupForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXTable;

public class ModifierGroupExplorer
extends TransparentPanel
implements ExplorerView {
    private List<ModifierGroup> a;
    private JXTable b;
    private ModifierGroupExplorerTableModel c;

    public ModifierGroupExplorer() {
        this.setLayout(new BorderLayout(5, 5));
        this.c = new ModifierGroupExplorerTableModel();
        this.b = new JXTable((TableModel)this.c);
        this.b.setRowHeight(PosUIManager.getSize(30));
        this.b.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        this.add((Component)this.b(), "North");
        this.add(new JScrollPane((Component)this.b));
        this.a();
    }

    private void a() {
        TransparentPanel transparentPanel = new TransparentPanel();
        ExplorerButtonPanel explorerButtonPanel = new ExplorerButtonPanel();
        JButton jButton = explorerButtonPanel.getEditButton();
        JButton jButton2 = explorerButtonPanel.getAddButton();
        JButton jButton3 = explorerButtonPanel.getDeleteButton();
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = ModifierGroupExplorer.this.b.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                        return;
                    }
                    n = ModifierGroupExplorer.this.b.convertRowIndexToModel(n);
                    ModifierGroup modifierGroup = (ModifierGroup)ModifierGroupExplorer.this.a.get(n);
                    ModifierGroupForm modifierGroupForm = new ModifierGroupForm(modifierGroup);
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)modifierGroupForm);
                    beanEditorDialog.open();
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    ModifierGroupExplorer.this.b.repaint();
                }
                catch (Throwable throwable) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ModifierGroupForm modifierGroupForm = new ModifierGroupForm();
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)modifierGroupForm);
                    beanEditorDialog.open();
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    ModifierGroup modifierGroup = (ModifierGroup)modifierGroupForm.getBean();
                    ModifierGroupExplorer.this.c.addModifierGroup(modifierGroup);
                }
                catch (Throwable throwable) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = ModifierGroupExplorer.this.b.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                        return;
                    }
                    n = ModifierGroupExplorer.this.b.convertRowIndexToModel(n);
                    if (ConfirmDeleteDialog.showMessage(ModifierGroupExplorer.this, POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 1) {
                        ModifierGroup modifierGroup = (ModifierGroup)ModifierGroupExplorer.this.a.get(n);
                        ModifierGroupDAO modifierGroupDAO = new ModifierGroupDAO();
                        modifierGroupDAO.delete(modifierGroup);
                        ModifierGroupExplorer.this.c.deleteModifierGroup(modifierGroup, n);
                    }
                }
                catch (Throwable throwable) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton);
        transparentPanel.add(jButton3);
        this.add((Component)transparentPanel, "South");
        this.b.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    try {
                        int n = ModifierGroupExplorer.this.b.getSelectedRow();
                        if (n < 0) {
                            return;
                        }
                        n = ModifierGroupExplorer.this.b.convertRowIndexToModel(n);
                        ModifierGroup modifierGroup = (ModifierGroup)ModifierGroupExplorer.this.a.get(n);
                        ModifierGroupForm modifierGroupForm = new ModifierGroupForm(modifierGroup);
                        BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)modifierGroupForm);
                        beanEditorDialog.open();
                        if (beanEditorDialog.isCanceled()) {
                            return;
                        }
                        ModifierGroupExplorer.this.b.repaint();
                    }
                    catch (Throwable throwable) {
                        BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
                    }
                }
            }
        });
    }

    private JPanel b() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout(""));
        jPanel.setBorder(BorderFactory.createTitledBorder("Refresh"));
        JButton jButton = new JButton(POSConstants.REFRESH);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ModifierGroupExplorer.this.initData();
                }
                catch (Exception exception) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
                }
            }
        });
        jPanel.add(jButton);
        return jPanel;
    }

    @Override
    public void initData() {
        ModifierGroupDAO modifierGroupDAO = new ModifierGroupDAO();
        modifierGroupDAO.updateModifierGroupBooleanPropertyValue(true);
        this.a = modifierGroupDAO.findNormalModifierGroups();
        this.c.fireTableDataChanged();
    }

    class ModifierGroupExplorerTableModel
    extends AbstractTableModel {
        String[] a = new String[]{POSConstants.NAME, POSConstants.TRANSLATED_NAME, POSConstants.MODIFIERS};

        ModifierGroupExplorerTableModel() {
        }

        @Override
        public int getRowCount() {
            if (ModifierGroupExplorer.this.a == null) {
                return 0;
            }
            return ModifierGroupExplorer.this.a.size();
        }

        @Override
        public int getColumnCount() {
            return this.a.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.a[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (ModifierGroupExplorer.this.a == null) {
                return "";
            }
            ModifierGroup modifierGroup = (ModifierGroup)ModifierGroupExplorer.this.a.get(n);
            switch (n2) {
                case 0: {
                    return modifierGroup.getName();
                }
                case 1: {
                    return modifierGroup.getTranslatedName();
                }
                case 2: {
                    return modifierGroup.getModifiers().toString();
                }
            }
            return null;
        }

        public void addModifierGroup(ModifierGroup modifierGroup) {
            int n = ModifierGroupExplorer.this.a.size();
            ModifierGroupExplorer.this.a.add(modifierGroup);
            this.fireTableRowsInserted(n, n);
        }

        public void deleteModifierGroup(ModifierGroup modifierGroup, int n) {
            ModifierGroupExplorer.this.a.remove(modifierGroup);
            this.fireTableRowsDeleted(n, n);
        }
    }
}

