/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.PizzaCrust;
import com.floreantpos.model.dao.PizzaCrustDAO;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.PizzaCrustForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXTable;

public class PizzaCrustExplorer
extends TransparentPanel {
    private JXTable a;
    private BeanTableModel<PizzaCrust> b = new BeanTableModel(PizzaCrust.class);

    public PizzaCrustExplorer() {
        this.b.addColumn(POSConstants.NAME.toUpperCase(), "name");
        this.b.addColumn(Messages.getString("PizzaCrustExplorer.0"), "translatedName");
        this.b.addColumn(Messages.getString("PizzaCrustExplorer.1"), "description");
        this.b.addColumn(Messages.getString("PizzaCrustExplorer.2"), "sortOrder");
        this.b.addColumn("Default", PizzaCrust.PROP_DEFAULT_CRUST);
        this.b.addRows(PizzaCrustDAO.getInstance().findAll());
        this.a = new JXTable(this.b);
        this.a.setRowHeight(PosUIManager.getSize(30));
        this.a.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.a));
        JButton jButton = new JButton(POSConstants.ADD);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    PizzaCrustForm pizzaCrustForm = new PizzaCrustForm();
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)pizzaCrustForm);
                    beanEditorDialog.open();
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    PizzaCrust pizzaCrust = (PizzaCrust)pizzaCrustForm.getBean();
                    PizzaCrustExplorer.this.b.addRow(pizzaCrust);
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        JButton jButton2 = new JButton(POSConstants.EDIT);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = PizzaCrustExplorer.this.a.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToEdit"));
                        return;
                    }
                    n = PizzaCrustExplorer.this.a.convertRowIndexToModel(n);
                    PizzaCrust pizzaCrust = (PizzaCrust)PizzaCrustExplorer.this.b.getRow(n);
                    PizzaCrustForm pizzaCrustForm = new PizzaCrustForm(pizzaCrust);
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)pizzaCrustForm);
                    beanEditorDialog.open();
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    PizzaCrustExplorer.this.a.repaint();
                }
                catch (Throwable throwable) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        JButton jButton3 = new JButton(POSConstants.DELETE);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = PizzaCrustExplorer.this.a.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SelectToDelete"));
                        return;
                    }
                    if (ConfirmDeleteDialog.showMessage(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) == 0) {
                        PizzaCrust pizzaCrust = (PizzaCrust)PizzaCrustExplorer.this.b.getRow(n);
                        PizzaCrustDAO pizzaCrustDAO = new PizzaCrustDAO();
                        pizzaCrustDAO.delete(pizzaCrust);
                        PizzaCrustExplorer.this.b.removeRow(n);
                    }
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        JButton jButton4 = new JButton("Set Default");
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = PizzaCrustExplorer.this.a.getSelectedRow();
                    if (n < 0) {
                        POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("SetDefault"));
                        return;
                    }
                    n = PizzaCrustExplorer.this.a.convertRowIndexToModel(n);
                    PizzaCrust pizzaCrust = (PizzaCrust)PizzaCrustExplorer.this.b.getRow(n);
                    ArrayList<PizzaCrust> arrayList = new ArrayList<PizzaCrust>();
                    arrayList.add(pizzaCrust);
                    for (PizzaCrust pizzaCrust2 : PizzaCrustExplorer.this.b.getRows()) {
                        if (!pizzaCrust2.isDefaultCrust().booleanValue()) continue;
                        pizzaCrust2.setDefaultCrust(false);
                        arrayList.add(pizzaCrust2);
                    }
                    pizzaCrust.setDefaultCrust(true);
                    PizzaCrustDAO pizzaCrustDAO = new PizzaCrustDAO();
                    pizzaCrustDAO.saveOrUpdateList(arrayList);
                    PizzaCrustExplorer.this.b.fireTableDataChanged();
                    PizzaCrustExplorer.this.a.revalidate();
                    PizzaCrustExplorer.this.a.repaint();
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(jButton);
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton3);
        transparentPanel.add(jButton4);
        this.add((Component)transparentPanel, "South");
    }
}

