/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.POSConstants;
import com.floreantpos.actions.StoreSessionReportAction;
import com.floreantpos.bo.actions.PosProgressDialog;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.main.Application;
import com.floreantpos.model.StoreSession;
import com.floreantpos.model.dao.StoreSessionDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.BeanTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.dialog.DrawerAndStaffBankReportHistoryDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.util.POSUtil;
import com.floreantpos.webservice.PosWebService;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;

public class StoreSessionExplorer
extends TransparentPanel {
    private JXTable a;
    private BeanTableModel<StoreSession> b;
    private JButton c;
    private JButton d;
    private JButton e;
    private JLabel f;
    private JXDatePicker g;
    private JXDatePicker h;
    private SimpleDateFormat i = new SimpleDateFormat("dd-MMM-yyyy hh:mm a");

    public StoreSessionExplorer() {
        this.a();
        this.b.setNumRows(StoreSessionDAO.getInstance().rowCount());
        this.c();
    }

    private void a() {
        this.b = new BeanTableModel<StoreSession>(StoreSession.class, 10){

            @Override
            public Object getValueAt(int n, int n2) {
                if (n2 == 0) {
                    return StoreSessionExplorer.this.i.format(((StoreSession)StoreSessionExplorer.this.b.getRow(n)).getOpenTime());
                }
                if (n2 == 1 && ((StoreSession)StoreSessionExplorer.this.b.getRow(n)).getCloseTime() != null) {
                    return StoreSessionExplorer.this.i.format(((StoreSession)StoreSessionExplorer.this.b.getRow(n)).getCloseTime());
                }
                return super.getValueAt(n, n2);
            }
        };
        this.b.addColumn("OPEN TIME", "openTime");
        this.b.addColumn("CLOSE TIME", "closeTime");
        this.b.addColumn("OPENED BY", "openedBy");
        this.b.addColumn("CLOSED BY", "closedBy");
        this.c = new JButton("<<< Previous");
        this.d = new JButton("Next >>>");
        this.f = new JLabel();
        this.a = new JXTable(this.b);
        this.a.setSortable(false);
        this.a.setDefaultRenderer(Object.class, (TableCellRenderer)new TableRenderer());
        this.a.setRowHeight(PosUIManager.getSize(30));
        this.a.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    StoreSessionExplorer.this.showReport();
                }
            }
        });
        this.c.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StoreSessionExplorer.this.b.setCurrentRowIndex(StoreSessionExplorer.this.b.getPreviousRowIndex());
                StoreSessionExplorer.this.c();
            }
        });
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StoreSessionExplorer.this.b.setCurrentRowIndex(StoreSessionExplorer.this.b.getNextRowIndex());
                StoreSessionExplorer.this.c();
            }
        });
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane((Component)this.a));
        this.add((Component)this.e(), "South");
        this.add((Component)this.b(), "North");
        this.resizeColumnWidth((JTable)this.a);
    }

    private JPanel b() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new MigLayout("", "[][]15[][]15[][]15[]", "[]5[]"));
        try {
            JLabel jLabel = new JLabel(POSConstants.START_DATE + ":");
            this.g = UiUtil.getCurrentMonthStart();
            JLabel jLabel2 = new JLabel(POSConstants.END_DATE + ":");
            this.h = UiUtil.getCurrentMonthEnd();
            JButton jButton = new JButton();
            jButton.setText(POSConstants.SEARCH_ITEM_BUTTON_TEXT);
            jButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    StoreSessionExplorer.this.d();
                }
            });
            jPanel.add(jLabel);
            jPanel.add((Component)this.g);
            jPanel.add(jLabel2);
            jPanel.add((Component)this.h);
            jPanel.add(jButton);
        }
        catch (Throwable throwable) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
        }
        return jPanel;
    }

    private void c() {
        StoreSessionDAO.getInstance().loadStoreSession(this.b);
        int n = this.b.getCurrentRowIndex() + 1;
        int n2 = this.b.getNextRowIndex();
        int n3 = this.b.getNumRows();
        if (n2 > n3) {
            n2 = n3;
        }
        this.f.setText(String.format("Showing %s to %s of %s", n, n2, n3));
        this.c.setEnabled(this.b.hasPrevious());
        this.d.setEnabled(this.b.hasNext());
    }

    private void d() {
        Date date;
        if (this.g.getDate() == null || this.h.getDate() == null) {
            POSMessageDialog.showError(this, "Please enter start and end date!");
            return;
        }
        Date date2 = DateUtil.startOfDay(this.g.getDate());
        if (date2.after(date = DateUtil.endOfDay(this.h.getDate()))) {
            POSMessageDialog.showError(POSUtil.getFocusedWindow(), POSConstants.FROM_DATE_CANNOT_BE_GREATER_THAN_TO_DATE_);
            return;
        }
        List<StoreSession> list = StoreSessionDAO.getInstance().findSessions(date2, date);
        this.b.removeAll();
        this.b.addRows(list);
    }

    private JPanel e() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout("fillx", "[33%][33%][33%]"));
        TransparentPanel transparentPanel = new TransparentPanel();
        JButton jButton = new JButton("History");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = StoreSessionExplorer.this.a.getSelectedRow();
                if (n < 0) {
                    POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select a row first");
                    return;
                }
                n = StoreSessionExplorer.this.a.convertRowIndexToModel(n);
                StoreSession storeSession = (StoreSession)StoreSessionExplorer.this.b.getRow(n);
                DrawerAndStaffBankReportHistoryDialog drawerAndStaffBankReportHistoryDialog = new DrawerAndStaffBankReportHistoryDialog(POSUtil.getBackOfficeWindow(), Application.getCurrentUser(), storeSession);
                drawerAndStaffBankReportHistoryDialog.setInfo("Store session history");
                drawerAndStaffBankReportHistoryDialog.setSize(PosUIManager.getSize(880, 580));
                drawerAndStaffBankReportHistoryDialog.open();
            }
        });
        transparentPanel.add((Component)jButton, "split 4");
        JButton jButton2 = new JButton("Summary");
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StoreSessionExplorer.this.showReport();
            }
        });
        transparentPanel.add(jButton2);
        jPanel.add((Component)transparentPanel, "skip 1,center");
        this.e = new JButton("Upload");
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StoreSessionExplorer.this.f();
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout(4));
        jPanel2.add(this.f);
        jPanel2.add(this.c);
        jPanel2.add(this.d);
        jPanel.add((Component)jPanel2, "grow");
        return jPanel;
    }

    private void f() {
        int n = this.a.getSelectedRow();
        if (n < 0) {
            POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select a row first.");
            return;
        }
        PosProgressDialog posProgressDialog = new PosProgressDialog(){

            @Override
            public void doBackgroundTask() throws Exception {
                int n = StoreSessionExplorer.this.a.getSelectedRow();
                n = StoreSessionExplorer.this.a.convertRowIndexToModel(n);
                StoreSession storeSession = (StoreSession)StoreSessionExplorer.this.b.getRow(n);
                PosWebService.get().uploadStoreSessionData(storeSession);
            }

            @Override
            public void done() {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Upload Complete.");
            }

            @Override
            public void error(Exception exception) {
                if (exception.getCause().getMessage().contains("Connection refused")) {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), "Connection failed.", exception);
                } else {
                    POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage(), exception);
                }
            }
        };
        posProgressDialog.setProgressLabelText("Uploading");
        posProgressDialog.pack();
        posProgressDialog.open();
    }

    protected void showReport() {
        try {
            int n = this.a.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showMessage(POSUtil.getFocusedWindow(), "Please select a row first");
                return;
            }
            n = this.a.convertRowIndexToModel(n);
            StoreSession storeSession = this.b.getRow(n);
            StoreSessionReportAction storeSessionReportAction = new StoreSessionReportAction(storeSession);
            storeSessionReportAction.execute();
        }
        catch (Exception exception) {
            BOMessageDialog.showError(exception);
        }
    }

    public void resizeColumnWidth(JTable jTable) {
        TableColumnModel tableColumnModel = jTable.getColumnModel();
        for (int i = 0; i < jTable.getColumnCount(); ++i) {
            tableColumnModel.getColumn(i).setPreferredWidth((Integer)this.g().get(i));
        }
    }

    private List g() {
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        arrayList.add(200);
        arrayList.add(200);
        arrayList.add(70);
        arrayList.add(70);
        return arrayList;
    }

    class TableRenderer
    extends DefaultTableCellRenderer {
        private SimpleDateFormat b = new SimpleDateFormat("dd-MMM-yyyy hh:mm a");

        TableRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            if (object instanceof Date) {
                String string = this.b.format(object);
                jLabel.setText(string);
                jLabel.setHorizontalAlignment(4);
            }
            return jLabel;
        }
    }
}

