/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.Tax;
import com.floreantpos.model.dao.TaxDAO;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.ConfirmDeleteDialog;
import com.floreantpos.ui.model.TaxForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;

public class TaxExplorer
extends TransparentPanel {
    private List<Tax> a = TaxDAO.getInstance().findAll();
    private JTable b;
    private TaxExplorerTableModel c = new TaxExplorerTableModel();

    public TaxExplorer() {
        this.b = new JTable(this.c);
        this.b.setRowHeight(PosUIManager.getSize(25));
        this.b.setDefaultRenderer(Object.class, new PosTableRenderer());
        this.setLayout(new BorderLayout(5, 5));
        this.add(new JScrollPane(this.b));
        JButton jButton = new JButton(POSConstants.ADD);
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    TaxForm taxForm = new TaxForm();
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)taxForm);
                    beanEditorDialog.open();
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    TaxExplorer.this.c.addTax((Tax)taxForm.getBean());
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        JButton jButton2 = new JButton(POSConstants.EDIT);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = TaxExplorer.this.b.getSelectedRow();
                    if (n < 0) {
                        return;
                    }
                    Tax tax = (Tax)TaxExplorer.this.a.get(n);
                    TaxForm taxForm = new TaxForm(tax);
                    BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)taxForm);
                    beanEditorDialog.open();
                    if (beanEditorDialog.isCanceled()) {
                        return;
                    }
                    TaxExplorer.this.b.repaint();
                }
                catch (Throwable throwable) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, throwable);
                }
            }
        });
        JButton jButton3 = new JButton(POSConstants.DELETE);
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    int n = TaxExplorer.this.b.getSelectedRow();
                    if (n < 0) {
                        return;
                    }
                    Tax tax = (Tax)TaxExplorer.this.a.get(n);
                    String string = "Are you sure to delete tax '%s'? This will be deletec fron all tax groups.";
                    string = String.format(string, tax.getName());
                    if (ConfirmDeleteDialog.showMessage(POSUtil.getBackOfficeWindow(), string, POSConstants.DELETE) == 0) {
                        TaxDAO.getInstance().delete(tax);
                        TaxExplorer.this.c.deleteTax(tax, n);
                    }
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(jButton);
        transparentPanel.add(jButton2);
        transparentPanel.add(jButton3);
        this.add((Component)transparentPanel, "South");
    }

    class TaxExplorerTableModel
    extends AbstractTableModel {
        String[] a = new String[]{POSConstants.NAME, POSConstants.RATE};

        TaxExplorerTableModel() {
        }

        @Override
        public int getRowCount() {
            if (TaxExplorer.this.a == null) {
                return 0;
            }
            return TaxExplorer.this.a.size();
        }

        @Override
        public int getColumnCount() {
            return this.a.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.a[n];
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (TaxExplorer.this.a == null) {
                return "";
            }
            Tax tax = (Tax)TaxExplorer.this.a.get(n);
            switch (n2) {
                case 0: {
                    return tax.getName();
                }
                case 1: {
                    return tax.getRate();
                }
            }
            return null;
        }

        public void addTax(Tax tax) {
            int n = TaxExplorer.this.a.size();
            TaxExplorer.this.a.add(tax);
            this.fireTableRowsInserted(n, n);
        }

        public void deleteTax(Tax tax, int n) {
            TaxExplorer.this.a.remove(tax);
            this.fireTableRowsDeleted(n, n);
        }
    }
}

