/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.explorer;

import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.main.Application;
import com.floreantpos.model.Ticket;
import com.floreantpos.model.dao.TicketDAO;
import com.floreantpos.model.util.DateUtil;
import com.floreantpos.swing.ListTableModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.PosTableRenderer;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.util.UiUtil;
import com.floreantpos.ui.views.OrderInfoDialog;
import com.floreantpos.ui.views.OrderInfoView;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import net.miginfocom.swing.MigLayout;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXTable;

public class TicketExplorer
extends TransparentPanel {
    private SimpleDateFormat a = new SimpleDateFormat("MMM dd yyyy, h:m a");
    private JXDatePicker b = UiUtil.getCurrentMonthStart();
    private JXDatePicker c = UiUtil.getCurrentMonthEnd();
    private JButton d = new JButton(POSConstants.GO);
    private JXTable e;
    private TicketExplorerTableModel f;
    private List<Ticket> g;
    private JButton h;
    private JButton i;
    private JButton j;
    private Ticket k;

    public TicketExplorer() {
        this.setLayout(new BorderLayout());
        this.e = new JXTable();
        this.e.setRowHeight(PosUIManager.getSize(30));
        this.e.setDefaultRenderer(Object.class, (TableCellRenderer)new PosTableRenderer());
        this.f = new TicketExplorerTableModel();
        this.e.setModel((TableModel)this.f);
        this.e.setAutoResizeMode(4);
        this.e.setRowHeight(PosUIManager.getSize(30));
        this.a();
        this.add((Component)new JScrollPane((Component)this.e), "Center");
        this.b();
        this.c();
    }

    private void a() {
        JPanel jPanel = new JPanel((LayoutManager)new MigLayout());
        this.d.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    TicketExplorer.this.c();
                }
                catch (Exception exception) {
                    BOMessageDialog.showError(POSUtil.getBackOfficeWindow(), POSConstants.ERROR_MESSAGE, exception);
                }
            }
        });
        jPanel.add((Component)new JLabel(POSConstants.FROM), "grow");
        jPanel.add((Component)this.b, "gapright 10");
        jPanel.add((Component)new JLabel(POSConstants.TO), "grow");
        jPanel.add((Component)this.c);
        jPanel.add((Component)this.d, "width 60!");
        this.add((Component)jPanel, "North");
    }

    private void b() {
        this.j = new JButton("Order Info");
        this.j.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketExplorer.this.f();
            }
        });
        this.h = new JButton(POSConstants.DELETE);
        this.h.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketExplorer.this.e();
            }
        });
        this.i = new JButton(POSConstants.DELETE_ALL);
        this.i.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                TicketExplorer.this.d();
            }
        });
        TransparentPanel transparentPanel = new TransparentPanel();
        transparentPanel.add(this.j);
        transparentPanel.add(this.h);
        transparentPanel.add(this.i);
        this.add((Component)transparentPanel, "South");
    }

    private void c() {
        if (this.f.getRows() != null) {
            this.f.getRows().clear();
        }
        Date date = this.b.getDate();
        Date date2 = this.c.getDate();
        date = DateUtil.startOfDay(date);
        date2 = DateUtil.endOfDay(date2);
        TicketDAO ticketDAO = new TicketDAO();
        this.g = ticketDAO.findClosedTickets(date, date2);
        this.f.setRows(this.g);
        this.e.repaint();
    }

    private void d() {
        try {
            List<Ticket> list = this.f.getRows();
            if (list.isEmpty()) {
                return;
            }
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE_ALL) != 0) {
                return;
            }
            TicketDAO.getInstance().deleteTickets(list);
            this.c();
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void e() {
        try {
            int n = this.e.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), POSConstants.SELECT_ONE_TICKET_TO_VOID);
                return;
            }
            n = this.e.convertRowIndexToModel(n);
            ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
            Ticket ticket = (Ticket)this.f.getRows().get(n);
            arrayList.add(ticket);
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), POSConstants.CONFIRM_DELETE, POSConstants.DELETE) != 0) {
                return;
            }
            TicketDAO.getInstance().deleteTickets(arrayList);
            this.f.deleteItem(n);
            this.e.repaint();
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void f() {
        try {
            int n = this.e.getSelectedRow();
            if (n < 0) {
                POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), POSConstants.SELECT_ONE_TICKET_TO_VOID);
                return;
            }
            n = this.e.convertRowIndexToModel(n);
            Ticket ticket = (Ticket)this.f.getRows().get(n);
            Ticket ticket2 = TicketDAO.getInstance().loadFullTicket(ticket.getId());
            ArrayList<Ticket> arrayList = new ArrayList<Ticket>();
            arrayList.add(ticket2);
            try {
                OrderInfoView orderInfoView = new OrderInfoView(arrayList);
                OrderInfoDialog orderInfoDialog = new OrderInfoDialog(orderInfoView);
                orderInfoDialog.setSize(600, 700);
                orderInfoDialog.setDefaultCloseOperation(2);
                orderInfoDialog.open();
            }
            catch (Exception exception) {
                PosLog.error(this.getClass(), exception);
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), POSConstants.ERROR_MESSAGE, exception);
        }
    }

    class TicketExplorerTableModel
    extends ListTableModel<Ticket> {
        String[] a = new String[]{POSConstants.ID, POSConstants.CREATED_BY.toUpperCase(), POSConstants.CREATE_TIME.toUpperCase(), POSConstants.SETTLE_TIME.toUpperCase(), POSConstants.SUBTOTAL.toUpperCase(), POSConstants.DISCOUNT.toUpperCase(), POSConstants.TAX.toUpperCase(), POSConstants.TOTAL, POSConstants.PAID, POSConstants.VOID.toUpperCase()};

        TicketExplorerTableModel() {
        }

        @Override
        public String[] getColumnNames() {
            return this.a;
        }

        @Override
        public int getColumnCount() {
            return this.a.length;
        }

        @Override
        public String getColumnName(int n) {
            return this.a[n];
        }

        @Override
        public Object getValueAt(int n, int n2) {
            Ticket ticket = (Ticket)this.rows.get(n);
            switch (n2) {
                case 0: {
                    return String.valueOf(ticket.getId());
                }
                case 1: {
                    return ticket.getOwner().toString();
                }
                case 2: {
                    return TicketExplorer.this.a.format(ticket.getCreateDate());
                }
                case 3: {
                    if (ticket.getClosingDate() != null) {
                        return TicketExplorer.this.a.format(ticket.getClosingDate());
                    }
                    return "";
                }
                case 4: {
                    return (double)ticket.getSubtotalAmount();
                }
                case 5: {
                    return (double)ticket.getDiscountAmount();
                }
                case 6: {
                    return (double)ticket.getTaxAmount();
                }
                case 7: {
                    return (double)ticket.getTotalAmountWithTips();
                }
                case 8: {
                    return (boolean)ticket.isPaid();
                }
                case 9: {
                    return (boolean)ticket.isVoided();
                }
            }
            return null;
        }
    }
}

