/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.menudesigner;

import com.floreantpos.Messages;
import com.floreantpos.POSConstants;
import com.floreantpos.bo.ui.explorer.PageSelectionListener;
import com.floreantpos.bo.ui.menudesigner.PageItemActionSelectorDialog;
import com.floreantpos.config.TerminalConfig;
import com.floreantpos.main.Application;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuPageDAO;
import com.floreantpos.model.dao.MenuPageItemDAO;
import com.floreantpos.swing.PosButton;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuItemForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import net.miginfocom.swing.MigLayout;

public class MenuPageDesignView
extends TransparentPanel {
    public static final String VIEW_NAME = "ITEM_VIEW";
    private static final int a = 5;
    private static final int b = 5;
    private List<MenuPageItem> c;
    private Dimension d;
    private MenuPage e;
    private JPanel f = new JPanel((LayoutManager)new MigLayout("center,wrap 4"));
    private PageSelectionListener g;
    private Integer h;
    private Integer i;
    private MenuPageItem j = null;

    public MenuPageDesignView() {
        this.d = new Dimension(TerminalConfig.getMenuItemButtonWidth(), TerminalConfig.getMenuItemButtonHeight());
        TitledBorder titledBorder = new TitledBorder(POSConstants.ITEMS);
        titledBorder.setTitleJustification(2);
        this.setBorder(new CompoundBorder(titledBorder, new EmptyBorder(2, 2, 2, 2)));
        this.setLayout(new BorderLayout(5, 5));
        this.f.setBackground(Color.GRAY);
        this.f.setOpaque(true);
        this.add(this.f);
    }

    public void setPageListener(PageSelectionListener pageSelectionListener) {
        this.g = pageSelectionListener;
    }

    public void setPageListener() {
    }

    public MenuPage getMenuPage() {
        return this.e;
    }

    public void setMenuPage(MenuPage menuPage) {
        this.e = menuPage;
        this.reset();
        try {
            if (menuPage == null) {
                return;
            }
            MenuPageDAO.getInstance().initialize(menuPage);
            this.h = menuPage.getCols();
            if (this.h <= 0) {
                this.h = 4;
            }
            this.i = menuPage.getRows();
            if (this.i <= 0) {
                this.i = 4;
            }
            MigLayout migLayout = new MigLayout("center,wrap " + this.h);
            if (menuPage.isFlixibleButtonSize().booleanValue()) {
                migLayout.setLayoutConstraints((Object)"fill");
                migLayout.setColumnConstraints((Object)"fill,grow");
                migLayout.setRowConstraints((Object)"fill,grow");
            }
            this.f.setLayout((LayoutManager)migLayout);
            this.c = menuPage.getPageItems();
            this.renderItems();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(Application.getPosWindow(), exception.getMessage(), exception);
        }
    }

    public void setMenuItems(List<MenuPageItem> list) {
        this.c = list;
        this.renderItems();
    }

    protected void renderItems() {
        try {
            Serializable serializable;
            String string;
            this.reset();
            if (this.c == null) {
                this.c = new ArrayList<MenuPageItem>();
            }
            HashMap<String, ItemButton> hashMap = new HashMap<String, ItemButton>();
            for (int i = 0; i < this.i; ++i) {
                for (int j = 0; j < this.h; ++j) {
                    string = String.valueOf(j) + String.valueOf(i);
                    serializable = this.a(j, i, this.c);
                    ItemButton itemButton = (ItemButton)this.createItemButton(serializable);
                    hashMap.put(string, itemButton);
                    String string2 = String.format("cell %s %s", j, i);
                    if (!this.e.isFlixibleButtonSize().booleanValue()) {
                        string2 = string2 + String.format(", w %s!, h %s!", this.e.getButtonWidth(), this.e.getButtonHeight());
                    }
                    this.f.add((Component)itemButton, string2);
                }
            }
            for (MenuPageItem menuPageItem : this.c) {
                string = String.valueOf(menuPageItem.getCol()) + String.valueOf(menuPageItem.getRow());
                serializable = (ItemButton)hashMap.get(string);
                if (serializable == null) continue;
                ((ItemButton)serializable).setMenuItem(menuPageItem.getMenuItem());
            }
            this.revalidate();
            this.repaint();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(this, exception.getMessage(), exception);
        }
    }

    public void reset() {
        this.f.removeAll();
    }

    public void fillSelectedPageItems(List<MenuPageItem> list) {
        int n = 0;
        for (int i = 0; i < this.f.getComponents().length; ++i) {
            ItemButton itemButton = (ItemButton)this.f.getComponent(i);
            if (itemButton.isEmptyItem()) {
                MenuPageItem menuPageItem = list.get(n);
                itemButton.setMenuItem(menuPageItem.getMenuItem());
                ++n;
            }
            if (n == list.size()) break;
        }
    }

    protected AbstractButton createItemButton(Object object) {
        MenuPageItem menuPageItem = (MenuPageItem)object;
        ItemButton itemButton = new ItemButton(menuPageItem);
        return itemButton;
    }

    public void resetPage() {
        for (int i = 0; i < this.f.getComponents().length; ++i) {
            MenuPageItem menuPageItem;
            ItemButton itemButton = (ItemButton)this.f.getComponent(i);
            if (itemButton.isEmptyItem() || (menuPageItem = itemButton.a).getId() != null) continue;
            itemButton.setMenuItem(null);
        }
        this.revalidate();
        this.repaint();
    }

    private MenuPageItem a(int n, int n2, List<MenuPageItem> list) {
        for (MenuPageItem menuPageItem : list) {
            if (menuPageItem.getCol() != n || menuPageItem.getRow() != n2) continue;
            return menuPageItem;
        }
        MenuPageItem menuPageItem = new MenuPageItem(n, n2);
        menuPageItem.setMenuPage(this.e);
        return menuPageItem;
    }

    public class ItemButton
    extends PosButton
    implements Transferable,
    MouseListener,
    MouseMotionListener {
        MenuPageItem a;
        private DataFlavor e = new DataFlavor(MenuPageItem.class, "menuPageItem");
        private final DataFlavor[] f = new DataFlavor[]{this.e};
        private DragAndDropTransferHandler g;

        ItemButton(MenuPageItem menuPageItem) {
            this.a = menuPageItem;
            this.setFocusable(true);
            this.setFocusPainted(true);
            this.setVerticalTextPosition(3);
            this.setHorizontalTextPosition(0);
            this.setIconTextGap(0);
            this.setText("+");
            this.setPreferredSize(MenuPageDesignView.this.d);
            this.updateView();
            this.g = new DragAndDropTransferHandler(this);
            this.setTransferHandler(this.g);
            this.addMouseMotionListener(this);
            this.addMouseListener(this);
        }

        int a() {
            return this.a.getRow();
        }

        int b() {
            return this.a.getCol();
        }

        public void setMenuPageItem(MenuPageItem menuPageItem) {
            this.a = menuPageItem;
        }

        public void setMenuItem(MenuItem menuItem) {
            this.a.setMenuItem(menuItem);
            this.a.setMenuPage(MenuPageDesignView.this.e);
            this.updateView();
        }

        public boolean isEmptyItem() {
            return this.a.getMenuItem() == null;
        }

        public void updateView() {
            Color color;
            MenuItem menuItem = this.a.getMenuItem();
            if (menuItem == null) {
                this.setIcon(null);
                this.setBackground(UIManager.getColor("control"));
                this.setForeground(Color.BLACK);
                this.setText("<html><body><center>+</center></body></html>");
                return;
            }
            ImageIcon imageIcon = menuItem.getImage();
            if (imageIcon != null) {
                if (menuItem.isShowImageOnly().booleanValue()) {
                    this.setText("");
                    this.setIcon(imageIcon);
                } else {
                    this.setIcon(imageIcon);
                    this.setText("<html><body><center>" + menuItem.getDisplayName() + "</center></body></html>");
                }
            } else {
                this.setText("<html><body><center>" + menuItem.getName() + "</center></body></html>");
            }
            Color color2 = menuItem.getButtonColor();
            if (color2 != null) {
                this.setBackground(color2);
            }
            if ((color = menuItem.getTextColor()) != null) {
                this.setForeground(color);
            }
        }

        private void c() {
            try {
                MenuItem menuItem = this.a.getMenuItem();
                ArrayList<MenuItem> arrayList = new ArrayList<MenuItem>();
                if (menuItem != null) {
                    arrayList.add(menuItem);
                }
                if (menuItem == null) {
                    menuItem = this.d();
                    if (menuItem == null) {
                        return;
                    }
                } else {
                    PageItemActionSelectorDialog pageItemActionSelectorDialog = new PageItemActionSelectorDialog(this.a);
                    pageItemActionSelectorDialog.setSize(PosUIManager.getSize(500, 350));
                    pageItemActionSelectorDialog.open();
                    if (pageItemActionSelectorDialog.isCanceled()) {
                        return;
                    }
                    String string = pageItemActionSelectorDialog.getActionCommand();
                    if (string.equals("REPLACE")) {
                        menuItem = this.d();
                        if (menuItem == null) {
                            return;
                        }
                    } else if (string.equals("EDIT")) {
                        this.a(menuItem);
                    } else if (string.equals("DETACH")) {
                        menuItem = null;
                    }
                }
                this.a.setMenuItem(menuItem);
                this.a.setMenuPage(MenuPageDesignView.this.e);
                this.updateView();
                if (MenuPageDesignView.this.g == null) {
                    return;
                }
                MenuPageDesignView.this.e.addTopageItems(this.a);
                this.a.setMenuPage(MenuPageDesignView.this.e);
                MenuPageDesignView.this.g.itemSelected(this.a);
            }
            catch (Exception exception) {
                POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), "Select Menu Item Eror!", exception);
            }
        }

        private MenuItem d() {
            MenuItemSelectionDialog menuItemSelectionDialog = MenuItemSelectionDialog.getInstance();
            menuItemSelectionDialog.setSelectionMode(0);
            menuItemSelectionDialog.setSize(PosUIManager.getSize(800, 600));
            menuItemSelectionDialog.open();
            if (menuItemSelectionDialog.isCanceled()) {
                return null;
            }
            return menuItemSelectionDialog.getSelectedRowData();
        }

        public void doReplaceMenuPageItem(MenuItem menuItem) {
            try {
                menuItem = this.d();
                if (menuItem == null) {
                    return;
                }
            }
            catch (Exception exception) {
                return;
            }
        }

        private void a(MenuItem menuItem) {
            try {
                MenuItemDAO.getInstance().initialize(menuItem);
                MenuItemForm menuItemForm = new MenuItemForm(menuItem);
                BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuItemForm);
                beanEditorDialog.openWithScale(1000, 700);
                if (beanEditorDialog.isCanceled()) {
                    return;
                }
                for (MenuPageItem menuPageItem : MenuPageDesignView.this.c) {
                    if (menuPageItem.getId() == null || !menuPageItem.getMenuItemId().equals(this.a.getMenuItemId())) continue;
                    menuPageItem.setMenuItem(null);
                    MenuPageItemDAO.getInstance().refresh(menuPageItem);
                }
                MenuPageDesignView.this.renderItems();
            }
            catch (Exception exception) {
                POSMessageDialog.showError(this, exception.getMessage(), exception);
            }
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            try {
                ItemButton itemButton = (ItemButton)mouseEvent.getSource();
                TransferHandler transferHandler = itemButton.getTransferHandler();
                transferHandler.exportAsDrag(itemButton, mouseEvent, 2);
            }
            catch (Exception exception) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), exception.getMessage());
            }
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            this.c();
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            return this.f;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            for (int i = 0; i < this.f.length; ++i) {
                if (!dataFlavor.equals(this.f[i])) continue;
                return true;
            }
            return false;
        }

        @Override
        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (dataFlavor.equals(this.e)) {
                return this.a;
            }
            throw new UnsupportedFlavorException(dataFlavor);
        }
    }

    public class DragAndDropTransferHandler
    extends TransferHandler {
        private ItemButton b = null;

        public DragAndDropTransferHandler(ItemButton itemButton) {
            this.b = itemButton;
        }

        @Override
        public int getSourceActions(JComponent jComponent) {
            return 2;
        }

        @Override
        protected Transferable createTransferable(JComponent jComponent) {
            return this.b;
        }

        @Override
        public boolean canImport(TransferHandler.TransferSupport transferSupport) {
            return transferSupport.isDataFlavorSupported(this.b.e);
        }

        @Override
        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            super.exportDone(jComponent, transferable, n);
            try {
                if (jComponent instanceof ItemButton && MenuPageDesignView.this.j != null) {
                    this.b.setMenuPageItem(MenuPageDesignView.this.j);
                    MenuPage menuPage = MenuPageDesignView.this.getMenuPage();
                    List<MenuPageItem> list = menuPage.getPageItems();
                    for (MenuPageItem menuPageItem : list) {
                        if (menuPageItem == null || !menuPageItem.getRandomId().equals(MenuPageDesignView.this.j.getRandomId())) continue;
                        menuPageItem.setRow(this.b.a());
                        menuPageItem.setCol(this.b.b());
                        break;
                    }
                    MenuPageDesignView.this.j = null;
                    this.b.updateView();
                    MenuPageDesignView.this.g.uiUpdate();
                    this.b.getModel().setPressed(false);
                }
            }
            catch (Exception exception) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("DragDropError"), exception);
            }
        }

        @Override
        public boolean importData(TransferHandler.TransferSupport transferSupport) {
            boolean bl = false;
            if (!this.canImport(transferSupport)) {
                return false;
            }
            try {
                Transferable transferable = transferSupport.getTransferable();
                MenuPageItem menuPageItem = (MenuPageItem)transferable.getTransferData(this.b.e);
                MenuPageDesignView.this.j = this.b.a;
                if (menuPageItem != null) {
                    int n = menuPageItem.getRow();
                    int n2 = menuPageItem.getCol();
                    menuPageItem.setRow(this.b.a());
                    menuPageItem.setCol(this.b.b());
                    this.b.setMenuPageItem(menuPageItem);
                    MenuPage menuPage = MenuPageDesignView.this.getMenuPage();
                    List<MenuPageItem> list = menuPage.getPageItems();
                    for (MenuPageItem menuPageItem2 : list) {
                        if (menuPageItem2 == null || !menuPageItem2.getRandomId().equals(menuPageItem.getRandomId())) continue;
                        menuPageItem2.setRow(this.b.a());
                        menuPageItem2.setCol(this.b.b());
                        break;
                    }
                    MenuPageDesignView.this.j.setRow(n);
                    MenuPageDesignView.this.j.setCol(n2);
                }
                this.b.updateView();
                MenuPageDesignView.this.g.uiUpdate();
                bl = true;
            }
            catch (Exception exception) {
                POSMessageDialog.showError(POSUtil.getFocusedWindow(), Messages.getString("DragDropError"));
            }
            return bl;
        }
    }
}

