/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.bo.ui.menudesigner;

import com.floreantpos.POSConstants;
import com.floreantpos.PosLog;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.bo.ui.explorer.PageSelectionListener;
import com.floreantpos.bo.ui.menudesigner.MenuPageDesignView;
import com.floreantpos.model.MenuCategory;
import com.floreantpos.model.MenuGroup;
import com.floreantpos.model.MenuItem;
import com.floreantpos.model.MenuPage;
import com.floreantpos.model.MenuPageItem;
import com.floreantpos.model.base.BaseMenuPage;
import com.floreantpos.model.dao.MenuCategoryDAO;
import com.floreantpos.model.dao.MenuGroupDAO;
import com.floreantpos.model.dao.MenuItemDAO;
import com.floreantpos.model.dao.MenuPageDAO;
import com.floreantpos.swing.ComboBoxModel;
import com.floreantpos.swing.PosUIManager;
import com.floreantpos.swing.TransparentPanel;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.RefreshableView;
import com.floreantpos.ui.dialog.BeanEditorDialog;
import com.floreantpos.ui.dialog.MenuItemSelectionDialog;
import com.floreantpos.ui.dialog.NumberSelectionDialog2;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.ui.model.MenuCategoryForm;
import com.floreantpos.ui.model.MenuGroupForm;
import com.floreantpos.ui.model.MenuPageForm;
import com.floreantpos.util.POSUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JButton;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.miginfocom.swing.MigLayout;
import org.hibernate.StaleStateException;

public class MenuPageDesigner
extends TransparentPanel
implements PageSelectionListener,
RefreshableView {
    private JList<MenuCategory> a;
    private JList<MenuGroup> b;
    private MenuPageDesignView c;
    private JList<MenuPage> d;
    private ComboBoxModel e;
    private JButton f;
    private JButton g;
    private JButton h;
    private JButton i;
    private JButton j;
    private JButton k;
    private JButton l;
    private JButton m;
    private JButton n;
    private JButton o;
    private JButton p;

    public MenuPageDesigner() {
        this.a();
    }

    private void a() {
        this.setLayout(new BorderLayout(5, 5));
        JPanel jPanel = new JPanel(new GridLayout(0, 1));
        JPanel jPanel2 = new JPanel(new BorderLayout());
        jPanel2.setPreferredSize(PosUIManager.getSize(300, 0));
        jPanel2.setBorder(new TitledBorder("-"));
        JPanel jPanel3 = new JPanel();
        jPanel3.setPreferredSize(PosUIManager.getSize(130, 82));
        this.add((Component)jPanel3, "East");
        this.a = new JList(new ComboBoxModel());
        this.a.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                MenuPageDesigner.this.b();
                MenuPageDesigner.this.e();
            }
        });
        this.b = new JList(new ComboBoxModel());
        this.b.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                MenuPageDesigner.this.b();
                MenuPageDesigner.this.f();
            }
        });
        this.n = new JButton("+");
        this.o = new JButton("+");
        this.j = new JButton("New Page");
        this.k = new JButton("Edit Page");
        this.i = new JButton("Hide Page");
        this.m = new JButton("Remove");
        this.l = new JButton("Remove All");
        this.m.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuPageDesigner.this.c();
            }
        });
        this.l.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuPageDesigner.this.d();
            }
        });
        this.i.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuPage menuPage = (MenuPage)MenuPageDesigner.this.d.getSelectedValue();
                if (menuPage == null) {
                    return;
                }
                menuPage.setVisible(menuPage.isVisible() == false);
                MenuPageDAO.getInstance().saveOrUpdate(menuPage);
                MenuPageDesigner.this.i.setText(menuPage.isVisible() != false ? "Hide Page" : "Show Page");
            }
        });
        this.n.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuPageDesigner.this.h();
            }
        });
        this.o.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuPageDesigner.this.i();
            }
        });
        this.j.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuPageDesigner.this.b();
                MenuPageDesigner.this.l();
            }
        });
        this.k.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuPageDesigner.this.b();
                MenuPageDesigner.this.n();
            }
        });
        this.h = new JButton("Auto Build Pages");
        this.h.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuPageDesigner.this.k();
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.a);
        jScrollPane.setBorder(new TitledBorder("Categories"));
        jPanel.add((Component)jScrollPane, String.format("grow, h %s", 200));
        JScrollPane jScrollPane2 = new JScrollPane(this.b);
        jScrollPane2.setBorder(new TitledBorder("Groups"));
        jPanel.add((Component)jScrollPane2, String.format("newline, grow, h %s", 200));
        this.e = new ComboBoxModel();
        this.d = new JList(this.e);
        this.d.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                MenuPageDesigner.this.b();
                MenuPageDesigner.this.g();
            }
        });
        JScrollPane jScrollPane3 = new JScrollPane(this.d);
        jScrollPane3.setBorder(new TitledBorder("Pages"));
        jPanel.add((Component)jScrollPane3, String.format("newline, grow, wrap", new Object[0]));
        jPanel2.add(jPanel);
        JPanel jPanel4 = new JPanel((LayoutManager)new MigLayout("fill"));
        jPanel4.add((Component)this.h, "growx");
        jPanel4.add((Component)this.j, "growx");
        jPanel4.add((Component)this.k, "growx,wrap");
        jPanel4.add((Component)this.i, "growx");
        jPanel4.add((Component)this.m, "growx");
        jPanel4.add((Component)this.l, "growx");
        this.l.setEnabled(false);
        jPanel2.add((Component)jPanel4, "South");
        JPanel jPanel5 = new JPanel(new BorderLayout());
        this.c = new MenuPageDesignView();
        this.c.setPageListener(this);
        JPanel jPanel6 = new JPanel((LayoutManager)new MigLayout("fillx"));
        JButton jButton = new JButton("Add Item");
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuPageDesigner.this.j();
            }
        });
        this.f = new JButton("Save");
        this.f.setEnabled(false);
        this.f.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuPageDesigner.this.doSaveMenuPage();
            }
        });
        this.g = new JButton("Cancel");
        this.g.setEnabled(false);
        this.g.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuPage menuPage = (MenuPage)MenuPageDesigner.this.d.getSelectedValue();
                menuPage = MenuPageDAO.getInstance().get(menuPage.getId());
                MenuPageDesigner.this.g.setEnabled(false);
                MenuPageDesigner.this.f.setEnabled(false);
                MenuPageDesigner.this.c.setMenuPage(menuPage);
            }
        });
        this.p = new JButton("Detach All");
        this.p.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MenuPageDesigner.this.o();
            }
        });
        jPanel6.add((Component)new JSeparator(), "grow,span");
        jPanel6.add((Component)this.f, "split 4");
        jPanel6.add(this.g);
        jPanel6.add(this.p);
        this.c.add((Component)jPanel6, "South");
        jPanel5.add(this.c);
        this.add((Component)jPanel2, "West");
        this.add(jPanel5);
        this.a(false);
    }

    private void b() {
        if (this.f.isEnabled()) {
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), "Do you want to save the changes?", "Confirm") == 0) {
                this.doSaveMenuPage();
            } else {
                this.c.resetPage();
                this.f.setEnabled(false);
                this.g.setEnabled(false);
            }
        }
    }

    protected void doSaveMenuPage() {
        MenuPage menuPage = this.d.getSelectedValue();
        try {
            MenuPageDAO.getInstance().saveOrUpdate(menuPage);
            this.f.setEnabled(false);
            this.g.setEnabled(false);
        }
        catch (StaleStateException staleStateException) {
            POSMessageDialog.showMessageDialogWithReloadButton(this, this);
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
        }
    }

    private void c() {
        try {
            MenuPage menuPage = this.d.getSelectedValue();
            if (menuPage == null) {
                return;
            }
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), "Are you sure you want to delete?", "Confirm") != 0) {
                return;
            }
            MenuPageDAO.getInstance().delete(menuPage);
            this.e.removeElement(menuPage);
            if (this.e.getSize() > 0) {
                this.d.setSelectedIndex(this.e.getSize() - 1);
            } else {
                this.g();
            }
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage());
        }
    }

    private void d() {
        try {
            List list = this.e.getDataList();
            if (list == null || list.isEmpty()) {
                return;
            }
            if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), "Are you sure you want to remove all pages from group " + this.b.getSelectedValue() + "?", "Confirm") != 0) {
                return;
            }
            MenuPageDAO.getInstance().deleteAll(list);
            this.e.removeAllElements();
            this.l.setEnabled(false);
            this.g();
        }
        catch (Exception exception) {
            POSMessageDialog.showError(exception.getMessage());
        }
    }

    public void initData() {
        List<MenuCategory> list = MenuCategoryDAO.getInstance().findAll();
        ComboBoxModel comboBoxModel = (ComboBoxModel)this.a.getModel();
        comboBoxModel.setDataList(list);
    }

    private void e() {
        MenuCategory menuCategory = this.a.getSelectedValue();
        if (menuCategory == null) {
            return;
        }
        ComboBoxModel comboBoxModel = (ComboBoxModel)this.b.getModel();
        comboBoxModel.removeAllElements();
        this.e.removeAllElements();
        List<MenuGroup> list = MenuGroupDAO.getInstance().findByParent(menuCategory);
        if (list != null) {
            comboBoxModel.setDataList(list);
            if (list.size() > 0) {
                this.b.setSelectedIndex(0);
            }
        }
        this.d.setSelectedValue(null, false);
        this.c.reset();
        this.c.revalidate();
        this.c.repaint();
    }

    private void f() {
        this.e.removeAllElements();
        MenuGroup menuGroup = this.b.getSelectedValue();
        if (menuGroup != null) {
            List<MenuPage> list = MenuPageDAO.getInstance().findByGroup(menuGroup);
            if (list != null && list.size() > 0) {
                this.e.setDataList(list);
                this.l.setEnabled(true);
            } else {
                this.l.setEnabled(false);
            }
        }
        this.g();
    }

    private void g() {
        MenuPage menuPage = null;
        if (this.e.getSize() > 0) {
            menuPage = this.d.getSelectedValue();
            if (menuPage != null) {
                this.i.setText(menuPage.isVisible() != false ? "Hide Page" : "Show Page");
                this.a(true);
                this.l.setEnabled(true);
            } else {
                this.a(false);
            }
        } else {
            this.a(false);
        }
        this.c.setMenuPage(menuPage);
    }

    private void a(boolean bl) {
        this.k.setEnabled(bl);
        this.i.setEnabled(bl);
        this.m.setEnabled(bl);
        this.p.setEnabled(bl);
    }

    public void doCreateNewPage() {
        if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), "Page not found.\n Do you want to create page?", "Confirm") != 0) {
            return;
        }
        int n = (int)NumberSelectionDialog2.takeIntInput("Enter page quantity");
        if (n < 1) {
            return;
        }
        ArrayList<MenuPage> arrayList = new ArrayList<MenuPage>();
        for (int i = 0; i < n; ++i) {
            MenuPage menuPage = new MenuPage();
            menuPage.setName("Page " + (i + 1));
            arrayList.add(menuPage);
        }
        try {
            MenuPageDAO.getInstance().saveOrUpdatePages(arrayList);
            this.e.setDataList(arrayList);
            this.d.setSelectedIndex(0);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    protected List<MenuItem> getSelectedMenuItems(List<MenuItem> list) {
        MenuItemSelectionDialog menuItemSelectionDialog = new MenuItemSelectionDialog(new ArrayList<MenuItem>());
        menuItemSelectionDialog.setSelectionMode(1);
        menuItemSelectionDialog.setSize(PosUIManager.getSize(750, 515));
        menuItemSelectionDialog.open();
        if (menuItemSelectionDialog.isCanceled()) {
            return null;
        }
        List<MenuItem> list2 = menuItemSelectionDialog.getSelectedItems();
        MenuPage menuPage = this.d.getSelectedValue();
        int n = menuPage.getCols() * menuPage.getRows();
        if (list2 != null && list2.size() > n) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), "Maximum size is " + n);
            return this.getSelectedMenuItems(list2);
        }
        return list2;
    }

    private void h() {
        try {
            MenuCategoryForm menuCategoryForm = new MenuCategoryForm();
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuCategoryForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            MenuCategory menuCategory = (MenuCategory)menuCategoryForm.getBean();
            ComboBoxModel comboBoxModel = (ComboBoxModel)this.a.getModel();
            comboBoxModel.addElement(menuCategory);
            this.a.setSelectedValue(menuCategory, true);
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void i() {
        try {
            MenuGroup menuGroup = new MenuGroup();
            MenuCategory menuCategory = this.a.getSelectedValue();
            if (menuCategory != null) {
                menuGroup.setMenuCategoryId(menuCategory.getId());
            } else {
                menuGroup.setMenuCategoryId(null);
            }
            MenuGroupForm menuGroupForm = new MenuGroupForm(menuGroup);
            BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuGroupForm);
            beanEditorDialog.open();
            if (beanEditorDialog.isCanceled()) {
                return;
            }
            MenuGroup menuGroup2 = (MenuGroup)menuGroupForm.getBean();
            ComboBoxModel comboBoxModel = (ComboBoxModel)this.b.getModel();
            comboBoxModel.addElement(menuGroup2);
            this.a.setSelectedValue(menuGroup2, true);
        }
        catch (Exception exception) {
            BOMessageDialog.showError(POSConstants.ERROR_MESSAGE, exception);
        }
    }

    private void j() {
        Serializable serializable;
        Object object;
        MenuPage menuPage = this.d.getSelectedValue();
        if (menuPage == null) {
            POSMessageDialog.showMessage("Select page first.");
            return;
        }
        ArrayList<MenuItem> arrayList = new ArrayList<MenuItem>();
        HashMap<String, Serializable> hashMap = new HashMap<String, Serializable>();
        if (menuPage.getPageItems() != null) {
            object = menuPage.getPageItems().iterator();
            while (object.hasNext()) {
                serializable = (MenuPageItem)object.next();
                if (((MenuPageItem)serializable).getMenuItem() == null) continue;
                hashMap.put(((MenuPageItem)serializable).getMenuItem().getId(), serializable);
                arrayList.add(((MenuPageItem)serializable).getMenuItem());
            }
        }
        if ((object = this.getSelectedMenuItems(arrayList)) == null) {
            return;
        }
        if (menuPage.getPageItems() != null) {
            menuPage.getPageItems().clear();
        }
        serializable = new ArrayList();
        Iterator iterator = object.iterator();
        while (iterator.hasNext()) {
            MenuItem menuItem = (MenuItem)iterator.next();
            MenuPageItem menuPageItem = (MenuPageItem)hashMap.get(menuItem.getId());
            if (menuPageItem == null) {
                menuPageItem = new MenuPageItem();
                menuPageItem.setMenuItem(menuItem);
                menuPageItem.setMenuPage(menuPage);
                serializable.add(menuPageItem);
                continue;
            }
            menuPage.addTopageItems(menuPageItem);
        }
        this.f.setEnabled(true);
        this.g.setEnabled(true);
        this.c.fillSelectedPageItems((List<MenuPageItem>)((Object)serializable));
    }

    private void k() {
        MenuGroup menuGroup = this.b.getSelectedValue();
        if (menuGroup == null) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), "Please select group first.");
            return;
        }
        List<MenuItem> list = MenuItemDAO.getInstance().findByParent(null, menuGroup, true);
        if (list == null || list.isEmpty()) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), "Selected group has no item.");
            return;
        }
        MenuPageForm menuPageForm = new MenuPageForm(new MenuPage(), true);
        BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuPageForm);
        beanEditorDialog.open();
        if (beanEditorDialog.isCanceled()) {
            return;
        }
        MenuPage menuPage = (MenuPage)menuPageForm.getBean();
        int n = menuPage.getRows();
        int n2 = menuPage.getCols();
        int n3 = list.size();
        int n4 = (int)Math.ceil((double)n3 / (double)(n2 * n));
        int n5 = n4 == 0 ? 1 : n4;
        ArrayList<MenuPageItem> arrayList = new ArrayList<MenuPageItem>();
        int n6 = 0;
        int n7 = 0;
        for (int i = 0; i < n5; ++i) {
            try {
                int n8;
                int n9;
                int n10 = this.e.getSize();
                MenuPage menuPage2 = null;
                if (menuPage2 == null) {
                    menuPage2 = new MenuPage();
                    menuPage2.setMenuGroupId(menuGroup.getId());
                    menuPage2.setName("Page " + (n10 + 1));
                    menuPage2.setRows(n);
                    menuPage2.setCols(n2);
                    menuPage2.setSortOrder(i);
                    menuPage2.setFlixibleButtonSize(menuPage.isFlixibleButtonSize());
                    menuPage2.setButtonHeight(menuPage.getButtonHeight());
                    menuPage2.setButtonWidth(menuPage.getButtonWidth());
                    MenuPageDAO.getInstance().saveOrUpdate(menuPage2);
                    this.e.addElement(menuPage2);
                }
                if (n3 < (n9 = n2 * n)) {
                    while (n6 < list.size()) {
                        MenuPageItem menuPageItem = new MenuPageItem();
                        menuPageItem.setMenuPage(menuPage2);
                        menuPageItem.setMenuItem(list.get(n6));
                        arrayList.add(menuPageItem);
                        menuPage2.addTopageItems(menuPageItem);
                        ++n6;
                    }
                } else {
                    n8 = 0;
                    while (n8 < n9) {
                        MenuPageItem menuPageItem = new MenuPageItem();
                        menuPageItem.setMenuPage(menuPage2);
                        menuPageItem.setMenuItem(list.get(n6));
                        arrayList.add(menuPageItem);
                        menuPage2.addTopageItems(menuPageItem);
                        ++n8;
                        ++n6;
                    }
                }
                n3 -= n9;
                for (n8 = 0; n8 < n; ++n8) {
                    for (int j = 0; j < n2 && n7 <= arrayList.size() - 1 && arrayList.get(n7) != null; ++n7, ++j) {
                        ((MenuPageItem)arrayList.get(n7)).setRow(n8);
                        ((MenuPageItem)arrayList.get(n7)).setCol(j);
                    }
                }
                MenuPageDAO.getInstance().saveOrUpdate(menuPage2);
                this.d.setSelectedValue(menuPage2, true);
                continue;
            }
            catch (Exception exception) {
                exception.printStackTrace();
                BOMessageDialog.showError(exception.getMessage());
            }
        }
        this.c.repaint();
        this.c.revalidate();
    }

    private void l() {
        MenuGroup menuGroup = this.b.getSelectedValue();
        if (menuGroup == null) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), "Select group first.");
            return;
        }
        try {
            MenuPage menuPage = new MenuPage();
            menuPage.setMenuGroupId(menuGroup.getId());
            menuPage.setCols(4);
            menuPage.setRows(4);
            int n = this.m();
            menuPage.setName("Page " + n);
            menuPage.setSortOrder(n);
            MenuPageDAO.getInstance().saveOrUpdate(menuPage);
            this.e.addElement(menuPage);
            this.d.setSelectedValue(menuPage, true);
        }
        catch (Exception exception) {
            PosLog.error(this.getClass(), exception);
        }
    }

    private int m() {
        Serializable serializable;
        String string = "";
        if (this.e.getSize() > 0) {
            serializable = (MenuPage)this.e.getElementAt(this.e.getSize() - 1);
            string = ((BaseMenuPage)serializable).getName();
        }
        serializable = Pattern.compile(".* ([0-9]+)");
        Matcher matcher = ((Pattern)serializable).matcher(string);
        int n = this.e.getSize() + 1;
        if (matcher.find()) {
            try {
                int n2 = Integer.parseInt(matcher.group(1));
                if (n2 + 1 > n) {
                    n = n2 + 1;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    private void n() {
        MenuPage menuPage = this.d.getSelectedValue();
        if (menuPage == null) {
            return;
        }
        MenuPageForm menuPageForm = new MenuPageForm(menuPage, false);
        BeanEditorDialog beanEditorDialog = new BeanEditorDialog((Frame)POSUtil.getBackOfficeWindow(), (BeanEditor)menuPageForm);
        beanEditorDialog.open();
        if (beanEditorDialog.isCanceled()) {
            return;
        }
        MenuPage menuPage2 = (MenuPage)menuPageForm.getBean();
        MenuPageDAO menuPageDAO = new MenuPageDAO();
        menuPageDAO.saveOrUpdate(menuPage2);
        this.d.setSelectedValue(menuPage2, true);
        this.g();
    }

    private void o() {
        MenuPage menuPage = this.d.getSelectedValue();
        if (menuPage == null || menuPage.getPageItems() == null) {
            POSMessageDialog.showMessage(POSUtil.getBackOfficeWindow(), "No item to detach.");
            return;
        }
        if (POSMessageDialog.showYesNoQuestionDialog(POSUtil.getBackOfficeWindow(), "Are you sure you want to detach all?", "Confirm") != 0) {
            return;
        }
        if (menuPage.getPageItems() != null) {
            menuPage.getPageItems().clear();
        }
        MenuPageDAO.getInstance().saveOrUpdate(menuPage);
        this.c.setMenuPage(menuPage);
    }

    @Override
    public void itemSelected(Object object) {
        this.f.setEnabled(true);
        this.g.setEnabled(true);
    }

    @Override
    public void refresh() {
        MenuPage menuPage = this.c.getMenuPage();
        MenuPage menuPage2 = MenuPageDAO.getInstance().get(menuPage.getId());
        this.c.setMenuPage(menuPage2);
    }

    @Override
    public void uiUpdate() {
        this.f.setEnabled(true);
        this.g.setEnabled(true);
    }
}

