/*
 * Decompiled with CFR 0.152.
 */
package com.floreantpos.customPayment;

import com.floreantpos.Messages;
import com.floreantpos.bo.ui.BOMessageDialog;
import com.floreantpos.model.CustomPayment;
import com.floreantpos.model.dao.CustomPaymentDAO;
import com.floreantpos.model.util.IllegalModelStateException;
import com.floreantpos.swing.FixedLengthTextField;
import com.floreantpos.ui.BeanEditor;
import com.floreantpos.ui.dialog.POSMessageDialog;
import com.floreantpos.util.POSUtil;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import net.miginfocom.swing.MigLayout;
import org.hibernate.StaleObjectStateException;

public class CustomPaymentForm
extends BeanEditor<CustomPayment> {
    private JLabel a;
    private JLabel b;
    private FixedLengthTextField c;
    private FixedLengthTextField d;
    private JCheckBox e;
    private JCheckBox f;

    public CustomPaymentForm() {
        this.a();
    }

    public CustomPaymentForm(CustomPayment customPayment) {
        this.a();
        this.setBean(customPayment);
    }

    private void a() {
        this.e = new JCheckBox(Messages.getString("CustomPaymentForm.0"));
        this.b = new JLabel(Messages.getString("CustomPaymentForm.1"));
        this.a = new JLabel(Messages.getString("CustomPaymentForm.2"));
        this.c = new FixedLengthTextField(60);
        this.d = new FixedLengthTextField(60);
        this.f = new JCheckBox("Enable");
        this.setLayout((LayoutManager)new MigLayout("fillx, hidemode 3", "[][]", ""));
        this.add((Component)this.a, "");
        this.add((Component)this.c, "growx, wrap");
        this.add((Component)this.b, "");
        this.add((Component)this.d, "growx, wrap");
        this.add((Component)this.e, "skip 1, wrap");
        this.add((Component)this.f, "skip 1, wrap");
        this.e.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CustomPaymentForm.this.e.isSelected()) {
                    CustomPaymentForm.this.b.setVisible(true);
                    CustomPaymentForm.this.d.setVisible(true);
                } else {
                    CustomPaymentForm.this.b.setVisible(false);
                    CustomPaymentForm.this.d.setVisible(false);
                }
            }
        });
        this.b.setVisible(false);
        this.d.setVisible(false);
        this.c.setEnabled(false);
        this.e.setEnabled(false);
    }

    @Override
    public void setFieldsEnable(boolean bl) {
        this.c.setEnabled(bl);
        this.e.setEnabled(bl);
        this.d.setEnabled(bl);
    }

    @Override
    public void createNew() {
        this.setBean(new CustomPayment());
        this.b.setVisible(false);
        this.d.setVisible(false);
        this.e.setSelected(false);
    }

    @Override
    public boolean save() {
        try {
            if (!this.updateModel()) {
                return false;
            }
            CustomPayment customPayment = (CustomPayment)this.getBean();
            CustomPaymentDAO.getInstance().saveOrUpdate(customPayment);
            this.updateView();
            return true;
        }
        catch (IllegalModelStateException illegalModelStateException) {
        }
        catch (StaleObjectStateException staleObjectStateException) {
            BOMessageDialog.showError(this, Messages.getString("CustomPaymentForm.10"));
        }
        return false;
    }

    @Override
    protected void updateView() {
        CustomPayment customPayment = (CustomPayment)this.getBean();
        this.c.setText(customPayment.getName());
        this.f.setSelected(customPayment.isEnable());
        if (customPayment.isRequiredRefNumber().booleanValue()) {
            this.d.setVisible(true);
            this.b.setVisible(true);
            this.d.setText(customPayment.getRefNumberFieldName());
            this.e.setSelected(customPayment.isRequiredRefNumber());
        } else {
            this.b.setVisible(false);
            this.d.setVisible(false);
            this.e.setSelected(customPayment.isRequiredRefNumber());
        }
    }

    @Override
    protected boolean updateModel() throws IllegalModelStateException {
        CustomPayment customPayment = (CustomPayment)this.getBean();
        if (this.c.getText().equals("")) {
            POSMessageDialog.showMessage(null, Messages.getString("CustomPaymentForm.12"));
            return false;
        }
        customPayment.setName(this.c.getText());
        customPayment.setEnable(this.f.isSelected());
        if (this.e.isSelected()) {
            if (this.d.getText().equals("")) {
                POSMessageDialog.showMessage(null, Messages.getString("CustomPaymentForm.14"));
                return false;
            }
            customPayment.setRefNumberFieldName(this.d.getText());
            customPayment.setRequiredRefNumber(true);
        } else {
            customPayment.setRefNumberFieldName("");
            customPayment.setRequiredRefNumber(false);
        }
        return true;
    }

    @Override
    public boolean delete() {
        try {
            CustomPayment customPayment = (CustomPayment)this.getBean();
            if (customPayment == null) {
                return false;
            }
            CustomPaymentDAO.getInstance().delete(customPayment);
            return true;
        }
        catch (Exception exception) {
            POSMessageDialog.showError(POSUtil.getBackOfficeWindow(), exception.getMessage(), exception);
            return false;
        }
    }

    @Override
    public String getDisplayText() {
        CustomPayment customPayment = (CustomPayment)this.getBean();
        if (customPayment.getId() == null) {
            return "Add Custom Payment";
        }
        return "Edit Custom Payment";
    }
}

